.TH TTF2AFM 1 "8 March 2016" "Web2C @VERSION@"
.PP 
.SH "NAME" 
ttf2afm \- utility to generate AFM files for TrueType fonts
.PP 
.SH "SYNOPSIS" 
.B ttf2afm
.RI [ OPTIONS ]
.I FONTFILE
.PP 
.SH "DESCRIPTION" 
.PP 
\fBttf2afm\fP is used to generate Adobe Font Metrics (AFM) files for
TrueType (TTF) fonts to allow them to be used with TeX\&.
.PP 
\fBttf2afm\fP takes the name of a TrueType font file as a required
argument\&.  It may also take one or more options from the list below
(\fB-i\fP and \fB-u\fP are mutually exclusive)\&.
.PP 
.SH "OPTIONS" 
.PP 
.IP "\fB-i\fP" 
force printing glyph names in form
`index'\fIdecnum\fP\&
.IP "\fB-u\fP" 
force printing glyph names in form
`uni'\fIhexnum\fP\&
.IP "\fB-c\fP \fIname\fP" 
write encoding tables to file
\fIname\&.eMN\fP, where \fIM\fP is the platform
ID and \fIN\fP is the encoding ID
.IP "\fB-v\fP" 
print program version
.IP "\fB-e\fP \fIenc\fP" 
encode AFM output using encoding vector from \fIenc\fP
.IP "\fB-o\fP \fIoutfile\fP" 
output to file \fIoutfile\fP instead of standard output
.IP "\fB-m\fP \fInum\fP" 
use Unicode mapping \fInum\fP in the font
.PP 
Platform numbers can be one of
.IP "0" 
Apple Unicode
.IP "1" 
Macintosh
.IP "2" 
ISO
.IP "3" 
Microsoft
.PP 
Encodings can be
.IP "0" 
Roman (if platform is Macintosh)
.IP "0" 
Symbol (if platform is Microsoft)
.IP "1" 
Unicode (if platform is Microsoft)
.PP
.SH "SEE ALSO"
afm2tfm(1), afm2pl(1).
FontForge (http://fontforge.sf.net).
LCDF TypeTools (http://lcdf.org).
A closer look at TrueType fonts and pdfTeX, Han The Thanh
(http://tug.org/TUGboat/tb30-1/tb94thanh.pdf).
.PP 
.SH "BUGS" 
.PP 
Send bug reports to <pdftex@tug\&.org> (public mailing list)\&.
.PP 
.SH "AUTHOR" 
.PP 
\fBttf2afm\fP is part of pdfTeX and was written by Han The Thanh\&.
.PP 
This manual page was originally written by C\&.M\&. Connelly, for the
Debian GNU/Linux system, and updated by Karl Berry and others.
