﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/appsync/model/SourceApiAssociationConfig.h>
#include <aws/appsync/model/SourceApiAssociationStatus.h>
#include <aws/core/utils/DateTime.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace AppSync
{
namespace Model
{

  /**
   * <p>Describes the configuration of a source API. A source API is a GraphQL API
   * that is linked to a merged API. There can be multiple source APIs attached to
   * each merged API. When linked to a merged API, the source API's schema, data
   * sources, and resolvers will be combined with other linked source API data to
   * form a new, singular API. </p> <p>Source APIs can originate from your account or
   * from other accounts via Amazon Web Services Resource Access Manager. For more
   * information about sharing resources from other accounts, see <a
   * href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">What is
   * Amazon Web Services Resource Access Manager?</a> in the <i>Amazon Web Services
   * Resource Access Manager</i> guide.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/SourceApiAssociation">AWS
   * API Reference</a></p>
   */
  class SourceApiAssociation
  {
  public:
    AWS_APPSYNC_API SourceApiAssociation();
    AWS_APPSYNC_API SourceApiAssociation(Aws::Utils::Json::JsonView jsonValue);
    AWS_APPSYNC_API SourceApiAssociation& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_APPSYNC_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline const Aws::String& GetAssociationId() const{ return m_associationId; }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline bool AssociationIdHasBeenSet() const { return m_associationIdHasBeenSet; }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline void SetAssociationId(const Aws::String& value) { m_associationIdHasBeenSet = true; m_associationId = value; }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline void SetAssociationId(Aws::String&& value) { m_associationIdHasBeenSet = true; m_associationId = std::move(value); }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline void SetAssociationId(const char* value) { m_associationIdHasBeenSet = true; m_associationId.assign(value); }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline SourceApiAssociation& WithAssociationId(const Aws::String& value) { SetAssociationId(value); return *this;}

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline SourceApiAssociation& WithAssociationId(Aws::String&& value) { SetAssociationId(std::move(value)); return *this;}

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline SourceApiAssociation& WithAssociationId(const char* value) { SetAssociationId(value); return *this;}


    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline const Aws::String& GetAssociationArn() const{ return m_associationArn; }

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline bool AssociationArnHasBeenSet() const { return m_associationArnHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline void SetAssociationArn(const Aws::String& value) { m_associationArnHasBeenSet = true; m_associationArn = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline void SetAssociationArn(Aws::String&& value) { m_associationArnHasBeenSet = true; m_associationArn = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline void SetAssociationArn(const char* value) { m_associationArnHasBeenSet = true; m_associationArn.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline SourceApiAssociation& WithAssociationArn(const Aws::String& value) { SetAssociationArn(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline SourceApiAssociation& WithAssociationArn(Aws::String&& value) { SetAssociationArn(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the source API association.</p>
     */
    inline SourceApiAssociation& WithAssociationArn(const char* value) { SetAssociationArn(value); return *this;}


    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline const Aws::String& GetSourceApiId() const{ return m_sourceApiId; }

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline bool SourceApiIdHasBeenSet() const { return m_sourceApiIdHasBeenSet; }

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline void SetSourceApiId(const Aws::String& value) { m_sourceApiIdHasBeenSet = true; m_sourceApiId = value; }

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline void SetSourceApiId(Aws::String&& value) { m_sourceApiIdHasBeenSet = true; m_sourceApiId = std::move(value); }

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline void SetSourceApiId(const char* value) { m_sourceApiIdHasBeenSet = true; m_sourceApiId.assign(value); }

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline SourceApiAssociation& WithSourceApiId(const Aws::String& value) { SetSourceApiId(value); return *this;}

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline SourceApiAssociation& WithSourceApiId(Aws::String&& value) { SetSourceApiId(std::move(value)); return *this;}

    /**
     * <p>The ID of the AppSync source API.</p>
     */
    inline SourceApiAssociation& WithSourceApiId(const char* value) { SetSourceApiId(value); return *this;}


    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync source API.</p>
     */
    inline const Aws::String& GetSourceApiArn() const{ return m_sourceApiArn; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync source API.</p>
     */
    inline bool SourceApiArnHasBeenSet() const { return m_sourceApiArnHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync source API.</p>
     */
    inline void SetSourceApiArn(const Aws::String& value) { m_sourceApiArnHasBeenSet = true; m_sourceApiArn = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync source API.</p>
     */
    inline void SetSourceApiArn(Aws::String&& value) { m_sourceApiArnHasBeenSet = true; m_sourceApiArn = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync source API.</p>
     */
    inline void SetSourceApiArn(const char* value) { m_sourceApiArnHasBeenSet = true; m_sourceApiArn.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync source API.</p>
     */
    inline SourceApiAssociation& WithSourceApiArn(const Aws::String& value) { SetSourceApiArn(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync source API.</p>
     */
    inline SourceApiAssociation& WithSourceApiArn(Aws::String&& value) { SetSourceApiArn(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync source API.</p>
     */
    inline SourceApiAssociation& WithSourceApiArn(const char* value) { SetSourceApiArn(value); return *this;}


    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline const Aws::String& GetMergedApiArn() const{ return m_mergedApiArn; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline bool MergedApiArnHasBeenSet() const { return m_mergedApiArnHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline void SetMergedApiArn(const Aws::String& value) { m_mergedApiArnHasBeenSet = true; m_mergedApiArn = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline void SetMergedApiArn(Aws::String&& value) { m_mergedApiArnHasBeenSet = true; m_mergedApiArn = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline void SetMergedApiArn(const char* value) { m_mergedApiArnHasBeenSet = true; m_mergedApiArn.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline SourceApiAssociation& WithMergedApiArn(const Aws::String& value) { SetMergedApiArn(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline SourceApiAssociation& WithMergedApiArn(Aws::String&& value) { SetMergedApiArn(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
     */
    inline SourceApiAssociation& WithMergedApiArn(const char* value) { SetMergedApiArn(value); return *this;}


    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline const Aws::String& GetMergedApiId() const{ return m_mergedApiId; }

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline bool MergedApiIdHasBeenSet() const { return m_mergedApiIdHasBeenSet; }

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline void SetMergedApiId(const Aws::String& value) { m_mergedApiIdHasBeenSet = true; m_mergedApiId = value; }

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline void SetMergedApiId(Aws::String&& value) { m_mergedApiIdHasBeenSet = true; m_mergedApiId = std::move(value); }

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline void SetMergedApiId(const char* value) { m_mergedApiIdHasBeenSet = true; m_mergedApiId.assign(value); }

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline SourceApiAssociation& WithMergedApiId(const Aws::String& value) { SetMergedApiId(value); return *this;}

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline SourceApiAssociation& WithMergedApiId(Aws::String&& value) { SetMergedApiId(std::move(value)); return *this;}

    /**
     * <p>The ID of the AppSync Merged API.</p>
     */
    inline SourceApiAssociation& WithMergedApiId(const char* value) { SetMergedApiId(value); return *this;}


    /**
     * <p>The description field.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }

    /**
     * <p>The description field.</p>
     */
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }

    /**
     * <p>The description field.</p>
     */
    inline void SetDescription(const Aws::String& value) { m_descriptionHasBeenSet = true; m_description = value; }

    /**
     * <p>The description field.</p>
     */
    inline void SetDescription(Aws::String&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }

    /**
     * <p>The description field.</p>
     */
    inline void SetDescription(const char* value) { m_descriptionHasBeenSet = true; m_description.assign(value); }

    /**
     * <p>The description field.</p>
     */
    inline SourceApiAssociation& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}

    /**
     * <p>The description field.</p>
     */
    inline SourceApiAssociation& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}

    /**
     * <p>The description field.</p>
     */
    inline SourceApiAssociation& WithDescription(const char* value) { SetDescription(value); return *this;}


    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline const SourceApiAssociationConfig& GetSourceApiAssociationConfig() const{ return m_sourceApiAssociationConfig; }

    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline bool SourceApiAssociationConfigHasBeenSet() const { return m_sourceApiAssociationConfigHasBeenSet; }

    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline void SetSourceApiAssociationConfig(const SourceApiAssociationConfig& value) { m_sourceApiAssociationConfigHasBeenSet = true; m_sourceApiAssociationConfig = value; }

    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline void SetSourceApiAssociationConfig(SourceApiAssociationConfig&& value) { m_sourceApiAssociationConfigHasBeenSet = true; m_sourceApiAssociationConfig = std::move(value); }

    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline SourceApiAssociation& WithSourceApiAssociationConfig(const SourceApiAssociationConfig& value) { SetSourceApiAssociationConfig(value); return *this;}

    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline SourceApiAssociation& WithSourceApiAssociationConfig(SourceApiAssociationConfig&& value) { SetSourceApiAssociationConfig(std::move(value)); return *this;}


    /**
     * <p>The state of the source API association.</p>
     */
    inline const SourceApiAssociationStatus& GetSourceApiAssociationStatus() const{ return m_sourceApiAssociationStatus; }

    /**
     * <p>The state of the source API association.</p>
     */
    inline bool SourceApiAssociationStatusHasBeenSet() const { return m_sourceApiAssociationStatusHasBeenSet; }

    /**
     * <p>The state of the source API association.</p>
     */
    inline void SetSourceApiAssociationStatus(const SourceApiAssociationStatus& value) { m_sourceApiAssociationStatusHasBeenSet = true; m_sourceApiAssociationStatus = value; }

    /**
     * <p>The state of the source API association.</p>
     */
    inline void SetSourceApiAssociationStatus(SourceApiAssociationStatus&& value) { m_sourceApiAssociationStatusHasBeenSet = true; m_sourceApiAssociationStatus = std::move(value); }

    /**
     * <p>The state of the source API association.</p>
     */
    inline SourceApiAssociation& WithSourceApiAssociationStatus(const SourceApiAssociationStatus& value) { SetSourceApiAssociationStatus(value); return *this;}

    /**
     * <p>The state of the source API association.</p>
     */
    inline SourceApiAssociation& WithSourceApiAssociationStatus(SourceApiAssociationStatus&& value) { SetSourceApiAssociationStatus(std::move(value)); return *this;}


    /**
     * <p>The detailed message related to the current state of the source API
     * association.</p>
     */
    inline const Aws::String& GetSourceApiAssociationStatusDetail() const{ return m_sourceApiAssociationStatusDetail; }

    /**
     * <p>The detailed message related to the current state of the source API
     * association.</p>
     */
    inline bool SourceApiAssociationStatusDetailHasBeenSet() const { return m_sourceApiAssociationStatusDetailHasBeenSet; }

    /**
     * <p>The detailed message related to the current state of the source API
     * association.</p>
     */
    inline void SetSourceApiAssociationStatusDetail(const Aws::String& value) { m_sourceApiAssociationStatusDetailHasBeenSet = true; m_sourceApiAssociationStatusDetail = value; }

    /**
     * <p>The detailed message related to the current state of the source API
     * association.</p>
     */
    inline void SetSourceApiAssociationStatusDetail(Aws::String&& value) { m_sourceApiAssociationStatusDetailHasBeenSet = true; m_sourceApiAssociationStatusDetail = std::move(value); }

    /**
     * <p>The detailed message related to the current state of the source API
     * association.</p>
     */
    inline void SetSourceApiAssociationStatusDetail(const char* value) { m_sourceApiAssociationStatusDetailHasBeenSet = true; m_sourceApiAssociationStatusDetail.assign(value); }

    /**
     * <p>The detailed message related to the current state of the source API
     * association.</p>
     */
    inline SourceApiAssociation& WithSourceApiAssociationStatusDetail(const Aws::String& value) { SetSourceApiAssociationStatusDetail(value); return *this;}

    /**
     * <p>The detailed message related to the current state of the source API
     * association.</p>
     */
    inline SourceApiAssociation& WithSourceApiAssociationStatusDetail(Aws::String&& value) { SetSourceApiAssociationStatusDetail(std::move(value)); return *this;}

    /**
     * <p>The detailed message related to the current state of the source API
     * association.</p>
     */
    inline SourceApiAssociation& WithSourceApiAssociationStatusDetail(const char* value) { SetSourceApiAssociationStatusDetail(value); return *this;}


    /**
     * <p>The datetime value of the last successful merge of the source API
     * association. The result will be in UTC format and your local time zone.</p>
     */
    inline const Aws::Utils::DateTime& GetLastSuccessfulMergeDate() const{ return m_lastSuccessfulMergeDate; }

    /**
     * <p>The datetime value of the last successful merge of the source API
     * association. The result will be in UTC format and your local time zone.</p>
     */
    inline bool LastSuccessfulMergeDateHasBeenSet() const { return m_lastSuccessfulMergeDateHasBeenSet; }

    /**
     * <p>The datetime value of the last successful merge of the source API
     * association. The result will be in UTC format and your local time zone.</p>
     */
    inline void SetLastSuccessfulMergeDate(const Aws::Utils::DateTime& value) { m_lastSuccessfulMergeDateHasBeenSet = true; m_lastSuccessfulMergeDate = value; }

    /**
     * <p>The datetime value of the last successful merge of the source API
     * association. The result will be in UTC format and your local time zone.</p>
     */
    inline void SetLastSuccessfulMergeDate(Aws::Utils::DateTime&& value) { m_lastSuccessfulMergeDateHasBeenSet = true; m_lastSuccessfulMergeDate = std::move(value); }

    /**
     * <p>The datetime value of the last successful merge of the source API
     * association. The result will be in UTC format and your local time zone.</p>
     */
    inline SourceApiAssociation& WithLastSuccessfulMergeDate(const Aws::Utils::DateTime& value) { SetLastSuccessfulMergeDate(value); return *this;}

    /**
     * <p>The datetime value of the last successful merge of the source API
     * association. The result will be in UTC format and your local time zone.</p>
     */
    inline SourceApiAssociation& WithLastSuccessfulMergeDate(Aws::Utils::DateTime&& value) { SetLastSuccessfulMergeDate(std::move(value)); return *this;}

  private:

    Aws::String m_associationId;
    bool m_associationIdHasBeenSet = false;

    Aws::String m_associationArn;
    bool m_associationArnHasBeenSet = false;

    Aws::String m_sourceApiId;
    bool m_sourceApiIdHasBeenSet = false;

    Aws::String m_sourceApiArn;
    bool m_sourceApiArnHasBeenSet = false;

    Aws::String m_mergedApiArn;
    bool m_mergedApiArnHasBeenSet = false;

    Aws::String m_mergedApiId;
    bool m_mergedApiIdHasBeenSet = false;

    Aws::String m_description;
    bool m_descriptionHasBeenSet = false;

    SourceApiAssociationConfig m_sourceApiAssociationConfig;
    bool m_sourceApiAssociationConfigHasBeenSet = false;

    SourceApiAssociationStatus m_sourceApiAssociationStatus;
    bool m_sourceApiAssociationStatusHasBeenSet = false;

    Aws::String m_sourceApiAssociationStatusDetail;
    bool m_sourceApiAssociationStatusDetailHasBeenSet = false;

    Aws::Utils::DateTime m_lastSuccessfulMergeDate;
    bool m_lastSuccessfulMergeDateHasBeenSet = false;
  };

} // namespace Model
} // namespace AppSync
} // namespace Aws
