"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderHook = renderHook;
Object.defineProperty(exports, "act", {
  enumerable: true,
  get: function get() {
    return _reactTestRenderer.act;
  }
});
Object.defineProperty(exports, "cleanup", {
  enumerable: true,
  get: function get() {
    return _cleanup.cleanup;
  }
});

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _reactTestRenderer = require("react-test-renderer");

var _asyncUtils = _interopRequireDefault(require("./asyncUtils"));

var _cleanup = require("./cleanup");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function TestHook(_ref) {
  var callback = _ref.callback,
      hookProps = _ref.hookProps,
      onError = _ref.onError,
      children = _ref.children;

  try {
    children(callback(hookProps));
  } catch (err) {
    if (err.then) {
      throw err;
    } else {
      onError(err);
    }
  }

  return null;
}

function Fallback() {
  return null;
}

function resultContainer() {
  var value = null;
  var error = null;
  var resolvers = [];
  var result = {
    get current() {
      if (error) {
        throw error;
      }

      return value;
    },

    get error() {
      return error;
    }

  };

  var updateResult = function updateResult(val, err) {
    value = val;
    error = err;
    resolvers.splice(0, resolvers.length).forEach(function (resolve) {
      return resolve();
    });
  };

  return {
    result: result,
    addResolver: function addResolver(resolver) {
      resolvers.push(resolver);
    },
    setValue: function setValue(val) {
      return updateResult(val);
    },
    setError: function setError(err) {
      return updateResult(undefined, err);
    }
  };
}

function renderHook(callback, _temp) {
  var _ref2 = _temp === void 0 ? {} : _temp,
      initialProps = _ref2.initialProps,
      wrapper = _ref2.wrapper;

  var _resultContainer = resultContainer(),
      result = _resultContainer.result,
      setValue = _resultContainer.setValue,
      setError = _resultContainer.setError,
      addResolver = _resultContainer.addResolver;

  var hookProps = {
    current: initialProps
  };

  var wrapUiIfNeeded = function wrapUiIfNeeded(innerElement) {
    return wrapper ? _react["default"].createElement(wrapper, null, innerElement) : innerElement;
  };

  var toRender = function toRender() {
    return wrapUiIfNeeded(_react["default"].createElement(_react.Suspense, {
      fallback: _react["default"].createElement(Fallback, null)
    }, _react["default"].createElement(TestHook, {
      callback: callback,
      hookProps: hookProps.current,
      onError: setError
    }, setValue)));
  };

  var testRenderer;
  (0, _reactTestRenderer.act)(function () {
    testRenderer = (0, _reactTestRenderer.create)(toRender());
  });
  var _testRenderer = testRenderer,
      unmount = _testRenderer.unmount,
      update = _testRenderer.update;

  function unmountHook() {
    (0, _reactTestRenderer.act)(function () {
      (0, _cleanup.removeCleanup)(unmountHook);
      unmount();
    });
  }

  (0, _cleanup.addCleanup)(unmountHook);
  return _objectSpread({
    result: result,
    rerender: function rerender(newProps) {
      if (newProps === void 0) {
        newProps = hookProps.current;
      }

      hookProps.current = newProps;
      (0, _reactTestRenderer.act)(function () {
        update(toRender());
      });
    },
    unmount: unmountHook
  }, (0, _asyncUtils["default"])(addResolver));
}