/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class EncapsulatedContentInfo
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    private OBJECT_IDENTIFIER contentType;
    private OCTET_STRING content;
    private SEQUENCE sequence = new SEQUENCE();
    private static Template templateInstance = new Template();

    public EncapsulatedContentInfo(OBJECT_IDENTIFIER contentType, ASN1Value content) {
        this.contentType = contentType;
        this.sequence.addElement(contentType);
        if (content != null) {
            this.content = content instanceof OCTET_STRING ? (OCTET_STRING)content : new OCTET_STRING(ASN1Util.encode(content));
            this.sequence.addElement(new EXPLICIT(new Tag(0L), this.content));
        }
    }

    public OBJECT_IDENTIFIER getContentType() {
        return this.contentType;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public OCTET_STRING getContent() {
        return this.content;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        @Override
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public Template() {
            this.seqt.addElement(new OBJECT_IDENTIFIER.Template());
            this.seqt.addOptionalElement(new EXPLICIT.Template(new Tag(0L), new OCTET_STRING.Template()));
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            assert (seq.size() == 2);
            ASN1Value content = seq.elementAt(1) == null ? null : ((EXPLICIT)seq.elementAt(1)).getContent();
            return new EncapsulatedContentInfo((OBJECT_IDENTIFIER)seq.elementAt(0), content);
        }
    }
}

