; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i16_stride5_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride5_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm1
; SSE-NEXT:    movdqa (%r8), %xmm2
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,4]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,7,5]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,1,0,1]
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movd %xmm0, 16(%r9)
; SSE-NEXT:    movdqa %xmm3, (%r9)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride5_vf2:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa (%r8), %xmm2
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,u,u,2,3,6,7,10,11]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm3[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm1, %xmm1
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX1-ONLY-NEXT:    vmovd %xmm1, 16(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, (%r9)
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride5_vf2:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-SLOW-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,4,5,8,9,12,13,u,u,2,3,6,7,10,11,u,u,18,19,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,3,0,3,4,7,4,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm0 = ymm0[3,3,3,3,4,5,6,7,11,11,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,255,255,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vmovd %xmm1, 16(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, (%r9)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride5_vf2:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-FAST-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,4,5,8,9,12,13],zero,zero,ymm0[2,3,6,7,10,11],zero,zero,ymm0[18,19],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1],zero,zero,zero,zero,zero,zero,ymm0[30,31],zero,zero,ymm0[30,31,30,31,16,17,18,19,28,29,30,31]
; AVX2-FAST-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-NEXT:    vmovd %xmm1, 16(%r9)
; AVX2-FAST-NEXT:    vmovdqa %xmm0, (%r9)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride5_vf2:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,4,5,8,9,12,13],zero,zero,ymm0[2,3,6,7,10,11],zero,zero,ymm0[18,19],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1],zero,zero,zero,zero,zero,zero,ymm0[30,31],zero,zero,ymm0[30,31,30,31,16,17,18,19,28,29,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovd %xmm1, 16(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, (%r9)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-LABEL: store_i16_stride5_vf2:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512F-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512F-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,4,5,8,9,12,13],zero,zero,ymm0[2,3,6,7,10,11],zero,zero,ymm0[18,19,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1],zero,zero,zero,zero,zero,zero,ymm0[30,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vmovd %xmm1, 16(%r9)
; AVX512F-NEXT:    vmovdqa %xmm0, (%r9)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride5_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512BW-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm1 = <0,2,4,6,8,1,3,5,7,9,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermw %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vmovd %xmm1, 16(%r9)
; AVX512BW-NEXT:    vmovdqa %xmm0, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <2 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <2 x i16>, ptr %in.vecptr4, align 64
  %1 = shufflevector <2 x i16> %in.vec0, <2 x i16> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i16> %in.vec2, <2 x i16> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <4 x i16> %1, <4 x i16> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = shufflevector <2 x i16> %in.vec4, <2 x i16> poison, <8 x i32> <i32 0, i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <8 x i16> %3, <8 x i16> %4, <10 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9>
  %interleaved.vec = shufflevector <10 x i16> %5, <10 x i16> poison, <10 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 1, i32 3, i32 5, i32 7, i32 9>
  store <10 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride5_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride5_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm5 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm3 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[3,3,3,3]
; SSE-NEXT:    psrldq {{.*#+}} xmm5 = xmm5[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,1,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,6,7]
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm5, %xmm7
; SSE-NEXT:    por %xmm4, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm4, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,1,0,1]
; SSE-NEXT:    pandn %xmm5, %xmm4
; SSE-NEXT:    por %xmm7, %xmm4
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,2,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,0,0,65535,65535,65535,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,1,1]
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    por %xmm2, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    pand %xmm2, %xmm7
; SSE-NEXT:    pandn %xmm5, %xmm2
; SSE-NEXT:    por %xmm7, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm6, %xmm3
; SSE-NEXT:    movq %xmm3, 32(%r9)
; SSE-NEXT:    movdqa %xmm2, (%r9)
; SSE-NEXT:    movdqa %xmm4, 16(%r9)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride5_vf4:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm1[3,1,2,3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[0,3,1,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm4[1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2],xmm2[3],xmm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm1[10,11,10,11,u,u,u,u,4,5,12,13,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[3,1,2,1]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[0,1,2,0,4,5,6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0],xmm2[1],xmm4[2,3,4,5],xmm2[6],xmm4[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,0,1,8,9,u,u,u,u,u,u,2,3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,u,u,u,u,u,u,2,3,10,11,u,u]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3],xmm0[4,5,6],xmm1[7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm2[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, (%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, 16(%r9)
; AVX1-ONLY-NEXT:    vmovq %xmm3, 32(%r9)
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride5_vf4:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-SLOW-NEXT:    vpbroadcastq %xmm3, %ymm3
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm2[0,1,8,9,u,u,u,u,u,u,2,3,10,11,u,u,26,27,u,u,u,u,u,u,20,21,28,29,u,u,u,u]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,0,1,8,9,u,u,u,u,u,u,2,3,u,u,u,u,20,21,28,29,u,u,u,u,u,u,22,23]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5,6],ymm2[7],ymm4[8,9],ymm2[10,11],ymm4[12,13,14],ymm2[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[3,1,2,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,3,1,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[3],xmm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovq %xmm0, 32(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, (%r9)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride5_vf4:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FAST-NEXT:    vpbroadcastq %xmm3, %ymm3
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm2[0,1,8,9,u,u,u,u,u,u,2,3,10,11,u,u,26,27,u,u,u,u,u,u,20,21,28,29,u,u,u,u]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,0,1,8,9,u,u,u,u,u,u,2,3,u,u,u,u,20,21,28,29,u,u,u,u,u,u,22,23]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5,6],ymm2[7],ymm4[8,9],ymm2[10,11],ymm4[12,13,14],ymm2[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-FAST-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,6,7,14,15,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3,4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[3],xmm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovq %xmm0, 32(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm2, (%r9)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride5_vf4:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq %xmm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm4 = ymm2[0,1,8,9,u,u,u,u,u,u,2,3,10,11,u,u,26,27,u,u,u,u,u,u,20,21,28,29,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,0,1,8,9,u,u,u,u,u,u,2,3,u,u,u,u,20,21,28,29,u,u,u,u,u,u,22,23]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5,6],ymm2[7],ymm4[8,9],ymm2[10,11],ymm4[12,13,14],ymm2[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,6,7,14,15,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[3],xmm0[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovq %xmm0, 32(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, (%r9)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride5_vf4:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    movq (%r8), %rax
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512F-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512F-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX512F-SLOW-NEXT:    vpbroadcastq %rax, %ymm3
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm2[0,1,8,9,u,u,u,u,u,u,2,3,10,11,u,u,26,27,u,u,u,u,u,u,20,21,28,29,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,0,1,8,9,u,u,u,u,u,u,2,3,u,u,u,u,20,21,28,29,u,u,u,u,u,u,22,23]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5,6],ymm2[7],ymm4[8,9],ymm2[10,11],ymm4[12,13,14],ymm2[15]
; AVX512F-SLOW-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm2
; AVX512F-SLOW-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[3,1,2,3]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,3,1,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[3],xmm0[4,5,6,7]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm0
; AVX512F-SLOW-NEXT:    vmovdqa %ymm2, (%r9)
; AVX512F-SLOW-NEXT:    vextracti32x4 $2, %zmm0, %xmm0
; AVX512F-SLOW-NEXT:    vmovq %xmm0, 32(%r9)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride5_vf4:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    movq (%r8), %rax
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512F-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512F-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX512F-FAST-NEXT:    vpbroadcastq %rax, %ymm3
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm2[0,1,8,9,u,u,u,u,u,u,2,3,10,11,u,u,26,27,u,u,u,u,u,u,20,21,28,29,u,u,u,u]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,0,1,8,9,u,u,u,u,u,u,2,3,u,u,u,u,20,21,28,29,u,u,u,u,u,u,22,23]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5,6],ymm2[7],ymm4[8,9],ymm2[10,11],ymm4[12,13,14],ymm2[15]
; AVX512F-FAST-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm2
; AVX512F-FAST-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,6,7,14,15,u,u,8,9,10,11,12,13,14,15]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3,4,5,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[3],xmm0[4,5,6,7]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm0
; AVX512F-FAST-NEXT:    vmovdqa %ymm2, (%r9)
; AVX512F-FAST-NEXT:    vextracti32x4 $2, %zmm0, %xmm0
; AVX512F-FAST-NEXT:    vmovq %xmm0, 32(%r9)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride5_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <0,4,8,12,16,1,5,9,13,17,2,6,10,14,18,3,7,11,15,19,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm0, %xmm1
; AVX512BW-NEXT:    vmovq %xmm1, 32(%r9)
; AVX512BW-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <4 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <4 x i16>, ptr %in.vecptr4, align 64
  %1 = shufflevector <4 x i16> %in.vec0, <4 x i16> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i16> %in.vec2, <4 x i16> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <8 x i16> %1, <8 x i16> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = shufflevector <4 x i16> %in.vec4, <4 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <16 x i16> %3, <16 x i16> %4, <20 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19>
  %interleaved.vec = shufflevector <20 x i16> %5, <20 x i16> poison, <20 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 1, i32 5, i32 9, i32 13, i32 17, i32 2, i32 6, i32 10, i32 14, i32 18, i32 3, i32 7, i32 11, i32 15, i32 19>
  store <20 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride5_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride5_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm4
; SSE-NEXT:    movdqa (%rsi), %xmm7
; SSE-NEXT:    movdqa (%rdx), %xmm2
; SSE-NEXT:    movdqa (%rcx), %xmm3
; SSE-NEXT:    movdqa (%r8), %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm7[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm0, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [0,65535,65535,65535,0,0,65535,65535]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm2[1,1,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,0,65535,65535,65535,65535,0]
; SSE-NEXT:    pand %xmm1, %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm1, %xmm11
; SSE-NEXT:    pandn %xmm10, %xmm11
; SSE-NEXT:    por %xmm9, %xmm11
; SSE-NEXT:    pand %xmm8, %xmm11
; SSE-NEXT:    pandn %xmm5, %xmm8
; SSE-NEXT:    por %xmm11, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm5, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm5
; SSE-NEXT:    por %xmm8, %xmm5
; SSE-NEXT:    movdqa %xmm2, %xmm8
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm3[0],xmm8[1],xmm3[1],xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,0,2,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,0,0,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm4, %xmm9
; SSE-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm9[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,1,1,1]
; SSE-NEXT:    pand %xmm10, %xmm11
; SSE-NEXT:    pandn %xmm8, %xmm10
; SSE-NEXT:    por %xmm11, %xmm10
; SSE-NEXT:    pand %xmm0, %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm6[0,1,0,1]
; SSE-NEXT:    pandn %xmm8, %xmm0
; SSE-NEXT:    por %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm10
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm7[4],xmm4[5],xmm7[5],xmm4[6],xmm7[6],xmm4[7],xmm7[7]
; SSE-NEXT:    psrlq $48, %xmm7
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm10 = xmm10[1],xmm7[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm7, %xmm11
; SSE-NEXT:    pandn %xmm10, %xmm11
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4],xmm3[4],xmm10[5],xmm3[5],xmm10[6],xmm3[6],xmm10[7],xmm3[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm10[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[2,1,3,3]
; SSE-NEXT:    pand %xmm7, %xmm12
; SSE-NEXT:    por %xmm11, %xmm12
; SSE-NEXT:    pand %xmm1, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,3,2,3]
; SSE-NEXT:    pandn %xmm6, %xmm1
; SSE-NEXT:    por %xmm12, %xmm1
; SSE-NEXT:    pslldq {{.*#+}} xmm10 = zero,zero,xmm10[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,2,2]
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm10, %xmm7
; SSE-NEXT:    por %xmm4, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [0,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm4, %xmm7
; SSE-NEXT:    pandn %xmm6, %xmm4
; SSE-NEXT:    por %xmm7, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm9[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,3,2,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    pandn %xmm8, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, 16(%r9)
; SSE-NEXT:    movdqa %xmm4, 48(%r9)
; SSE-NEXT:    movdqa %xmm1, 64(%r9)
; SSE-NEXT:    movdqa %xmm0, (%r9)
; SSE-NEXT:    movdqa %xmm5, 32(%r9)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride5_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm4
; AVX1-ONLY-NEXT:    vmovdqa (%r8), %xmm0
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm5, %xmm1
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm1 = xmm2[1],xmm1[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm3[4],xmm4[4],xmm3[5],xmm4[5],xmm3[6],xmm4[6],xmm3[7],xmm4[7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm6[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,1,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm7[0,1,2],xmm1[3,4],xmm7[5,6,7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,0,2,1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm9 = xmm8[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[0,1,1,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm9[0,1],xmm7[2,3],xmm9[4,5,6],xmm7[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm0[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1,2,3],xmm9[4],xmm7[5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[0,2,2,3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm10[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm10[0,1],xmm8[2,3],xmm10[4,5],xmm8[6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0],xmm9[1],xmm8[2,3,4,5],xmm9[6],xmm8[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm6 = zero,zero,xmm6[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm2[4],xmm5[4],xmm2[5],xmm5[5],xmm2[6],xmm5[6],xmm2[7],xmm5[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm9 = xmm9[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[0,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm9[0,1,2],xmm6[3,4],xmm9[5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm9[0],xmm6[1,2,3,4],xmm9[5],xmm6[6,7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm5[0,1,2,3],xmm2[4],xmm5[5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm4[2],xmm3[3,4,5,6],xmm4[7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1,2,3],xmm2[4,5],xmm3[6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm2[0,1,2],xmm0[3],xmm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, 32(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, 48(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, 16(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, (%r9)
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1],xmm9[2],xmm1[3,4,5,6],xmm9[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, 64(%r9)
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride5_vf8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm3
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm4
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm5
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm6
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm7 = ymm5[0,1,2,3,5,6,4,7,8,9,10,11,13,14,12,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[0,2,3,2,4,6,7,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm5[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[6,7,10,11,u,u,6,7,u,u,8,9,12,13,u,u,22,23,26,27,u,u,22,23,u,u,24,25,28,29,u,u]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0,1],ymm7[2],ymm8[3],ymm7[4],ymm8[5,6],ymm7[7],ymm8[8,9],ymm7[10],ymm8[11],ymm7[12],ymm8[13,14],ymm7[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm6[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[u,u,u,u,6,7,10,11,u,u,u,u,u,u,8,9,u,u,u,u,22,23,26,27,u,u,u,u,u,u,24,25]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm6[3,3,3,3,4,5,6,7,11,11,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm9 = ymm9[0,1,2,3,5,5,4,7,8,9,10,11,13,13,12,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0,1],ymm8[2,3],ymm9[4,5,6],ymm8[7],ymm9[8,9],ymm8[10,11],ymm9[12,13,14],ymm8[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = <255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,1,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm7, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,2,0]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,ymm6[0,1,8,9,12,13],zero,zero,zero,zero,ymm6[2,3,18,19,18,19],zero,zero,zero,zero,ymm6[28,29,20,21,28,29],zero,zero
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,2,0,2]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[0,1,8,9],zero,zero,zero,zero,zero,zero,ymm5[2,3,10,11],zero,zero,zero,zero,zero,zero,ymm5[20,21,28,29],zero,zero,zero,zero,zero,zero,ymm5[22,23]
; AVX2-SLOW-NEXT:    vpor %ymm6, %ymm5, %ymm5
; AVX2-SLOW-NEXT:    vpbroadcastq (%r8), %ymm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-SLOW-NEXT:    vpsrlq $48, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm3[4],xmm1[5],xmm3[5],xmm1[6],xmm3[6],xmm1[7],xmm3[7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,7,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,1,3,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[3,4],xmm1[5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastd 12(%r8), %xmm1
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4,5,6],xmm1[7]
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, 64(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, (%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, 32(%r9)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride5_vf8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm3
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm4
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm5
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm6
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = <1,5,2,6,2,6,u,u>
; AVX2-FAST-NEXT:    vpermd %ymm6, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm7 = zero,zero,ymm7[2,3,6,7,2,3],zero,zero,zero,zero,ymm7[8,9,12,13,16,17],zero,zero,zero,zero,ymm7[18,19,22,23,28,29],zero,zero,zero,zero
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = <5,2,6,u,2,6,3,7>
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[2,3],zero,zero,zero,zero,zero,zero,ymm8[4,5,8,9],zero,zero,zero,zero,zero,zero,ymm8[18,19,22,23],zero,zero,zero,zero,zero,zero,ymm8[24,25,28,29]
; AVX2-FAST-NEXT:    vpor %ymm7, %ymm8, %ymm7
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,1,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm7, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,2,0]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,ymm6[0,1,8,9,12,13],zero,zero,zero,zero,ymm6[2,3,18,19,18,19],zero,zero,zero,zero,ymm6[28,29,20,21,28,29],zero,zero
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,2,0,2]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[0,1,8,9],zero,zero,zero,zero,zero,zero,ymm5[2,3,10,11],zero,zero,zero,zero,zero,zero,ymm5[20,21,28,29],zero,zero,zero,zero,zero,zero,ymm5[22,23]
; AVX2-FAST-NEXT:    vpor %ymm6, %ymm5, %ymm5
; AVX2-FAST-NEXT:    vpbroadcastq (%r8), %ymm6
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-FAST-NEXT:    vpsrlq $48, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[8,9,10,11,u,u,u,u,u,u,12,13,14,15,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[3,4],xmm1[5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastd 12(%r8), %xmm1
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4,5,6],xmm1[7]
; AVX2-FAST-NEXT:    vmovdqa %xmm0, 64(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm5, (%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm4, 32(%r9)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride5_vf8:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %xmm4
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm7 = ymm5[u,u,u,u,10,11,u,u,8,9,u,u,u,u,12,13,u,u,u,u,26,27,u,u,24,25,u,u,u,u,28,29]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm5[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[6,7,10,11,u,u,6,7,u,u,8,9,12,13,u,u,22,23,26,27,u,u,22,23,u,u,24,25,28,29,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0,1],ymm7[2],ymm8[3],ymm7[4],ymm8[5,6],ymm7[7],ymm8[8,9],ymm7[10],ymm8[11],ymm7[12],ymm8[13,14],ymm7[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm8 = ymm6[6,7,6,7,u,u,u,u,10,11,10,11,8,9,u,u,22,23,22,23,u,u,u,u,26,27,26,27,24,25,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm6[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[u,u,u,u,6,7,10,11,u,u,u,u,u,u,8,9,u,u,u,u,22,23,26,27,u,u,u,u,u,u,24,25]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6],ymm9[7],ymm8[8,9],ymm9[10,11],ymm8[12,13,14],ymm9[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = <255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,1,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm7, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,2,0]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,ymm6[0,1,8,9,12,13],zero,zero,zero,zero,ymm6[2,3,18,19,18,19],zero,zero,zero,zero,ymm6[28,29,20,21,28,29],zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,2,0,2]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[0,1,8,9],zero,zero,zero,zero,zero,zero,ymm5[2,3,10,11],zero,zero,zero,zero,zero,zero,ymm5[20,21,28,29],zero,zero,zero,zero,zero,zero,ymm5[22,23]
; AVX2-FAST-PERLANE-NEXT:    vpor %ymm6, %ymm5, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq (%r8), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpsrlq $48, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[8,9,10,11,u,u,u,u,u,u,12,13,14,15,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[3,4],xmm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 12(%r8), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4,5,6],xmm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, 64(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm5, (%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, 32(%r9)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride5_vf8:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %xmm3
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %xmm0
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa (%r8), %xmm4
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm5
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm6
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[u,u,u,u,6,7,u,u,u,u,u,u,u,u,8,9,u,u,u,u,u,u,26,27,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm6[1,1,2,3,5,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm8 = ymm8[0,1,2,3,5,5,4,7,8,9,10,11,13,13,12,15]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0,1],ymm7[2,3],ymm8[4,5,6],ymm7[7],ymm8[8,9],ymm7[10,11],ymm8[12,13,14],ymm7[15]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpandn %ymm7, %ymm8, %ymm7
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,2,0]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,ymm6[0,1,8,9,u,u],zero,zero,zero,zero,ymm6[2,3,18,19,u,u],zero,zero,zero,zero,ymm6[28,29,20,21,u,u],zero,zero
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm7, %zmm6, %zmm6
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm7 = ymm5[0,1,2,3,5,6,4,7,8,9,10,11,13,14,12,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[0,2,3,2,4,6,7,6]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm5[2,3,0,1]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[6,7,u,u,u,u,u,u,u,u,8,9,u,u,u,u,u,u,26,27,u,u,u,u,u,u,u,u,28,29,u,u]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm9[0,1],ymm7[2],ymm9[3],ymm7[4],ymm9[5,6],ymm7[7],ymm9[8,9],ymm7[10],ymm9[11],ymm7[12],ymm9[13,14],ymm7[15]
; AVX512F-SLOW-NEXT:    vpand %ymm7, %ymm8, %ymm7
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,2,0,2]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[0,1,8,9],zero,zero,zero,zero,ymm5[u,u,2,3,10,11],zero,zero,zero,zero,ymm5[u,u,20,21,28,29],zero,zero,zero,zero,ymm5[u,u,22,23]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm7, %zmm5, %zmm5
; AVX512F-SLOW-NEXT:    vporq %zmm6, %zmm5, %zmm5
; AVX512F-SLOW-NEXT:    vpbroadcastq (%r8), %ymm6
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,1,1]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm6, %zmm4
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm5, %zmm4
; AVX512F-SLOW-NEXT:    vpsrlq $48, %xmm3, %xmm3
; AVX512F-SLOW-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,7,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm2[3,4],xmm0[5,6,7]
; AVX512F-SLOW-NEXT:    vpbroadcastd 12(%r8), %xmm1
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4,5,6],xmm1[7]
; AVX512F-SLOW-NEXT:    vmovdqa %xmm0, 64(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm4, (%r9)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride5_vf8:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512F-FAST-NEXT:    vmovdqa (%r8), %xmm4
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm5
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm6
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[0,2,2,0]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm7 = zero,zero,zero,zero,ymm7[0,1,8,9,u,u],zero,zero,zero,zero,ymm7[2,3,18,19,u,u],zero,zero,zero,zero,ymm7[28,29,20,21,u,u],zero,zero
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = <1,5,2,6,2,6,u,u>
; AVX512F-FAST-NEXT:    vpermd %ymm6, %ymm8, %ymm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,ymm6[2,3,6,7,u,u],zero,zero,zero,zero,ymm6[8,9,12,13,u,u],zero,zero,zero,zero,ymm6[18,19,22,23,u,u],zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm6, %zmm7, %zmm6
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm5[0,2,0,2]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[0,1,8,9],zero,zero,zero,zero,ymm7[u,u,2,3,10,11],zero,zero,zero,zero,ymm7[u,u,20,21,28,29],zero,zero,zero,zero,ymm7[u,u,22,23]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = <5,2,6,u,2,6,3,7>
; AVX512F-FAST-NEXT:    vpermd %ymm5, %ymm8, %ymm5
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[2,3],zero,zero,zero,zero,ymm5[u,u,4,5,8,9],zero,zero,zero,zero,ymm5[u,u,18,19,22,23],zero,zero,zero,zero,ymm5[u,u,24,25,28,29]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm7, %zmm5
; AVX512F-FAST-NEXT:    vporq %zmm6, %zmm5, %zmm5
; AVX512F-FAST-NEXT:    vpbroadcastq (%r8), %ymm6
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,1,1]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm6, %zmm4
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm5, %zmm4
; AVX512F-FAST-NEXT:    vpsrlq $48, %xmm1, %xmm1
; AVX512F-FAST-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[8,9,10,11,u,u,u,u,u,u,12,13,14,15,u,u]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[3,4],xmm1[5,6,7]
; AVX512F-FAST-NEXT:    vpbroadcastd 12(%r8), %xmm1
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4,5,6],xmm1[7]
; AVX512F-FAST-NEXT:    vmovdqa %xmm0, 64(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, (%r9)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride5_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vmovdqa (%r8), %xmm2
; AVX512BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm1 = [22,30,38,7,15,23,31,39]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,8,16,24,32,1,9,17,25,33,2,10,18,26,34,3,11,19,27,35,4,12,20,28,36,5,13,21,29,37,6,14]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512BW-NEXT:    vmovdqa %xmm1, 64(%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <8 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <8 x i16>, ptr %in.vecptr4, align 64
  %1 = shufflevector <8 x i16> %in.vec0, <8 x i16> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i16> %in.vec2, <8 x i16> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <16 x i16> %1, <16 x i16> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = shufflevector <8 x i16> %in.vec4, <8 x i16> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <32 x i16> %3, <32 x i16> %4, <40 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39>
  %interleaved.vec = shufflevector <40 x i16> %5, <40 x i16> poison, <40 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 1, i32 9, i32 17, i32 25, i32 33, i32 2, i32 10, i32 18, i32 26, i32 34, i32 3, i32 11, i32 19, i32 27, i32 35, i32 4, i32 12, i32 20, i32 28, i32 36, i32 5, i32 13, i32 21, i32 29, i32 37, i32 6, i32 14, i32 22, i32 30, i32 38, i32 7, i32 15, i32 23, i32 31, i32 39>
  store <40 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride5_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride5_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    movdqa 16(%rdi), %xmm5
; SSE-NEXT:    movdqa (%rsi), %xmm15
; SSE-NEXT:    movdqa 16(%rsi), %xmm13
; SSE-NEXT:    movdqa 16(%rdx), %xmm10
; SSE-NEXT:    movdqa (%rcx), %xmm14
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rcx), %xmm11
; SSE-NEXT:    movdqa 16(%r8), %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm13[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [0,65535,65535,65535,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm10[1,1,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535,0,65535,65535,65535,65535,0]
; SSE-NEXT:    pand %xmm9, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm11[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm12
; SSE-NEXT:    pandn %xmm7, %xmm12
; SSE-NEXT:    por %xmm6, %xmm12
; SSE-NEXT:    pand %xmm0, %xmm12
; SSE-NEXT:    por %xmm4, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm3, %xmm12
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    por %xmm12, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    pandn %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm15[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm15, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm2, %xmm12
; SSE-NEXT:    por %xmm7, %xmm12
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm14[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm14
; SSE-NEXT:    pandn %xmm7, %xmm14
; SSE-NEXT:    movdqa (%rdx), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm15 = xmm2[1,1,2,2]
; SSE-NEXT:    pand %xmm9, %xmm15
; SSE-NEXT:    por %xmm15, %xmm14
; SSE-NEXT:    pand %xmm0, %xmm14
; SSE-NEXT:    pandn %xmm12, %xmm0
; SSE-NEXT:    movdqa (%r8), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    por %xmm14, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm12
; SSE-NEXT:    movdqa %xmm5, %xmm14
; SSE-NEXT:    punpckhwd {{.*#+}} xmm14 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm13[0],xmm5[1],xmm13[1],xmm5[2],xmm13[2],xmm5[3],xmm13[3]
; SSE-NEXT:    psrlq $48, %xmm13
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm12 = xmm12[1],xmm13[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm13
; SSE-NEXT:    pandn %xmm12, %xmm13
; SSE-NEXT:    movdqa %xmm10, %xmm12
; SSE-NEXT:    punpckhwd {{.*#+}} xmm12 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm15 = xmm12[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm15 = xmm15[2,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm15
; SSE-NEXT:    por %xmm13, %xmm15
; SSE-NEXT:    pand %xmm9, %xmm15
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm8[2,3,2,3]
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm15, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm12 = zero,zero,xmm12[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm2, %xmm15
; SSE-NEXT:    pandn %xmm12, %xmm15
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm14[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[0,1,2,2]
; SSE-NEXT:    pand %xmm2, %xmm12
; SSE-NEXT:    por %xmm15, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [0,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm15, %xmm14
; SSE-NEXT:    pandn %xmm1, %xmm14
; SSE-NEXT:    pand %xmm15, %xmm12
; SSE-NEXT:    por %xmm12, %xmm14
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm5[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movdqa %xmm11, %xmm12
; SSE-NEXT:    punpcklwd {{.*#+}} xmm12 = xmm12[0],xmm10[0],xmm12[1],xmm10[1],xmm12[2],xmm10[2],xmm12[3],xmm10[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm12[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm12[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm8[0,1,0,1]
; SSE-NEXT:    movdqa %xmm12, %xmm13
; SSE-NEXT:    pandn %xmm1, %xmm13
; SSE-NEXT:    por %xmm0, %xmm13
; SSE-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm11[0],xmm10[1],xmm11[1],xmm10[2],xmm11[2],xmm10[3],xmm11[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm10[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,0,0,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm10, %xmm11
; SSE-NEXT:    pandn %xmm0, %xmm11
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm5[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,1]
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pandn %xmm1, %xmm7
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm0, %xmm7
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1],xmm6[2],xmm4[2],xmm6[3],xmm4[3]
; SSE-NEXT:    psrlq $48, %xmm11
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm11[1]
; SSE-NEXT:    movdqa %xmm2, %xmm11
; SSE-NEXT:    pandn %xmm1, %xmm11
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm3[4],xmm1[5],xmm3[5],xmm1[6],xmm3[6],xmm1[7],xmm3[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm1[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[2,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm8
; SSE-NEXT:    por %xmm11, %xmm8
; SSE-NEXT:    pand %xmm9, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm5[2,3,2,3]
; SSE-NEXT:    pandn %xmm11, %xmm9
; SSE-NEXT:    por %xmm8, %xmm9
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,2]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    pand %xmm15, %xmm2
; SSE-NEXT:    pandn %xmm11, %xmm15
; SSE-NEXT:    por %xmm2, %xmm15
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm6[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[0,1,0,1]
; SSE-NEXT:    pandn %xmm0, %xmm12
; SSE-NEXT:    por %xmm1, %xmm12
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm4[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm6[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,1,1]
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm10
; SSE-NEXT:    por %xmm2, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm10, %xmm1
; SSE-NEXT:    movdqa %xmm1, (%r9)
; SSE-NEXT:    movdqa %xmm12, 16(%r9)
; SSE-NEXT:    movdqa %xmm15, 48(%r9)
; SSE-NEXT:    movdqa %xmm9, 64(%r9)
; SSE-NEXT:    movdqa %xmm7, 80(%r9)
; SSE-NEXT:    movdqa %xmm13, 96(%r9)
; SSE-NEXT:    movdqa %xmm14, 128(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r9)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride5_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm9
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm9[4],xmm7[4],xmm9[5],xmm7[5],xmm9[6],xmm7[6],xmm9[7],xmm7[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm6 = [65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm6, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm4
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm12
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm12, %xmm3
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm3 = xmm10[1],xmm3[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm10[4],xmm12[4],xmm10[5],xmm12[5],xmm10[6],xmm12[6],xmm10[7],xmm12[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm8[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm8, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa 16(%r8), %xmm11
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm11[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm8[2],xmm0[3,4,5,6],xmm8[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm8[0],xmm3[1,2,3,4],xmm8[5],xmm3[6,7]
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm4, %xmm8
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm8 = xmm2[1],xmm8[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm10[0],xmm12[0],xmm10[1],xmm12[1],xmm10[2],xmm12[2],xmm10[3],xmm12[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm14 = xmm13[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[0,1,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm8, %ymm14
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm5[4],xmm1[4],xmm5[5],xmm1[5],xmm5[6],xmm1[6],xmm5[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm15 = xmm8[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,1,3,3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm15, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm14, %ymm6, %ymm14
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm14, %ymm6
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm6, %xmm0
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm12[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm12[0,1,2,3],xmm10[4],xmm12[5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm13[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm7[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm13 = xmm10[0,1],xmm13[2],xmm10[3,4,5,6],xmm13[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm11[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm0[0,1,2,3],xmm14[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm7[0],xmm9[0],xmm7[1],xmm9[1],xmm7[2],xmm9[2],xmm7[3],xmm9[3]
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm15 = [65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm12, %ymm15, %ymm7
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm15, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm0[0],xmm14[1],xmm0[2,3,4,5],xmm14[6],xmm0[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm9 = xmm0[0,1,2],xmm11[3],xmm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm1[0],xmm5[0],xmm1[1],xmm5[1],xmm1[2],xmm5[2],xmm1[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[1,1,2,3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm2[0],xmm4[0],xmm2[1],xmm4[1],xmm2[2],xmm4[2],xmm2[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm11[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[0,1,1,1]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm12, %ymm11
; AVX1-ONLY-NEXT:    vmovdqa (%r8), %xmm12
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm15, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm15, %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm11, %ymm0
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm11
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm12[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0],xmm13[1],xmm11[2,3,4,5],xmm13[6],xmm11[7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm13[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm5[0,1],xmm1[2],xmm5[3,4,5,6],xmm1[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm5 = zero,zero,xmm8[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm4[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3],xmm2[4],xmm5[5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm2[4],xmm4[4],xmm2[5],xmm4[5],xmm2[6],xmm4[6],xmm2[7],xmm4[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm5, %ymm2
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm4 = [65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm4, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm12[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm6[0,1],xmm2[2],xmm6[3,4,5,6],xmm2[7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm1[0,1,2],xmm12[3],xmm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0],xmm1[1,2,3,4],xmm2[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, 48(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, 32(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, (%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm11, 16(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm9, 112(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, 96(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, 64(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm10, 80(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, 128(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 144(%r9)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride5_vf16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm3
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm4
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %ymm1
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm7
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm8
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm9
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm6
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm6[0],xmm9[0],xmm6[1],xmm9[1],xmm6[2],xmm9[2],xmm6[3],xmm9[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,5,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm6, %ymm5, %ymm5
; AVX2-SLOW-NEXT:    vpbroadcastq (%r8), %ymm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm5, %ymm6, %ymm5
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm3[1,1,1,2,5,5,5,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm10 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm10[0],ymm6[1],ymm10[2,3],ymm6[4],ymm10[5],ymm6[6],ymm10[7,8],ymm6[9],ymm10[10,11],ymm6[12],ymm10[13],ymm6[14],ymm10[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,3,2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm0[0,1,2,1,4,5,6,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm11 = ymm2[3,1,2,2,4,5,6,7,11,9,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm11[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm11[0,1],ymm10[2],ymm11[3],ymm10[4],ymm11[5,6],ymm10[7],ymm11[8,9],ymm10[10],ymm11[11],ymm10[12],ymm11[13,14],ymm10[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = <255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm6, %ymm10, %ymm6
; AVX2-SLOW-NEXT:    vpbroadcastq 16(%r8), %ymm10
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm6, %ymm10, %ymm6
; AVX2-SLOW-NEXT:    vpbroadcastq 8(%rdi), %xmm10
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0],xmm10[1],xmm9[2,3],xmm10[4],xmm9[5],xmm10[6],xmm9[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,2,2,2]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm7 = xmm8[0],xmm7[1],xmm8[2],xmm7[3],xmm8[4,5],xmm7[6],xmm8[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,0]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = <255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm9, %ymm7, %ymm7
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm1[0,1,1,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm9 = ymm2[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[2,3,2,2,6,7,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2],ymm8[3],ymm9[4,5],ymm8[6],ymm9[7,8],ymm8[9],ymm9[10],ymm8[11],ymm9[12,13],ymm8[14],ymm9[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,2]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm3[3,2,3,3,7,6,7,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm10 = ymm4[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm10[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm9 = ymm10[0],ymm9[1],ymm10[2],ymm9[3,4],ymm10[5,6,7,8],ymm9[9],ymm10[10],ymm9[11,12],ymm10[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = <u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-SLOW-NEXT:    vpbroadcastq 24(%r8), %ymm9
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = [0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[3,0,3,0,7,4,7,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[3],ymm3[4,5],ymm4[6],ymm3[7,8],ymm4[9],ymm3[10],ymm4[11],ymm3[12,13],ymm4[14],ymm3[15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm2[1],ymm0[2,3],ymm2[4],ymm0[5],ymm2[6],ymm0[7,8],ymm2[9],ymm0[10,11],ymm2[12],ymm0[13],ymm2[14],ymm0[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 64(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, 128(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm7, 32(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, 96(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, (%r9)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride5_vf16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm2
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm3
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %ymm4
; AVX2-FAST-NEXT:    vmovdqa (%r8), %ymm1
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm6
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm5
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm7
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm8
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm5, %ymm9, %ymm5
; AVX2-FAST-NEXT:    vpbroadcastq (%r8), %ymm9
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm5, %ymm9, %ymm5
; AVX2-FAST-NEXT:    vpbroadcastq 8(%rdi), %xmm9
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0],xmm9[1],xmm6[2,3],xmm9[4],xmm6[5],xmm9[6],xmm6[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,2,2,2]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm7 = xmm8[0],xmm7[1],xmm8[2],xmm7[3],xmm8[4,5],xmm7[6],xmm8[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,0]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = <255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm6, %ymm7, %ymm6
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm1[0,1,1,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm6, %ymm7, %ymm6
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm7 = ymm3[1,1,1,2,5,5,5,6]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2,3],ymm7[4],ymm8[5],ymm7[6],ymm8[7,8],ymm7[9],ymm8[10,11],ymm7[12],ymm8[13],ymm7[14],ymm8[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm8 = ymm0[0,1,2,1,4,5,6,5]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm9 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,18,19,u,u,20,21,u,u,24,25,24,25,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0,1],ymm8[2],ymm9[3],ymm8[4],ymm9[5,6],ymm8[7],ymm9[8,9],ymm8[10],ymm9[11],ymm8[12],ymm9[13,14],ymm8[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-FAST-NEXT:    vpbroadcastq 16(%r8), %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm8 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm9 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,31,u,u,26,27,u,u,30,31,28,29,u,u,28,29]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2],ymm8[3],ymm9[4,5],ymm8[6],ymm9[7,8],ymm8[9],ymm9[10],ymm8[11],ymm9[12,13],ymm8[14],ymm9[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,2]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm3[3,2,3,3,7,6,7,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm10 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,u,u,30,31,u,u,u,u,28,29,30,31,30,31]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm9 = ymm10[0],ymm9[1],ymm10[2],ymm9[3,4],ymm10[5,6,7,8],ymm9[9],ymm10[10],ymm9[11,12],ymm10[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,3,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = <u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FAST-NEXT:    vpbroadcastq 24(%r8), %ymm9
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[3,0,3,0,7,4,7,4]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[3],ymm3[4,5],ymm4[6],ymm3[7,8],ymm4[9],ymm3[10],ymm4[11],ymm3[12,13],ymm4[14],ymm3[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm2[1],ymm0[2,3],ymm2[4],ymm0[5],ymm2[6],ymm0[7,8],ymm2[9],ymm0[10,11],ymm2[12],ymm0[13],ymm2[14],ymm0[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 64(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm8, 128(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm7, 96(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm6, 32(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm5, (%r9)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride5_vf16:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm5, %ymm9, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq (%r8), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm5, %ymm9, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 8(%rdi), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0],xmm9[1],xmm6[2,3],xmm9[4],xmm6[5],xmm9[6],xmm6[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm7 = xmm8[0],xmm7[1],xmm8[2],xmm7[3],xmm8[4,5],xmm7[6],xmm8[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,0]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = <255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm6, %ymm7, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm1[0,1,1,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm6, %ymm7, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm7 = ymm3[1,1,1,2,5,5,5,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm8 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2,3],ymm7[4],ymm8[5],ymm7[6],ymm8[7,8],ymm7[9],ymm8[10,11],ymm7[12],ymm8[13],ymm7[14],ymm8[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm8 = ymm0[0,1,2,1,4,5,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm9 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,18,19,u,u,20,21,u,u,24,25,24,25,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0,1],ymm8[2],ymm9[3],ymm8[4],ymm9[5,6],ymm8[7],ymm9[8,9],ymm8[10],ymm9[11],ymm8[12],ymm9[13,14],ymm8[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = <255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 16(%r8), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm8 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm9 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,31,u,u,26,27,u,u,30,31,28,29,u,u,28,29]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2],ymm8[3],ymm9[4,5],ymm8[6],ymm9[7,8],ymm8[9],ymm9[10],ymm8[11],ymm9[12,13],ymm8[14],ymm9[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm9 = ymm3[3,2,3,3,7,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm10 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,u,u,30,31,u,u,u,u,28,29,30,31,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm9 = ymm10[0],ymm9[1],ymm10[2],ymm9[3,4],ymm10[5,6,7,8],ymm9[9],ymm10[10],ymm9[11,12],ymm10[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = <u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 24(%r8), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = [0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[3,0,3,0,7,4,7,4]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[3],ymm3[4,5],ymm4[6],ymm3[7,8],ymm4[9],ymm3[10],ymm4[11],ymm3[12,13],ymm4[14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm2[1],ymm0[2,3],ymm2[4],ymm0[5],ymm2[6],ymm0[7,8],ymm2[9],ymm0[10,11],ymm2[12],ymm0[13],ymm2[14],ymm0[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm3, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 64(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm8, 128(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm7, 96(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, 32(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm5, (%r9)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride5_vf16:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %ymm3
; AVX512F-SLOW-NEXT:    vmovdqa (%r8), %ymm4
; AVX512F-SLOW-NEXT:    vpbroadcastq 8(%rdi), %xmm5
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %xmm6
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm6[6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm7[0],xmm5[1],xmm7[2,3],xmm5[4],xmm7[5],xmm5[6],xmm7[7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %xmm7
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm8 = xmm7[1,2,2,2]
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %xmm9
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm10 = xmm9[10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm8 = xmm10[0],xmm8[1],xmm10[2],xmm8[3],xmm10[4,5],xmm8[6],xmm10[7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,0,0]
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm5, %ymm8
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm8, %zmm0, %zmm5
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %xmm8
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,2,1,3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,5,6]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %ymm7, %ymm8, %ymm6
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm6[0,1,2,3],zmm5[4,5,6,7]
; AVX512F-SLOW-NEXT:    vpbroadcastq (%r8), %ymm6
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm4[0,1,1,1]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm7, %zmm6, %zmm6
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm5, %zmm6
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm1[u,u,u,u,u,u,u,u,14,15,u,u,u,u,u,u,u,u,16,17,u,u,u,u,u,u,u,u,18,19,u,u]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm0[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm7[0],ymm5[1],ymm7[2,3],ymm5[4],ymm7[5],ymm5[6],ymm7[7,8],ymm5[9],ymm7[10,11],ymm5[12],ymm7[13],ymm5[14],ymm7[15]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm7 = ymm3[u,u,12,13,u,u,u,u,u,u,u,u,14,15,u,u,u,u,u,u,u,u,16,17,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm2[3,0,3,0,7,4,7,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm9[0],ymm7[1],ymm9[2],ymm7[3],ymm9[4,5],ymm7[6],ymm9[7,8],ymm7[9],ymm9[10],ymm7[11],ymm9[12,13],ymm7[14],ymm9[15]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %ymm5, %ymm9, %ymm7
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm0[0,1,2,1,4,5,6,5]
; AVX512F-SLOW-NEXT:    vprolq $16, %ymm1, %ymm10
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm10[0,1],ymm5[2],ymm10[3],ymm5[4],ymm10[5,6],ymm5[7],ymm10[8,9],ymm5[10],ymm10[11],ymm5[12],ymm10[13,14],ymm5[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm2[1,1,1,2,5,5,5,6]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm11 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm11[0],ymm10[1],ymm11[2,3],ymm10[4],ymm11[5],ymm10[6],ymm11[7,8],ymm10[9],ymm11[10,11],ymm10[12],ymm11[13],ymm10[14],ymm11[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,3,2,3]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %ymm5, %ymm8, %ymm10
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm10, %zmm0, %zmm5
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm7[0,1,2,3],zmm5[4,5,6,7]
; AVX512F-SLOW-NEXT:    vpbroadcastq 16(%r8), %ymm7
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpandn %ymm7, %ymm8, %ymm7
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,ymm4[12,13],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[14,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[16,17],zero,zero,zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm7, %zmm4, %zmm4
; AVX512F-SLOW-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm5, %zmm4
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[3,2,3,3,7,6,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm3[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2],ymm2[3,4],ymm3[5,6,7,8],ymm2[9],ymm3[10],ymm2[11,12],ymm3[13,14,15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,3,2]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm1[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,3,2,2,6,7,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8],ymm0[9],ymm1[10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,2]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %ymm2, %ymm9, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0]
; AVX512F-SLOW-NEXT:    vpternlogq $202, 24(%r8){1to4}, %ymm0, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa %ymm1, 128(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm4, 64(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm6, (%r9)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride5_vf16:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %ymm3
; AVX512F-FAST-NEXT:    vmovdqa (%r8), %ymm4
; AVX512F-FAST-NEXT:    vpbroadcastq 8(%rdi), %xmm5
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %xmm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm6[6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm7[0],xmm5[1],xmm7[2,3],xmm5[4],xmm7[5],xmm5[6],xmm7[7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %xmm7
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm8 = xmm7[1,2,2,2]
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %xmm9
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm10 = xmm9[10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm8 = xmm10[0],xmm8[1],xmm10[2],xmm8[3],xmm10[4,5],xmm8[6],xmm10[7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,0,0]
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm5, %ymm8
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm8, %zmm0, %zmm5
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %xmm8
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $226, %ymm7, %ymm8, %ymm6
; AVX512F-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm6[0,1,2,3],zmm5[4,5,6,7]
; AVX512F-FAST-NEXT:    vpbroadcastq (%r8), %ymm6
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm4[0,1,1,1]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm7, %zmm6, %zmm6
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm5, %zmm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = ymm1[u,u,u,u,u,u,u,u,14,15,u,u,u,u,u,u,u,u,16,17,u,u,u,u,u,u,u,u,18,19,u,u]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm0[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm7[0],ymm5[1],ymm7[2,3],ymm5[4],ymm7[5],ymm5[6],ymm7[7,8],ymm5[9],ymm7[10,11],ymm5[12],ymm7[13],ymm5[14],ymm7[15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm7 = ymm3[u,u,12,13,u,u,u,u,u,u,u,u,14,15,u,u,u,u,u,u,u,u,16,17,u,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm2[3,0,3,0,7,4,7,4]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm9[0],ymm7[1],ymm9[2],ymm7[3],ymm9[4,5],ymm7[6],ymm9[7,8],ymm7[9],ymm9[10],ymm7[11],ymm9[12,13],ymm7[14],ymm9[15]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535]
; AVX512F-FAST-NEXT:    vpternlogq $226, %ymm5, %ymm9, %ymm7
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm0[0,1,2,1,4,5,6,5]
; AVX512F-FAST-NEXT:    vprolq $16, %ymm1, %ymm10
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm10[0,1],ymm5[2],ymm10[3],ymm5[4],ymm10[5,6],ymm5[7],ymm10[8,9],ymm5[10],ymm10[11],ymm5[12],ymm10[13,14],ymm5[15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm10 = ymm2[1,1,1,2,5,5,5,6]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm11 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm10 = ymm11[0],ymm10[1],ymm11[2,3],ymm10[4],ymm11[5],ymm10[6],ymm11[7,8],ymm10[9],ymm11[10,11],ymm10[12],ymm11[13],ymm10[14],ymm11[15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,3,2,3]
; AVX512F-FAST-NEXT:    vpternlogq $226, %ymm5, %ymm8, %ymm10
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm10, %zmm0, %zmm5
; AVX512F-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm7[0,1,2,3],zmm5[4,5,6,7]
; AVX512F-FAST-NEXT:    vpbroadcastq 16(%r8), %ymm7
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpandn %ymm7, %ymm8, %ymm7
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,ymm4[12,13],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[14,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[16,17],zero,zero,zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm7, %zmm4, %zmm4
; AVX512F-FAST-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm5, %zmm4
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[3,2,3,3,7,6,7,7]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,u,u,30,31,u,u,u,u,28,29,30,31,30,31]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2],ymm2[3,4],ymm3[5,6,7,8],ymm2[9],ymm3[10],ymm2[11,12],ymm3[13,14,15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,3,2]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,31,u,u,26,27,u,u,30,31,28,29,u,u,28,29]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8],ymm0[9],ymm1[10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,2]
; AVX512F-FAST-NEXT:    vpternlogq $226, %ymm2, %ymm9, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0]
; AVX512F-FAST-NEXT:    vpternlogq $202, 24(%r8){1to4}, %ymm0, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa %ymm1, 128(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, 64(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm6, (%r9)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride5_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vmovdqa (%r8), %ymm2
; AVX512BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,13,29,45,61,u,14,30,46,62,u,15,31,47,63,u>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <0,16,32,48,u,1,17,33,49,u,2,18,34,50,u,3,19,35,51,u,4,20,36,52,u,5,21,37,53,u,6,22>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [0,1,2,3,32,5,6,7,8,33,10,11,12,13,34,15,16,17,18,35,20,21,22,23,36,25,26,27,28,37,30,31]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm4, %zmm5
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <6,22,u,39,55,7,23,u,40,56,8,24,u,41,57,9,25,u,42,58,10,26,u,43,59,11,27,u,44,60,12,28>
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm1, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,1,38,3,4,5,6,39,8,9,10,11,40,13,14,15,16,41,18,19,20,21,42,23,24,25,26,43,28,29,30,31]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm4, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 64(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%r9)
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm0 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512BW-NEXT:    vpermi2w %ymm2, %ymm3, %ymm0
; AVX512BW-NEXT:    vmovdqa %ymm0, 128(%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <16 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <16 x i16>, ptr %in.vecptr4, align 64
  %1 = shufflevector <16 x i16> %in.vec0, <16 x i16> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i16> %in.vec2, <16 x i16> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <32 x i16> %1, <32 x i16> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = shufflevector <16 x i16> %in.vec4, <16 x i16> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <64 x i16> %3, <64 x i16> %4, <80 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79>
  %interleaved.vec = shufflevector <80 x i16> %5, <80 x i16> poison, <80 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 1, i32 17, i32 33, i32 49, i32 65, i32 2, i32 18, i32 34, i32 50, i32 66, i32 3, i32 19, i32 35, i32 51, i32 67, i32 4, i32 20, i32 36, i32 52, i32 68, i32 5, i32 21, i32 37, i32 53, i32 69, i32 6, i32 22, i32 38, i32 54, i32 70, i32 7, i32 23, i32 39, i32 55, i32 71, i32 8, i32 24, i32 40, i32 56, i32 72, i32 9, i32 25, i32 41, i32 57, i32 73, i32 10, i32 26, i32 42, i32 58, i32 74, i32 11, i32 27, i32 43, i32 59, i32 75, i32 12, i32 28, i32 44, i32 60, i32 76, i32 13, i32 29, i32 45, i32 61, i32 77, i32 14, i32 30, i32 46, i32 62, i32 78, i32 15, i32 31, i32 47, i32 63, i32 79>
  store <80 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride5_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride5_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $232, %rsp
; SSE-NEXT:    movdqa (%rdi), %xmm6
; SSE-NEXT:    movdqa 16(%rdi), %xmm11
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsi), %xmm8
; SSE-NEXT:    movdqa 16(%rsi), %xmm13
; SSE-NEXT:    movdqa (%rdx), %xmm2
; SSE-NEXT:    movdqa (%rcx), %xmm0
; SSE-NEXT:    movdqa 16(%rcx), %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%r8), %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm6, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm8[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm9, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,65535,65535,65535,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[1,1,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [65535,65535,0,65535,65535,65535,65535,0]
; SSE-NEXT:    pand %xmm14, %xmm5
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm14, %xmm10
; SSE-NEXT:    pandn %xmm7, %xmm10
; SSE-NEXT:    por %xmm5, %xmm10
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    por %xmm4, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm5, %xmm10
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm15, %xmm3
; SSE-NEXT:    por %xmm10, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    pandn %xmm11, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm13[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm9, %xmm7
; SSE-NEXT:    por %xmm4, %xmm7
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm7, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm12[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm14, %xmm7
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    movdqa 16(%rdx), %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm4[1,1,2,2]
; SSE-NEXT:    pand %xmm14, %xmm11
; SSE-NEXT:    por %xmm11, %xmm7
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    por %xmm10, %xmm7
; SSE-NEXT:    movdqa 16(%r8), %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm5, %xmm7
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm10, %xmm3
; SSE-NEXT:    por %xmm7, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    movdqa 32(%rsi), %xmm3
; SSE-NEXT:    movdqa %xmm3, (%rsp) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm9, %xmm10
; SSE-NEXT:    por %xmm7, %xmm10
; SSE-NEXT:    movdqa %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm10, %xmm7
; SSE-NEXT:    movdqa 32(%rcx), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm14, %xmm11
; SSE-NEXT:    pandn %xmm10, %xmm11
; SSE-NEXT:    movdqa 32(%rdx), %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm10[1,1,2,2]
; SSE-NEXT:    pand %xmm14, %xmm12
; SSE-NEXT:    por %xmm12, %xmm11
; SSE-NEXT:    pand %xmm1, %xmm11
; SSE-NEXT:    por %xmm7, %xmm11
; SSE-NEXT:    pand %xmm5, %xmm11
; SSE-NEXT:    movdqa 32(%r8), %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm7, %xmm3
; SSE-NEXT:    por %xmm11, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    movdqa 48(%rsi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm9, %xmm11
; SSE-NEXT:    por %xmm7, %xmm11
; SSE-NEXT:    movdqa 48(%rcx), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm14, %xmm12
; SSE-NEXT:    pandn %xmm7, %xmm12
; SSE-NEXT:    movdqa 48(%rdx), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm3[1,1,2,2]
; SSE-NEXT:    pand %xmm14, %xmm7
; SSE-NEXT:    por %xmm7, %xmm12
; SSE-NEXT:    pand %xmm1, %xmm12
; SSE-NEXT:    pandn %xmm11, %xmm1
; SSE-NEXT:    por %xmm12, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    movdqa 48(%r8), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[0,0,2,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,0,0,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm3, %xmm11
; SSE-NEXT:    pandn %xmm7, %xmm11
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm7[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[0,1,1,1]
; SSE-NEXT:    pand %xmm3, %xmm12
; SSE-NEXT:    por %xmm11, %xmm12
; SSE-NEXT:    pand %xmm9, %xmm12
; SSE-NEXT:    movdqa %xmm15, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm15[0,1,0,1]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm11, %xmm1
; SSE-NEXT:    por %xmm12, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[2,3,2,3]
; SSE-NEXT:    movdqa %xmm0, %xmm12
; SSE-NEXT:    punpcklwd {{.*#+}} xmm12 = xmm12[0],xmm2[0],xmm12[1],xmm2[1],xmm12[2],xmm2[2],xmm12[3],xmm2[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm12[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm7[0],xmm12[1],xmm7[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pandn %xmm11, %xmm1
; SSE-NEXT:    pand %xmm7, %xmm12
; SSE-NEXT:    por %xmm12, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    pslldq {{.*#+}} xmm7 = zero,zero,xmm7[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm11
; SSE-NEXT:    pandn %xmm7, %xmm11
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm7[0,1,2,2]
; SSE-NEXT:    pand %xmm1, %xmm12
; SSE-NEXT:    por %xmm11, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [0,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm15, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm5[2,3,2,3]
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    pandn %xmm11, %xmm0
; SSE-NEXT:    por %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm8
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm6 = xmm6[1],xmm8[1]
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    por %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm11, %xmm0
; SSE-NEXT:    pand %xmm14, %xmm2
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm13[0],xmm2[1],xmm13[1],xmm2[2],xmm13[2],xmm2[3],xmm13[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm2[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,1,1,1]
; SSE-NEXT:    pand %xmm3, %xmm8
; SSE-NEXT:    por %xmm6, %xmm8
; SSE-NEXT:    pand %xmm9, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm11[0,1,0,1]
; SSE-NEXT:    movdqa %xmm9, %xmm7
; SSE-NEXT:    pandn %xmm6, %xmm7
; SSE-NEXT:    por %xmm8, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,3,2,3]
; SSE-NEXT:    movdqa %xmm5, %xmm8
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm4[0],xmm8[1],xmm4[1],xmm8[2],xmm4[2],xmm8[3],xmm4[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm2[0],xmm8[1],xmm2[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    pandn %xmm6, %xmm7
; SSE-NEXT:    pand %xmm2, %xmm8
; SSE-NEXT:    movdqa %xmm2, %xmm12
; SSE-NEXT:    por %xmm8, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm5[4],xmm4[5],xmm5[5],xmm4[6],xmm5[6],xmm4[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pslldq {{.*#+}} xmm2 = zero,zero,xmm2[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm13[4],xmm2[5],xmm13[5],xmm2[6],xmm13[6],xmm2[7],xmm13[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,2]
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    pand %xmm15, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm11[2,3,2,3]
; SSE-NEXT:    movdqa %xmm15, %xmm5
; SSE-NEXT:    pandn %xmm6, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm13
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm13[1]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[2,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm13
; SSE-NEXT:    por %xmm2, %xmm13
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    pand %xmm14, %xmm13
; SSE-NEXT:    por %xmm13, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    movdqa (%rsp), %xmm5 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm13 = xmm2[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,1,1,1]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm9, %xmm13
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[0,1,0,1]
; SSE-NEXT:    pandn %xmm6, %xmm13
; SSE-NEXT:    por %xmm0, %xmm13
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm2[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm10[0],xmm2[1],xmm10[1],xmm2[2],xmm10[2],xmm2[3],xmm10[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm12, %xmm11
; SSE-NEXT:    pandn %xmm6, %xmm11
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    por %xmm2, %xmm11
; SSE-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4],xmm8[4],xmm10[5],xmm8[5],xmm10[6],xmm8[6],xmm10[7],xmm8[7]
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pslldq {{.*#+}} xmm2 = zero,zero,xmm2[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm5[4],xmm2[5],xmm5[5],xmm2[6],xmm5[6],xmm2[7],xmm5[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,2]
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    pand %xmm15, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[2,3,2,3]
; SSE-NEXT:    movdqa %xmm15, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    por %xmm2, %xmm7
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    psrlq $48, %xmm2
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm4 = xmm4[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[2,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    por %xmm2, %xmm10
; SSE-NEXT:    movdqa %xmm14, %xmm9
; SSE-NEXT:    pandn %xmm0, %xmm9
; SSE-NEXT:    pand %xmm14, %xmm10
; SSE-NEXT:    por %xmm10, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm6, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm5[0],xmm10[1],xmm5[1],xmm10[2],xmm5[2],xmm10[3],xmm5[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm10[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[0,1,1,1]
; SSE-NEXT:    pand %xmm3, %xmm12
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm12, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,1,0,1]
; SSE-NEXT:    pandn %xmm0, %xmm12
; SSE-NEXT:    por %xmm3, %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm10[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,3,2,3]
; SSE-NEXT:    movdqa %xmm8, %xmm10
; SSE-NEXT:    movdqa %xmm2, %xmm12
; SSE-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm2[0],xmm10[1],xmm2[1],xmm10[2],xmm2[2],xmm10[3],xmm2[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm10[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm10 = xmm10[0],xmm3[0],xmm10[1],xmm3[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm3, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm10, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm8[4],xmm3[5],xmm8[5],xmm3[6],xmm8[6],xmm3[7],xmm8[7]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm8
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm5[4],xmm0[5],xmm5[5],xmm0[6],xmm5[6],xmm0[7],xmm5[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,2]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[2,3,2,3]
; SSE-NEXT:    pandn %xmm3, %xmm15
; SSE-NEXT:    por %xmm0, %xmm15
; SSE-NEXT:    psrlq $48, %xmm5
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm6 = xmm6[1],xmm5[1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm8[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    pand %xmm14, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm14
; SSE-NEXT:    por %xmm1, %xmm14
; SSE-NEXT:    movdqa %xmm14, 304(%r9)
; SSE-NEXT:    movdqa %xmm15, 288(%r9)
; SSE-NEXT:    movdqa %xmm2, 256(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r9)
; SSE-NEXT:    movdqa %xmm9, 224(%r9)
; SSE-NEXT:    movdqa %xmm7, 208(%r9)
; SSE-NEXT:    movdqa %xmm11, 176(%r9)
; SSE-NEXT:    movdqa %xmm13, 160(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    addq $232, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride5_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $72, %rsp
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX1-ONLY-NEXT:    vmovdqa 48(%rsi), %xmm6
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm6[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm5[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm3[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm14 = [65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm14, %ymm1
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdx), %xmm11
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdx), %xmm0
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[1,1,2,2]
; AVX1-ONLY-NEXT:    vmovdqa 32(%rcx), %xmm13
; AVX1-ONLY-NEXT:    vmovdqa 48(%rcx), %xmm4
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm4[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm7[2],xmm2[3,4,5,6],xmm7[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm7, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm14, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vmovdqa 48(%r8), %xmm2
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm8 = zero,zero,xmm7[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm8, %ymm7
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm12 = [65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm7, %ymm12, %ymm7
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm6, %xmm8
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm8 = xmm5[1],xmm8[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm5[4],xmm6[4],xmm5[5],xmm6[5],xmm5[6],xmm6[6],xmm5[7],xmm6[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm12, %ymm5
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm6
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1],xmm7[2],xmm6[3,4,5,6],xmm7[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm7[0],xmm5[1,2,3,4],xmm7[5],xmm5[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm11[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm13[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm6[2],xmm5[3,4,5,6],xmm6[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm11[4],xmm13[4],xmm11[5],xmm13[5],xmm11[6],xmm13[6],xmm11[7],xmm13[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm7 = zero,zero,xmm6[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm10[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1,2,3],xmm15[4],xmm7[5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm15[4],xmm10[4],xmm15[5],xmm10[5],xmm15[6],xmm10[6],xmm15[7],xmm10[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm8[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm8 = [65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm5, %ymm8, %ymm5
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm8, %ymm7
; AVX1-ONLY-NEXT:    vorps %ymm5, %ymm7, %ymm5
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm10, %xmm7
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm7 = xmm15[1],xmm7[1]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm7, %ymm3
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,1,3,3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm6, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 32(%r8), %xmm7
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1,2],xmm2[3],xmm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3,4,5],xmm2[6],xmm1[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm12, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm2[4],xmm1[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm1
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm7[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0],xmm1[1,2,3,4],xmm2[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6],xmm2[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm11[0],xmm13[0],xmm11[1],xmm13[1],xmm11[2],xmm13[2],xmm11[3],xmm13[3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm13[0],xmm11[0],xmm13[1],xmm11[1],xmm13[2],xmm11[2],xmm13[3],xmm11[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm9
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm15[0],xmm10[0],xmm15[1],xmm10[1],xmm15[2],xmm10[2],xmm15[3],xmm10[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm1[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,1,1]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm6
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm5[0,1,2],xmm7[3],xmm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm14, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm14, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm7[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3,4,5],xmm2[6],xmm1[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm2[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm9[4],xmm6[4],xmm9[5],xmm6[5],xmm9[6],xmm6[6],xmm9[7],xmm6[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm0, %xmm4
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm4 = xmm1[1],xmm4[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm12, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm12, %ymm4
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm4, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa 16(%r8), %xmm8
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm8[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1],xmm7[2],xmm4[3,4,5,6],xmm7[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm7[0],xmm2[1,2,3,4],xmm7[5],xmm2[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm15
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm7
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm7, %xmm2
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm15[1],xmm2[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm3[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,1,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm4
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm5
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm4[4],xmm5[4],xmm4[5],xmm5[5],xmm4[6],xmm5[6],xmm4[7],xmm5[7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm13 = xmm10[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,1,3,3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm9[0],xmm6[0],xmm9[1],xmm6[1],xmm9[2],xmm6[2],xmm9[3],xmm6[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm11 = xmm11[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[0,0,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm13, %ymm11
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm12, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm12, %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm11, %ymm12
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm3[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm6[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm9[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1],xmm1[2],xmm2[3,4,5,6],xmm1[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm9[0],xmm6[1],xmm9[1],xmm6[2],xmm9[2],xmm6[3],xmm9[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm14, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm14, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0,1,2],xmm8[3],xmm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm8[0,1,0,1]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm12, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm3[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm2[0],xmm3[1],xmm2[2,3,4,5],xmm3[6],xmm2[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm5[0],xmm4[1],xmm5[1],xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[1,1,2,3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm15[0],xmm7[0],xmm15[1],xmm7[1],xmm15[2],xmm7[2],xmm15[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm6[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[0,1,1,1]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm8, %ymm6
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm14, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm14, %ymm6
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm6, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa (%r8), %xmm6
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm8
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm6[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0],xmm9[1],xmm8[2,3,4,5],xmm9[6],xmm8[7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm9[4],xmm2[5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2],xmm4[3,4,5,6],xmm5[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm5 = zero,zero,xmm10[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm7[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3],xmm15[4],xmm5[5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm15[4],xmm7[4],xmm15[5],xmm7[5],xmm15[6],xmm7[6],xmm15[7],xmm7[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm7 = [65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm4, %ymm7, %ymm4
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vorps %ymm4, %ymm5, %ymm4
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm6[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm12[0,1],xmm5[2],xmm12[3,4,5,6],xmm5[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm9
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0],xmm9[1,2,3,4],xmm5[5],xmm9[6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1,2],xmm6[3],xmm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, 32(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, 48(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, (%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, 16(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, 96(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, 112(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, 64(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, 80(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 128(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 144(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 160(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 176(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 224(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 240(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 192(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 208(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 288(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 304(%r9)
; AVX1-ONLY-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 256(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 272(%r9)
; AVX1-ONLY-NEXT:    addq $72, %rsp
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride5_vf32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $72, %rsp
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm3
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm7
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm10
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm8
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm10[0],xmm6[0],xmm10[1],xmm6[1],xmm10[2],xmm6[2],xmm10[3],xmm6[3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm5 = [4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm4, %xmm4
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm12
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm9
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm11
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm13
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,5,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm11, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vpbroadcastq (%r8), %ymm11
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm4, %ymm11, %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm11, %xmm5
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm13[0],xmm9[0],xmm13[1],xmm9[1],xmm13[2],xmm9[2],xmm13[3],xmm9[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,5,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm11, %ymm5, %ymm5
; AVX2-SLOW-NEXT:    vpbroadcastq 32(%r8), %ymm11
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm5, %ymm11, %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, (%rsp) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm11 = <6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13>
; AVX2-SLOW-NEXT:    vpshufb %xmm11, %xmm12, %xmm12
; AVX2-SLOW-NEXT:    vpbroadcastq 8(%rdi), %xmm13
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0],xmm13[1],xmm12[2,3],xmm13[4],xmm12[5],xmm13[6],xmm12[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm13 = <10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9>
; AVX2-SLOW-NEXT:    vpshufb %xmm13, %xmm10, %xmm10
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[1,2,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm6 = xmm10[0],xmm6[1],xmm10[2],xmm6[3],xmm10[4,5],xmm6[6],xmm10[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,0]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = <255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm12, %ymm6, %ymm6
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm1[0,1,1,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm6, %ymm10, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm15 = ymm3[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm15[2,3,2,2,6,7,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm15 = ymm15[0],ymm10[1],ymm15[2],ymm10[3],ymm15[4,5],ymm10[6],ymm15[7,8],ymm10[9],ymm15[10],ymm10[11],ymm15[12,13],ymm10[14],ymm15[15]
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm10
; AVX2-SLOW-NEXT:    vpshufb %xmm11, %xmm9, %xmm9
; AVX2-SLOW-NEXT:    vpbroadcastq 40(%rdi), %xmm11
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0],xmm11[1],xmm9[2,3],xmm11[4],xmm9[5],xmm11[6],xmm9[7]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm11
; AVX2-SLOW-NEXT:    vpshufb %xmm13, %xmm8, %xmm8
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %ymm13
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,2,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0],xmm7[1],xmm8[2],xmm7[3],xmm8[4,5],xmm7[6],xmm8[7]
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,3,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm9, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm11[3,2,3,3,7,6,7,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm14 = ymm13[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm9 = ymm14[0],ymm9[1],ymm14[2],ymm9[3,4],ymm14[5,6,7,8],ymm9[9],ymm14[10],ymm9[11,12],ymm14[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm15, %ymm9, %ymm9
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm4[0,1,1,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm8, %ymm14, %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, %ymm8
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm0[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm14 = ymm10[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[2,3,2,2,6,7,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm14[0],ymm12[1],ymm14[2],ymm12[3],ymm14[4,5],ymm12[6],ymm14[7,8],ymm12[9],ymm14[10],ymm12[11],ymm14[12,13],ymm12[14],ymm14[15]
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm14
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm15 = ymm14[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm15[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm7
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm7[3,2,3,3,7,6,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm15[0],ymm4[1],ymm15[2],ymm4[3,4],ymm15[5,6,7,8],ymm4[9],ymm15[10],ymm4[11,12],ymm15[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,2,3,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm12, %ymm4, %ymm1
; AVX2-SLOW-NEXT:    vpbroadcastq 56(%r8), %ymm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm9, %ymm4, %ymm9
; AVX2-SLOW-NEXT:    vpbroadcastq 24(%r8), %ymm4
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm1, %ymm4, %ymm12
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25>
; AVX2-SLOW-NEXT:    vpshufb %ymm1, %ymm13, %ymm4
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm11[1,1,1,2,5,5,5,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm15[1],ymm4[2,3],ymm15[4],ymm4[5],ymm15[6],ymm4[7,8],ymm15[9],ymm4[10,11],ymm15[12],ymm4[13],ymm15[14],ymm4[15]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm15 = ymm3[3,1,2,2,4,5,6,7,11,9,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm15 = ymm15[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[0,1,2,1,4,5,6,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm15[0,1],ymm5[2],ymm15[3],ymm5[4],ymm15[5,6],ymm5[7],ymm15[8,9],ymm5[10],ymm15[11],ymm5[12],ymm15[13,14],ymm5[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = <255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm4, %ymm5, %ymm4
; AVX2-SLOW-NEXT:    vpshufb %ymm1, %ymm14, %ymm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm7[1,1,1,2,5,5,5,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm5[1],ymm1[2,3],ymm5[4],ymm1[5],ymm5[6],ymm1[7,8],ymm5[9],ymm1[10,11],ymm5[12],ymm1[13],ymm5[14],ymm1[15]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm5 = ymm10[3,1,2,2,4,5,6,7,11,9,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm5 = ymm5[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm0[0,1,2,1,4,5,6,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1],ymm6[2],ymm5[3],ymm6[4],ymm5[5,6],ymm6[7],ymm5[8,9],ymm6[10],ymm5[11],ymm6[12],ymm5[13,14],ymm6[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm1, %ymm5, %ymm1
; AVX2-SLOW-NEXT:    vpbroadcastq 48(%r8), %ymm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-SLOW-NEXT:    vpbroadcastq 16(%r8), %ymm5
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm1, %ymm5, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm5, %ymm13, %ymm6
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm11[3,0,3,0,7,4,7,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm11[0],ymm6[1],ymm11[2],ymm6[3],ymm11[4,5],ymm6[6],ymm11[7,8],ymm6[9],ymm11[10],ymm6[11],ymm11[12,13],ymm6[14],ymm11[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm11, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3],ymm3[4],ymm2[5],ymm3[6],ymm2[7,8],ymm3[9],ymm2[10,11],ymm3[12],ymm2[13],ymm3[14],ymm2[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = <255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm6, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpshufb %ymm5, %ymm14, %ymm5
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm7[3,0,3,0,7,4,7,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2],ymm5[3],ymm0[4,5],ymm5[6],ymm0[7,8],ymm5[9],ymm0[10],ymm5[11],ymm0[12,13],ymm5[14],ymm0[15]
; AVX2-SLOW-NEXT:    vpshufb %ymm11, %ymm10, %ymm5
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm8[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2,3],ymm5[4],ymm6[5],ymm5[6],ymm6[7,8],ymm5[9],ymm6[10,11],ymm5[12],ymm6[13],ymm5[14],ymm6[15]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm0, %ymm5, %ymm0
; AVX2-SLOW-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm3 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm3 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm0, %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 64(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, 224(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, 96(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm12, 128(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm9, 288(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, 256(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-SLOW-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-SLOW-NEXT:    addq $72, %rsp
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride5_vf32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    subq $72, %rsp
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm3
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %ymm4
; AVX2-FAST-NEXT:    vmovdqa (%r8), %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm9
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %xmm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm6 = <6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13>
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm9, %xmm5
; AVX2-FAST-NEXT:    vpbroadcastq 8(%rdi), %xmm7
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0],xmm7[1],xmm5[2,3],xmm7[4],xmm5[5],xmm7[6],xmm5[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm10
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %xmm11
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm7 = <10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9>
; AVX2-FAST-NEXT:    vpshufb %xmm7, %xmm10, %xmm12
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm13
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[1,2,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0],xmm14[1],xmm12[2],xmm14[3],xmm12[4,5],xmm14[6],xmm12[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,0,0]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = <255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm5, %ymm12, %ymm5
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm0[0,1,1,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm5, %ymm12, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm12
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm12[0],xmm9[0],xmm12[1],xmm9[1],xmm12[2],xmm9[2],xmm12[3],xmm9[3]
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %xmm12
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm10[0],xmm13[0],xmm10[1],xmm13[1],xmm10[2],xmm13[2],xmm10[3],xmm13[3]
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm8, %xmm6
; AVX2-FAST-NEXT:    vpbroadcastq 40(%rdi), %xmm13
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0],xmm13[1],xmm6[2,3],xmm13[4],xmm6[5],xmm13[6],xmm6[7]
; AVX2-FAST-NEXT:    vpshufb %xmm7, %xmm11, %xmm7
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm12[1,2,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0],xmm13[1],xmm7[2],xmm13[3],xmm7[4,5],xmm13[6],xmm7[7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm13 = [0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX2-FAST-NEXT:    vpshufb %xmm13, %xmm9, %xmm9
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm6, %ymm7, %ymm6
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm14 = [4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-FAST-NEXT:    vpshufb %xmm14, %xmm10, %xmm7
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm0, %ymm9, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm2[0,1,1,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm6, %ymm9, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq (%r8), %ymm9
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm7, %ymm9, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %xmm9
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %ymm9
; AVX2-FAST-NEXT:    vpshufb %xmm13, %xmm8, %xmm8
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %ymm10
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,0,1]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-FAST-NEXT:    vpshufb %xmm14, %xmm11, %xmm11
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm0, %ymm8, %ymm11, %ymm0
; AVX2-FAST-NEXT:    vpbroadcastq 32(%r8), %ymm8
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm0, %ymm8, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,26,27,30,31,30,31,28,29,30,31,28,29>
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm4, %ymm11
; AVX2-FAST-NEXT:    vmovdqa %ymm3, %ymm7
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm12 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm11 = ymm11[0],ymm12[1],ymm11[2],ymm12[3],ymm11[4,5],ymm12[6],ymm11[7,8],ymm12[9],ymm11[10],ymm12[11],ymm11[12,13],ymm12[14],ymm11[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,30,31,30,31,26,27,28,29,30,31,30,31>
; AVX2-FAST-NEXT:    vpshufb %ymm12, %ymm10, %ymm13
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm9[3,2,3,3,7,6,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm13 = ymm13[0],ymm14[1],ymm13[2],ymm14[3,4],ymm13[5,6,7,8],ymm14[9],ymm13[10],ymm14[11,12],ymm13[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,2,3,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = <u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm11, %ymm13, %ymm13
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm11
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm11, %ymm0
; AVX2-FAST-NEXT:    vmovdqa %ymm1, %ymm8
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm15 = ymm1[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm15[1],ymm0[2],ymm15[3],ymm0[4,5],ymm15[6],ymm0[7,8],ymm15[9],ymm0[10],ymm15[11],ymm0[12,13],ymm15[14],ymm0[15]
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %ymm15
; AVX2-FAST-NEXT:    vpshufb %ymm12, %ymm15, %ymm12
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm2
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[3,2,3,3,7,6,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm12[0],ymm5[1],ymm12[2],ymm5[3,4],ymm12[5,6,7,8],ymm5[9],ymm12[10],ymm5[11,12],ymm12[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,3,2]
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm0, %ymm5, %ymm0
; AVX2-FAST-NEXT:    vpbroadcastq 56(%r8), %ymm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = [0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm13, %ymm5, %ymm12
; AVX2-FAST-NEXT:    vpbroadcastq 24(%r8), %ymm5
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm0, %ymm5, %ymm13
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25>
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm10, %ymm5
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm9[1,1,1,2,5,5,5,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0],ymm14[1],ymm5[2,3],ymm14[4],ymm5[5],ymm14[6],ymm5[7,8],ymm14[9],ymm5[10,11],ymm14[12],ymm5[13],ymm14[14],ymm5[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,18,19,u,u,20,21,u,u,24,25,24,25,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm6 = ymm7[0,1,2,1,4,5,6,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm6[2],ymm0[3],ymm6[4],ymm0[5,6],ymm6[7],ymm0[8,9],ymm6[10],ymm0[11],ymm6[12],ymm0[13,14],ymm6[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = <255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm5, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm15, %ymm3
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[1,1,1,2,5,5,5,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm5[1],ymm3[2,3],ymm5[4],ymm3[5],ymm5[6],ymm3[7,8],ymm5[9],ymm3[10,11],ymm5[12],ymm3[13],ymm5[14],ymm3[15]
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm11, %ymm5
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm1[0,1,2,1,4,5,6,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1],ymm14[2],ymm5[3],ymm14[4],ymm5[5,6],ymm14[7],ymm5[8,9],ymm14[10],ymm5[11],ymm14[12],ymm5[13,14],ymm14[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm3[2,3,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm1, %ymm5, %ymm1
; AVX2-FAST-NEXT:    vpbroadcastq 48(%r8), %ymm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm0, %ymm5, %ymm0
; AVX2-FAST-NEXT:    vpbroadcastq 16(%r8), %ymm5
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm1, %ymm5, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm5, %ymm10, %ymm6
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[3,0,3,0,7,4,7,4]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm9[0],ymm6[1],ymm9[2],ymm6[3],ymm9[4,5],ymm6[6],ymm9[7,8],ymm6[9],ymm9[10],ymm6[11],ymm9[12,13],ymm6[14],ymm9[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm9, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm7[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2,3],ymm4[4],ymm3[5],ymm4[6],ymm3[7,8],ymm4[9],ymm3[10,11],ymm4[12],ymm3[13],ymm4[14],ymm3[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = <255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm6, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpshufb %ymm5, %ymm15, %ymm5
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[3,0,3,0,7,4,7,4]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm5[1],ymm2[2],ymm5[3],ymm2[4,5],ymm5[6],ymm2[7,8],ymm5[9],ymm2[10],ymm5[11],ymm2[12,13],ymm5[14],ymm2[15]
; AVX2-FAST-NEXT:    vpshufb %ymm9, %ymm11, %ymm5
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm8[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2,3],ymm5[4],ymm6[5],ymm5[6],ymm6[7,8],ymm5[9],ymm6[10,11],ymm5[12],ymm6[13],ymm5[14],ymm6[15]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm2, %ymm5, %ymm2
; AVX2-FAST-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm4 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vpermq $165, (%rsp), %ymm4 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm4 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vmovdqa %ymm2, 64(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, 224(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, 96(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm13, 128(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm12, 288(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 256(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-FAST-NEXT:    addq $72, %rsp
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride5_vf32:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $72, %rsp
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %xmm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm6 = <6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm9, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 8(%rdi), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0],xmm7[1],xmm5[2,3],xmm7[4],xmm5[5],xmm7[6],xmm5[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %xmm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm7 = <10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm7, %xmm10, %xmm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm13
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[1,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0],xmm14[1],xmm12[2],xmm14[3],xmm12[4,5],xmm14[6],xmm12[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,0,0]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm14 = <255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm5, %ymm12, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm12 = ymm0[0,1,1,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm5, %ymm12, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm12
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm12[0],xmm9[0],xmm12[1],xmm9[1],xmm12[2],xmm9[2],xmm12[3],xmm9[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %xmm12
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm10[0],xmm13[0],xmm10[1],xmm13[1],xmm10[2],xmm13[2],xmm10[3],xmm13[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm8, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 40(%rdi), %xmm13
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0],xmm13[1],xmm6[2,3],xmm13[4],xmm6[5],xmm13[6],xmm6[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm7, %xmm11, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm13 = xmm12[1,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0],xmm13[1],xmm7[2],xmm13[3],xmm7[4,5],xmm13[6],xmm7[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm13 = [0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm13, %xmm9, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm6, %ymm7, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm14 = [4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm14, %xmm10, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm9, %ymm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm2[0,1,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm6, %ymm9, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq (%r8), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm7, %ymm9, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm13, %xmm8, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm14, %xmm11, %xmm11
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm8, %ymm11, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 32(%r8), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm0, %ymm8, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,26,27,30,31,30,31,28,29,30,31,28,29>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm4, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm12 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm11 = ymm11[0],ymm12[1],ymm11[2],ymm12[3],ymm11[4,5],ymm12[6],ymm11[7,8],ymm12[9],ymm11[10],ymm12[11],ymm11[12,13],ymm12[14],ymm11[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,30,31,30,31,26,27,28,29,30,31,30,31>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm12, %ymm10, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm9[3,2,3,3,7,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm13 = ymm13[0],ymm14[1],ymm13[2],ymm14[3,4],ymm13[5,6,7,8],ymm14[9],ymm13[10],ymm14[11,12],ymm13[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,2,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm14 = <u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm11, %ymm13, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm11, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm1[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm15[1],ymm0[2],ymm15[3],ymm0[4,5],ymm15[6],ymm0[7,8],ymm15[9],ymm0[10],ymm15[11],ymm0[12,13],ymm15[14],ymm0[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm12, %ymm15, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[3,2,3,3,7,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm5 = ymm12[0],ymm5[1],ymm12[2],ymm5[3,4],ymm12[5,6,7,8],ymm5[9],ymm12[10],ymm5[11,12],ymm12[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm0, %ymm5, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 56(%r8), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm14 = [0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm13, %ymm5, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 24(%r8), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm0, %ymm5, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm3, %ymm10, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm9[1,1,1,2,5,5,5,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0],ymm14[1],ymm5[2,3],ymm14[4],ymm5[5],ymm14[6],ymm5[7,8],ymm14[9],ymm5[10,11],ymm14[12],ymm5[13],ymm14[14],ymm5[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm14 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,18,19,u,u,20,21,u,u,24,25,24,25,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm14, %ymm4, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm6 = ymm7[0,1,2,1,4,5,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm6[2],ymm0[3],ymm6[4],ymm0[5,6],ymm6[7],ymm0[8,9],ymm6[10],ymm0[11],ymm6[12],ymm0[13,14],ymm6[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = <255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm5, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm3, %ymm15, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[1,1,1,2,5,5,5,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm5[1],ymm3[2,3],ymm5[4],ymm3[5],ymm5[6],ymm3[7,8],ymm5[9],ymm3[10,11],ymm5[12],ymm3[13],ymm5[14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm14, %ymm11, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm1[0,1,2,1,4,5,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1],ymm14[2],ymm5[3],ymm14[4],ymm5[5,6],ymm14[7],ymm5[8,9],ymm14[10],ymm5[11],ymm14[12],ymm5[13,14],ymm14[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm3[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm1, %ymm5, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 48(%r8), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm0, %ymm5, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 16(%r8), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm1, %ymm5, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm5, %ymm10, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[3,0,3,0,7,4,7,4]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm9[0],ymm6[1],ymm9[2],ymm6[3],ymm9[4,5],ymm6[6],ymm9[7,8],ymm6[9],ymm9[10],ymm6[11],ymm9[12,13],ymm6[14],ymm9[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm9, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm7[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2,3],ymm4[4],ymm3[5],ymm4[6],ymm3[7,8],ymm4[9],ymm3[10,11],ymm4[12],ymm3[13],ymm4[14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = <255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm6, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm5, %ymm15, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[3,0,3,0,7,4,7,4]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm5[1],ymm2[2],ymm5[3],ymm2[4,5],ymm5[6],ymm2[7,8],ymm5[9],ymm2[10],ymm5[11],ymm2[12,13],ymm5[14],ymm2[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm9, %ymm11, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm8[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2,3],ymm5[4],ymm6[5],ymm5[6],ymm6[7,8],ymm5[9],ymm6[10,11],ymm5[12],ymm6[13],ymm5[14],ymm6[15]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm2, %ymm5, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm4 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpermq $165, (%rsp), %ymm4 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm4 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm2, %ymm4, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, 64(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, 224(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, 96(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm13, 128(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm12, 288(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 256(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-FAST-PERLANE-NEXT:    addq $72, %rsp
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride5_vf32:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm4
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm0[3,2,3,3,7,6,7,7]
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %ymm1
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm1[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2],ymm2[3,4],ymm3[5,6,7,8],ymm2[9],ymm3[10],ymm2[11,12],ymm3[13,14,15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,3,2]
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm9
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %xmm12
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm10
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm5 = [4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm5, %xmm24
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm3[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %ymm5
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm7 = ymm5[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[2,3,2,2,6,7,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2],ymm6[3],ymm7[4,5],ymm6[6],ymm7[7,8],ymm6[9],ymm7[10],ymm6[11],ymm7[12,13],ymm6[14],ymm7[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,3,2,2]
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %xmm14
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdi), %xmm23
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm13
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm13[0],xmm11[0],xmm13[1],xmm11[1],xmm13[2],xmm11[2],xmm13[3],xmm11[3]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[0,2,1,3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,4,5,6]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,0,1]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm13, %zmm6, %zmm6
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm16 = [65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm2, %zmm16, %zmm6
; AVX512F-SLOW-NEXT:    vpbroadcastq 24(%r8), %ymm2
; AVX512F-SLOW-NEXT:    vpbroadcastq 32(%r8), %ymm13
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm13, %zmm2, %zmm2
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm6, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm13
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm7 = <u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u>
; AVX512F-SLOW-NEXT:    vpshufb %ymm7, %ymm13, %ymm6
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm7, %ymm20
; AVX512F-SLOW-NEXT:    vmovdqa64 32(%rdi), %ymm17
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm15 = ymm17[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm15 = ymm15[0],ymm6[1],ymm15[2,3],ymm6[4],ymm15[5],ymm6[6],ymm15[7,8],ymm6[9],ymm15[10,11],ymm6[12],ymm15[13],ymm6[14],ymm15[15]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm6 = <6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13>
; AVX512F-SLOW-NEXT:    vpshufb %xmm6, %xmm11, %xmm11
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm6, %xmm25
; AVX512F-SLOW-NEXT:    vpbroadcastq 40(%rdi), %xmm8
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm8 = xmm11[0],xmm8[1],xmm11[2,3],xmm8[4],xmm11[5],xmm8[6],xmm11[7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,0,1]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm15, %zmm8, %zmm8
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rcx), %ymm15
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm7 = <u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u>
; AVX512F-SLOW-NEXT:    vpshufb %ymm7, %ymm15, %ymm11
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm7, %ymm21
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm4[3,0,3,0,7,4,7,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0],ymm11[1],ymm7[2],ymm11[3],ymm7[4,5],ymm11[6],ymm7[7,8],ymm11[9],ymm7[10],ymm11[11],ymm7[12,13],ymm11[14],ymm7[15]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm11 = <10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9>
; AVX512F-SLOW-NEXT:    vpshufb %xmm11, %xmm10, %xmm10
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[1,2,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm9 = xmm10[0],xmm9[1],xmm10[2],xmm9[3],xmm10[4,5],xmm9[6],xmm10[7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,0]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm7, %zmm9, %zmm18
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm18
; AVX512F-SLOW-NEXT:    vmovdqa (%r8), %ymm9
; AVX512F-SLOW-NEXT:    vmovdqa 32(%r8), %ymm8
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm7 = [128,128,128,128,12,13,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128]
; AVX512F-SLOW-NEXT:    vpshufb %ymm7, %ymm8, %ymm10
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm7, %ymm22
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,1,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm19 = [65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535]
; AVX512F-SLOW-NEXT:    vpandnq %ymm8, %ymm19, %ymm8
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm10, %zmm8, %zmm10
; AVX512F-SLOW-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm18, %zmm10
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %xmm8
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm12[0],xmm8[0],xmm12[1],xmm8[1],xmm12[2],xmm8[2],xmm12[3],xmm8[3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm24, %xmm6
; AVX512F-SLOW-NEXT:    vpshufb %xmm6, %xmm7, %xmm7
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX512F-SLOW-NEXT:    vpshufb %xmm11, %xmm12, %xmm11
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[1,2,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm8 = xmm11[0],xmm8[1],xmm11[2],xmm8[3],xmm11[4,5],xmm8[6],xmm11[7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,0,0]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm8, %zmm7, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm25, %xmm6
; AVX512F-SLOW-NEXT:    vpshufb %xmm6, %xmm14, %xmm6
; AVX512F-SLOW-NEXT:    vpbroadcastq 8(%rdi), %xmm8
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0],xmm8[1],xmm6[2,3],xmm8[4],xmm6[5],xmm8[6],xmm6[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm23, %xmm8
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm8[0],xmm14[0],xmm8[1],xmm14[1],xmm8[2],xmm14[2],xmm8[3],xmm14[3]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[0,2,1,3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,4,5,6]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm6, %zmm8, %zmm6
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} zmm6 = zmm6[0,1,0,1,4,5,4,5]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm7, %zmm8, %zmm6
; AVX512F-SLOW-NEXT:    vpbroadcastq (%r8), %ymm7
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm9[0,1,1,1]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm11, %zmm7, %zmm7
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm6, %zmm7
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm17[0,1,2,1,4,5,6,5]
; AVX512F-SLOW-NEXT:    vprolq $16, %ymm13, %ymm11
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm11[0,1],ymm6[2],ymm11[3],ymm6[4],ymm11[5,6],ymm6[7],ymm11[8,9],ymm6[10],ymm11[11],ymm6[12],ymm11[13,14],ymm6[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,3,2,3]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm17[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm12 = ymm13[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,3,2,2,6,7,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm12[0],ymm11[1],ymm12[2],ymm11[3],ymm12[4,5],ymm11[6],ymm12[7,8],ymm11[9],ymm12[10],ymm11[11],ymm12[12,13],ymm11[14],ymm12[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,2]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm11, %zmm6, %zmm11
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25>
; AVX512F-SLOW-NEXT:    vpshufb %ymm6, %ymm15, %ymm12
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = ymm4[1,1,1,2,5,5,5,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm12[0],ymm13[1],ymm12[2,3],ymm13[4],ymm12[5],ymm13[6],ymm12[7,8],ymm13[9],ymm12[10,11],ymm13[12],ymm12[13],ymm13[14],ymm12[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[3,2,3,3,7,6,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm13 = ymm15[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = ymm13[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm13[0],ymm4[1],ymm13[2],ymm4[3,4],ymm13[5,6,7,8],ymm4[9],ymm13[10],ymm4[11,12],ymm13[13,14,15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,2,3,2]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm12, %zmm4
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm11, %zmm8, %zmm4
; AVX512F-SLOW-NEXT:    vpbroadcastq 48(%r8), %ymm8
; AVX512F-SLOW-NEXT:    vpbroadcastq 56(%r8), %ymm11
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm11, %zmm8, %zmm8
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm4, %zmm8
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm20, %ymm4
; AVX512F-SLOW-NEXT:    vpshufb %ymm4, %ymm5, %ymm4
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm3[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm11[0],ymm4[1],ymm11[2,3],ymm4[4],ymm11[5],ymm4[6],ymm11[7,8],ymm4[9],ymm11[10,11],ymm4[12],ymm11[13],ymm4[14],ymm11[15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[0,1,2,1,4,5,6,5]
; AVX512F-SLOW-NEXT:    vprolq $16, %ymm5, %ymm5
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm5[0,1],ymm3[2],ymm5[3],ymm3[4],ymm5[5,6],ymm3[7],ymm5[8,9],ymm3[10],ymm5[11],ymm3[12],ymm5[13,14],ymm3[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm3
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm21, %ymm4
; AVX512F-SLOW-NEXT:    vpshufb %ymm4, %ymm1, %ymm4
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm0[3,0,3,0,7,4,7,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0],ymm4[1],ymm5[2],ymm4[3],ymm5[4,5],ymm4[6],ymm5[7,8],ymm4[9],ymm5[10],ymm4[11],ymm5[12,13],ymm4[14],ymm5[15]
; AVX512F-SLOW-NEXT:    vpshufb %ymm6, %ymm1, %ymm1
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[1,1,1,2,5,5,5,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5],ymm0[6],ymm1[7,8],ymm0[9],ymm1[10,11],ymm0[12],ymm1[13],ymm0[14],ymm1[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm4, %zmm0
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm3, %zmm16, %zmm0
; AVX512F-SLOW-NEXT:    vpbroadcastq 16(%r8), %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpandn %ymm1, %ymm3, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm22, %ymm3
; AVX512F-SLOW-NEXT:    vpshufb %ymm3, %ymm9, %ymm3
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm1
; AVX512F-SLOW-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm8, 256(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm7, (%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm10, 192(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm2, 128(%r9)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride5_vf32:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    vmovdqa 32(%rsi), %ymm11
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u>
; AVX512F-FAST-NEXT:    vpshufb %ymm1, %ymm11, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm1, %ymm20
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdi), %ymm12
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm12[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5],ymm0[6],ymm1[7,8],ymm0[9],ymm1[10,11],ymm0[12],ymm1[13],ymm0[14],ymm1[15]
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %xmm0
; AVX512F-FAST-NEXT:    vmovdqa 32(%rsi), %xmm6
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm7 = <6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13>
; AVX512F-FAST-NEXT:    vpshufb %xmm7, %xmm6, %xmm2
; AVX512F-FAST-NEXT:    vpbroadcastq 40(%rdi), %xmm3
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1],xmm2[2,3],xmm3[4],xmm2[5],xmm3[6],xmm2[7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm16
; AVX512F-FAST-NEXT:    vmovdqa 32(%rcx), %ymm13
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u>
; AVX512F-FAST-NEXT:    vpshufb %ymm2, %ymm13, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm2, %ymm21
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdx), %ymm14
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm14[3,0,3,0,7,4,7,4]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4,5],ymm1[6],ymm2[7,8],ymm1[9],ymm2[10],ymm1[11],ymm2[12,13],ymm1[14],ymm2[15]
; AVX512F-FAST-NEXT:    vmovdqa 32(%rcx), %xmm8
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm2 = <10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9>
; AVX512F-FAST-NEXT:    vpshufb %xmm2, %xmm8, %xmm3
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdx), %xmm9
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm9[1,2,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm4[1],xmm3[2],xmm4[3],xmm3[4,5],xmm4[6],xmm3[7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,0]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm3
; AVX512F-FAST-NEXT:    vmovdqa 32(%r8), %ymm1
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [128,128,128,128,12,13,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128]
; AVX512F-FAST-NEXT:    vpshufb %ymm5, %ymm1, %ymm4
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm5, %ymm22
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,1,1]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535]
; AVX512F-FAST-NEXT:    vpandn %ymm1, %ymm10, %ymm1
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm18
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %xmm4
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm2, %xmm4, %xmm2
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,2,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm10 = xmm2[0],xmm1[1],xmm2[2],xmm1[3],xmm2[4,5],xmm1[6],xmm2[7]
; AVX512F-FAST-NEXT:    vpshufb %xmm7, %xmm0, %xmm1
; AVX512F-FAST-NEXT:    vpbroadcastq 8(%rdi), %xmm2
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3],xmm2[4],xmm1[5],xmm2[6],xmm1[7]
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX512F-FAST-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm17
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm12[0,1,2,1,4,5,6,5]
; AVX512F-FAST-NEXT:    vprolq $16, %ymm11, %ymm1
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm1[0,1],ymm0[2],ymm1[3],ymm0[4],ymm1[5,6],ymm0[7],ymm1[8,9],ymm0[10],ymm1[11],ymm0[12],ymm1[13,14],ymm0[15]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,26,27,30,31,30,31,28,29,30,31,28,29>
; AVX512F-FAST-NEXT:    vpshufb %ymm1, %ymm11, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm12[2,3,2,3,6,7,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm12 = ymm0[0],ymm2[1],ymm0[2],ymm2[3],ymm0[4,5],ymm2[6],ymm0[7,8],ymm2[9],ymm0[10],ymm2[11],ymm0[12,13],ymm2[14],ymm0[15]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25>
; AVX512F-FAST-NEXT:    vpshufb %ymm2, %ymm13, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm2, %ymm23
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm14[1,1,1,2,5,5,5,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm2[1],ymm0[2,3],ymm2[4],ymm0[5],ymm2[6],ymm0[7,8],ymm2[9],ymm0[10,11],ymm2[12],ymm0[13],ymm2[14],ymm0[15]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,30,31,30,31,26,27,28,29,30,31,30,31>
; AVX512F-FAST-NEXT:    vpshufb %ymm2, %ymm13, %ymm13
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[3,2,3,3,7,6,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm14 = ymm13[0],ymm14[1],ymm13[2],ymm14[3,4],ymm13[5,6,7,8],ymm14[9],ymm13[10],ymm14[11,12],ymm13[13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 (%rdx), %ymm19
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %ymm13
; AVX512F-FAST-NEXT:    vpshufb %ymm2, %ymm13, %ymm2
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm19[3,2,3,3,7,6,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm5[1],ymm2[2],ymm5[3,4],ymm2[5,6,7,8],ymm5[9],ymm2[10],ymm5[11,12],ymm2[13,14,15]
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm8[0],xmm9[0],xmm8[1],xmm9[1],xmm8[2],xmm9[2],xmm8[3],xmm9[3]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm8 = [4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX512F-FAST-NEXT:    vpshufb %xmm8, %xmm15, %xmm9
; AVX512F-FAST-NEXT:    vpshufb %xmm8, %xmm5, %xmm5
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %ymm8
; AVX512F-FAST-NEXT:    vpshufb %ymm1, %ymm8, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %ymm15
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm11 = ymm15[2,3,2,3,6,7,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm11[1],ymm1[2],ymm11[3],ymm1[4,5],ymm11[6],ymm1[7,8],ymm11[9],ymm1[10],ymm11[11],ymm1[12,13],ymm11[14],ymm1[15]
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdi), %xmm11
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm11[0],xmm6[0],xmm11[1],xmm6[1],xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm4, %xmm6, %xmm4
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm20, %ymm6
; AVX512F-FAST-NEXT:    vpshufb %ymm6, %ymm8, %ymm6
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm15[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm11[0],ymm6[1],ymm11[2,3],ymm6[4],ymm11[5],ymm6[6],ymm11[7,8],ymm6[9],ymm11[10,11],ymm6[12],ymm11[13],ymm6[14],ymm11[15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,1,0,0]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm12[2,3,2,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm14[2,2,3,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,3,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm15[0,1,2,1,4,5,6,5]
; AVX512F-FAST-NEXT:    vprolq $16, %ymm8, %ymm8
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm8 = ymm8[0,1],ymm14[2],ymm8[3],ymm14[4],ymm8[5,6],ymm14[7],ymm8[8,9],ymm14[10],ymm8[11],ymm14[12],ymm8[13,14],ymm14[15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm8, %zmm6, %zmm6
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm21, %ymm8
; AVX512F-FAST-NEXT:    vpshufb %ymm8, %ymm13, %ymm8
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm19[3,0,3,0,7,4,7,4]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm8 = ymm14[0],ymm8[1],ymm14[2],ymm8[3],ymm14[4,5],ymm8[6],ymm14[7,8],ymm8[9],ymm14[10],ymm8[11],ymm14[12,13],ymm8[14],ymm14[15]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm23, %ymm14
; AVX512F-FAST-NEXT:    vpshufb %ymm14, %ymm13, %ymm13
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm19[1,1,1,2,5,5,5,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm13 = ymm13[0],ymm14[1],ymm13[2,3],ymm14[4],ymm13[5],ymm14[6],ymm13[7,8],ymm14[9],ymm13[10,11],ymm14[12],ymm13[13],ymm14[14],ymm13[15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,3,2,3]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm13, %zmm8, %zmm8
; AVX512F-FAST-NEXT:    vmovdqa (%r8), %ymm13
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm14 = ymm13[0,1,1,1]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm22, %ymm15
; AVX512F-FAST-NEXT:    vpshufb %ymm15, %ymm13, %ymm13
; AVX512F-FAST-NEXT:    vpbroadcastq 16(%r8), %ymm15
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm19 = [65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpandnq %ymm15, %ymm19, %ymm15
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm13, %zmm13
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm16, %zmm3
; AVX512F-FAST-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm18
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm10, %zmm9, %zmm3
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} zmm9 = zmm17[0,1,0,1,4,5,4,5]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm3, %zmm10, %zmm9
; AVX512F-FAST-NEXT:    vpbroadcastq (%r8), %ymm3
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm14, %zmm3, %zmm3
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm3
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm11, %zmm7, %zmm7
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm12, %zmm0, %zmm0
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm7, %zmm10, %zmm0
; AVX512F-FAST-NEXT:    vpbroadcastq 48(%r8), %ymm7
; AVX512F-FAST-NEXT:    vpbroadcastq 56(%r8), %ymm9
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm9, %zmm7, %zmm7
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm7
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm2, %zmm0
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm1
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm0, %zmm2, %zmm1
; AVX512F-FAST-NEXT:    vpbroadcastq 24(%r8), %ymm0
; AVX512F-FAST-NEXT:    vpbroadcastq 32(%r8), %ymm4
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm0
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm0
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm6, %zmm2, %zmm8
; AVX512F-FAST-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm13
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm13, 64(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, 128(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, 256(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm18, 192(%r9)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride5_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <u,u,0,32,u,u,u,1,33,u,u,u,2,34,u,u,u,3,35,u,u,u,4,36,u,u,u,5,37,u,u,u>
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm5
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <0,32,u,u,u,1,33,u,u,u,2,34,u,u,u,3,35,u,u,u,4,36,u,u,u,5,37,u,u,u,6,38>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm6
; AVX512BW-NEXT:    movl $415641996, %eax # imm = 0x18C6318C
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm5, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [0,1,2,3,32,5,6,7,8,33,10,11,12,13,34,15,16,17,18,35,20,21,22,23,36,25,26,27,28,37,30,31]
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm6, %zmm5
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <u,u,u,7,39,u,u,u,8,40,u,u,u,9,41,u,u,u,10,42,u,u,u,11,43,u,u,u,12,44,u,u>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm6
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <6,38,u,u,u,7,39,u,u,u,8,40,u,u,u,9,41,u,u,u,10,42,u,u,u,11,43,u,u,u,12,44>
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm7
; AVX512BW-NEXT:    movl $831283992, %eax # imm = 0x318C6318
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu16 %zmm6, %zmm7 {%k2}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,1,38,3,4,5,6,39,8,9,10,11,40,13,14,15,16,41,18,19,20,21,42,23,24,25,26,43,28,29,30,31]
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm7, %zmm6
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,u,13,45,u,u,u,14,46,u,u,u,15,47,u,u,u,16,48,u,u,u,17,49,u,u,u,18,50,u,u>
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm7
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,13,45,u,u,u,14,46,u,u,u,15,47,u,u,u,16,48,u,u,u,17,49,u,u,u,18,50,u,u,u,19>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm8
; AVX512BW-NEXT:    vmovdqu16 %zmm7, %zmm8 {%k2}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [44,1,2,3,4,45,6,7,8,9,46,11,12,13,14,47,16,17,18,19,48,21,22,23,24,49,26,27,28,29,50,31]
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm8, %zmm7
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,19,51,u,u,u,20,52,u,u,u,21,53,u,u,u,22,54,u,u,u,23,55,u,u,u,24,56,u,u,u,25>
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm8
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <19,u,u,u,52,20,u,u,u,53,21,u,u,u,54,22,u,u,u,55,23,u,u,u,56,24,u,u,u,57,25,u>
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm1, %zmm9
; AVX512BW-NEXT:    movl $-1939662650, %eax # imm = 0x8C6318C6
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu16 %zmm8, %zmm9 {%k2}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [0,1,2,51,4,5,6,7,52,9,10,11,12,53,14,15,16,17,54,19,20,21,22,55,24,25,26,27,56,29,30,31]
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm9, %zmm8
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,26,58,u,u,u,27,59,u,u,u,28,60,u,u,u,29,61,u,u,u,30,62,u,u,u,31,63,u,u,u>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm9
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = <25,u,u,u,58,26,u,u,u,59,27,u,u,u,60,28,u,u,u,61,29,u,u,u,62,30,u,u,u,63,31,u>
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu16 %zmm9, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,57,2,3,4,5,58,7,8,9,10,59,12,13,14,15,60,17,18,19,20,61,22,23,24,25,62,27,28,29,30,63]
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 256(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 192(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 128(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 64(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <32 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <32 x i16>, ptr %in.vecptr4, align 64
  %1 = shufflevector <32 x i16> %in.vec0, <32 x i16> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i16> %in.vec2, <32 x i16> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <64 x i16> %1, <64 x i16> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %4 = shufflevector <32 x i16> %in.vec4, <32 x i16> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <128 x i16> %3, <128 x i16> %4, <160 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159>
  %interleaved.vec = shufflevector <160 x i16> %5, <160 x i16> poison, <160 x i32> <i32 0, i32 32, i32 64, i32 96, i32 128, i32 1, i32 33, i32 65, i32 97, i32 129, i32 2, i32 34, i32 66, i32 98, i32 130, i32 3, i32 35, i32 67, i32 99, i32 131, i32 4, i32 36, i32 68, i32 100, i32 132, i32 5, i32 37, i32 69, i32 101, i32 133, i32 6, i32 38, i32 70, i32 102, i32 134, i32 7, i32 39, i32 71, i32 103, i32 135, i32 8, i32 40, i32 72, i32 104, i32 136, i32 9, i32 41, i32 73, i32 105, i32 137, i32 10, i32 42, i32 74, i32 106, i32 138, i32 11, i32 43, i32 75, i32 107, i32 139, i32 12, i32 44, i32 76, i32 108, i32 140, i32 13, i32 45, i32 77, i32 109, i32 141, i32 14, i32 46, i32 78, i32 110, i32 142, i32 15, i32 47, i32 79, i32 111, i32 143, i32 16, i32 48, i32 80, i32 112, i32 144, i32 17, i32 49, i32 81, i32 113, i32 145, i32 18, i32 50, i32 82, i32 114, i32 146, i32 19, i32 51, i32 83, i32 115, i32 147, i32 20, i32 52, i32 84, i32 116, i32 148, i32 21, i32 53, i32 85, i32 117, i32 149, i32 22, i32 54, i32 86, i32 118, i32 150, i32 23, i32 55, i32 87, i32 119, i32 151, i32 24, i32 56, i32 88, i32 120, i32 152, i32 25, i32 57, i32 89, i32 121, i32 153, i32 26, i32 58, i32 90, i32 122, i32 154, i32 27, i32 59, i32 91, i32 123, i32 155, i32 28, i32 60, i32 92, i32 124, i32 156, i32 29, i32 61, i32 93, i32 125, i32 157, i32 30, i32 62, i32 94, i32 126, i32 158, i32 31, i32 63, i32 95, i32 127, i32 159>
  store <160 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride5_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride5_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $616, %rsp # imm = 0x268
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsi), %xmm15
; SSE-NEXT:    movdqa 16(%rsi), %xmm11
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rdx), %xmm7
; SSE-NEXT:    movdqa (%rcx), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rcx), %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%r8), %xmm13
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm15[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,65535,65535,65535,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[1,1,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535,0,65535,65535,65535,65535,0]
; SSE-NEXT:    pand %xmm9, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm2[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    por %xmm3, %xmm8
; SSE-NEXT:    pand %xmm1, %xmm8
; SSE-NEXT:    por %xmm5, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm2, %xmm8
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm13, %xmm0
; SSE-NEXT:    por %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm11[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm10, %xmm5
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm5, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm12[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm6
; SSE-NEXT:    pandn %xmm5, %xmm6
; SSE-NEXT:    movdqa 16(%rdx), %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm12[1,1,2,2]
; SSE-NEXT:    pand %xmm9, %xmm8
; SSE-NEXT:    por %xmm8, %xmm6
; SSE-NEXT:    pand %xmm1, %xmm6
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    movdqa 16(%r8), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa 32(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm10, %xmm6
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm6, %xmm3
; SSE-NEXT:    movdqa 32(%rcx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    movdqa 32(%rdx), %xmm14
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm14[1,1,2,2]
; SSE-NEXT:    pand %xmm9, %xmm11
; SSE-NEXT:    por %xmm11, %xmm8
; SSE-NEXT:    pand %xmm1, %xmm8
; SSE-NEXT:    por %xmm3, %xmm8
; SSE-NEXT:    pand %xmm2, %xmm8
; SSE-NEXT:    movdqa 32(%r8), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa 48(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm10, %xmm8
; SSE-NEXT:    por %xmm3, %xmm8
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm8, %xmm3
; SSE-NEXT:    movdqa 48(%rcx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm11
; SSE-NEXT:    pandn %xmm8, %xmm11
; SSE-NEXT:    movdqa 48(%rdx), %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm8[1,1,2,2]
; SSE-NEXT:    pand %xmm9, %xmm13
; SSE-NEXT:    por %xmm13, %xmm11
; SSE-NEXT:    pand %xmm1, %xmm11
; SSE-NEXT:    por %xmm3, %xmm11
; SSE-NEXT:    pand %xmm2, %xmm11
; SSE-NEXT:    movdqa 48(%r8), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa 64(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm10, %xmm11
; SSE-NEXT:    por %xmm3, %xmm11
; SSE-NEXT:    movdqa %xmm1, %xmm13
; SSE-NEXT:    pandn %xmm11, %xmm13
; SSE-NEXT:    movdqa 64(%rcx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm11
; SSE-NEXT:    pandn %xmm3, %xmm11
; SSE-NEXT:    movdqa 64(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,2]
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    pand %xmm1, %xmm11
; SSE-NEXT:    por %xmm13, %xmm11
; SSE-NEXT:    pand %xmm2, %xmm11
; SSE-NEXT:    movdqa 64(%r8), %xmm3
; SSE-NEXT:    movdqa %xmm3, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    movdqa 80(%rsi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm10, %xmm11
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pandn %xmm11, %xmm0
; SSE-NEXT:    movdqa 80(%rcx), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm13
; SSE-NEXT:    pandn %xmm11, %xmm13
; SSE-NEXT:    movdqa 80(%rdx), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm3[1,1,2,2]
; SSE-NEXT:    pand %xmm9, %xmm11
; SSE-NEXT:    por %xmm11, %xmm13
; SSE-NEXT:    pand %xmm1, %xmm13
; SSE-NEXT:    por %xmm0, %xmm13
; SSE-NEXT:    pand %xmm2, %xmm13
; SSE-NEXT:    movdqa 80(%r8), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm13, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    movdqa 96(%rsi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm10, %xmm11
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pandn %xmm11, %xmm0
; SSE-NEXT:    movdqa 96(%rcx), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm13
; SSE-NEXT:    pandn %xmm11, %xmm13
; SSE-NEXT:    movdqa 96(%rdx), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm3[1,1,2,2]
; SSE-NEXT:    pand %xmm9, %xmm11
; SSE-NEXT:    por %xmm11, %xmm13
; SSE-NEXT:    pand %xmm1, %xmm13
; SSE-NEXT:    por %xmm0, %xmm13
; SSE-NEXT:    pand %xmm2, %xmm13
; SSE-NEXT:    movdqa 96(%r8), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm13, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    movdqa 112(%rsi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm4[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm10, %xmm11
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    movdqa 112(%rcx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm13
; SSE-NEXT:    pandn %xmm0, %xmm13
; SSE-NEXT:    movdqa 112(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,2]
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm0, %xmm13
; SSE-NEXT:    pand %xmm1, %xmm13
; SSE-NEXT:    pandn %xmm11, %xmm1
; SSE-NEXT:    por %xmm13, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    movdqa 112(%r8), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,0,0,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm1, %xmm11
; SSE-NEXT:    pandn %xmm0, %xmm11
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm15[0],xmm0[1],xmm15[1],xmm0[2],xmm15[2],xmm0[3],xmm15[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm13 = xmm0[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm13[0,1,1,1]
; SSE-NEXT:    pand %xmm1, %xmm13
; SSE-NEXT:    por %xmm11, %xmm13
; SSE-NEXT:    pand %xmm10, %xmm13
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm6[0,1,0,1]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm11, %xmm1
; SSE-NEXT:    por %xmm13, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SSE-NEXT:    movdqa %xmm3, %xmm13
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    punpcklwd {{.*#+}} xmm13 = xmm13[0],xmm7[0],xmm13[1],xmm7[1],xmm13[2],xmm7[2],xmm13[3],xmm7[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm13 = xmm13[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm13 = xmm13[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pandn %xmm11, %xmm1
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm4[4],xmm7[5],xmm4[5],xmm7[6],xmm4[6],xmm7[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    pandn %xmm1, %xmm11
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,2]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm11, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [0,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[2,3,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm15
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm15[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[2,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm7
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pand %xmm9, %xmm7
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,0,0,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm5[0],xmm1[1],xmm5[1],xmm1[2],xmm5[2],xmm1[3],xmm5[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm1[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,1,1,1]
; SSE-NEXT:    pand %xmm0, %xmm7
; SSE-NEXT:    por %xmm2, %xmm7
; SSE-NEXT:    pand %xmm10, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[0,1,0,1]
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movdqa %xmm15, %xmm7
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm12[0],xmm7[1],xmm12[1],xmm7[2],xmm12[2],xmm7[3],xmm12[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm1[0],xmm7[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm7
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm12 = xmm12[4],xmm15[4],xmm12[5],xmm15[5],xmm12[6],xmm15[6],xmm12[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm5[4],xmm1[5],xmm5[5],xmm1[6],xmm5[6],xmm1[7],xmm5[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,2]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[2,3,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm5
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm5[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm12[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pand %xmm9, %xmm5
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm12[0],xmm1[1],xmm12[1],xmm1[2],xmm12[2],xmm1[3],xmm12[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,0,0,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm7[0],xmm1[1],xmm7[1],xmm1[2],xmm7[2],xmm1[3],xmm7[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm1[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,1,1,1]
; SSE-NEXT:    pand %xmm6, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    pand %xmm10, %xmm5
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm11[0,1,0,1]
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movdqa %xmm12, %xmm5
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm14[0],xmm5[1],xmm14[1],xmm5[2],xmm14[2],xmm5[3],xmm14[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm1, %xmm15
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm14 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm7[4],xmm1[5],xmm7[5],xmm1[6],xmm7[6],xmm1[7],xmm7[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,2]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm11[2,3,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm14[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pand %xmm9, %xmm5
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm11[0],xmm1[1],xmm11[1],xmm1[2],xmm11[2],xmm1[3],xmm11[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1],xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm1[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,1,1,1]
; SSE-NEXT:    pand %xmm6, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    pand %xmm10, %xmm5
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[0,1,0,1]
; SSE-NEXT:    movdqa %xmm10, %xmm12
; SSE-NEXT:    pandn %xmm2, %xmm12
; SSE-NEXT:    por %xmm5, %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movdqa %xmm11, %xmm5
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm8[0],xmm5[1],xmm8[1],xmm5[2],xmm8[2],xmm5[3],xmm8[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    pand %xmm15, %xmm5
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4],xmm11[4],xmm8[5],xmm11[5],xmm8[6],xmm11[6],xmm8[7],xmm11[7]
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm3[4],xmm1[5],xmm3[5],xmm1[6],xmm3[6],xmm1[7],xmm3[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,2]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[2,3,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm5
; SSE-NEXT:    pandn %xmm2, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm8[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pand %xmm9, %xmm5
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1],xmm1[2],xmm8[2],xmm1[3],xmm8[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1],xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm1[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,1,1,1]
; SSE-NEXT:    pand %xmm6, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    pand %xmm10, %xmm5
; SSE-NEXT:    movdqa (%rsp), %xmm7 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[0,1,0,1]
; SSE-NEXT:    movdqa %xmm10, %xmm12
; SSE-NEXT:    pandn %xmm2, %xmm12
; SSE-NEXT:    por %xmm5, %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movdqa %xmm8, %xmm5
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm11[0],xmm5[1],xmm11[1],xmm5[2],xmm11[2],xmm5[3],xmm11[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    pand %xmm15, %xmm5
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm3[4],xmm1[5],xmm3[5],xmm1[6],xmm3[6],xmm1[7],xmm3[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,2]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[2,3,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm7
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm7, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm5[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pand %xmm9, %xmm3
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1],xmm1[2],xmm8[2],xmm1[3],xmm8[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,1,1]
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm11[0,1,0,1]
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pandn %xmm5, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm12[0],xmm3[1],xmm12[1],xmm3[2],xmm12[2],xmm3[3],xmm12[3]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm5, %xmm1
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm8[4],xmm1[5],xmm8[5],xmm1[6],xmm8[6],xmm1[7],xmm8[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,2]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm11[2,3,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[2,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    por %xmm1, %xmm8
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    pand %xmm9, %xmm8
; SSE-NEXT:    por %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm2, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm5[0],xmm8[1],xmm5[1],xmm8[2],xmm5[2],xmm8[3],xmm5[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm8[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm14 = xmm1[0,1,1,1]
; SSE-NEXT:    pand %xmm6, %xmm14
; SSE-NEXT:    por %xmm3, %xmm14
; SSE-NEXT:    pand %xmm10, %xmm14
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[0,1,0,1]
; SSE-NEXT:    movdqa %xmm10, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    por %xmm14, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[2,3,2,3]
; SSE-NEXT:    movdqa %xmm0, %xmm14
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    punpcklwd {{.*#+}} xmm14 = xmm14[0],xmm11[0],xmm14[1],xmm11[1],xmm14[2],xmm11[2],xmm14[3],xmm11[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm14 = xmm14[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm14 = xmm14[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm14[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1]
; SSE-NEXT:    movdqa %xmm15, %xmm14
; SSE-NEXT:    pandn %xmm3, %xmm14
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm0, %xmm14
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm7[4],xmm3[5],xmm7[5],xmm3[6],xmm7[6],xmm3[7],xmm7[7]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm5[4],xmm0[5],xmm5[5],xmm0[6],xmm5[6],xmm0[7],xmm5[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,2]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm11
; SSE-NEXT:    pandn %xmm1, %xmm11
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm7[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm9, %xmm15
; SSE-NEXT:    pandn %xmm1, %xmm15
; SSE-NEXT:    pand %xmm9, %xmm3
; SSE-NEXT:    por %xmm3, %xmm15
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm7[0],xmm1[1],xmm7[1],xmm1[2],xmm7[2],xmm1[3],xmm7[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm5[0],xmm3[1],xmm5[1],xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm3[0,1,3,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[0,1,1,1]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pand %xmm6, %xmm12
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm12, %xmm2
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,1,0,1]
; SSE-NEXT:    pandn %xmm1, %xmm10
; SSE-NEXT:    por %xmm6, %xmm10
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,3,2,3]
; SSE-NEXT:    movdqa %xmm7, %xmm6
; SSE-NEXT:    movdqa %xmm0, %xmm12
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,5,4,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    por %xmm6, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm7[4],xmm3[5],xmm7[5],xmm3[6],xmm7[6],xmm3[7],xmm7[7]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm5[4],xmm1[5],xmm5[5],xmm1[6],xmm5[6],xmm1[7],xmm5[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,2]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; SSE-NEXT:    pandn %xmm3, %xmm13
; SSE-NEXT:    por %xmm1, %xmm13
; SSE-NEXT:    psrlq $48, %xmm5
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm8 = xmm8[1],xmm5[1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm7[0,1,2,3,4,5,7,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm8, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    pand %xmm9, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm9
; SSE-NEXT:    por %xmm4, %xmm9
; SSE-NEXT:    movdqa %xmm9, 624(%r9)
; SSE-NEXT:    movdqa %xmm13, 608(%r9)
; SSE-NEXT:    movdqa %xmm0, 576(%r9)
; SSE-NEXT:    movdqa %xmm10, 560(%r9)
; SSE-NEXT:    movdqa %xmm15, 544(%r9)
; SSE-NEXT:    movdqa %xmm11, 528(%r9)
; SSE-NEXT:    movdqa %xmm14, 496(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%r9)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    addq $616, %rsp # imm = 0x268
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride5_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $392, %rsp # imm = 0x188
; AVX1-ONLY-NEXT:    vmovdqa 80(%rcx), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 80(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm12 = [65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 80(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vmovdqa 80(%rsi), %xmm11
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm11, %xmm1
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm1 = xmm10[1],xmm1[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm10[4],xmm11[4],xmm10[5],xmm11[5],xmm10[6],xmm11[6],xmm10[7],xmm11[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm12, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 80(%r8), %xmm9
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm9[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm1[0],xmm0[1,2,3,4],xmm1[5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4,5,6],xmm1[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa 64(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm1, %xmm3
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm3 = xmm0[1],xmm3[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm10[0],xmm11[0],xmm10[1],xmm11[1],xmm10[2],xmm11[2],xmm10[3],xmm11[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm8[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,1,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm7
; AVX1-ONLY-NEXT:    vmovdqa 64(%rcx), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdx), %xmm6
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm13 = xmm3[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,1,3,3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm14 = xmm14[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[0,0,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vandnps %ymm7, %ymm12, %ymm7
; AVX1-ONLY-NEXT:    vandps %ymm12, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm13, %ymm7
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm13
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm11 = xmm11[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm11[0,1,2,3],xmm10[4],xmm11[5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm8, %ymm8
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm4[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm11 = xmm2[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1],xmm11[2],xmm10[3,4,5,6],xmm11[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm9[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm13[0,1,2,3],xmm14[4],xmm13[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1],xmm2[2],xmm4[2],xmm2[3],xmm4[3]
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm15 = [65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm8, %ymm15, %ymm4
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm15, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm2[0],xmm14[1],xmm2[2,3,4,5],xmm14[6],xmm2[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm9[3],xmm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,2,3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm4[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[0,1,1,1]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm8, %ymm4
; AVX1-ONLY-NEXT:    vmovdqa 64(%r8), %xmm8
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm15, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm15, %ymm4
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm4, %ymm2
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm8[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm9 = xmm2[0,1,2,3],xmm4[4],xmm2[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm4[1],xmm2[2,3,4,5],xmm4[6],xmm2[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm6[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm5[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm4[2],xmm2[3,4,5,6],xmm4[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm8[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm7[0,1],xmm4[2],xmm7[3,4,5,6],xmm4[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm3 = zero,zero,xmm3[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm1[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3],xmm0[4],xmm3[5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm11 = [65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm11, %ymm1
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm11, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0,1,2],xmm8[3],xmm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3,4],xmm4[5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovdqa 48(%rsi), %xmm5
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm5[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0,1,2,3],xmm4[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm4[0],xmm5[0],xmm4[1],xmm5[1],xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm0[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovdqa 48(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm1[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm2[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm2[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm7[0,1],xmm6[2],xmm7[3,4,5,6],xmm6[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm15, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm15, %ymm6
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm6, %ymm3
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm7 = zero,zero,xmm6[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm5, %xmm7
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm7 = xmm4[1],xmm7[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm4[4],xmm5[4],xmm4[5],xmm5[5],xmm4[6],xmm5[6],xmm4[7],xmm5[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vandnps %ymm6, %ymm12, %ymm5
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm12, %ymm4
; AVX1-ONLY-NEXT:    vorps %ymm5, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vmovdqa 48(%r8), %xmm7
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm7[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm5[0],xmm4[1,2,3,4],xmm5[5],xmm4[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2],xmm4[3,4,5,6],xmm5[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 32(%rcx), %xmm4
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm4[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm5[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdx), %xmm5
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm5[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm8[0,1],xmm6[2],xmm8[3,4,5,6],xmm6[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm9 = zero,zero,xmm8[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm6, %ymm9
; AVX1-ONLY-NEXT:    vmovdqa 32(%rsi), %xmm6
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm6[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm13 = xmm10[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm13 = xmm13[0,1,2,3],xmm10[4],xmm13[5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm10[4],xmm6[4],xmm10[5],xmm6[5],xmm10[6],xmm6[6],xmm10[7],xmm6[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm14 = xmm14[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vandnps %ymm9, %ymm11, %ymm9
; AVX1-ONLY-NEXT:    vandps %ymm11, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vorps %ymm9, %ymm13, %ymm9
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm6, %xmm13
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm13 = xmm10[1],xmm13[1]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm13, %ymm0
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm8[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,1,3,3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm12, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm1
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2],xmm7[3],xmm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm7[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm1[1],xmm3[2,3,4,5],xmm1[6],xmm3[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 32(%r8), %xmm2
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm9, %xmm3
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm7[0],xmm3[1,2,3,4],xmm7[5],xmm3[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm0[0,1],xmm7[2],xmm0[3,4,5,6],xmm7[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm4[0],xmm5[0],xmm4[1],xmm5[1],xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm10[0],xmm6[0],xmm10[1],xmm6[1],xmm10[2],xmm6[2],xmm10[3],xmm6[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm1[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,1,1]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm15, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm15, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm9[0,1,2],xmm2[3],xmm9[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm0[0,1,2,3],xmm1[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3,4,5],xmm1[6],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 112(%rsi), %xmm4
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm4[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 112(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0,1,2,3],xmm5[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm0[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovdqa 112(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm1[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm2[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 112(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm2[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm7[0,1],xmm6[2],xmm7[3,4,5,6],xmm6[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm15, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm15, %ymm6
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm6, %ymm3
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm7 = zero,zero,xmm6[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm4, %xmm7
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm7 = xmm5[1],xmm7[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vandnps %ymm6, %ymm12, %ymm5
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm12, %ymm4
; AVX1-ONLY-NEXT:    vorps %ymm5, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vmovdqa 112(%r8), %xmm5
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm6[0],xmm4[1,2,3,4],xmm6[5],xmm4[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm6[2],xmm4[3,4,5,6],xmm6[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 96(%rcx), %xmm4
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm4[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm6[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdx), %xmm6
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm8[0,1],xmm7[2],xmm8[3,4,5,6],xmm7[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm6[4],xmm4[4],xmm6[5],xmm4[5],xmm6[6],xmm4[6],xmm6[7],xmm4[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm9 = zero,zero,xmm8[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm7, %ymm9
; AVX1-ONLY-NEXT:    vmovdqa 96(%rsi), %xmm7
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm7[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm13 = xmm10[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm13 = xmm13[0,1,2,3],xmm10[4],xmm13[5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm10[4],xmm7[4],xmm10[5],xmm7[5],xmm10[6],xmm7[6],xmm10[7],xmm7[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm14 = xmm14[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vandnps %ymm9, %ymm11, %ymm9
; AVX1-ONLY-NEXT:    vandps %ymm11, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vorps %ymm9, %ymm13, %ymm9
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm7, %xmm13
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm13 = xmm10[1],xmm13[1]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm13, %ymm0
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm8[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,1,3,3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm12, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm1
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2],xmm5[3],xmm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm1[1],xmm3[2,3,4,5],xmm1[6],xmm3[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 96(%r8), %xmm2
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm9, %xmm3
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm5[0],xmm3[1,2,3,4],xmm5[5],xmm3[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm0[0,1],xmm5[2],xmm0[3,4,5,6],xmm5[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm6[0],xmm4[0],xmm6[1],xmm4[1],xmm6[2],xmm4[2],xmm6[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm4[0],xmm6[0],xmm4[1],xmm6[1],xmm4[2],xmm6[2],xmm4[3],xmm6[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm10[0],xmm7[0],xmm10[1],xmm7[1],xmm10[2],xmm7[2],xmm10[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm1[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,1,1]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm15, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm15, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm9[0,1,2],xmm2[3],xmm9[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm0[0,1,2,3],xmm1[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3,4,5],xmm1[6],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm7[4],xmm3[4],xmm7[5],xmm3[5],xmm7[6],xmm3[6],xmm7[7],xmm3[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm4
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm0, %xmm5
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm5 = xmm1[1],xmm5[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm6[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX1-ONLY-NEXT:    vandnps %ymm4, %ymm12, %ymm4
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm12, %ymm5
; AVX1-ONLY-NEXT:    vorps %ymm4, %ymm5, %ymm4
; AVX1-ONLY-NEXT:    vmovdqa 16(%r8), %xmm8
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm8[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm5[0],xmm4[1,2,3,4],xmm5[5],xmm4[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1],xmm5[2],xmm4[3,4,5,6],xmm5[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm10
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm9
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm9, %xmm4
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm4 = xmm10[1],xmm4[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm2[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,1,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm6
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm5[4],xmm6[4],xmm5[5],xmm6[5],xmm5[6],xmm6[6],xmm5[7],xmm6[7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm14 = xmm11[0,1,2,3,4,5,7,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[2,1,3,3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm7[0],xmm3[0],xmm7[1],xmm3[1],xmm7[2],xmm3[2],xmm7[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm13[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[0,0,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm14, %ymm13
; AVX1-ONLY-NEXT:    vandnps %ymm4, %ymm12, %ymm4
; AVX1-ONLY-NEXT:    vandps %ymm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm4, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm2[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm3[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm7[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1],xmm1[2],xmm2[3,4,5,6],xmm1[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm7[0],xmm3[1],xmm7[1],xmm3[2],xmm7[2],xmm3[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm15, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm15, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm12, %xmm0
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm8[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0],xmm1[1],xmm2[2,3,4,5],xmm1[6],xmm2[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm8[3],xmm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,0,2,1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,2,3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,5,4,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm4[0,1,3,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,1,1,1]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm7, %ymm4
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm15, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm15, %ymm4
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vmovdqa (%r8), %xmm4
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm4[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm3[0,1,2,3],xmm7[4],xmm3[5,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm7[1],xmm3[2,3,4,5],xmm7[6],xmm3[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm6[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm6[2],xmm5[3,4,5,6],xmm6[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm6 = zero,zero,xmm11[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm9[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2,3],xmm10[4],xmm6[5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[0,2,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm7 = [65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm5, %ymm7, %ymm5
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vorps %ymm5, %ymm6, %ymm5
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm12[0,1],xmm6[2],xmm12[3,4,5,6],xmm6[7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[3],xmm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0],xmm5[1,2,3,4],xmm6[5],xmm5[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, 48(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, 32(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, 16(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, (%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, 112(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, 96(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, 80(%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, 64(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 144(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 128(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 496(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 480(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 560(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 544(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 528(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 512(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 624(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 608(%r9)
; AVX1-ONLY-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 592(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 576(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 176(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 160(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 240(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 224(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 208(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 192(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 304(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 288(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 272(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 256(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 368(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 352(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 336(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 320(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 432(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 416(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 400(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 384(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 464(%r9)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 448(%r9)
; AVX1-ONLY-NEXT:    addq $392, %rsp # imm = 0x188
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride5_vf64:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $968, %rsp # imm = 0x3C8
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm11
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm14
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm5
; AVX2-SLOW-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm13
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm15
; AVX2-SLOW-NEXT:    vmovdqa 64(%rcx), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm13[0],xmm11[0],xmm13[1],xmm11[1],xmm13[2],xmm11[2],xmm13[3],xmm11[3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm4
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm8
; AVX2-SLOW-NEXT:    vmovdqa 64(%rsi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm7
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %xmm12
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1],xmm6[2],xmm4[2],xmm6[3],xmm4[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,5,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm6, %ymm1, %ymm9
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,5,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm6, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm6, %xmm6
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm12[0],xmm0[0],xmm12[1],xmm0[1],xmm12[2],xmm0[2],xmm12[3],xmm0[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,5,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm7, %ymm6, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdx), %xmm12
; AVX2-SLOW-NEXT:    vmovdqa 96(%rcx), %xmm6
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm6[0],xmm12[0],xmm6[1],xmm12[1],xmm6[2],xmm12[2],xmm6[3],xmm12[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm7, %xmm3
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rsi), %xmm7
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %xmm5
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm5[0],xmm7[0],xmm5[1],xmm7[1],xmm5[2],xmm7[2],xmm5[3],xmm7[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,5,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm5, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vpbroadcastq (%r8), %ymm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm9, %ymm5, %ymm5
; AVX2-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastq 32(%r8), %ymm5
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm1, %ymm5, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastq 64(%r8), %ymm1
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastq 96(%r8), %ymm0
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm3 = <6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13>
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm4, %xmm0
; AVX2-SLOW-NEXT:    vpbroadcastq 8(%rdi), %xmm1
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5],xmm1[6],xmm0[7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm2 = <10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9>
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm13, %xmm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm11[1,2,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm5[1],xmm1[2],xmm5[3],xmm1[4,5],xmm5[6],xmm1[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,0]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm13 = <255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm0, %ymm1, %ymm9
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm8, %xmm0
; AVX2-SLOW-NEXT:    vpbroadcastq 40(%rdi), %xmm1
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5],xmm1[6],xmm0[7]
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm15, %xmm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm14[1,2,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm4[1],xmm1[2],xmm4[3],xmm1[4,5],xmm4[6],xmm1[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpbroadcastq 72(%rdi), %xmm4
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm4[1],xmm1[2,3],xmm4[4],xmm1[5],xmm4[6],xmm1[7]
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm10
; AVX2-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm4, %xmm4
; AVX2-SLOW-NEXT:    vpshufd $169, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm5 = mem[1,2,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0],xmm5[1],xmm4[2],xmm5[3],xmm4[4,5],xmm5[6],xmm4[7]
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm11
; AVX2-SLOW-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm1, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %ymm5
; AVX2-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm7, %xmm1
; AVX2-SLOW-NEXT:    vpbroadcastq 104(%rdi), %xmm3
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm3[1],xmm1[2,3],xmm3[4],xmm1[5],xmm3[6],xmm1[7]
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %ymm7
; AVX2-SLOW-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm6, %xmm2
; AVX2-SLOW-NEXT:    vmovdqa 64(%r8), %ymm6
; AVX2-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm12[1,2,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1],xmm2[2],xmm3[3],xmm2[4,5],xmm3[6],xmm2[7]
; AVX2-SLOW-NEXT:    vmovdqa 96(%r8), %ymm8
; AVX2-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm5[0,1,1,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm9, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm7[0,1,1,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm6[0,1,1,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm4, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm8[0,1,1,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25>
; AVX2-SLOW-NEXT:    vpshufb %ymm8, %ymm11, %ymm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm10[1,1,1,2,5,5,5,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm4
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm4[3,1,2,2,4,5,6,7,11,9,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm2[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm11
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm11[0,1,2,1,4,5,6,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3],ymm3[4],ymm2[5,6],ymm3[7],ymm2[8,9],ymm3[10],ymm2[11],ymm3[12],ymm2[13,14],ymm3[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = <255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm1, %ymm2, %ymm10
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufb %ymm8, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm0[1,1,1,2,5,5,5,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm0
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm0[3,1,2,2,4,5,6,7,11,9,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, %ymm5
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm2[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm0[0,1,2,1,4,5,6,5]
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, %ymm9
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3],ymm3[4],ymm2[5,6],ymm3[7],ymm2[8,9],ymm3[10],ymm2[11],ymm3[12],ymm2[13,14],ymm3[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm1, %ymm2, %ymm6
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdx), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rcx), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufb %ymm8, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm0[1,1,1,2,5,5,5,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX2-SLOW-NEXT:    vmovdqa 64(%rsi), %ymm15
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm15[3,1,2,2,4,5,6,7,11,9,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqu %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm2[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm7
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm7[0,1,2,1,4,5,6,5]
; AVX2-SLOW-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3],ymm3[4],ymm2[5,6],ymm3[7],ymm2[8,9],ymm3[10],ymm2[11],ymm3[12],ymm2[13,14],ymm3[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm1, %ymm2, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa 96(%rcx), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufb %ymm8, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdx), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm0[1,1,1,2,5,5,5,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rsi), %ymm0
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm0[3,1,2,2,4,5,6,7,11,9,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm1[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm13
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm13[0,1,2,1,4,5,6,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm14[2],ymm0[3],ymm14[4],ymm0[5,6],ymm14[7],ymm0[8,9],ymm14[10],ymm0[11],ymm14[12],ymm0[13,14],ymm14[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm8, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpbroadcastq 16(%r8), %ymm8
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm10, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastq 48(%r8), %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm6, %ymm8, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastq 80(%r8), %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm3, %ymm8, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastq 112(%r8), %ymm3
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm0, %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm4[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,2,6,7,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm11[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2],ymm3[3],ymm0[4,5],ymm3[6],ymm0[7,8],ymm3[9],ymm0[10],ymm3[11],ymm0[12,13],ymm3[14],ymm0[15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm10[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm6[3,2,3,3,7,6,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm8[1],ymm3[2],ymm8[3,4],ymm3[5,6,7,8],ymm8[9],ymm3[10],ymm8[11,12],ymm3[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = <u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm0, %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm5[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,3,2,2,6,7,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm9[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm12[1],ymm3[2],ymm12[3],ymm3[4,5],ymm12[6],ymm3[7,8],ymm12[9],ymm3[10],ymm12[11],ymm3[12,13],ymm12[14],ymm3[15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm12 = ymm9[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm5[3,2,3,3,7,6,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm12[0],ymm14[1],ymm12[2],ymm14[3,4],ymm12[5,6,7,8],ymm14[9],ymm12[10],ymm14[11,12],ymm12[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,2,3,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm3, %ymm12, %ymm3
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm12 = ymm15[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,3,2,2,6,7,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm7[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm12[0],ymm14[1],ymm12[2],ymm14[3],ymm12[4,5],ymm14[6],ymm12[7,8],ymm14[9],ymm12[10],ymm14[11],ymm12[12,13],ymm14[14],ymm12[15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm14 = ymm7[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm4[3,2,3,3,7,6,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm14 = ymm14[0],ymm15[1],ymm14[2],ymm15[3,4],ymm14[5,6,7,8],ymm15[9],ymm14[10],ymm15[11,12],ymm14[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,3,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm12, %ymm14, %ymm14
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm12 = ymm2[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,3,2,2,6,7,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm13[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm12[0],ymm15[1],ymm12[2],ymm15[3],ymm12[4,5],ymm15[6],ymm12[7,8],ymm15[9],ymm12[10],ymm15[11],ymm12[12,13],ymm15[14],ymm12[15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm15 = ymm2[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm15[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm1[3,2,3,3,7,6,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm15[0],ymm0[1],ymm15[2],ymm0[3,4],ymm15[5,6,7,8],ymm0[9],ymm15[10],ymm0[11,12],ymm15[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,3,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm12, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpbroadcastq 24(%r8), %ymm8
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = [0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastq 56(%r8), %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm3, %ymm8, %ymm3
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastq 88(%r8), %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm14, %ymm8, %ymm3
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastq 120(%r8), %ymm14
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm0, %ymm14, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = <u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm14, %ymm10, %ymm15
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm6[3,0,3,0,7,4,7,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm12[0],ymm15[1],ymm12[2],ymm15[3],ymm12[4,5],ymm15[6],ymm12[7,8],ymm15[9],ymm12[10],ymm15[11],ymm12[12,13],ymm15[14],ymm12[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = <u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u>
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %ymm15, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm11[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm8[0],ymm0[1],ymm8[2,3],ymm0[4],ymm8[5],ymm0[6],ymm8[7,8],ymm0[9],ymm8[10,11],ymm0[12],ymm8[13],ymm0[14],ymm8[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = <255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm12, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpshufb %ymm14, %ymm9, %ymm12
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm5[3,0,3,0,7,4,7,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm12[1],ymm3[2],ymm12[3],ymm3[4,5],ymm12[6],ymm3[7,8],ymm12[9],ymm3[10],ymm12[11],ymm3[12,13],ymm12[14],ymm3[15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %ymm15, %ymm5, %ymm12
; AVX2-SLOW-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm10 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm10[0],ymm12[1],ymm10[2,3],ymm12[4],ymm10[5],ymm12[6],ymm10[7,8],ymm12[9],ymm10[10,11],ymm12[12],ymm10[13],ymm12[14],ymm10[15]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm3, %ymm10, %ymm3
; AVX2-SLOW-NEXT:    vpshufb %ymm14, %ymm7, %ymm9
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm4[3,0,3,0,7,4,7,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm9 = ymm10[0],ymm9[1],ymm10[2],ymm9[3],ymm10[4,5],ymm9[6],ymm10[7,8],ymm9[9],ymm10[10],ymm9[11],ymm10[12,13],ymm9[14],ymm10[15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %ymm15, %ymm4, %ymm7
; AVX2-SLOW-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm6 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3],ymm7[4],ymm6[5],ymm7[6],ymm6[7,8],ymm7[9],ymm6[10,11],ymm7[12],ymm6[13],ymm7[14],ymm6[15]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm9, %ymm6, %ymm6
; AVX2-SLOW-NEXT:    vpshufb %ymm14, %ymm2, %ymm5
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm1[3,0,3,0,7,4,7,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2],ymm5[3],ymm4[4,5],ymm5[6],ymm4[7,8],ymm5[9],ymm4[10],ymm5[11],ymm4[12,13],ymm5[14],ymm4[15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %ymm15, %ymm1, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm13[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm4, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm2 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm0, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm2 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm3 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm6, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm5 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm1, %ymm5, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, 544(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, 384(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, 224(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 64(%r9)
; AVX2-SLOW-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 608(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 576(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 512(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 448(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 416(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 352(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 288(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 256(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 480(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 320(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-SLOW-NEXT:    addq $968, %rsp # imm = 0x3C8
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride5_vf64:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    subq $936, %rsp # imm = 0x3A8
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %xmm7
; AVX2-FAST-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rsi), %xmm5
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %xmm14
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %xmm13
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = [0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm0, %xmm8
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm1[0,1,0,1]
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm11
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %xmm9
; AVX2-FAST-NEXT:    vmovdqa 64(%rdx), %xmm12
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm6
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %xmm10
; AVX2-FAST-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm11[0],xmm6[1],xmm11[1],xmm6[2],xmm11[2],xmm6[3],xmm11[3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = [4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm15 = ymm3[0,1,0,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm2, %ymm15, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm14[0],xmm7[0],xmm14[1],xmm7[1],xmm14[2],xmm7[2],xmm14[3],xmm7[3]
; AVX2-FAST-NEXT:    vmovdqa %xmm8, %xmm2
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm14, %xmm14
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,1,0,1]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm15, %xmm15
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,0,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm14, %ymm15, %ymm14
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm13[0],xmm5[0],xmm13[1],xmm5[1],xmm13[2],xmm5[2],xmm13[3],xmm5[3]
; AVX2-FAST-NEXT:    vmovdqa %xmm5, %xmm8
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm13, %xmm13
; AVX2-FAST-NEXT:    vmovdqa %xmm2, %xmm5
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,0,1]
; AVX2-FAST-NEXT:    vmovdqa %xmm0, %xmm7
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm0[0],xmm12[0],xmm0[1],xmm12[1],xmm0[2],xmm12[2],xmm0[3],xmm12[3]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm15, %xmm15
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,0,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm13, %ymm15, %ymm15
; AVX2-FAST-NEXT:    vmovdqa 96(%rsi), %xmm13
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %xmm2
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm13[0],xmm2[1],xmm13[1],xmm2[2],xmm13[2],xmm2[3],xmm13[3]
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm2, %xmm0
; AVX2-FAST-NEXT:    vmovdqa 96(%rdx), %xmm2
; AVX2-FAST-NEXT:    vmovdqa 96(%rcx), %xmm1
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpbroadcastq (%r8), %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq 32(%r8), %ymm3
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm14, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq 64(%r8), %ymm3
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm15, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq 96(%r8), %ymm3
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm0, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = <6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13>
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpbroadcastq 8(%rdi), %xmm4
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm4[1],xmm3[2,3],xmm4[4],xmm3[5],xmm4[6],xmm3[7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = <10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9>
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm6, %xmm5
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm11[1,2,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0],xmm6[1],xmm5[2],xmm6[3],xmm5[4,5],xmm6[6],xmm5[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,0]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = <255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm3, %ymm5, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX2-FAST-NEXT:    vpbroadcastq 40(%rdi), %xmm11
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0],xmm11[1],xmm5[2,3],xmm11[4],xmm5[5],xmm11[6],xmm5[7]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm10, %xmm10
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[1,2,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm9 = xmm10[0],xmm9[1],xmm10[2],xmm9[3],xmm10[4,5],xmm9[6],xmm10[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm5, %ymm9, %ymm5
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm8, %xmm9
; AVX2-FAST-NEXT:    vpbroadcastq 72(%rdi), %xmm10
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0],xmm10[1],xmm9[2,3],xmm10[4],xmm9[5],xmm10[6],xmm9[7]
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm11
; AVX2-FAST-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm7, %xmm8
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm12[1,2,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm7 = xmm8[0],xmm7[1],xmm8[2],xmm7[3],xmm8[4,5],xmm7[6],xmm8[7]
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %ymm12
; AVX2-FAST-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm9[0,1,0,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm8, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vmovdqa (%r8), %ymm9
; AVX2-FAST-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX2-FAST-NEXT:    vpbroadcastq 104(%rdi), %xmm8
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm8[1],xmm0[2,3],xmm8[4],xmm0[5],xmm8[6],xmm0[7]
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %ymm8
; AVX2-FAST-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vmovdqa 64(%r8), %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[1,2,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3],xmm1[4,5],xmm2[6],xmm1[7]
; AVX2-FAST-NEXT:    vmovdqa 96(%r8), %ymm10
; AVX2-FAST-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm9[0,1,1,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm3, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm8[0,1,1,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm5, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm4[0,1,1,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm7, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm10[0,1,1,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25>
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm12, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm11[1,1,1,2,5,5,5,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm12
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,18,19,u,u,20,21,u,u,24,25,24,25,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm13, %ymm12, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm4[0,1,2,1,4,5,6,5]
; AVX2-FAST-NEXT:    vmovdqa %ymm4, %ymm14
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3],ymm3[4],ymm2[5,6],ymm3[7],ymm2[8,9],ymm3[10],ymm2[11],ymm3[12],ymm2[13,14],ymm3[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = <255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa %ymm3, %ymm5
; AVX2-FAST-NEXT:    vmovdqu %ymm1, (%rsp) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm3[1,1,1,2,5,5,5,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm11
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %ymm13, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm11[0,1,2,1,4,5,6,5]
; AVX2-FAST-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3],ymm3[4],ymm2[5,6],ymm3[7],ymm2[8,9],ymm3[10],ymm2[11],ymm3[12],ymm2[13,14],ymm3[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rdx), %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rcx), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[1,1,1,2,5,5,5,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %ymm9
; AVX2-FAST-NEXT:    vmovdqa 64(%rsi), %ymm10
; AVX2-FAST-NEXT:    vpshufb %ymm13, %ymm10, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm9[0,1,2,1,4,5,6,5]
; AVX2-FAST-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3],ymm3[4],ymm2[5,6],ymm3[7],ymm2[8,9],ymm3[10],ymm2[11],ymm3[12],ymm2[13,14],ymm3[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm1, %ymm2, %ymm7
; AVX2-FAST-NEXT:    vmovdqa 96(%rcx), %ymm8
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm8, %ymm0
; AVX2-FAST-NEXT:    vmovdqa 96(%rdx), %ymm6
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm6[1,1,1,2,5,5,5,6]
; AVX2-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm0[0],ymm2[1],ymm0[2,3],ymm2[4],ymm0[5],ymm2[6],ymm0[7,8],ymm2[9],ymm0[10,11],ymm2[12],ymm0[13],ymm2[14],ymm0[15]
; AVX2-FAST-NEXT:    vmovdqa 96(%rsi), %ymm4
; AVX2-FAST-NEXT:    vpshufb %ymm13, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %ymm13
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm15 = ymm13[0,1,2,1,4,5,6,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm15[2],ymm0[3],ymm15[4],ymm0[5,6],ymm15[7],ymm0[8,9],ymm15[10],ymm0[11],ymm15[12],ymm0[13,14],ymm15[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpbroadcastq 16(%r8), %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, (%rsp), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqu %ymm1, (%rsp) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq 48(%r8), %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm15, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq 80(%r8), %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm7, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq 112(%r8), %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,26,27,30,31,30,31,28,29,30,31,28,29>
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm12, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm7 = ymm14[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm7[1],ymm1[2],ymm7[3],ymm1[4,5],ymm7[6],ymm1[7,8],ymm7[9],ymm1[10],ymm7[11],ymm1[12,13],ymm7[14],ymm1[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,30,31,30,31,26,27,28,29,30,31,30,31>
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm2, %ymm15
; AVX2-FAST-NEXT:    vpshufd $251, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm14 = mem[3,2,3,3,7,6,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3,4],ymm15[5,6,7,8],ymm14[9],ymm15[10],ymm14[11,12],ymm15[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,3,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = <u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm1, %ymm14, %ymm1
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm5, %ymm14
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm12 = ymm11[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm12 = ymm14[0],ymm12[1],ymm14[2],ymm12[3],ymm14[4,5],ymm12[6],ymm14[7,8],ymm12[9],ymm14[10],ymm12[11],ymm14[12,13],ymm12[14],ymm14[15]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm2, %ymm14
; AVX2-FAST-NEXT:    vpshufd $251, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm11 = mem[3,2,3,3,7,6,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm11 = ymm14[0],ymm11[1],ymm14[2],ymm11[3,4],ymm14[5,6,7,8],ymm11[9],ymm14[10],ymm11[11,12],ymm14[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,2,3,2]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm12, %ymm11, %ymm11
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm10, %ymm12
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm9[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm12 = ymm12[0],ymm14[1],ymm12[2],ymm14[3],ymm12[4,5],ymm14[6],ymm12[7,8],ymm14[9],ymm12[10],ymm14[11],ymm12[12,13],ymm14[14],ymm12[15]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm2, %ymm14
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm10 = ymm3[3,2,3,3,7,6,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm10 = ymm14[0],ymm10[1],ymm14[2],ymm10[3,4],ymm14[5,6,7,8],ymm10[9],ymm14[10],ymm10[11,12],ymm14[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,2,3,2]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm12, %ymm10, %ymm10
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm12 = ymm13[2,3,2,3,6,7,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm12[1],ymm0[2],ymm12[3],ymm0[4,5],ymm12[6],ymm0[7,8],ymm12[9],ymm0[10],ymm12[11],ymm0[12,13],ymm12[14],ymm0[15]
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm8, %ymm7
; AVX2-FAST-NEXT:    vmovdqa %ymm8, %ymm4
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm12 = ymm6[3,2,3,3,7,6,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0],ymm12[1],ymm7[2],ymm12[3,4],ymm7[5,6,7,8],ymm12[9],ymm7[10],ymm12[11,12],ymm7[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,2,3,2]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm0, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpbroadcastq 24(%r8), %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = [0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq 56(%r8), %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm11, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq 88(%r8), %ymm11
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm10, %ymm11, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq 120(%r8), %ymm11
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm7, %ymm11, %ymm7
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u>
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm11, %ymm0, %ymm12
; AVX2-FAST-NEXT:    vpshufd $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm14 = mem[3,0,3,0,7,4,7,4]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm12 = ymm14[0],ymm12[1],ymm14[2],ymm12[3],ymm14[4,5],ymm12[6],ymm14[7,8],ymm12[9],ymm14[10],ymm12[11],ymm14[12,13],ymm12[14],ymm14[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = <u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u>
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm0, %ymm15
; AVX2-FAST-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm0 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm15[1],ymm0[2,3],ymm15[4],ymm0[5],ymm15[6],ymm0[7,8],ymm15[9],ymm0[10,11],ymm15[12],ymm0[13],ymm15[14],ymm0[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = <255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm12, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm11, %ymm1, %ymm12
; AVX2-FAST-NEXT:    vpshufd $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm1 = mem[3,0,3,0,7,4,7,4]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm12[1],ymm1[2],ymm12[3],ymm1[4,5],ymm12[6],ymm1[7,8],ymm12[9],ymm1[10],ymm12[11],ymm1[12,13],ymm12[14],ymm1[15]
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm5, %ymm12
; AVX2-FAST-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm10 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm10 = ymm10[0],ymm12[1],ymm10[2,3],ymm12[4],ymm10[5],ymm12[6],ymm10[7,8],ymm12[9],ymm10[10,11],ymm12[12],ymm10[13],ymm12[14],ymm10[15]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm1, %ymm10, %ymm1
; AVX2-FAST-NEXT:    vpshufb %ymm11, %ymm2, %ymm8
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm3[3,0,3,0,7,4,7,4]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2],ymm8[3],ymm9[4,5],ymm8[6],ymm9[7,8],ymm8[9],ymm9[10],ymm8[11],ymm9[12,13],ymm8[14],ymm9[15]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm2, %ymm5
; AVX2-FAST-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm6 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2,3],ymm5[4],ymm6[5],ymm5[6],ymm6[7,8],ymm5[9],ymm6[10,11],ymm5[12],ymm6[13],ymm5[14],ymm6[15]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm8, %ymm5, %ymm5
; AVX2-FAST-NEXT:    vpshufb %ymm11, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vpshufd $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm3 = mem[3,0,3,0,7,4,7,4]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[3],ymm3[4,5],ymm4[6],ymm3[7,8],ymm4[9],ymm3[10],ymm4[11],ymm3[12,13],ymm4[14],ymm3[15]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm13[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2,3],ymm2[4],ymm4[5],ymm2[6],ymm4[7,8],ymm2[9],ymm4[10,11],ymm2[12],ymm4[13],ymm2[14],ymm4[15]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm3 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm0, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm3 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm1
; AVX2-FAST-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm3 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm5, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm5 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm2, %ymm5, %ymm2
; AVX2-FAST-NEXT:    vmovdqa %ymm2, 544(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, 384(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, 224(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 64(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm7, 608(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 576(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 448(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 416(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 288(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 256(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX2-FAST-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 512(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 480(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 352(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 320(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FAST-NEXT:    addq $936, %rsp # imm = 0x3A8
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride5_vf64:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $936, %rsp # imm = 0x3A8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rsi), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdi), %xmm13
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm0 = [0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm1[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdx), %xmm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm11[0],xmm6[1],xmm11[1],xmm6[2],xmm11[2],xmm6[3],xmm11[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm4 = [4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm15 = ymm3[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm2, %ymm15, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm14[0],xmm7[0],xmm14[1],xmm7[1],xmm14[2],xmm7[2],xmm14[3],xmm7[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm8, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm14, %xmm14
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm15, %xmm15
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm14, %ymm15, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm13[0],xmm5[0],xmm13[1],xmm5[1],xmm13[2],xmm5[2],xmm13[3],xmm5[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm5, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm13, %xmm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm2, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm0[0],xmm12[0],xmm0[1],xmm12[1],xmm0[2],xmm12[2],xmm0[3],xmm12[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm15, %xmm15
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm13, %ymm15, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rsi), %xmm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdi), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm13[0],xmm2[1],xmm13[1],xmm2[2],xmm13[2],xmm2[3],xmm13[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm2, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdx), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rcx), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm0, %ymm4, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq (%r8), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 32(%r8), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm14, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 64(%r8), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm15, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 96(%r8), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm0, %ymm3, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm0 = <6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13>
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 8(%rdi), %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm4[1],xmm3[2,3],xmm4[4],xmm3[5],xmm4[6],xmm3[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm4 = <10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm6, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm6 = xmm11[1,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0],xmm6[1],xmm5[2],xmm6[3],xmm5[4,5],xmm6[6],xmm5[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,0]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = <255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm3, %ymm5, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 40(%rdi), %xmm11
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0],xmm11[1],xmm5[2,3],xmm11[4],xmm5[5],xmm11[6],xmm5[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm10, %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[1,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm9 = xmm10[0],xmm9[1],xmm10[2],xmm9[3],xmm10[4,5],xmm9[6],xmm10[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm5, %ymm9, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm8, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 72(%rdi), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0],xmm10[1],xmm9[2,3],xmm10[4],xmm9[5],xmm10[6],xmm9[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm7, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm7 = xmm12[1,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm7 = xmm8[0],xmm7[1],xmm8[2],xmm7[3],xmm8[4,5],xmm7[6],xmm8[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm9[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm8, %ymm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 104(%rdi), %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm8[1],xmm0[2,3],xmm8[4],xmm0[5],xmm8[6],xmm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%r8), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[1,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3],xmm1[4,5],xmm2[6],xmm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%r8), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm9[0,1,1,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm3, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm8[0,1,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm5, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm4[0,1,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm7, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm10[0,1,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm12, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm2 = ymm11[1,1,1,2,5,5,5,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm13 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,18,19,u,u,20,21,u,u,24,25,24,25,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm13, %ymm12, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm4[0,1,2,1,4,5,6,5]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3],ymm3[4],ymm2[5,6],ymm3[7],ymm2[8,9],ymm3[10],ymm2[11],ymm3[12],ymm2[13,14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = <255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm2 = ymm3[1,1,1,2,5,5,5,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm13, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm11[0,1,2,1,4,5,6,5]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3],ymm3[4],ymm2[5,6],ymm3[7],ymm2[8,9],ymm3[10],ymm2[11],ymm3[12],ymm2[13,14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdx), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rcx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[1,1,1,2,5,5,5,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdi), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rsi), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm13, %ymm10, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm9[0,1,2,1,4,5,6,5]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3],ymm3[4],ymm2[5,6],ymm3[7],ymm2[8,9],ymm3[10],ymm2[11],ymm3[12],ymm2[13,14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm1, %ymm2, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rcx), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm8, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdx), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm2 = ymm6[1,1,1,2,5,5,5,6]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm0[0],ymm2[1],ymm0[2,3],ymm2[4],ymm0[5],ymm2[6],ymm0[7,8],ymm2[9],ymm0[10,11],ymm2[12],ymm0[13],ymm2[14],ymm0[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rsi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm13, %ymm4, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdi), %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm13[0,1,2,1,4,5,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm15[2],ymm0[3],ymm15[4],ymm0[5,6],ymm15[7],ymm0[8,9],ymm15[10],ymm0[11],ymm15[12],ymm0[13,14],ymm15[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 16(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, (%rsp), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 48(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 80(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm7, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 112(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,26,27,30,31,30,31,28,29,30,31,28,29>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm12, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm7 = ymm14[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm7[1],ymm1[2],ymm7[3],ymm1[4,5],ymm7[6],ymm1[7,8],ymm7[9],ymm1[10],ymm7[11],ymm1[12,13],ymm7[14],ymm1[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,30,31,30,31,26,27,28,29,30,31,30,31>
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm7, %ymm2, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpshufd $251, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm14 = mem[3,2,3,3,7,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3,4],ymm15[5,6,7,8],ymm14[9],ymm15[10],ymm14[11,12],ymm15[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = <u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm1, %ymm14, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm5, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm12 = ymm11[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm12 = ymm14[0],ymm12[1],ymm14[2],ymm12[3],ymm14[4,5],ymm12[6],ymm14[7,8],ymm12[9],ymm14[10],ymm12[11],ymm14[12,13],ymm12[14],ymm14[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm7, %ymm2, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpshufd $251, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm11 = mem[3,2,3,3,7,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm11 = ymm14[0],ymm11[1],ymm14[2],ymm11[3,4],ymm14[5,6,7,8],ymm11[9],ymm14[10],ymm11[11,12],ymm14[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,2,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm12, %ymm11, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm10, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm9[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm12 = ymm12[0],ymm14[1],ymm12[2],ymm14[3],ymm12[4,5],ymm14[6],ymm12[7,8],ymm14[9],ymm12[10],ymm14[11],ymm12[12,13],ymm14[14],ymm12[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm7, %ymm2, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm10 = ymm3[3,2,3,3,7,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm10 = ymm14[0],ymm10[1],ymm14[2],ymm10[3,4],ymm14[5,6,7,8],ymm10[9],ymm14[10],ymm10[11,12],ymm14[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,2,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm12, %ymm10, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm12 = ymm13[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm12[1],ymm0[2],ymm12[3],ymm0[4,5],ymm12[6],ymm0[7,8],ymm12[9],ymm0[10],ymm12[11],ymm0[12,13],ymm12[14],ymm0[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm7, %ymm8, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm8, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm12 = ymm6[3,2,3,3,7,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0],ymm12[1],ymm7[2],ymm12[3,4],ymm7[5,6,7,8],ymm12[9],ymm7[10],ymm12[11,12],ymm7[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,2,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm0, %ymm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 24(%r8), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = [0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 56(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm11, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 88(%r8), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm10, %ymm11, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 120(%r8), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm7, %ymm11, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u>
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm11, %ymm0, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufd $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm14 = mem[3,0,3,0,7,4,7,4]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm12 = ymm14[0],ymm12[1],ymm14[2],ymm12[3],ymm14[4,5],ymm12[6],ymm14[7,8],ymm12[9],ymm14[10],ymm12[11],ymm14[12,13],ymm12[14],ymm14[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm14 = <u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u>
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm14, %ymm0, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm15[1],ymm0[2,3],ymm15[4],ymm0[5],ymm15[6],ymm0[7,8],ymm15[9],ymm0[10,11],ymm15[12],ymm0[13],ymm15[14],ymm0[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = <255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255,255,255,u,u,0,0,0,0,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm12, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm11, %ymm1, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufd $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm1 = mem[3,0,3,0,7,4,7,4]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm12[1],ymm1[2],ymm12[3],ymm1[4,5],ymm12[6],ymm1[7,8],ymm12[9],ymm1[10],ymm12[11],ymm1[12,13],ymm12[14],ymm1[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm14, %ymm5, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm10 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm10 = ymm10[0],ymm12[1],ymm10[2,3],ymm12[4],ymm10[5],ymm12[6],ymm10[7,8],ymm12[9],ymm10[10,11],ymm12[12],ymm10[13],ymm12[14],ymm10[15]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm1, %ymm10, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm11, %ymm2, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm9 = ymm3[3,0,3,0,7,4,7,4]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2],ymm8[3],ymm9[4,5],ymm8[6],ymm9[7,8],ymm8[9],ymm9[10],ymm8[11],ymm9[12,13],ymm8[14],ymm9[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm14, %ymm2, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm6 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2,3],ymm5[4],ymm6[5],ymm5[6],ymm6[7,8],ymm5[9],ymm6[10,11],ymm5[12],ymm6[13],ymm5[14],ymm6[15]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm8, %ymm5, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm11, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufd $51, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm3 = mem[3,0,3,0,7,4,7,4]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[3],ymm3[4,5],ymm4[6],ymm3[7,8],ymm4[9],ymm3[10],ymm4[11],ymm3[12,13],ymm4[14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm14, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm13[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2,3],ymm2[4],ymm4[5],ymm2[6],ymm4[7,8],ymm2[9],ymm4[10,11],ymm2[12],ymm4[13],ymm2[14],ymm4[15]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm3, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm3 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm0, %ymm3, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm3 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm3 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm5, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpermq $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm5 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm2, %ymm5, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, 544(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, 384(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, 224(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 64(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm7, 608(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 576(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 448(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 416(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 288(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 256(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 512(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 480(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 352(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 320(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FAST-PERLANE-NEXT:    addq $936, %rsp # imm = 0x3A8
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride5_vf64:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    subq $616, %rsp # imm = 0x268
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rcx), %ymm0
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u>
; AVX512F-SLOW-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm20
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rdx), %ymm15
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm15[3,0,3,0,7,4,7,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8],ymm0[9],ymm1[10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rcx), %xmm0
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm9 = <10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9>
; AVX512F-SLOW-NEXT:    vpshufb %xmm9, %xmm0, %xmm2
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rdx), %xmm3
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[1,2,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm4[1],xmm2[2],xmm4[3],xmm2[4,5],xmm4[6],xmm2[7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,0]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rsi), %ymm13
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u>
; AVX512F-SLOW-NEXT:    vpshufb %ymm2, %ymm13, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm2, %ymm16
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm7
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm7[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5],ymm1[6],ymm2[7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13],ymm1[14],ymm2[15]
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rsi), %xmm2
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm10 = <6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13>
; AVX512F-SLOW-NEXT:    vpshufb %xmm10, %xmm2, %xmm4
; AVX512F-SLOW-NEXT:    vpbroadcastq 104(%rdi), %xmm5
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0],xmm5[1],xmm4[2,3],xmm5[4],xmm4[5],xmm5[6],xmm4[7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm4, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 96(%r8), %ymm1
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,ymm1[12,13],zero,zero,zero,zero,zero,zero,zero,zero,ymm1[14,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm1[16,17],zero,zero,zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm1[0,1,1,1]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = [65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535]
; AVX512F-SLOW-NEXT:    vpandn %ymm5, %ymm1, %ymm5
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm5, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdx), %ymm27
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rdx), %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm1[3,2,3,3,7,6,7,7]
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rcx), %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm5 = ymm1[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0],ymm4[1],ymm5[2],ymm4[3,4],ymm5[5,6,7,8],ymm4[9],ymm5[10],ymm4[11,12],ymm5[13,14,15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm4[2,2,3,2]
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm1 = [4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX512F-SLOW-NEXT:    vmovdqa %xmm1, %xmm6
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rdi), %ymm28
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm28[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rsi), %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm1[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,3,2,2,6,7,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2],ymm0[3],ymm3[4,5],ymm0[6],ymm3[7,8],ymm0[9],ymm3[10],ymm0[11],ymm3[12,13],ymm0[14],ymm3[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,2]
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rdi), %xmm0
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,5,6]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm0
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rcx), %xmm2
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512F-SLOW-NEXT:    vpshufb %xmm9, %xmm2, %xmm2
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,2,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm2[0],xmm0[1],xmm2[2],xmm0[3],xmm2[4,5],xmm0[6],xmm2[7]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %xmm3
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rsi), %xmm0
; AVX512F-SLOW-NEXT:    vpshufb %xmm10, %xmm0, %xmm2
; AVX512F-SLOW-NEXT:    vpbroadcastq 72(%rdi), %xmm5
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm5[1],xmm2[2,3],xmm5[4],xmm2[5],xmm5[6],xmm2[7]
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm5[0],xmm0[0],xmm5[1],xmm0[1],xmm5[2],xmm0[2],xmm5[3],xmm0[3]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,5,6]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm27[3,2,3,3,7,6,7,7]
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %ymm14
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm5 = ymm14[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm5[0],ymm0[1],ymm5[2],ymm0[3,4],ymm5[5,6,7,8],ymm0[9],ymm5[10],ymm0[11,12],ymm5[13,14,15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,3,2]
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpshufb %xmm10, %xmm3, %xmm0
; AVX512F-SLOW-NEXT:    vpbroadcastq 8(%rdi), %xmm5
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm5[1],xmm0[2,3],xmm5[4],xmm0[5],xmm5[6],xmm0[7]
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %xmm5
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3]
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm5
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,2,1,3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,5,6]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm11
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm5[0],xmm11[0],xmm5[1],xmm11[1],xmm5[2],xmm11[2],xmm5[3],xmm11[3]
; AVX512F-SLOW-NEXT:    vmovdqa %xmm6, %xmm1
; AVX512F-SLOW-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm30 = ymm0[0,1,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %ymm6
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm6[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,3,2,2,6,7,6,6]
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdi), %ymm21
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm21[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm3[0],ymm8[1],ymm3[2],ymm8[3],ymm3[4,5],ymm8[6],ymm3[7,8],ymm8[9],ymm3[10],ymm8[11],ymm3[12,13],ymm8[14],ymm3[15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm0, %ymm17
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rcx), %ymm3
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm20, %ymm0
; AVX512F-SLOW-NEXT:    vpshufb %ymm0, %ymm3, %ymm8
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm2[3,0,3,0,7,4,7,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm12[0],ymm8[1],ymm12[2],ymm8[3],ymm12[4,5],ymm8[6],ymm12[7,8],ymm8[9],ymm12[10],ymm8[11],ymm12[12,13],ymm8[14],ymm12[15]
; AVX512F-SLOW-NEXT:    vpshufb %xmm9, %xmm5, %xmm5
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[1,2,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0],xmm11[1],xmm5[2],xmm11[3],xmm5[4,5],xmm11[6],xmm5[7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,0]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm8, %zmm5, %zmm31
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm5
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm16, %ymm8
; AVX512F-SLOW-NEXT:    vpshufb %ymm8, %ymm5, %ymm8
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm0[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm11[0],ymm8[1],ymm11[2,3],ymm8[4],ymm11[5],ymm8[6],ymm11[7,8],ymm8[9],ymm11[10,11],ymm8[12],ymm11[13],ymm8[14],ymm11[15]
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm12
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm12, %xmm18
; AVX512F-SLOW-NEXT:    vpshufb %xmm10, %xmm11, %xmm10
; AVX512F-SLOW-NEXT:    vpbroadcastq 40(%rdi), %xmm11
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0],xmm11[1],xmm10[2,3],xmm11[4],xmm10[5],xmm11[6],xmm10[7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,1,0,1]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm8, %zmm10, %zmm29
; AVX512F-SLOW-NEXT:    vmovdqa 32(%r8), %ymm8
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm8[0,1,1,1]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535]
; AVX512F-SLOW-NEXT:    vpandn %ymm10, %ymm11, %ymm10
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [128,128,128,128,12,13,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128]
; AVX512F-SLOW-NEXT:    vpshufb %ymm12, %ymm8, %ymm8
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm8, %zmm10, %zmm10
; AVX512F-SLOW-NEXT:    vpshufb %xmm1, %xmm4, %xmm4
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm4, %ymm22
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %xmm4
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %xmm8
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3]
; AVX512F-SLOW-NEXT:    vpshufb %xmm1, %xmm11, %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm26
; AVX512F-SLOW-NEXT:    vpshufb %xmm9, %xmm4, %xmm4
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[1,2,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm4[0],xmm8[1],xmm4[2],xmm8[3],xmm4[4,5],xmm8[6],xmm4[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm25
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm7[0,1,2,1,4,5,6,5]
; AVX512F-SLOW-NEXT:    vprolq $16, %ymm13, %ymm8
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm8[0,1],ymm4[2],ymm8[3],ymm4[4],ymm8[5,6],ymm4[7],ymm8[8,9],ymm4[10],ymm8[11],ymm4[12],ymm8[13,14],ymm4[15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm23
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm13[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,3,2,2,6,7,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm4[0],ymm7[1],ymm4[2],ymm7[3],ymm4[4,5],ymm7[6],ymm4[7,8],ymm7[9],ymm4[10],ymm7[11],ymm4[12,13],ymm7[14],ymm4[15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm24
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25>
; AVX512F-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX512F-SLOW-NEXT:    vpshufb %ymm4, %ymm9, %ymm7
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm15[1,1,1,2,5,5,5,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm7[0],ymm8[1],ymm7[2,3],ymm8[4],ymm7[5],ymm8[6],ymm7[7,8],ymm8[9],ymm7[10,11],ymm8[12],ymm7[13],ymm8[14],ymm7[15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm19
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm7 = ymm9[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = ymm15[3,2,3,3,7,6,7,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm15 = ymm7[0],ymm13[1],ymm7[2],ymm13[3,4],ymm7[5,6,7,8],ymm13[9],ymm7[10],ymm13[11,12],ymm7[13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm0[0,1,2,1,4,5,6,5]
; AVX512F-SLOW-NEXT:    vprolq $16, %ymm5, %ymm13
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm13[0,1],ymm7[2],ymm13[3],ymm7[4],ymm13[5,6],ymm7[7],ymm13[8,9],ymm7[10],ymm13[11],ymm7[12],ymm13[13,14],ymm7[15]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm5 = ymm5[0,1,2,3,7,6,5,7,8,9,10,11,15,14,13,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[2,3,2,2,6,7,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm13 = ymm5[0],ymm0[1],ymm5[2],ymm0[3],ymm5[4,5],ymm0[6],ymm5[7,8],ymm0[9],ymm5[10],ymm0[11],ymm5[12,13],ymm0[14],ymm5[15]
; AVX512F-SLOW-NEXT:    vpshufb %ymm4, %ymm3, %ymm0
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[1,1,1,2,5,5,5,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm0[0],ymm5[1],ymm0[2,3],ymm5[4],ymm0[5],ymm5[6],ymm0[7,8],ymm5[9],ymm0[10,11],ymm5[12],ymm0[13],ymm5[14],ymm0[15]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm3[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,2,3,6,7,6,7]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm2[3,2,3,3,7,6,7,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm0[0],ymm1[1],ymm0[2],ymm1[3,4],ymm0[5,6,7,8],ymm1[9],ymm0[10],ymm1[11,12],ymm0[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm16, %ymm9
; AVX512F-SLOW-NEXT:    vpshufb %ymm9, %ymm6, %ymm0
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm21[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5],ymm0[6],ymm1[7,8],ymm0[9],ymm1[10,11],ymm0[12],ymm1[13],ymm0[14],ymm1[15]
; AVX512F-SLOW-NEXT:    vprolq $16, %ymm6, %ymm1
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm21[0,1,2,1,4,5,6,5]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3],ymm2[4],ymm1[5,6],ymm2[7],ymm1[8,9],ymm2[10],ymm1[11],ymm2[12],ymm1[13,14],ymm2[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm16
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm20, %ymm8
; AVX512F-SLOW-NEXT:    vpshufb %ymm8, %ymm14, %ymm0
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm27[3,0,3,0,7,4,7,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8],ymm0[9],ymm1[10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX512F-SLOW-NEXT:    vpshufb %ymm4, %ymm14, %ymm1
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm27[1,1,1,2,5,5,5,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5],ymm2[6],ymm1[7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13],ymm2[14],ymm1[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm2
; AVX512F-SLOW-NEXT:    vpbroadcastq 16(%r8), %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = [65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpandn %ymm0, %ymm1, %ymm6
; AVX512F-SLOW-NEXT:    vmovdqa (%r8), %ymm0
; AVX512F-SLOW-NEXT:    vpshufb %ymm12, %ymm0, %ymm14
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm12, %ymm27
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm6, %zmm14, %zmm6
; AVX512F-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX512F-SLOW-NEXT:    vpshufb %ymm9, %ymm11, %ymm14
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm28[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm12[0],ymm14[1],ymm12[2,3],ymm14[4],ymm12[5],ymm14[6],ymm12[7,8],ymm14[9],ymm12[10,11],ymm14[12],ymm12[13],ymm14[14],ymm12[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm17[2,3,2,2]
; AVX512F-SLOW-NEXT:    vprolq $16, %ymm11, %ymm14
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm28[0,1,2,1,4,5,6,5]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm14[0,1],ymm11[2],ymm14[3],ymm11[4],ymm14[5,6],ymm11[7],ymm14[8,9],ymm11[10],ymm14[11],ymm11[12],ymm14[13,14],ymm11[15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm11, %zmm12, %zmm21
; AVX512F-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX512F-SLOW-NEXT:    vpshufb %ymm8, %ymm11, %ymm12
; AVX512F-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm8[3,0,3,0,7,4,7,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm14[0],ymm12[1],ymm14[2],ymm12[3],ymm14[4,5],ymm12[6],ymm14[7,8],ymm12[9],ymm14[10],ymm12[11],ymm14[12,13],ymm12[14],ymm14[15]
; AVX512F-SLOW-NEXT:    vpshufb %ymm4, %ymm11, %ymm4
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm18[0,2,1,3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm14 = xmm14[0,1,2,3,4,4,5,6]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,1,0,1]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[1,1,1,2,5,5,5,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm8[1],ymm4[2,3],ymm8[4],ymm4[5],ymm8[6],ymm4[7,8],ymm8[9],ymm4[10,11],ymm8[12],ymm4[13],ymm8[14],ymm4[15]
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm8 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, (%rsp), %zmm11, %zmm17 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm18 = [65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm8, %zmm18, %zmm17
; AVX512F-SLOW-NEXT:    vpbroadcastq 88(%r8), %ymm8
; AVX512F-SLOW-NEXT:    vpbroadcastq 96(%r8), %ymm20
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm20, %zmm8, %zmm8
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm17, %zmm20, %zmm8
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm30, %zmm11, %zmm17
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm14, %zmm9, %zmm9
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm17, %zmm18, %zmm9
; AVX512F-SLOW-NEXT:    vpbroadcastq 24(%r8), %ymm14
; AVX512F-SLOW-NEXT:    vpbroadcastq 32(%r8), %ymm17
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm17, %zmm14, %zmm14
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm9, %zmm20, %zmm14
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm22[0,1,0,1]
; AVX512F-SLOW-NEXT:    vpermq $4, {{[-0-9]+}}(%r{{[sb]}}p), %ymm17 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm17 = mem[0,1,0,0]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm12, %zmm4
; AVX512F-SLOW-NEXT:    vpbroadcastq 80(%r8), %ymm12
; AVX512F-SLOW-NEXT:    vpandn %ymm12, %ymm1, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa 64(%r8), %ymm12
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm27, %ymm11
; AVX512F-SLOW-NEXT:    vpshufb %ymm11, %ymm12, %ymm11
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,1,1]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm20 = ymm26[0,1,0,1]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm22 = ymm25[0,1,0,0]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,1,1]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm23 = ymm23[2,3,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm24 = ymm24[2,3,2,2]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm25 = ymm19[2,3,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,2,3,2]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,3,2,2]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,3,2]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm11, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0]
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogq $226, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm19 # 64-byte Folded Reload
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm31, %zmm11, %zmm29
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogq $248, %zmm11, %zmm19, %zmm26
; AVX512F-SLOW-NEXT:    vpternlogq $248, %zmm11, %zmm29, %zmm10
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm17, %zmm9, %zmm9
; AVX512F-SLOW-NEXT:    vpermq $68, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Folded Reload
; AVX512F-SLOW-NEXT:    # zmm11 = mem[0,1,0,1,4,5,4,5]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm9, %zmm17, %zmm11
; AVX512F-SLOW-NEXT:    vpbroadcastq 64(%r8), %ymm9
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm12, %zmm9, %zmm9
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm11, %zmm12, %zmm9
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm22, %zmm20, %zmm11
; AVX512F-SLOW-NEXT:    vpermq $68, {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Folded Reload
; AVX512F-SLOW-NEXT:    # zmm19 = mem[0,1,0,1,4,5,4,5]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm11, %zmm17, %zmm19
; AVX512F-SLOW-NEXT:    vpbroadcastq (%r8), %ymm11
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm11, %zmm0
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm19, %zmm12, %zmm0
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm24, %zmm23, %zmm11
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm15, %zmm25, %zmm12
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm11, %zmm17, %zmm12
; AVX512F-SLOW-NEXT:    vpbroadcastq 112(%r8), %ymm11
; AVX512F-SLOW-NEXT:    vpbroadcastq 120(%r8), %ymm15
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm15, %zmm11, %zmm11
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm15 = [65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0]
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm12, %zmm15, %zmm11
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm13, %zmm7, %zmm7
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm5, %zmm3
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm7, %zmm17, %zmm3
; AVX512F-SLOW-NEXT:    vpbroadcastq 48(%r8), %ymm5
; AVX512F-SLOW-NEXT:    vpbroadcastq 56(%r8), %ymm7
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm7, %zmm5, %zmm5
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm3, %zmm15, %zmm5
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm16, %zmm18, %zmm2
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm21, %zmm18, %zmm4
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $248, %zmm3, %zmm2, %zmm6
; AVX512F-SLOW-NEXT:    vpternlogq $248, %zmm3, %zmm4, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm1, 384(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm6, 64(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm5, 256(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm11, 576(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm10, 192(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm14, 128(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm9, 320(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm8, 448(%r9)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm26, 512(%r9)
; AVX512F-SLOW-NEXT:    addq $616, %rsp # imm = 0x268
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride5_vf64:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    subq $488, %rsp # imm = 0x1E8
; AVX512F-FAST-NEXT:    vmovdqa 96(%rcx), %ymm0
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u>
; AVX512F-FAST-NEXT:    vpshufb %ymm2, %ymm0, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa %ymm2, %ymm7
; AVX512F-FAST-NEXT:    vmovdqa64 96(%rdx), %ymm20
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm20[3,0,3,0,7,4,7,4]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4,5],ymm1[6],ymm2[7,8],ymm1[9],ymm2[10],ymm1[11],ymm2[12,13],ymm1[14],ymm2[15]
; AVX512F-FAST-NEXT:    vmovdqa 96(%rcx), %xmm9
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm6 = <10,11,u,u,6,7,u,u,8,9,8,9,u,u,8,9>
; AVX512F-FAST-NEXT:    vpshufb %xmm6, %xmm9, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa 96(%rdx), %xmm15
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm15[1,2,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1],xmm2[2],xmm3[3],xmm2[4,5],xmm3[6],xmm2[7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,0]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 96(%rsi), %ymm8
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u>
; AVX512F-FAST-NEXT:    vpshufb %ymm2, %ymm8, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa %ymm2, %ymm11
; AVX512F-FAST-NEXT:    vmovdqa64 96(%rdi), %ymm23
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm23[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5],ymm1[6],ymm2[7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13],ymm1[14],ymm2[15]
; AVX512F-FAST-NEXT:    vmovdqa 96(%rsi), %xmm4
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm3 = <6,7,u,u,10,11,6,7,u,u,8,9,u,u,12,13>
; AVX512F-FAST-NEXT:    vpshufb %xmm3, %xmm4, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm4, %xmm31
; AVX512F-FAST-NEXT:    vpbroadcastq 104(%rdi), %xmm4
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm4[1],xmm2[2,3],xmm4[4],xmm2[5],xmm4[6],xmm2[7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm16
; AVX512F-FAST-NEXT:    vmovdqa 96(%r8), %ymm1
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [128,128,128,128,12,13,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128]
; AVX512F-FAST-NEXT:    vpshufb %ymm4, %ymm1, %ymm2
; AVX512F-FAST-NEXT:    vmovdqa %ymm4, %ymm14
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,1,1]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = [65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535]
; AVX512F-FAST-NEXT:    vpandn %ymm1, %ymm13, %ymm1
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm1
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 64(%rdx), %xmm1
; AVX512F-FAST-NEXT:    vmovdqa 64(%rcx), %xmm2
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm12 = [4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX512F-FAST-NEXT:    vpshufb %xmm12, %xmm4, %xmm4
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %xmm6, %xmm2, %xmm2
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,2,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0],xmm1[1],xmm2[2],xmm1[3],xmm2[4,5],xmm1[6],xmm2[7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,0]
; AVX512F-FAST-NEXT:    vmovdqu %ymm1, (%rsp) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512F-FAST-NEXT:    vmovdqa 64(%rsi), %xmm2
; AVX512F-FAST-NEXT:    vpshufb %xmm3, %xmm2, %xmm4
; AVX512F-FAST-NEXT:    vpbroadcastq 72(%rdi), %xmm5
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0],xmm5[1],xmm4[2,3],xmm5[4],xmm4[5],xmm5[6],xmm4[7]
; AVX512F-FAST-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX512F-FAST-NEXT:    vpshufb %xmm5, %xmm2, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa %xmm5, %xmm10
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm2
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 32(%rcx), %ymm2
; AVX512F-FAST-NEXT:    vpshufb %ymm7, %ymm2, %ymm4
; AVX512F-FAST-NEXT:    vmovdqa64 32(%rdx), %ymm27
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm27[3,0,3,0,7,4,7,4]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm5[0],ymm4[1],ymm5[2],ymm4[3],ymm5[4,5],ymm4[6],ymm5[7,8],ymm4[9],ymm5[10],ymm4[11],ymm5[12,13],ymm4[14],ymm5[15]
; AVX512F-FAST-NEXT:    vpshufb %xmm3, %xmm1, %xmm4
; AVX512F-FAST-NEXT:    vpbroadcastq 8(%rdi), %xmm5
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0],xmm5[1],xmm4[2,3],xmm5[4],xmm4[5],xmm5[6],xmm4[7]
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %xmm5
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm10, %xmm1, %xmm1
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm1
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 32(%rcx), %xmm10
; AVX512F-FAST-NEXT:    vpshufb %xmm6, %xmm10, %xmm1
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdx), %xmm5
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm5[1,2,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm4[1],xmm1[2],xmm4[3],xmm1[4,5],xmm4[6],xmm1[7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,0]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm7, %zmm1, %zmm1
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 32(%rsi), %ymm7
; AVX512F-FAST-NEXT:    vmovdqa64 32(%rdi), %ymm30
; AVX512F-FAST-NEXT:    vpshufb %ymm11, %ymm7, %ymm1
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm30[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm4[0],ymm1[1],ymm4[2,3],ymm1[4],ymm4[5],ymm1[6],ymm4[7,8],ymm1[9],ymm4[10,11],ymm1[12],ymm4[13],ymm1[14],ymm4[15]
; AVX512F-FAST-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX512F-FAST-NEXT:    vpshufb %xmm3, %xmm11, %xmm3
; AVX512F-FAST-NEXT:    vpbroadcastq 40(%rdi), %xmm4
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm4[1],xmm3[2,3],xmm4[4],xmm3[5],xmm4[6],xmm3[7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm18
; AVX512F-FAST-NEXT:    vmovdqa 32(%r8), %ymm1
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm1[0,1,1,1]
; AVX512F-FAST-NEXT:    vpshufb %ymm14, %ymm1, %ymm1
; AVX512F-FAST-NEXT:    vpandn %ymm3, %ymm13, %ymm3
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm29
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm12, %xmm4, %xmm4
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %xmm6, %xmm3, %xmm3
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,2,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm3[0],xmm1[1],xmm3[2],xmm1[3],xmm3[4,5],xmm1[6],xmm3[7]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm1, %ymm17
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm23[0,1,2,1,4,5,6,5]
; AVX512F-FAST-NEXT:    vprolq $16, %ymm8, %ymm3
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm3[0,1],ymm1[2],ymm3[3],ymm1[4],ymm3[5,6],ymm1[7],ymm3[8,9],ymm1[10],ymm3[11],ymm1[12],ymm3[13,14],ymm1[15]
; AVX512F-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,26,27,30,31,30,31,28,29,30,31,28,29>
; AVX512F-FAST-NEXT:    vpshufb %ymm14, %ymm8, %ymm1
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm23[2,3,2,3,6,7,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2],ymm3[3],ymm1[4,5],ymm3[6],ymm1[7,8],ymm3[9],ymm1[10],ymm3[11],ymm1[12,13],ymm3[14],ymm1[15]
; AVX512F-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,22,23,u,u,20,21,u,u,24,25>
; AVX512F-FAST-NEXT:    vpshufb %ymm13, %ymm0, %ymm1
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm20[1,1,1,2,5,5,5,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3],ymm3[4],ymm1[5],ymm3[6],ymm1[7,8],ymm3[9],ymm1[10,11],ymm3[12],ymm1[13],ymm3[14],ymm1[15]
; AVX512F-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,30,31,30,31,26,27,28,29,30,31,30,31>
; AVX512F-FAST-NEXT:    vpshufb %ymm6, %ymm0, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm20[3,2,3,3,7,6,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3,4],ymm0[5,6,7,8],ymm1[9],ymm0[10],ymm1[11,12],ymm0[13,14,15]
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 64(%rdx), %ymm20
; AVX512F-FAST-NEXT:    vmovdqa 64(%rcx), %ymm12
; AVX512F-FAST-NEXT:    vpshufb %ymm6, %ymm12, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm20[3,2,3,3,7,6,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3,4],ymm0[5,6,7,8],ymm1[9],ymm0[10],ymm1[11,12],ymm0[13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm0, %ymm26
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm9[0],xmm15[0],xmm9[1],xmm15[1],xmm9[2],xmm15[2],xmm9[3],xmm15[3]
; AVX512F-FAST-NEXT:    vmovdqa 64(%rdi), %ymm15
; AVX512F-FAST-NEXT:    vmovdqa 64(%rsi), %ymm9
; AVX512F-FAST-NEXT:    vpshufb %ymm14, %ymm9, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm15[2,3,2,3,6,7,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7,8],ymm1[9],ymm0[10],ymm1[11],ymm0[12,13],ymm1[14],ymm0[15]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm0, %ymm28
; AVX512F-FAST-NEXT:    vmovdqa 96(%rdi), %xmm0
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm31, %xmm1
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm30[0,1,2,1,4,5,6,5]
; AVX512F-FAST-NEXT:    vprolq $16, %ymm7, %ymm8
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm8[0,1],ymm0[2],ymm8[3],ymm0[4],ymm8[5,6],ymm0[7],ymm8[8,9],ymm0[10],ymm8[11],ymm0[12],ymm8[13,14],ymm0[15]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm0, %ymm25
; AVX512F-FAST-NEXT:    vpshufb %ymm14, %ymm7, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm7 = ymm30[2,3,2,3,6,7,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm7[1],ymm0[2],ymm7[3],ymm0[4,5],ymm7[6],ymm0[7,8],ymm7[9],ymm0[10],ymm7[11],ymm0[12,13],ymm7[14],ymm0[15]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm0, %ymm24
; AVX512F-FAST-NEXT:    vpshufb %ymm13, %ymm2, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm7 = ymm27[1,1,1,2,5,5,5,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm7[1],ymm0[2,3],ymm7[4],ymm0[5],ymm7[6],ymm0[7,8],ymm7[9],ymm0[10,11],ymm7[12],ymm0[13],ymm7[14],ymm0[15]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm0, %ymm22
; AVX512F-FAST-NEXT:    vpshufb %ymm6, %ymm2, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm27[3,2,3,3,7,6,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm8 = ymm0[0],ymm2[1],ymm0[2],ymm2[3,4],ymm0[5,6,7,8],ymm2[9],ymm0[10],ymm2[11,12],ymm0[13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %ymm0
; AVX512F-FAST-NEXT:    vpshufb %ymm6, %ymm0, %ymm2
; AVX512F-FAST-NEXT:    vmovdqa64 (%rdx), %ymm27
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm6 = ymm27[3,2,3,3,7,6,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm6[1],ymm2[2],ymm6[3,4],ymm2[5,6,7,8],ymm6[9],ymm2[10],ymm6[11,12],ymm2[13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm2, %ymm21
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm10[0],xmm5[0],xmm10[1],xmm5[1],xmm10[2],xmm5[2],xmm10[3],xmm5[3]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm2 = [4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX512F-FAST-NEXT:    vpshufb %xmm2, %xmm4, %xmm7
; AVX512F-FAST-NEXT:    vpshufb %xmm2, %xmm5, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm2, %ymm19
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %ymm5
; AVX512F-FAST-NEXT:    vpshufb %ymm14, %ymm5, %ymm4
; AVX512F-FAST-NEXT:    vmovdqa64 (%rdi), %ymm23
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm10 = ymm23[2,3,2,3,6,7,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm14 = ymm4[0],ymm10[1],ymm4[2],ymm10[3],ymm4[4,5],ymm10[6],ymm4[7,8],ymm10[9],ymm4[10],ymm10[11],ymm4[12,13],ymm10[14],ymm4[15]
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdi), %xmm4
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm4[0],xmm11[0],xmm4[1],xmm11[1],xmm4[2],xmm11[2],xmm4[3],xmm11[3]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX512F-FAST-NEXT:    vpshufb %xmm2, %xmm1, %xmm6
; AVX512F-FAST-NEXT:    vpshufb %xmm2, %xmm10, %xmm10
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,0,1,u,u,u,u,14,15,u,u,2,3,u,u,u,u,16,17,u,u,u,u,30,31,u,u,18,19,u,u>
; AVX512F-FAST-NEXT:    vpshufb %ymm3, %ymm5, %ymm1
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm23[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm11[0],ymm1[1],ymm11[2,3],ymm1[4],ymm11[5],ymm1[6],ymm11[7,8],ymm1[9],ymm11[10,11],ymm1[12],ymm11[13],ymm1[14],ymm11[15]
; AVX512F-FAST-NEXT:    vprolq $16, %ymm5, %ymm5
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm11 = ymm23[0,1,2,1,4,5,6,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1],ymm11[2],ymm5[3],ymm11[4],ymm5[5,6],ymm11[7],ymm5[8,9],ymm11[10],ymm5[11],ymm11[12],ymm5[13,14],ymm11[15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm1, %zmm23
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u>
; AVX512F-FAST-NEXT:    vpshufb %ymm2, %ymm0, %ymm1
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm27[3,0,3,0,7,4,7,4]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm5[0],ymm1[1],ymm5[2],ymm1[3],ymm5[4,5],ymm1[6],ymm5[7,8],ymm1[9],ymm5[10],ymm1[11],ymm5[12,13],ymm1[14],ymm5[15]
; AVX512F-FAST-NEXT:    vpshufb %ymm13, %ymm0, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm27[1,1,1,2,5,5,5,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2,3],ymm5[4],ymm0[5],ymm5[6],ymm0[7,8],ymm5[9],ymm0[10,11],ymm5[12],ymm0[13],ymm5[14],ymm0[15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm27
; AVX512F-FAST-NEXT:    vpbroadcastq 16(%r8), %ymm0
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm31 = [65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpandnq %ymm0, %ymm31, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa (%r8), %ymm5
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [128,128,128,128,12,13,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128]
; AVX512F-FAST-NEXT:    vpshufb %ymm1, %ymm5, %ymm11
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm11, %zmm30
; AVX512F-FAST-NEXT:    vpshufb %ymm3, %ymm9, %ymm0
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm15[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm11[0],ymm0[1],ymm11[2,3],ymm0[4],ymm11[5],ymm0[6],ymm11[7,8],ymm0[9],ymm11[10,11],ymm0[12],ymm11[13],ymm0[14],ymm11[15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm17[0,1,0,0]
; AVX512F-FAST-NEXT:    vprolq $16, %ymm9, %ymm9
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm15 = ymm15[0,1,2,1,4,5,6,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm9 = ymm9[0,1],ymm15[2],ymm9[3],ymm15[4],ymm9[5,6],ymm15[7],ymm9[8,9],ymm15[10],ymm9[11],ymm15[12],ymm9[13,14],ymm15[15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,3,2,3]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm9, %zmm0, %zmm0
; AVX512F-FAST-NEXT:    vpshufb %ymm2, %ymm12, %ymm9
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm15 = ymm20[3,0,3,0,7,4,7,4]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm9 = ymm15[0],ymm9[1],ymm15[2],ymm9[3],ymm15[4,5],ymm9[6],ymm15[7,8],ymm9[9],ymm15[10],ymm9[11],ymm15[12,13],ymm9[14],ymm15[15]
; AVX512F-FAST-NEXT:    vpshufb %ymm13, %ymm12, %ymm3
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,1,1]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm15 = ymm20[1,1,1,2,5,5,5,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm15[1],ymm3[2,3],ymm15[4],ymm3[5],ymm15[6],ymm3[7,8],ymm15[9],ymm3[10,11],ymm15[12],ymm3[13],ymm15[14],ymm3[15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm9, %zmm3
; AVX512F-FAST-NEXT:    vmovdqa 64(%r8), %ymm9
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm15 = ymm9[0,1,1,1]
; AVX512F-FAST-NEXT:    vpshufb %ymm1, %ymm9, %ymm9
; AVX512F-FAST-NEXT:    vpbroadcastq 80(%r8), %ymm20
; AVX512F-FAST-NEXT:    vpandnq %ymm20, %ymm31, %ymm1
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm9, %zmm1
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0]
; AVX512F-FAST-NEXT:    vpternlogq $226, {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm16 # 64-byte Folded Reload
; AVX512F-FAST-NEXT:    vpternlogq $226, {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm18 # 64-byte Folded Reload
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535]
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512F-FAST-NEXT:    vpternlogq $248, %zmm9, %zmm16, %zmm20
; AVX512F-FAST-NEXT:    vpternlogq $248, %zmm9, %zmm18, %zmm29
; AVX512F-FAST-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    # ymm9 = mem[2,3,2,3]
; AVX512F-FAST-NEXT:    vpermq $174, {{[-0-9]+}}(%r{{[sb]}}p), %ymm16 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    # ymm16 = mem[2,3,2,2]
; AVX512F-FAST-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %ymm17 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    # ymm17 = mem[2,3,2,3]
; AVX512F-FAST-NEXT:    vpermq $186, {{[-0-9]+}}(%r{{[sb]}}p), %ymm18 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    # ymm18 = mem[2,2,3,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm26 = ymm26[2,2,3,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm7[0,1,0,1]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm28 = ymm28[2,3,2,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm6[0,1,0,1]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm31 = ymm25[2,3,2,3]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm24[2,3,2,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm22[2,3,2,3]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,2,3,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm21[2,2,3,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm19[0,1,0,1]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,3,2,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,1,0,1]
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512F-FAST-NEXT:    vinserti64x4 $1, (%rsp), %zmm19, %zmm19 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    vpermq $68, {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Folded Reload
; AVX512F-FAST-NEXT:    # zmm21 = mem[0,1,0,1,4,5,4,5]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm19, %zmm22, %zmm21
; AVX512F-FAST-NEXT:    vpbroadcastq 64(%r8), %ymm19
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm19, %zmm15
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm19 = [65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $184, %zmm21, %zmm19, %zmm15
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm11, %zmm21, %zmm11
; AVX512F-FAST-NEXT:    vpermq $68, {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Folded Reload
; AVX512F-FAST-NEXT:    # zmm21 = mem[0,1,0,1,4,5,4,5]
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm11, %zmm22, %zmm21
; AVX512F-FAST-NEXT:    vpbroadcastq (%r8), %ymm11
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm11, %zmm5
; AVX512F-FAST-NEXT:    vpternlogq $184, %zmm21, %zmm19, %zmm5
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm16, %zmm9, %zmm9
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm18, %zmm17, %zmm11
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm9, %zmm22, %zmm11
; AVX512F-FAST-NEXT:    vpbroadcastq 112(%r8), %ymm9
; AVX512F-FAST-NEXT:    vpbroadcastq 120(%r8), %ymm16
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm16, %zmm9, %zmm9
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm16 = [65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0]
; AVX512F-FAST-NEXT:    vpternlogq $184, %zmm11, %zmm16, %zmm9
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm26, %zmm2
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm28, %zmm4
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535,65535,0,0,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm2, %zmm11, %zmm4
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm13, %zmm31, %zmm2
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm8, %zmm12, %zmm8
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm2, %zmm22, %zmm8
; AVX512F-FAST-NEXT:    vpbroadcastq 48(%r8), %ymm2
; AVX512F-FAST-NEXT:    vpbroadcastq 56(%r8), %ymm12
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm12, %zmm2, %zmm2
; AVX512F-FAST-NEXT:    vpternlogq $184, %zmm8, %zmm16, %zmm2
; AVX512F-FAST-NEXT:    vpbroadcastq 88(%r8), %ymm8
; AVX512F-FAST-NEXT:    vpbroadcastq 96(%r8), %ymm12
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm12, %zmm8, %zmm8
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535]
; AVX512F-FAST-NEXT:    vpternlogq $184, %zmm4, %zmm12, %zmm8
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm6, %zmm7, %zmm4
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm10, %zmm14, %zmm6
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm4, %zmm11, %zmm6
; AVX512F-FAST-NEXT:    vpbroadcastq 24(%r8), %ymm4
; AVX512F-FAST-NEXT:    vpbroadcastq 32(%r8), %ymm7
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm7, %zmm4, %zmm4
; AVX512F-FAST-NEXT:    vpternlogq $184, %zmm6, %zmm12, %zmm4
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm23, %zmm11, %zmm27
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm0, %zmm11, %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $248, %zmm0, %zmm27, %zmm30
; AVX512F-FAST-NEXT:    vpternlogq $248, %zmm0, %zmm3, %zmm1
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm1, 384(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm30, 64(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, 128(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm2, 256(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm8, 448(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm9, 576(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm5, (%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm29, 192(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm15, 320(%r9)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm20, 512(%r9)
; AVX512F-FAST-NEXT:    addq $488, %rsp # imm = 0x1E8
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride5_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm15
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm13
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm16 = <u,u,0,32,u,u,u,1,33,u,u,u,2,34,u,u,u,3,35,u,u,u,4,36,u,u,u,5,37,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512BW-NEXT:    vpermt2w %zmm6, %zmm16, %zmm7
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = <0,32,u,u,u,1,33,u,u,u,2,34,u,u,u,3,35,u,u,u,4,36,u,u,u,5,37,u,u,u,6,38>
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512BW-NEXT:    vpermt2w %zmm4, %zmm17, %zmm3
; AVX512BW-NEXT:    movl $415641996, %eax # imm = 0x18C6318C
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm7, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm18 = [0,1,2,3,32,5,6,7,8,33,10,11,12,13,34,15,16,17,18,35,20,21,22,23,36,25,26,27,28,37,30,31]
; AVX512BW-NEXT:    vpermt2w %zmm5, %zmm18, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm19 = <u,u,26,58,u,u,u,27,59,u,u,u,28,60,u,u,u,29,61,u,u,u,30,62,u,u,u,31,63,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512BW-NEXT:    vpermt2w %zmm11, %zmm19, %zmm9
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <25,u,u,u,58,26,u,u,u,59,27,u,u,u,60,28,u,u,u,61,29,u,u,u,62,30,u,u,u,63,31,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512BW-NEXT:    vpermt2w %zmm12, %zmm8, %zmm7
; AVX512BW-NEXT:    vmovdqu16 %zmm9, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [0,57,2,3,4,5,58,7,8,9,10,59,12,13,14,15,60,17,18,19,20,61,22,23,24,25,62,27,28,29,30,63]
; AVX512BW-NEXT:    vpermt2w %zmm13, %zmm20, %zmm7
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm21 = <u,19,51,u,u,u,20,52,u,u,u,21,53,u,u,u,22,54,u,u,u,23,55,u,u,u,24,56,u,u,u,25>
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm14
; AVX512BW-NEXT:    vpermt2w %zmm15, %zmm21, %zmm14
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <19,u,u,u,52,20,u,u,u,53,21,u,u,u,54,22,u,u,u,55,23,u,u,u,56,24,u,u,u,57,25,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm9
; AVX512BW-NEXT:    vpermt2w %zmm0, %zmm10, %zmm9
; AVX512BW-NEXT:    movl $-1939662650, %eax # imm = 0x8C6318C6
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vmovdqu16 %zmm14, %zmm9 {%k3}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [0,1,2,51,4,5,6,7,52,9,10,11,12,53,14,15,16,17,54,19,20,21,22,55,24,25,26,27,56,29,30,31]
; AVX512BW-NEXT:    vpermt2w %zmm13, %zmm22, %zmm9
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm23 = <u,u,u,13,45,u,u,u,14,46,u,u,u,15,47,u,u,u,16,48,u,u,u,17,49,u,u,u,18,50,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm24
; AVX512BW-NEXT:    vpermt2w %zmm15, %zmm23, %zmm24
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm25 = <u,13,45,u,u,u,14,46,u,u,u,15,47,u,u,u,16,48,u,u,u,17,49,u,u,u,18,50,u,u,u,19>
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512BW-NEXT:    vpermt2w %zmm11, %zmm25, %zmm14
; AVX512BW-NEXT:    movl $831283992, %eax # imm = 0x318C6318
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu16 %zmm24, %zmm14 {%k2}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm24 = [44,1,2,3,4,45,6,7,8,9,46,11,12,13,14,47,16,17,18,19,48,21,22,23,24,49,26,27,28,29,50,31]
; AVX512BW-NEXT:    vpermt2w %zmm13, %zmm24, %zmm14
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm26 = <u,u,u,7,39,u,u,u,8,40,u,u,u,9,41,u,u,u,10,42,u,u,u,11,43,u,u,u,12,44,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm27
; AVX512BW-NEXT:    vpermt2w %zmm11, %zmm26, %zmm27
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <6,38,u,u,u,7,39,u,u,u,8,40,u,u,u,9,41,u,u,u,10,42,u,u,u,11,43,u,u,u,12,44>
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm29
; AVX512BW-NEXT:    vpermt2w %zmm15, %zmm28, %zmm29
; AVX512BW-NEXT:    vmovdqu16 %zmm27, %zmm29 {%k2}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm27 = [0,1,38,3,4,5,6,39,8,9,10,11,40,13,14,15,16,41,18,19,20,21,42,23,24,25,26,43,28,29,30,31]
; AVX512BW-NEXT:    vpermt2w %zmm13, %zmm27, %zmm29
; AVX512BW-NEXT:    vpermt2w %zmm15, %zmm16, %zmm12
; AVX512BW-NEXT:    vpermt2w %zmm11, %zmm17, %zmm0
; AVX512BW-NEXT:    vmovdqu16 %zmm12, %zmm0 {%k1}
; AVX512BW-NEXT:    vpermt2w %zmm13, %zmm18, %zmm0
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm1, %zmm19
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm6, %zmm8
; AVX512BW-NEXT:    vmovdqu16 %zmm19, %zmm8 {%k1}
; AVX512BW-NEXT:    vpermt2w %zmm5, %zmm20, %zmm8
; AVX512BW-NEXT:    vpermi2w %zmm6, %zmm2, %zmm21
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm4, %zmm10
; AVX512BW-NEXT:    vmovdqu16 %zmm21, %zmm10 {%k3}
; AVX512BW-NEXT:    vpermt2w %zmm5, %zmm22, %zmm10
; AVX512BW-NEXT:    vpermi2w %zmm6, %zmm2, %zmm23
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm1, %zmm25
; AVX512BW-NEXT:    vmovdqu16 %zmm23, %zmm25 {%k2}
; AVX512BW-NEXT:    vpermt2w %zmm5, %zmm24, %zmm25
; AVX512BW-NEXT:    vpermt2w %zmm4, %zmm26, %zmm1
; AVX512BW-NEXT:    vpermt2w %zmm6, %zmm28, %zmm2
; AVX512BW-NEXT:    vmovdqu16 %zmm1, %zmm2 {%k2}
; AVX512BW-NEXT:    vpermt2w %zmm5, %zmm27, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 64(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 128(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 192(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 256(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, 384(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, 448(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 512(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 576(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <64 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <64 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <64 x i16>, ptr %in.vecptr4, align 64
  %1 = shufflevector <64 x i16> %in.vec0, <64 x i16> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i16> %in.vec2, <64 x i16> %in.vec3, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %3 = shufflevector <128 x i16> %1, <128 x i16> %2, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %4 = shufflevector <64 x i16> %in.vec4, <64 x i16> poison, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <256 x i16> %3, <256 x i16> %4, <320 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255, i32 256, i32 257, i32 258, i32 259, i32 260, i32 261, i32 262, i32 263, i32 264, i32 265, i32 266, i32 267, i32 268, i32 269, i32 270, i32 271, i32 272, i32 273, i32 274, i32 275, i32 276, i32 277, i32 278, i32 279, i32 280, i32 281, i32 282, i32 283, i32 284, i32 285, i32 286, i32 287, i32 288, i32 289, i32 290, i32 291, i32 292, i32 293, i32 294, i32 295, i32 296, i32 297, i32 298, i32 299, i32 300, i32 301, i32 302, i32 303, i32 304, i32 305, i32 306, i32 307, i32 308, i32 309, i32 310, i32 311, i32 312, i32 313, i32 314, i32 315, i32 316, i32 317, i32 318, i32 319>
  %interleaved.vec = shufflevector <320 x i16> %5, <320 x i16> poison, <320 x i32> <i32 0, i32 64, i32 128, i32 192, i32 256, i32 1, i32 65, i32 129, i32 193, i32 257, i32 2, i32 66, i32 130, i32 194, i32 258, i32 3, i32 67, i32 131, i32 195, i32 259, i32 4, i32 68, i32 132, i32 196, i32 260, i32 5, i32 69, i32 133, i32 197, i32 261, i32 6, i32 70, i32 134, i32 198, i32 262, i32 7, i32 71, i32 135, i32 199, i32 263, i32 8, i32 72, i32 136, i32 200, i32 264, i32 9, i32 73, i32 137, i32 201, i32 265, i32 10, i32 74, i32 138, i32 202, i32 266, i32 11, i32 75, i32 139, i32 203, i32 267, i32 12, i32 76, i32 140, i32 204, i32 268, i32 13, i32 77, i32 141, i32 205, i32 269, i32 14, i32 78, i32 142, i32 206, i32 270, i32 15, i32 79, i32 143, i32 207, i32 271, i32 16, i32 80, i32 144, i32 208, i32 272, i32 17, i32 81, i32 145, i32 209, i32 273, i32 18, i32 82, i32 146, i32 210, i32 274, i32 19, i32 83, i32 147, i32 211, i32 275, i32 20, i32 84, i32 148, i32 212, i32 276, i32 21, i32 85, i32 149, i32 213, i32 277, i32 22, i32 86, i32 150, i32 214, i32 278, i32 23, i32 87, i32 151, i32 215, i32 279, i32 24, i32 88, i32 152, i32 216, i32 280, i32 25, i32 89, i32 153, i32 217, i32 281, i32 26, i32 90, i32 154, i32 218, i32 282, i32 27, i32 91, i32 155, i32 219, i32 283, i32 28, i32 92, i32 156, i32 220, i32 284, i32 29, i32 93, i32 157, i32 221, i32 285, i32 30, i32 94, i32 158, i32 222, i32 286, i32 31, i32 95, i32 159, i32 223, i32 287, i32 32, i32 96, i32 160, i32 224, i32 288, i32 33, i32 97, i32 161, i32 225, i32 289, i32 34, i32 98, i32 162, i32 226, i32 290, i32 35, i32 99, i32 163, i32 227, i32 291, i32 36, i32 100, i32 164, i32 228, i32 292, i32 37, i32 101, i32 165, i32 229, i32 293, i32 38, i32 102, i32 166, i32 230, i32 294, i32 39, i32 103, i32 167, i32 231, i32 295, i32 40, i32 104, i32 168, i32 232, i32 296, i32 41, i32 105, i32 169, i32 233, i32 297, i32 42, i32 106, i32 170, i32 234, i32 298, i32 43, i32 107, i32 171, i32 235, i32 299, i32 44, i32 108, i32 172, i32 236, i32 300, i32 45, i32 109, i32 173, i32 237, i32 301, i32 46, i32 110, i32 174, i32 238, i32 302, i32 47, i32 111, i32 175, i32 239, i32 303, i32 48, i32 112, i32 176, i32 240, i32 304, i32 49, i32 113, i32 177, i32 241, i32 305, i32 50, i32 114, i32 178, i32 242, i32 306, i32 51, i32 115, i32 179, i32 243, i32 307, i32 52, i32 116, i32 180, i32 244, i32 308, i32 53, i32 117, i32 181, i32 245, i32 309, i32 54, i32 118, i32 182, i32 246, i32 310, i32 55, i32 119, i32 183, i32 247, i32 311, i32 56, i32 120, i32 184, i32 248, i32 312, i32 57, i32 121, i32 185, i32 249, i32 313, i32 58, i32 122, i32 186, i32 250, i32 314, i32 59, i32 123, i32 187, i32 251, i32 315, i32 60, i32 124, i32 188, i32 252, i32 316, i32 61, i32 125, i32 189, i32 253, i32 317, i32 62, i32 126, i32 190, i32 254, i32 318, i32 63, i32 127, i32 191, i32 255, i32 319>
  store <320 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX: {{.*}}
; AVX1: {{.*}}
; AVX2: {{.*}}
; AVX2-ONLY: {{.*}}
; AVX512: {{.*}}
; AVX512BW-FAST: {{.*}}
; AVX512BW-ONLY-FAST: {{.*}}
; AVX512BW-ONLY-SLOW: {{.*}}
; AVX512BW-SLOW: {{.*}}
; AVX512DQ-FAST: {{.*}}
; AVX512DQ-SLOW: {{.*}}
; AVX512DQBW-FAST: {{.*}}
; AVX512DQBW-SLOW: {{.*}}
; AVX512F-ONLY-FAST: {{.*}}
; AVX512F-ONLY-SLOW: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK10: {{.*}}
; FALLBACK11: {{.*}}
; FALLBACK12: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; FALLBACK8: {{.*}}
; FALLBACK9: {{.*}}
