; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

declare void @use(i1)
declare void @llvm.assume(i1)

define void @test.not.uge.ult(i8 %start, i8 %high) {
; CHECK-LABEL: @test.not.uge.ult(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR_I:%.*]] = add nsw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp uge i8 [[ADD_PTR_I]], [[HIGH:%.*]]
; CHECK-NEXT:    br i1 [[C_1]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    ret void
; CHECK:       if.end:
; CHECK-NEXT:    [[T_0:%.*]] = icmp ult i8 [[START]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 [[T_0]])
; CHECK-NEXT:    [[START_1:%.*]] = add nsw i8 [[START]], 1
; CHECK-NEXT:    [[T_1:%.*]] = icmp ult i8 [[START_1]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 [[T_1]])
; CHECK-NEXT:    [[START_2:%.*]] = add nsw i8 [[START]], 2
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult i8 [[START_2]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 [[T_2]])
; CHECK-NEXT:    [[START_3:%.*]] = add nsw i8 [[START]], 3
; CHECK-NEXT:    [[T_3:%.*]] = icmp ult i8 [[START_3]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 [[T_3]])
; CHECK-NEXT:    [[START_4:%.*]] = add nsw i8 [[START]], 4
; CHECK-NEXT:    [[C_4:%.*]] = icmp ult i8 [[START_4]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 [[C_4]])
; CHECK-NEXT:    ret void
;
entry:
  %add.ptr.i = add nsw i8 %start, 3
  %c.1 = icmp uge i8 %add.ptr.i, %high
  br i1 %c.1, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  ret void

if.end:                                           ; preds = %entry
  %t.0 = icmp ult i8 %start, %high
  call void @use(i1 %t.0)
  %start.1 = add nsw i8 %start, 1
  %t.1 = icmp ult i8 %start.1, %high
  call void @use(i1 %t.1)
  %start.2 = add nsw i8 %start, 2
  %t.2 = icmp ult i8 %start.2, %high
  call void @use(i1 %t.2)
  %start.3 = add nsw i8 %start, 3
  %t.3 = icmp ult i8 %start.3, %high
  call void @use(i1 %t.3)
  %start.4 = add nsw i8 %start, 4
  %c.4 = icmp ult i8 %start.4, %high
  call void @use(i1 %c.4)
  ret void
}

define void @test.not.sge.slt(i8 %start, i8 %high) {
; CHECK-LABEL: @test.not.sge.slt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR_I:%.*]] = add nsw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp sge i8 [[ADD_PTR_I]], [[HIGH:%.*]]
; CHECK-NEXT:    br i1 [[C_1]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    ret void
; CHECK:       if.end:
; CHECK-NEXT:    [[T_0:%.*]] = icmp slt i8 [[START]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[START_1:%.*]] = add nsw i8 [[START]], 1
; CHECK-NEXT:    [[T_1:%.*]] = icmp slt i8 [[START_1]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[START_2:%.*]] = add nsw i8 [[START]], 2
; CHECK-NEXT:    [[T_2:%.*]] = icmp slt i8 [[START_2]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[START_3:%.*]] = add nsw i8 [[START]], 3
; CHECK-NEXT:    [[T_3:%.*]] = icmp slt i8 [[START_3]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[START_4:%.*]] = add nsw i8 [[START]], 4
; CHECK-NEXT:    [[C_4:%.*]] = icmp slt i8 [[START_4]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 [[C_4]])
; CHECK-NEXT:    ret void
;
entry:
  %add.ptr.i = add nsw i8 %start, 3
  %c.1 = icmp sge i8 %add.ptr.i, %high
  br i1 %c.1, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  ret void

if.end:                                           ; preds = %entry
  %t.0 = icmp slt i8 %start, %high
  call void @use(i1 %t.0)
  %start.1 = add nsw i8 %start, 1
  %t.1 = icmp slt i8 %start.1, %high
  call void @use(i1 %t.1)
  %start.2 = add nsw i8 %start, 2
  %t.2 = icmp slt i8 %start.2, %high
  call void @use(i1 %t.2)
  %start.3 = add nsw i8 %start, 3
  %t.3 = icmp slt i8 %start.3, %high
  call void @use(i1 %t.3)
  %start.4 = add nsw i8 %start, 4
  %c.4 = icmp slt i8 %start.4, %high
  call void @use(i1 %c.4)
  ret void
}

define void @test.decompose.nonconst(i8 %a, i8 %b, i8 %c, i8 %d) {
; CHECK-LABEL: @test.decompose.nonconst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C_0:%.*]] = icmp sge i8 [[A:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp sge i8 [[B:%.*]], [[C]]
; CHECK-NEXT:    [[AND_0:%.*]] = and i1 [[C_0]], [[C_1]]
; CHECK-NEXT:    br i1 [[AND_0]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[C_2:%.*]] = icmp sge i8 [[A]], 0
; CHECK-NEXT:    [[C_3:%.*]] = icmp sge i8 [[B]], 0
; CHECK-NEXT:    [[AND_1:%.*]] = and i1 [[C_2]], [[C_3]]
; CHECK-NEXT:    br i1 [[AND_1]], label [[IF_THEN_2:%.*]], label [[IF_END]]
; CHECK:       if.then.2:
; CHECK-NEXT:    [[ADD_0:%.*]] = add nsw i8 [[A]], [[B]]
; CHECK-NEXT:    [[T_0:%.*]] = icmp sge i8 [[ADD_0]], [[C]]
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[ADD_1:%.*]] = add nsw i8 [[A]], [[A]]
; CHECK-NEXT:    [[T_1:%.*]] = icmp sge i8 [[ADD_0]], [[C]]
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[ADD_2:%.*]] = add nsw i8 [[A]], [[D:%.*]]
; CHECK-NEXT:    [[C_4:%.*]] = icmp sge i8 [[ADD_2]], [[C]]
; CHECK-NEXT:    call void @use(i1 [[C_4]])
; CHECK-NEXT:    ret void
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  %c.0 = icmp sge i8 %a, %c
  %c.1 = icmp sge i8 %b, %c
  %and.0 = and i1 %c.0, %c.1
  br i1 %and.0, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %c.2 = icmp sge i8 %a, 0
  %c.3 = icmp sge i8 %b, 0
  %and.1 = and i1 %c.2, %c.3
  br i1 %and.1, label %if.then.2, label %if.end

if.then.2:
  %add.0 = add nsw i8 %a, %b
  %t.0 = icmp sge i8 %add.0, %c
  call void @use(i1 %t.0)
  %add.1 = add nsw i8 %a, %a
  %t.1 = icmp sge i8 %add.0, %c
  call void @use(i1 %t.1)
  %add.2 = add nsw i8 %a, %d
  %c.4 = icmp sge i8 %add.2, %c
  call void @use(i1 %c.4)
  ret void

if.end:                                           ; preds = %entry
  ret void
}

define void @test.decompose.nonconst.no.null.check(i8 %a, i8 %b, i8 %c, i8 %d) {
; CHECK-LABEL: @test.decompose.nonconst.no.null.check(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C_0:%.*]] = icmp sge i8 [[A:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp sge i8 [[B:%.*]], [[C]]
; CHECK-NEXT:    [[AND_0:%.*]] = and i1 [[C_0]], [[C_1]]
; CHECK-NEXT:    br i1 [[AND_0]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[ADD_0:%.*]] = add nsw i8 [[A]], [[B]]
; CHECK-NEXT:    [[T_0:%.*]] = icmp sge i8 [[ADD_0]], [[C]]
; CHECK-NEXT:    call void @use(i1 [[T_0]])
; CHECK-NEXT:    [[ADD_1:%.*]] = add nsw i8 [[A]], [[A]]
; CHECK-NEXT:    [[T_1:%.*]] = icmp sge i8 [[ADD_0]], [[C]]
; CHECK-NEXT:    call void @use(i1 [[T_1]])
; CHECK-NEXT:    [[ADD_2:%.*]] = add nsw i8 [[A]], [[D:%.*]]
; CHECK-NEXT:    [[C_4:%.*]] = icmp sge i8 [[ADD_2]], [[C]]
; CHECK-NEXT:    call void @use(i1 [[C_4]])
; CHECK-NEXT:    ret void
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  %c.0 = icmp sge i8 %a, %c
  %c.1 = icmp sge i8 %b, %c
  %and.0 = and i1 %c.0, %c.1
  br i1 %and.0, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %add.0 = add nsw i8 %a, %b
  %t.0 = icmp sge i8 %add.0, %c
  call void @use(i1 %t.0)
  %add.1 = add nsw i8 %a, %a
  %t.1 = icmp sge i8 %add.0, %c
  call void @use(i1 %t.1)
  %add.2 = add nsw i8 %a, %d
  %c.4 = icmp sge i8 %add.2, %c
  call void @use(i1 %c.4)
  ret void

if.end:                                           ; preds = %entry
  ret void
}

define void @test.sge.slt.add.neg(i8 %start, i8 %high) {
; CHECK-LABEL: @test.sge.slt.add.neg(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR_I:%.*]] = add nsw i8 [[START:%.*]], -3
; CHECK-NEXT:    [[C_1:%.*]] = icmp slt i8 [[ADD_PTR_I]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[C_2:%.*]] = icmp slt i8 [[START]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 [[C_2]])
; CHECK-NEXT:    [[START_1:%.*]] = add nsw i8 [[START]], 1
; CHECK-NEXT:    [[C_3:%.*]] = icmp slt i8 [[START_1]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 [[C_3]])
; CHECK-NEXT:    [[START_2:%.*]] = add nsw i8 [[START]], -2
; CHECK-NEXT:    [[C_4:%.*]] = icmp slt i8 [[START_2]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 [[C_4]])
; CHECK-NEXT:    [[START_3:%.*]] = add nsw i8 [[START]], -3
; CHECK-NEXT:    [[T_1:%.*]] = icmp slt i8 [[START_3]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[START_4:%.*]] = add nsw i8 [[START]], -4
; CHECK-NEXT:    [[T_2:%.*]] = icmp slt i8 [[START_4]], [[HIGH]]
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    ret void
;
entry:
  %add.ptr.i = add nsw i8 %start, -3
  %c.1 = icmp slt i8 %add.ptr.i, %high
  call void @llvm.assume(i1 %c.1)
  %c.2 = icmp slt i8 %start, %high
  call void @use(i1 %c.2)
  %start.1 = add nsw i8 %start,  1
  %c.3 = icmp slt i8 %start.1, %high
  call void @use(i1 %c.3)
  %start.2 = add nsw i8 %start, -2
  %c.4 = icmp slt i8 %start.2, %high
  call void @use(i1 %c.4)
  %start.3 = add nsw i8 %start, -3
  %t.1 = icmp slt i8 %start.3, %high
  call void @use(i1 %t.1)
  %start.4 = add nsw i8 %start, -4
  %t.2 = icmp slt i8 %start.4, %high
  call void @use(i1 %t.2)
  ret void
}

define i1 @test_ult_add_nsw_pos_1(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_pos_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[HIGH_EXT:%.*]] = zext i8 [[HIGH:%.*]] to i16
; CHECK-NEXT:    [[START_EXT:%.*]] = zext i8 [[START:%.*]] to i16
; CHECK-NEXT:    [[ADD_EXT:%.*]] = add nsw i16 [[START_EXT]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i16 [[ADD_EXT]], [[HIGH_EXT]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[T:%.*]] = icmp ult i16 [[START_EXT]], [[HIGH_EXT]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %high.ext = zext i8 %high to i16
  %start.ext = zext i8 %start to i16
  %add.ext = add nsw i16 %start.ext, 3
  %c.1 = icmp ult i16 %add.ext, %high.ext
  call void @llvm.assume(i1 %c.1)

  %t = icmp ult i16 %start.ext, %high.ext
  ret i1 %t
}

define i1 @test_ult_add_nsw_pos_1_assume_pos(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_pos_1_assume_pos(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_POS:%.*]] = icmp sge i8 [[START:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[START_POS]])
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[T:%.*]] = icmp ult i8 [[START]], [[HIGH]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %start.pos = icmp sge i8 %start, 0
  call void @llvm.assume(i1 %start.pos)
  %add = add nsw i8 %start, 3
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)

  %t = icmp ult i8 %start, %high
  ret i1 %t
}

define i1 @test_ult_add_nsw_pos_1_no_assume_pos(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_pos_1_no_assume_pos(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[T:%.*]] = icmp ult i8 [[START]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[T]]
;
entry:
  %add = add nsw i8 %start, 3
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)

  %t = icmp ult i8 %start, %high
  ret i1 %t
}

define i1 @test_ult_add_nsw_pos_1_cmp_no_ext(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_pos_1_cmp_no_ext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[HIGH_EXT:%.*]] = zext i8 [[HIGH:%.*]] to i16
; CHECK-NEXT:    [[START_EXT:%.*]] = zext i8 [[START:%.*]] to i16
; CHECK-NEXT:    [[ADD_EXT:%.*]] = add nsw i16 [[START_EXT]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i16 [[ADD_EXT]], [[HIGH_EXT]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[T:%.*]] = icmp ult i8 [[START]], [[HIGH]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %high.ext = zext i8 %high to i16
  %start.ext = zext i8 %start to i16
  %add.ext = add nsw i16 %start.ext, 3
  %c.1 = icmp ult i16 %add.ext, %high.ext
  call void @llvm.assume(i1 %c.1)

  %t = icmp ult i8 %start, %high
  ret i1 %t
}

define i1 @test_ult_add_nsw_pos_2(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_pos_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[HIGH_EXT:%.*]] = zext i8 [[HIGH:%.*]] to i16
; CHECK-NEXT:    [[START_EXT:%.*]] = zext i8 [[START:%.*]] to i16
; CHECK-NEXT:    [[ADD_EXT:%.*]] = add nsw i16 [[START_EXT]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i16 [[ADD_EXT]], [[HIGH_EXT]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[F:%.*]] = icmp uge i16 [[START_EXT]], [[HIGH_EXT]]
; CHECK-NEXT:    ret i1 false
;
entry:
  %high.ext = zext i8 %high to i16
  %start.ext = zext i8 %start to i16
  %add.ext = add nsw i16 %start.ext, 3
  %c.1 = icmp ult i16 %add.ext, %high.ext
  call void @llvm.assume(i1 %c.1)

  %f = icmp uge i16 %start.ext, %high.ext
  ret i1 %f
}

define i1 @test_ult_add_nsw_pos_2_assume_pos(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_pos_2_assume_pos(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_POS:%.*]] = icmp sge i8 [[START:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[START_POS]])
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[F:%.*]] = icmp uge i8 [[START]], [[HIGH]]
; CHECK-NEXT:    ret i1 false
;
entry:
  %start.pos = icmp sge i8 %start, 0
  call void @llvm.assume(i1 %start.pos)
  %add = add nsw i8 %start, 3
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)

  %f = icmp uge i8 %start, %high
  ret i1 %f
}

define i1 @test_ult_add_nsw_pos_2_cmp_no_ext(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_pos_2_cmp_no_ext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[HIGH_EXT:%.*]] = zext i8 [[HIGH:%.*]] to i16
; CHECK-NEXT:    [[START_EXT:%.*]] = zext i8 [[START:%.*]] to i16
; CHECK-NEXT:    [[ADD_EXT:%.*]] = add nsw i16 [[START_EXT]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i16 [[ADD_EXT]], [[HIGH_EXT]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[C:%.*]] = icmp uge i8 [[START]], [[HIGH]]
; CHECK-NEXT:    ret i1 false
;
entry:
  %high.ext = zext i8 %high to i16
  %start.ext = zext i8 %start to i16
  %add.ext = add nsw i16 %start.ext, 3
  %c.1 = icmp ult i16 %add.ext, %high.ext
  call void @llvm.assume(i1 %c.1)

  %c = icmp uge i8 %start, %high
  ret i1 %c
}

define i1 @test_ult_add_nsw_pos_3(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_pos_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[HIGH_EXT:%.*]] = zext i8 [[HIGH:%.*]] to i16
; CHECK-NEXT:    [[START_EXT:%.*]] = zext i8 [[START:%.*]] to i16
; CHECK-NEXT:    [[ADD_EXT:%.*]] = add nsw i16 [[START_EXT]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i16 [[ADD_EXT]], [[HIGH_EXT]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[ADD_4:%.*]] = add nsw i16 [[START_EXT]], 4
; CHECK-NEXT:    [[C:%.*]] = icmp ult i16 [[ADD_4]], [[HIGH_EXT]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %high.ext = zext i8 %high to i16
  %start.ext = zext i8 %start to i16
  %add.ext = add nsw i16 %start.ext, 3
  %c.1 = icmp ult i16 %add.ext, %high.ext
  call void @llvm.assume(i1 %c.1)

  %add.4 = add nsw i16 %start.ext, 4
  %c = icmp ult i16 %add.4, %high.ext
  ret i1 %c
}

define i1 @test_ult_add_nsw_pos_3_assume_pos(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_pos_3_assume_pos(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_POS:%.*]] = icmp sge i8 [[START:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[START_POS]])
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[ADD_4:%.*]] = add nsw i8 [[START]], 4
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[ADD_4]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %start.pos = icmp sge i8 %start, 0
  call void @llvm.assume(i1 %start.pos)
  %add = add nsw i8 %start, 3
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)

  %add.4 = add nsw i8 %start, 4
  %c = icmp ult i8 %add.4, %high
  ret i1 %c
}

define i1 @test_ult_add_nsw_pos_4(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_pos_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[HIGH_EXT:%.*]] = zext i8 [[HIGH:%.*]] to i16
; CHECK-NEXT:    [[START_EXT:%.*]] = zext i8 [[START:%.*]] to i16
; CHECK-NEXT:    [[ADD_EXT:%.*]] = add nsw i16 [[START_EXT]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i16 [[ADD_EXT]], [[HIGH_EXT]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[ADD_2:%.*]] = add nsw i16 [[START_EXT]], 2
; CHECK-NEXT:    [[C:%.*]] = icmp ult i16 [[ADD_2]], [[HIGH_EXT]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %high.ext = zext i8 %high to i16
  %start.ext = zext i8 %start to i16
  %add.ext = add nsw i16 %start.ext, 3
  %c.1 = icmp ult i16 %add.ext, %high.ext
  call void @llvm.assume(i1 %c.1)

  %add.2 = add nsw i16 %start.ext, 2
  %c = icmp ult i16 %add.2, %high.ext
  ret i1 %c
}

define i1 @test_ult_add_nsw_pos_4_assume_pos(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_pos_4_assume_pos(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_POS:%.*]] = icmp sge i8 [[START:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[START_POS]])
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[ADD_2:%.*]] = add nsw i8 [[START]], 2
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[ADD_2]], [[HIGH]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %start.pos = icmp sge i8 %start, 0
  call void @llvm.assume(i1 %start.pos)
  %add = add nsw i8 %start, 3
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)

  %add.2 = add nsw i8 %start, 2
  %c = icmp ult i8 %add.2, %high
  ret i1 %c
}

define i1 @test_ult_add_nsw_neg_5(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_neg_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[HIGH_EXT:%.*]] = zext i8 [[HIGH:%.*]] to i16
; CHECK-NEXT:    [[START_EXT:%.*]] = zext i8 [[START:%.*]] to i16
; CHECK-NEXT:    [[ADD_EXT:%.*]] = add nsw i16 [[START_EXT]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i16 [[ADD_EXT]], [[HIGH_EXT]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[SUB_2:%.*]] = add nsw i16 [[START_EXT]], -2
; CHECK-NEXT:    [[C:%.*]] = icmp ult i16 [[SUB_2]], [[HIGH_EXT]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %high.ext = zext i8 %high to i16
  %start.ext = zext i8 %start to i16
  %add.ext = add nsw i16 %start.ext, 3
  %c.1 = icmp ult i16 %add.ext, %high.ext
  call void @llvm.assume(i1 %c.1)

  %sub.2 = add nsw i16 %start.ext, -2
  %c = icmp ult i16 %sub.2, %high.ext
  ret i1 %c
}

define i1 @test_ult_add_nsw_neg_5_assume_pos(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_neg_5_assume_pos(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_POS:%.*]] = icmp sge i8 [[START:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[START_POS]])
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[SUB_2:%.*]] = add nsw i8 [[START]], -2
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[SUB_2]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %start.pos = icmp sge i8 %start, 0
  call void @llvm.assume(i1 %start.pos)
  %add = add nsw i8 %start, 3
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)

  %sub.2 = add nsw i8 %start, -2
  %c = icmp ult i8 %sub.2, %high
  ret i1 %c
}

define i1 @test_ult_add_no_nsw_pos_6(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_no_nsw_pos_6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[HIGH_EXT:%.*]] = zext i8 [[HIGH:%.*]] to i16
; CHECK-NEXT:    [[START_EXT:%.*]] = zext i8 [[START:%.*]] to i16
; CHECK-NEXT:    [[ADD_EXT:%.*]] = add i16 [[START_EXT]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i16 [[ADD_EXT]], [[HIGH_EXT]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[ADD_2:%.*]] = add i16 [[START_EXT]], 2
; CHECK-NEXT:    [[C:%.*]] = icmp ult i16 [[ADD_2]], [[HIGH_EXT]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %high.ext = zext i8 %high to i16
  %start.ext = zext i8 %start to i16
  %add.ext = add i16 %start.ext, 3
  %c.1 = icmp ult i16 %add.ext, %high.ext
  call void @llvm.assume(i1 %c.1)

  %add.2 = add i16 %start.ext, 2
  %c = icmp ult i16 %add.2, %high.ext
  ret i1 %c
}

define i1 @test_ult_add_no_nsw_pos_6_assume_pos(i8 %start, i8 %high) {
; CHECK-LABEL: @test_ult_add_no_nsw_pos_6_assume_pos(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_POS:%.*]] = icmp sge i8 [[START:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[START_POS]])
; CHECK-NEXT:    [[ADD:%.*]] = add i8 [[START]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[ADD_2:%.*]] = add i8 [[START]], 2
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[ADD_2]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %start.pos = icmp sge i8 %start, 0
  call void @llvm.assume(i1 %start.pos)
  %add = add i8 %start, 3
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)

  %add.2 = add i8 %start, 2
  %c = icmp ult i8 %add.2, %high
  ret i1 %c
}

define i1 @test_ult_add_nsw_var_7(i8 %start, i8 %off, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_var_7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START:%.*]], [[OFF:%.*]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[OFF_POS:%.*]] = icmp sge i8 [[OFF]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_POS]])
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[START]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %add = add nsw i8 %start, %off
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)
  %off.pos = icmp sge i8 %off, 0
  call void @llvm.assume(i1 %off.pos)

  %c = icmp ult i8 %start, %high
  ret i1 %c
}

define i1 @test_ult_add_no_nsw_var_7(i8 %start, i8 %off, i8 %high) {
; CHECK-LABEL: @test_ult_add_no_nsw_var_7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add i8 [[START:%.*]], [[OFF:%.*]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[OFF_POS:%.*]] = icmp sge i8 [[OFF]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_POS]])
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[START]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %add = add i8 %start, %off
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)
  %off.pos = icmp sge i8 %off, 0
  call void @llvm.assume(i1 %off.pos)

  %c = icmp ult i8 %start, %high
  ret i1 %c
}

define i1 @test_ult_add_nsw_var_8(i8 %start, i8 %off.1, i8 %off.2, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_var_8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START:%.*]], [[OFF_2:%.*]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[OFF_1_POS:%.*]] = icmp sge i8 [[OFF_1:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_1_POS]])
; CHECK-NEXT:    [[OFF_2_POS:%.*]] = icmp sge i8 [[OFF_2]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_2_POS]])
; CHECK-NEXT:    [[OFF_1_ULT:%.*]] = icmp ult i8 [[OFF_1]], [[OFF_2]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_1_ULT]])
; CHECK-NEXT:    [[ADD_OFF_2:%.*]] = add nsw i8 [[START]], [[OFF_1]]
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[ADD_OFF_2]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %add = add nsw i8 %start, %off.2
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)
  %off.1.pos = icmp sge i8 %off.1, 0
  call void @llvm.assume(i1 %off.1.pos)
  %off.2.pos = icmp sge i8 %off.2, 0
  call void @llvm.assume(i1 %off.2.pos)
  %off.1.ult = icmp ult i8 %off.1, %off.2
  call void @llvm.assume(i1 %off.1.ult)

  %add.off.2 = add nsw i8 %start, %off.1
  %c = icmp ult i8 %add.off.2, %high
  ret i1 %c
}

define i1 @test_ult_add_nsw_var_8_all_pos(i8 %start, i8 %off.1, i8 %off.2, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_var_8_all_pos(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_POS:%.*]] = icmp sge i8 [[START:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[START_POS]])
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START]], [[OFF_2:%.*]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[OFF_1_POS:%.*]] = icmp sge i8 [[OFF_1:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_1_POS]])
; CHECK-NEXT:    [[OFF_2_POS:%.*]] = icmp sge i8 [[OFF_2]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_2_POS]])
; CHECK-NEXT:    [[OFF_1_ULT:%.*]] = icmp ult i8 [[OFF_1]], [[OFF_2]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_1_ULT]])
; CHECK-NEXT:    [[ADD_OFF_2:%.*]] = add nsw i8 [[START]], [[OFF_1]]
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[ADD_OFF_2]], [[HIGH]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %start.pos = icmp sge i8 %start, 0
  call void @llvm.assume(i1 %start.pos)
  %add = add nsw i8 %start, %off.2
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)
  %off.1.pos = icmp sge i8 %off.1, 0
  call void @llvm.assume(i1 %off.1.pos)
  %off.2.pos = icmp sge i8 %off.2, 0
  call void @llvm.assume(i1 %off.2.pos)
  %off.1.ult = icmp ult i8 %off.1, %off.2
  call void @llvm.assume(i1 %off.1.ult)

  %add.off.2 = add nsw i8 %start, %off.1
  %c = icmp ult i8 %add.off.2, %high
  ret i1 %c
}

define i1 @test_ult_add_no_nsw_var_8_all_pos(i8 %start, i8 %off.1, i8 %off.2, i8 %high) {
; CHECK-LABEL: @test_ult_add_no_nsw_var_8_all_pos(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_POS:%.*]] = icmp sge i8 [[START:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[START_POS]])
; CHECK-NEXT:    [[ADD:%.*]] = add i8 [[START]], [[OFF_2:%.*]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[OFF_1_POS:%.*]] = icmp sge i8 [[OFF_1:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_1_POS]])
; CHECK-NEXT:    [[OFF_2_POS:%.*]] = icmp sge i8 [[OFF_2]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_2_POS]])
; CHECK-NEXT:    [[OFF_1_ULT:%.*]] = icmp ult i8 [[OFF_1]], [[OFF_2]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_1_ULT]])
; CHECK-NEXT:    [[ADD_OFF_2:%.*]] = add nsw i8 [[START]], [[OFF_1]]
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[ADD_OFF_2]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %start.pos = icmp sge i8 %start, 0
  call void @llvm.assume(i1 %start.pos)
  %add = add i8 %start, %off.2
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)
  %off.1.pos = icmp sge i8 %off.1, 0
  call void @llvm.assume(i1 %off.1.pos)
  %off.2.pos = icmp sge i8 %off.2, 0
  call void @llvm.assume(i1 %off.2.pos)
  %off.1.ult = icmp ult i8 %off.1, %off.2
  call void @llvm.assume(i1 %off.1.ult)

  %add.off.2 = add nsw i8 %start, %off.1
  %c = icmp ult i8 %add.off.2, %high
  ret i1 %c
}

define i1 @test_ult_add_nsw_var_9_all_pos(i8 %start, i8 %off.1, i8 %off.2, i8 %high) {
; CHECK-LABEL: @test_ult_add_nsw_var_9_all_pos(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_POS:%.*]] = icmp sge i8 [[START:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[START_POS]])
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START]], [[OFF_2:%.*]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[ADD]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[OFF_1_POS:%.*]] = icmp sge i8 [[OFF_1:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_1_POS]])
; CHECK-NEXT:    [[OFF_2_POS:%.*]] = icmp sge i8 [[OFF_2]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[OFF_2_POS]])
; CHECK-NEXT:    [[ADD_OFF_2:%.*]] = add nsw i8 [[START]], [[OFF_1]]
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[ADD_OFF_2]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %start.pos = icmp sge i8 %start, 0
  call void @llvm.assume(i1 %start.pos)
  %add = add nsw i8 %start, %off.2
  %c.1 = icmp ult i8 %add, %high
  call void @llvm.assume(i1 %c.1)
  %off.1.pos = icmp sge i8 %off.1, 0
  call void @llvm.assume(i1 %off.1.pos)
  %off.2.pos = icmp sge i8 %off.2, 0
  call void @llvm.assume(i1 %off.2.pos)

  %add.off.2 = add nsw i8 %start, %off.1
  %c = icmp ult i8 %add.off.2, %high
  ret i1 %c
}

define i1 @add_neg_1_known_sge_ult_1(i32 %a) {
; CHECK-LABEL: @add_neg_1_known_sge_ult_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SGE:%.*]] = icmp sge i32 [[A:%.*]], 1
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_SGE]])
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[A]], -1
; CHECK-NEXT:    [[C:%.*]] = icmp ult i32 [[SUB]], [[A]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.sge = icmp sge i32 %a, 1
  call void @llvm.assume(i1 %a.sge)
  %sub = add nsw i32 %a, -1
  %c = icmp ult i32 %sub, %a
  ret i1 %c
}

define i1 @add_neg_1_known_sge_uge_1(i32 %a) {
; CHECK-LABEL: @add_neg_1_known_sge_uge_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SGE:%.*]] = icmp sge i32 [[A:%.*]], 1
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_SGE]])
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[A]], -1
; CHECK-NEXT:    [[C:%.*]] = icmp uge i32 [[SUB]], 0
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.sge = icmp sge i32 %a, 1
  call void @llvm.assume(i1 %a.sge)
  %sub = add nsw i32 %a, -1
  %c = icmp uge i32 %sub, 0
  ret i1 %c
}

define i1 @add_neg_1_not_known_sge_ult_1(i32 %a) {
; CHECK-LABEL: @add_neg_1_not_known_sge_ult_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SGE:%.*]] = icmp sge i32 [[A:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_SGE]])
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[A]], -1
; CHECK-NEXT:    [[C:%.*]] = icmp ult i32 [[SUB]], [[A]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.sge = icmp sge i32 %a, 0
  call void @llvm.assume(i1 %a.sge)
  %sub = add nsw i32 %a, -1
  %c = icmp ult i32 %sub, %a
  ret i1 %c
}

define i1 @add_neg_1_not_known_sge_uge_1(i32 %a) {
; CHECK-LABEL: @add_neg_1_not_known_sge_uge_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SGE:%.*]] = icmp sge i32 [[A:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_SGE]])
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[A]], -1
; CHECK-NEXT:    [[C:%.*]] = icmp uge i32 [[SUB]], 0
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.sge = icmp sge i32 %a, 0
  call void @llvm.assume(i1 %a.sge)
  %sub = add nsw i32 %a, -1
  %c = icmp uge i32 %sub, 0
  ret i1 %c
}

define i1 @add_neg_3_known_sge_ult_1(i32 %a) {
; CHECK-LABEL: @add_neg_3_known_sge_ult_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SGE:%.*]] = icmp sge i32 [[A:%.*]], 3
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_SGE]])
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[A]], -3
; CHECK-NEXT:    [[C:%.*]] = icmp ult i32 [[SUB]], [[A]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.sge = icmp sge i32 %a, 3
  call void @llvm.assume(i1 %a.sge)
  %sub = add nsw i32 %a, -3
  %c = icmp ult i32 %sub, %a
  ret i1 %c
}

define i1 @add_neg_3_known_sge_uge_1(i32 %a) {
; CHECK-LABEL: @add_neg_3_known_sge_uge_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SGE:%.*]] = icmp sge i32 [[A:%.*]], 4
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_SGE]])
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[A]], -3
; CHECK-NEXT:    [[C:%.*]] = icmp uge i32 [[SUB]], 0
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.sge = icmp sge i32 %a, 4
  call void @llvm.assume(i1 %a.sge)
  %sub = add nsw i32 %a, -3
  %c = icmp uge i32 %sub, 0
  ret i1 %c
}

define i1 @add_neg_3_not_known_sge_ult_1(i32 %a) {
; CHECK-LABEL: @add_neg_3_not_known_sge_ult_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SGE:%.*]] = icmp sge i32 [[A:%.*]], 2
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_SGE]])
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[A]], -3
; CHECK-NEXT:    [[C:%.*]] = icmp ult i32 [[SUB]], [[A]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.sge = icmp sge i32 %a, 2
  call void @llvm.assume(i1 %a.sge)
  %sub = add nsw i32 %a, -3
  %c = icmp ult i32 %sub, %a
  ret i1 %c
}

define i1 @add_neg_3_not_known_sge_uge_1(i32 %a) {
; CHECK-LABEL: @add_neg_3_not_known_sge_uge_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SGE:%.*]] = icmp sge i32 [[A:%.*]], 2
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_SGE]])
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[A]], -3
; CHECK-NEXT:    [[C:%.*]] = icmp uge i32 [[SUB]], 0
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.sge = icmp sge i32 %a, 2
  call void @llvm.assume(i1 %a.sge)
  %sub = add nsw i32 %a, -3
  %c = icmp uge i32 %sub, 0
  ret i1 %c
}

define i1 @add_neg_3_not_known_sge_ult_2(i32 %a, i32 %b) {
; CHECK-LABEL: @add_neg_3_not_known_sge_ult_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SGE:%.*]] = icmp sge i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_SGE]])
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[A]], -3
; CHECK-NEXT:    [[C:%.*]] = icmp ult i32 [[SUB]], [[A]]
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.sge = icmp sge i32 %a, %b
  call void @llvm.assume(i1 %a.sge)
  %sub = add nsw i32 %a, -3
  %c = icmp ult i32 %sub, %a
  ret i1 %c
}
