/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// DistributionsContainerAPIService DistributionsContainerAPI service
type DistributionsContainerAPIService service

type DistributionsContainerAPIDistributionsContainerContainerAddRoleRequest struct {
	ctx context.Context
	ApiService *DistributionsContainerAPIService
	containerContainerDistributionHref string
	nestedRole *NestedRole
}

func (r DistributionsContainerAPIDistributionsContainerContainerAddRoleRequest) NestedRole(nestedRole NestedRole) DistributionsContainerAPIDistributionsContainerContainerAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r DistributionsContainerAPIDistributionsContainerContainerAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.DistributionsContainerContainerAddRoleExecute(r)
}

/*
DistributionsContainerContainerAddRole Method for DistributionsContainerContainerAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerDistributionHref
 @return DistributionsContainerAPIDistributionsContainerContainerAddRoleRequest
*/
func (a *DistributionsContainerAPIService) DistributionsContainerContainerAddRole(ctx context.Context, containerContainerDistributionHref string) DistributionsContainerAPIDistributionsContainerContainerAddRoleRequest {
	return DistributionsContainerAPIDistributionsContainerContainerAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerDistributionHref: containerContainerDistributionHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *DistributionsContainerAPIService) DistributionsContainerContainerAddRoleExecute(r DistributionsContainerAPIDistributionsContainerContainerAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsContainerAPIService.DistributionsContainerContainerAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_distribution_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_distribution_href"+"}", parameterValueToString(r.containerContainerDistributionHref, "containerContainerDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsContainerAPIDistributionsContainerContainerCreateRequest struct {
	ctx context.Context
	ApiService *DistributionsContainerAPIService
	containerContainerDistribution *ContainerContainerDistribution
}

func (r DistributionsContainerAPIDistributionsContainerContainerCreateRequest) ContainerContainerDistribution(containerContainerDistribution ContainerContainerDistribution) DistributionsContainerAPIDistributionsContainerContainerCreateRequest {
	r.containerContainerDistribution = &containerContainerDistribution
	return r
}

func (r DistributionsContainerAPIDistributionsContainerContainerCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsContainerContainerCreateExecute(r)
}

/*
DistributionsContainerContainerCreate Create a container distribution

Trigger an asynchronous create task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return DistributionsContainerAPIDistributionsContainerContainerCreateRequest
*/
func (a *DistributionsContainerAPIService) DistributionsContainerContainerCreate(ctx context.Context) DistributionsContainerAPIDistributionsContainerContainerCreateRequest {
	return DistributionsContainerAPIDistributionsContainerContainerCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsContainerAPIService) DistributionsContainerContainerCreateExecute(r DistributionsContainerAPIDistributionsContainerContainerCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsContainerAPIService.DistributionsContainerContainerCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/distributions/container/container/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.containerContainerDistribution == nil {
		return localVarReturnValue, nil, reportError("containerContainerDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.containerContainerDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsContainerAPIDistributionsContainerContainerDeleteRequest struct {
	ctx context.Context
	ApiService *DistributionsContainerAPIService
	containerContainerDistributionHref string
}

func (r DistributionsContainerAPIDistributionsContainerContainerDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsContainerContainerDeleteExecute(r)
}

/*
DistributionsContainerContainerDelete Delete a container distribution

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerDistributionHref
 @return DistributionsContainerAPIDistributionsContainerContainerDeleteRequest
*/
func (a *DistributionsContainerAPIService) DistributionsContainerContainerDelete(ctx context.Context, containerContainerDistributionHref string) DistributionsContainerAPIDistributionsContainerContainerDeleteRequest {
	return DistributionsContainerAPIDistributionsContainerContainerDeleteRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerDistributionHref: containerContainerDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsContainerAPIService) DistributionsContainerContainerDeleteExecute(r DistributionsContainerAPIDistributionsContainerContainerDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsContainerAPIService.DistributionsContainerContainerDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_distribution_href"+"}", parameterValueToString(r.containerContainerDistributionHref, "containerContainerDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsContainerAPIDistributionsContainerContainerListRequest struct {
	ctx context.Context
	ApiService *DistributionsContainerAPIService
	basePath *string
	basePathContains *string
	basePathIcontains *string
	basePathIn *[]string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	namespaceName *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	repository *string
	repositoryIn *[]string
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where base_path matches value
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) BasePath(basePath string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.basePath = &basePath
	return r
}

// Filter results where base_path contains value
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) BasePathContains(basePathContains string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.basePathContains = &basePathContains
	return r
}

// Filter results where base_path contains value
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) BasePathIcontains(basePathIcontains string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.basePathIcontains = &basePathIcontains
	return r
}

// Filter results where base_path is in a comma-separated list of values
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) BasePathIn(basePathIn []string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.basePathIn = &basePathIn
	return r
}

// Number of results to return per page.
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) Limit(limit int32) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) Name(name string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) NameContains(nameContains string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) NameIcontains(nameIcontains string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) NameIn(nameIn []string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) NameStartswith(nameStartswith string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) NamespaceName(namespaceName string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.namespaceName = &namespaceName
	return r
}

// The initial index from which to return the results.
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) Offset(offset int32) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;base_path&#x60; - Base path * &#x60;-base_path&#x60; - Base path (descending) * &#x60;hidden&#x60; - Hidden * &#x60;-hidden&#x60; - Hidden (descending) * &#x60;private&#x60; - Private * &#x60;-private&#x60; - Private (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) Ordering(ordering []string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) PulpHrefIn(pulpHrefIn []string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) PulpIdIn(pulpIdIn []string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) PulpLabelSelect(pulpLabelSelect string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Filter results where repository matches value
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) Repository(repository string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.repository = &repository
	return r
}

// Filter results where repository is in a comma-separated list of values
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) RepositoryIn(repositoryIn []string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.repositoryIn = &repositoryIn
	return r
}

// Filter distributions based on the content served by them
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) WithContent(withContent string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) Fields(fields []string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) ExcludeFields(excludeFields []string) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsContainerAPIDistributionsContainerContainerListRequest) Execute() (*PaginatedcontainerContainerDistributionResponseList, *http.Response, error) {
	return r.ApiService.DistributionsContainerContainerListExecute(r)
}

/*
DistributionsContainerContainerList List container distributions

The Container Distribution will serve the latest version of a Repository if
``repository`` is specified. The Container Distribution will serve a specific
repository version if ``repository_version``. Note that **either**
``repository`` or ``repository_version`` can be set on a Container
Distribution, but not both.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return DistributionsContainerAPIDistributionsContainerContainerListRequest
*/
func (a *DistributionsContainerAPIService) DistributionsContainerContainerList(ctx context.Context) DistributionsContainerAPIDistributionsContainerContainerListRequest {
	return DistributionsContainerAPIDistributionsContainerContainerListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedcontainerContainerDistributionResponseList
func (a *DistributionsContainerAPIService) DistributionsContainerContainerListExecute(r DistributionsContainerAPIDistributionsContainerContainerListRequest) (*PaginatedcontainerContainerDistributionResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedcontainerContainerDistributionResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsContainerAPIService.DistributionsContainerContainerList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/distributions/container/container/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.basePath != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path", r.basePath, "")
	}
	if r.basePathContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__contains", r.basePathContains, "")
	}
	if r.basePathIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__icontains", r.basePathIcontains, "")
	}
	if r.basePathIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__in", r.basePathIn, "csv")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.namespaceName != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "namespace__name", r.namespaceName, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.repository != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository", r.repository, "")
	}
	if r.repositoryIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository__in", r.repositoryIn, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsContainerAPIDistributionsContainerContainerListRolesRequest struct {
	ctx context.Context
	ApiService *DistributionsContainerAPIService
	containerContainerDistributionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r DistributionsContainerAPIDistributionsContainerContainerListRolesRequest) Fields(fields []string) DistributionsContainerAPIDistributionsContainerContainerListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsContainerAPIDistributionsContainerContainerListRolesRequest) ExcludeFields(excludeFields []string) DistributionsContainerAPIDistributionsContainerContainerListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsContainerAPIDistributionsContainerContainerListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.DistributionsContainerContainerListRolesExecute(r)
}

/*
DistributionsContainerContainerListRoles Method for DistributionsContainerContainerListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerDistributionHref
 @return DistributionsContainerAPIDistributionsContainerContainerListRolesRequest
*/
func (a *DistributionsContainerAPIService) DistributionsContainerContainerListRoles(ctx context.Context, containerContainerDistributionHref string) DistributionsContainerAPIDistributionsContainerContainerListRolesRequest {
	return DistributionsContainerAPIDistributionsContainerContainerListRolesRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerDistributionHref: containerContainerDistributionHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *DistributionsContainerAPIService) DistributionsContainerContainerListRolesExecute(r DistributionsContainerAPIDistributionsContainerContainerListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsContainerAPIService.DistributionsContainerContainerListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_distribution_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_distribution_href"+"}", parameterValueToString(r.containerContainerDistributionHref, "containerContainerDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsContainerAPIDistributionsContainerContainerMyPermissionsRequest struct {
	ctx context.Context
	ApiService *DistributionsContainerAPIService
	containerContainerDistributionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r DistributionsContainerAPIDistributionsContainerContainerMyPermissionsRequest) Fields(fields []string) DistributionsContainerAPIDistributionsContainerContainerMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsContainerAPIDistributionsContainerContainerMyPermissionsRequest) ExcludeFields(excludeFields []string) DistributionsContainerAPIDistributionsContainerContainerMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsContainerAPIDistributionsContainerContainerMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.DistributionsContainerContainerMyPermissionsExecute(r)
}

/*
DistributionsContainerContainerMyPermissions Method for DistributionsContainerContainerMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerDistributionHref
 @return DistributionsContainerAPIDistributionsContainerContainerMyPermissionsRequest
*/
func (a *DistributionsContainerAPIService) DistributionsContainerContainerMyPermissions(ctx context.Context, containerContainerDistributionHref string) DistributionsContainerAPIDistributionsContainerContainerMyPermissionsRequest {
	return DistributionsContainerAPIDistributionsContainerContainerMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerDistributionHref: containerContainerDistributionHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *DistributionsContainerAPIService) DistributionsContainerContainerMyPermissionsExecute(r DistributionsContainerAPIDistributionsContainerContainerMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsContainerAPIService.DistributionsContainerContainerMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_distribution_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_distribution_href"+"}", parameterValueToString(r.containerContainerDistributionHref, "containerContainerDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsContainerAPIDistributionsContainerContainerPartialUpdateRequest struct {
	ctx context.Context
	ApiService *DistributionsContainerAPIService
	containerContainerDistributionHref string
	patchedcontainerContainerDistribution *PatchedcontainerContainerDistribution
}

func (r DistributionsContainerAPIDistributionsContainerContainerPartialUpdateRequest) PatchedcontainerContainerDistribution(patchedcontainerContainerDistribution PatchedcontainerContainerDistribution) DistributionsContainerAPIDistributionsContainerContainerPartialUpdateRequest {
	r.patchedcontainerContainerDistribution = &patchedcontainerContainerDistribution
	return r
}

func (r DistributionsContainerAPIDistributionsContainerContainerPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsContainerContainerPartialUpdateExecute(r)
}

/*
DistributionsContainerContainerPartialUpdate Update a container distribution

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerDistributionHref
 @return DistributionsContainerAPIDistributionsContainerContainerPartialUpdateRequest
*/
func (a *DistributionsContainerAPIService) DistributionsContainerContainerPartialUpdate(ctx context.Context, containerContainerDistributionHref string) DistributionsContainerAPIDistributionsContainerContainerPartialUpdateRequest {
	return DistributionsContainerAPIDistributionsContainerContainerPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerDistributionHref: containerContainerDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsContainerAPIService) DistributionsContainerContainerPartialUpdateExecute(r DistributionsContainerAPIDistributionsContainerContainerPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsContainerAPIService.DistributionsContainerContainerPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_distribution_href"+"}", parameterValueToString(r.containerContainerDistributionHref, "containerContainerDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedcontainerContainerDistribution == nil {
		return localVarReturnValue, nil, reportError("patchedcontainerContainerDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedcontainerContainerDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsContainerAPIDistributionsContainerContainerReadRequest struct {
	ctx context.Context
	ApiService *DistributionsContainerAPIService
	containerContainerDistributionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r DistributionsContainerAPIDistributionsContainerContainerReadRequest) Fields(fields []string) DistributionsContainerAPIDistributionsContainerContainerReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsContainerAPIDistributionsContainerContainerReadRequest) ExcludeFields(excludeFields []string) DistributionsContainerAPIDistributionsContainerContainerReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsContainerAPIDistributionsContainerContainerReadRequest) Execute() (*ContainerContainerDistributionResponse, *http.Response, error) {
	return r.ApiService.DistributionsContainerContainerReadExecute(r)
}

/*
DistributionsContainerContainerRead Inspect a container distribution

The Container Distribution will serve the latest version of a Repository if
``repository`` is specified. The Container Distribution will serve a specific
repository version if ``repository_version``. Note that **either**
``repository`` or ``repository_version`` can be set on a Container
Distribution, but not both.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerDistributionHref
 @return DistributionsContainerAPIDistributionsContainerContainerReadRequest
*/
func (a *DistributionsContainerAPIService) DistributionsContainerContainerRead(ctx context.Context, containerContainerDistributionHref string) DistributionsContainerAPIDistributionsContainerContainerReadRequest {
	return DistributionsContainerAPIDistributionsContainerContainerReadRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerDistributionHref: containerContainerDistributionHref,
	}
}

// Execute executes the request
//  @return ContainerContainerDistributionResponse
func (a *DistributionsContainerAPIService) DistributionsContainerContainerReadExecute(r DistributionsContainerAPIDistributionsContainerContainerReadRequest) (*ContainerContainerDistributionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContainerContainerDistributionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsContainerAPIService.DistributionsContainerContainerRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_distribution_href"+"}", parameterValueToString(r.containerContainerDistributionHref, "containerContainerDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsContainerAPIDistributionsContainerContainerRemoveRoleRequest struct {
	ctx context.Context
	ApiService *DistributionsContainerAPIService
	containerContainerDistributionHref string
	nestedRole *NestedRole
}

func (r DistributionsContainerAPIDistributionsContainerContainerRemoveRoleRequest) NestedRole(nestedRole NestedRole) DistributionsContainerAPIDistributionsContainerContainerRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r DistributionsContainerAPIDistributionsContainerContainerRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.DistributionsContainerContainerRemoveRoleExecute(r)
}

/*
DistributionsContainerContainerRemoveRole Method for DistributionsContainerContainerRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerDistributionHref
 @return DistributionsContainerAPIDistributionsContainerContainerRemoveRoleRequest
*/
func (a *DistributionsContainerAPIService) DistributionsContainerContainerRemoveRole(ctx context.Context, containerContainerDistributionHref string) DistributionsContainerAPIDistributionsContainerContainerRemoveRoleRequest {
	return DistributionsContainerAPIDistributionsContainerContainerRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerDistributionHref: containerContainerDistributionHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *DistributionsContainerAPIService) DistributionsContainerContainerRemoveRoleExecute(r DistributionsContainerAPIDistributionsContainerContainerRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsContainerAPIService.DistributionsContainerContainerRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_distribution_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_distribution_href"+"}", parameterValueToString(r.containerContainerDistributionHref, "containerContainerDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsContainerAPIDistributionsContainerContainerUpdateRequest struct {
	ctx context.Context
	ApiService *DistributionsContainerAPIService
	containerContainerDistributionHref string
	containerContainerDistribution *ContainerContainerDistribution
}

func (r DistributionsContainerAPIDistributionsContainerContainerUpdateRequest) ContainerContainerDistribution(containerContainerDistribution ContainerContainerDistribution) DistributionsContainerAPIDistributionsContainerContainerUpdateRequest {
	r.containerContainerDistribution = &containerContainerDistribution
	return r
}

func (r DistributionsContainerAPIDistributionsContainerContainerUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsContainerContainerUpdateExecute(r)
}

/*
DistributionsContainerContainerUpdate Update a container distribution

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerDistributionHref
 @return DistributionsContainerAPIDistributionsContainerContainerUpdateRequest
*/
func (a *DistributionsContainerAPIService) DistributionsContainerContainerUpdate(ctx context.Context, containerContainerDistributionHref string) DistributionsContainerAPIDistributionsContainerContainerUpdateRequest {
	return DistributionsContainerAPIDistributionsContainerContainerUpdateRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerDistributionHref: containerContainerDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsContainerAPIService) DistributionsContainerContainerUpdateExecute(r DistributionsContainerAPIDistributionsContainerContainerUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsContainerAPIService.DistributionsContainerContainerUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_distribution_href"+"}", parameterValueToString(r.containerContainerDistributionHref, "containerContainerDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.containerContainerDistribution == nil {
		return localVarReturnValue, nil, reportError("containerContainerDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.containerContainerDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
