/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
	"reflect"
)


// PublicationsPypiAPIService PublicationsPypiAPI service
type PublicationsPypiAPIService service

type PublicationsPypiAPIPublicationsPythonPypiCreateRequest struct {
	ctx context.Context
	ApiService *PublicationsPypiAPIService
	pythonPythonPublication *PythonPythonPublication
}

func (r PublicationsPypiAPIPublicationsPythonPypiCreateRequest) PythonPythonPublication(pythonPythonPublication PythonPythonPublication) PublicationsPypiAPIPublicationsPythonPypiCreateRequest {
	r.pythonPythonPublication = &pythonPythonPublication
	return r
}

func (r PublicationsPypiAPIPublicationsPythonPypiCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.PublicationsPythonPypiCreateExecute(r)
}

/*
PublicationsPythonPypiCreate Create a python publication


Dispatches a publish task, which generates metadata that will be used by pip.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PublicationsPypiAPIPublicationsPythonPypiCreateRequest
*/
func (a *PublicationsPypiAPIService) PublicationsPythonPypiCreate(ctx context.Context) PublicationsPypiAPIPublicationsPythonPypiCreateRequest {
	return PublicationsPypiAPIPublicationsPythonPypiCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *PublicationsPypiAPIService) PublicationsPythonPypiCreateExecute(r PublicationsPypiAPIPublicationsPythonPypiCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsPypiAPIService.PublicationsPythonPypiCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/publications/python/pypi/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.pythonPythonPublication == nil {
		return localVarReturnValue, nil, reportError("pythonPythonPublication is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.pythonPythonPublication
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PublicationsPypiAPIPublicationsPythonPypiDeleteRequest struct {
	ctx context.Context
	ApiService *PublicationsPypiAPIService
	pythonPythonPublicationHref string
}

func (r PublicationsPypiAPIPublicationsPythonPypiDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.PublicationsPythonPypiDeleteExecute(r)
}

/*
PublicationsPythonPypiDelete Delete a python publication


Python Publications refer to the Python Package content in a repository version, and include
metadata about that content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonPublicationHref
 @return PublicationsPypiAPIPublicationsPythonPypiDeleteRequest
*/
func (a *PublicationsPypiAPIService) PublicationsPythonPypiDelete(ctx context.Context, pythonPythonPublicationHref string) PublicationsPypiAPIPublicationsPythonPypiDeleteRequest {
	return PublicationsPypiAPIPublicationsPythonPypiDeleteRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonPublicationHref: pythonPythonPublicationHref,
	}
}

// Execute executes the request
func (a *PublicationsPypiAPIService) PublicationsPythonPypiDeleteExecute(r PublicationsPypiAPIPublicationsPythonPypiDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsPypiAPIService.PublicationsPythonPypiDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_publication_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_publication_href"+"}", parameterValueToString(r.pythonPythonPublicationHref, "pythonPythonPublicationHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type PublicationsPypiAPIPublicationsPythonPypiListRequest struct {
	ctx context.Context
	ApiService *PublicationsPypiAPIService
	content *string
	contentIn *string
	limit *int32
	offset *int32
	ordering *[]string
	pulpCreated *time.Time
	pulpCreatedGt *time.Time
	pulpCreatedGte *time.Time
	pulpCreatedLt *time.Time
	pulpCreatedLte *time.Time
	pulpCreatedRange *[]time.Time
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repository *string
	repositoryVersion *string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) Content(content string) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.content = &content
	return r
}

// Content Unit referenced by HREF
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) ContentIn(contentIn string) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.contentIn = &contentIn
	return r
}

// Number of results to return per page.
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) Limit(limit int32) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) Offset(offset int32) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;complete&#x60; - Complete * &#x60;-complete&#x60; - Complete (descending) * &#x60;pass_through&#x60; - Pass through * &#x60;-pass_through&#x60; - Pass through (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) Ordering(ordering []string) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.ordering = &ordering
	return r
}

// Filter results where pulp_created matches value
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) PulpCreated(pulpCreated time.Time) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.pulpCreated = &pulpCreated
	return r
}

// Filter results where pulp_created is greater than value
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) PulpCreatedGt(pulpCreatedGt time.Time) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.pulpCreatedGt = &pulpCreatedGt
	return r
}

// Filter results where pulp_created is greater than or equal to value
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) PulpCreatedGte(pulpCreatedGte time.Time) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.pulpCreatedGte = &pulpCreatedGte
	return r
}

// Filter results where pulp_created is less than value
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) PulpCreatedLt(pulpCreatedLt time.Time) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.pulpCreatedLt = &pulpCreatedLt
	return r
}

// Filter results where pulp_created is less than or equal to value
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) PulpCreatedLte(pulpCreatedLte time.Time) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.pulpCreatedLte = &pulpCreatedLte
	return r
}

// Filter results where pulp_created is between two comma separated values
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) PulpCreatedRange(pulpCreatedRange []time.Time) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.pulpCreatedRange = &pulpCreatedRange
	return r
}

// Multiple values may be separated by commas.
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) PulpHrefIn(pulpHrefIn []string) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) PulpIdIn(pulpIdIn []string) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository referenced by HREF
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) Repository(repository string) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.repository = &repository
	return r
}

// Repository Version referenced by HREF
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) RepositoryVersion(repositoryVersion string) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// A list of fields to include in the response.
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) Fields(fields []string) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) ExcludeFields(excludeFields []string) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PublicationsPypiAPIPublicationsPythonPypiListRequest) Execute() (*PaginatedpythonPythonPublicationResponseList, *http.Response, error) {
	return r.ApiService.PublicationsPythonPypiListExecute(r)
}

/*
PublicationsPythonPypiList List python publications


Python Publications refer to the Python Package content in a repository version, and include
metadata about that content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PublicationsPypiAPIPublicationsPythonPypiListRequest
*/
func (a *PublicationsPypiAPIService) PublicationsPythonPypiList(ctx context.Context) PublicationsPypiAPIPublicationsPythonPypiListRequest {
	return PublicationsPypiAPIPublicationsPythonPypiListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedpythonPythonPublicationResponseList
func (a *PublicationsPypiAPIService) PublicationsPythonPypiListExecute(r PublicationsPypiAPIPublicationsPythonPypiListRequest) (*PaginatedpythonPythonPublicationResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedpythonPythonPublicationResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsPypiAPIService.PublicationsPythonPypiList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/publications/python/pypi/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.content != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content", r.content, "")
	}
	if r.contentIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content__in", r.contentIn, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpCreated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created", r.pulpCreated, "")
	}
	if r.pulpCreatedGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gt", r.pulpCreatedGt, "")
	}
	if r.pulpCreatedGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gte", r.pulpCreatedGte, "")
	}
	if r.pulpCreatedLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lt", r.pulpCreatedLt, "")
	}
	if r.pulpCreatedLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lte", r.pulpCreatedLte, "")
	}
	if r.pulpCreatedRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__range", r.pulpCreatedRange, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repository != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository", r.repository, "")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PublicationsPypiAPIPublicationsPythonPypiReadRequest struct {
	ctx context.Context
	ApiService *PublicationsPypiAPIService
	pythonPythonPublicationHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PublicationsPypiAPIPublicationsPythonPypiReadRequest) Fields(fields []string) PublicationsPypiAPIPublicationsPythonPypiReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PublicationsPypiAPIPublicationsPythonPypiReadRequest) ExcludeFields(excludeFields []string) PublicationsPypiAPIPublicationsPythonPypiReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PublicationsPypiAPIPublicationsPythonPypiReadRequest) Execute() (*PythonPythonPublicationResponse, *http.Response, error) {
	return r.ApiService.PublicationsPythonPypiReadExecute(r)
}

/*
PublicationsPythonPypiRead Inspect a python publication


Python Publications refer to the Python Package content in a repository version, and include
metadata about that content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonPublicationHref
 @return PublicationsPypiAPIPublicationsPythonPypiReadRequest
*/
func (a *PublicationsPypiAPIService) PublicationsPythonPypiRead(ctx context.Context, pythonPythonPublicationHref string) PublicationsPypiAPIPublicationsPythonPypiReadRequest {
	return PublicationsPypiAPIPublicationsPythonPypiReadRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonPublicationHref: pythonPythonPublicationHref,
	}
}

// Execute executes the request
//  @return PythonPythonPublicationResponse
func (a *PublicationsPypiAPIService) PublicationsPythonPypiReadExecute(r PublicationsPypiAPIPublicationsPythonPypiReadRequest) (*PythonPythonPublicationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PythonPythonPublicationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsPypiAPIService.PublicationsPythonPypiRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_publication_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_publication_href"+"}", parameterValueToString(r.pythonPythonPublicationHref, "pythonPythonPublicationHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
