/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the CollectionVersionResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CollectionVersionResponse{}

// CollectionVersionResponse A serializer for a CollectionVersion.
type CollectionVersionResponse struct {
	Version *string `json:"version,omitempty"`
	// Get href.
	Href *string `json:"href,omitempty"`
	CreatedAt time.Time `json:"created_at"`
	UpdatedAt time.Time `json:"updated_at"`
	RequiresAnsible NullableString `json:"requires_ansible,omitempty"`
	// Get a list of mark values filtering only those in the current repo.
	Marks []string `json:"marks,omitempty"`
	Artifact *ArtifactRefResponse `json:"artifact,omitempty"`
	Collection *CollectionRefResponse `json:"collection,omitempty"`
	// Get artifact download URL.
	DownloadUrl *string `json:"download_url,omitempty"`
	Name *string `json:"name,omitempty"`
	Namespace *CollectionNamespaceResponse `json:"namespace,omitempty"`
	Signatures []CollectionVersionSignatureResponse `json:"signatures"`
	Metadata *CollectionMetadataResponse `json:"metadata,omitempty"`
	// Get the git URL.
	GitUrl *string `json:"git_url,omitempty"`
	// Get the git commit sha.
	GitCommitSha *string `json:"git_commit_sha,omitempty"`
	// A JSON field holding MANIFEST.json data.
	Manifest map[string]interface{} `json:"manifest,omitempty"`
	// A JSON field holding FILES.json data.
	Files map[string]interface{} `json:"files,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CollectionVersionResponse CollectionVersionResponse

// NewCollectionVersionResponse instantiates a new CollectionVersionResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCollectionVersionResponse(createdAt time.Time, updatedAt time.Time, signatures []CollectionVersionSignatureResponse) *CollectionVersionResponse {
	this := CollectionVersionResponse{}
	this.CreatedAt = createdAt
	this.UpdatedAt = updatedAt
	this.Signatures = signatures
	return &this
}

// NewCollectionVersionResponseWithDefaults instantiates a new CollectionVersionResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCollectionVersionResponseWithDefaults() *CollectionVersionResponse {
	this := CollectionVersionResponse{}
	return &this
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetVersion() string {
	if o == nil || IsNil(o.Version) {
		var ret string
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetVersionOk() (*string, bool) {
	if o == nil || IsNil(o.Version) {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasVersion() bool {
	if o != nil && !IsNil(o.Version) {
		return true
	}

	return false
}

// SetVersion gets a reference to the given string and assigns it to the Version field.
func (o *CollectionVersionResponse) SetVersion(v string) {
	o.Version = &v
}

// GetHref returns the Href field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetHref() string {
	if o == nil || IsNil(o.Href) {
		var ret string
		return ret
	}
	return *o.Href
}

// GetHrefOk returns a tuple with the Href field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetHrefOk() (*string, bool) {
	if o == nil || IsNil(o.Href) {
		return nil, false
	}
	return o.Href, true
}

// HasHref returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasHref() bool {
	if o != nil && !IsNil(o.Href) {
		return true
	}

	return false
}

// SetHref gets a reference to the given string and assigns it to the Href field.
func (o *CollectionVersionResponse) SetHref(v string) {
	o.Href = &v
}

// GetCreatedAt returns the CreatedAt field value
func (o *CollectionVersionResponse) GetCreatedAt() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.CreatedAt
}

// GetCreatedAtOk returns a tuple with the CreatedAt field value
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetCreatedAtOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.CreatedAt, true
}

// SetCreatedAt sets field value
func (o *CollectionVersionResponse) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetUpdatedAt returns the UpdatedAt field value
func (o *CollectionVersionResponse) GetUpdatedAt() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.UpdatedAt
}

// GetUpdatedAtOk returns a tuple with the UpdatedAt field value
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetUpdatedAtOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.UpdatedAt, true
}

// SetUpdatedAt sets field value
func (o *CollectionVersionResponse) SetUpdatedAt(v time.Time) {
	o.UpdatedAt = v
}

// GetRequiresAnsible returns the RequiresAnsible field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *CollectionVersionResponse) GetRequiresAnsible() string {
	if o == nil || IsNil(o.RequiresAnsible.Get()) {
		var ret string
		return ret
	}
	return *o.RequiresAnsible.Get()
}

// GetRequiresAnsibleOk returns a tuple with the RequiresAnsible field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CollectionVersionResponse) GetRequiresAnsibleOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.RequiresAnsible.Get(), o.RequiresAnsible.IsSet()
}

// HasRequiresAnsible returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasRequiresAnsible() bool {
	if o != nil && o.RequiresAnsible.IsSet() {
		return true
	}

	return false
}

// SetRequiresAnsible gets a reference to the given NullableString and assigns it to the RequiresAnsible field.
func (o *CollectionVersionResponse) SetRequiresAnsible(v string) {
	o.RequiresAnsible.Set(&v)
}
// SetRequiresAnsibleNil sets the value for RequiresAnsible to be an explicit nil
func (o *CollectionVersionResponse) SetRequiresAnsibleNil() {
	o.RequiresAnsible.Set(nil)
}

// UnsetRequiresAnsible ensures that no value is present for RequiresAnsible, not even an explicit nil
func (o *CollectionVersionResponse) UnsetRequiresAnsible() {
	o.RequiresAnsible.Unset()
}

// GetMarks returns the Marks field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetMarks() []string {
	if o == nil || IsNil(o.Marks) {
		var ret []string
		return ret
	}
	return o.Marks
}

// GetMarksOk returns a tuple with the Marks field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetMarksOk() ([]string, bool) {
	if o == nil || IsNil(o.Marks) {
		return nil, false
	}
	return o.Marks, true
}

// HasMarks returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasMarks() bool {
	if o != nil && !IsNil(o.Marks) {
		return true
	}

	return false
}

// SetMarks gets a reference to the given []string and assigns it to the Marks field.
func (o *CollectionVersionResponse) SetMarks(v []string) {
	o.Marks = v
}

// GetArtifact returns the Artifact field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetArtifact() ArtifactRefResponse {
	if o == nil || IsNil(o.Artifact) {
		var ret ArtifactRefResponse
		return ret
	}
	return *o.Artifact
}

// GetArtifactOk returns a tuple with the Artifact field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetArtifactOk() (*ArtifactRefResponse, bool) {
	if o == nil || IsNil(o.Artifact) {
		return nil, false
	}
	return o.Artifact, true
}

// HasArtifact returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasArtifact() bool {
	if o != nil && !IsNil(o.Artifact) {
		return true
	}

	return false
}

// SetArtifact gets a reference to the given ArtifactRefResponse and assigns it to the Artifact field.
func (o *CollectionVersionResponse) SetArtifact(v ArtifactRefResponse) {
	o.Artifact = &v
}

// GetCollection returns the Collection field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetCollection() CollectionRefResponse {
	if o == nil || IsNil(o.Collection) {
		var ret CollectionRefResponse
		return ret
	}
	return *o.Collection
}

// GetCollectionOk returns a tuple with the Collection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetCollectionOk() (*CollectionRefResponse, bool) {
	if o == nil || IsNil(o.Collection) {
		return nil, false
	}
	return o.Collection, true
}

// HasCollection returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasCollection() bool {
	if o != nil && !IsNil(o.Collection) {
		return true
	}

	return false
}

// SetCollection gets a reference to the given CollectionRefResponse and assigns it to the Collection field.
func (o *CollectionVersionResponse) SetCollection(v CollectionRefResponse) {
	o.Collection = &v
}

// GetDownloadUrl returns the DownloadUrl field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetDownloadUrl() string {
	if o == nil || IsNil(o.DownloadUrl) {
		var ret string
		return ret
	}
	return *o.DownloadUrl
}

// GetDownloadUrlOk returns a tuple with the DownloadUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetDownloadUrlOk() (*string, bool) {
	if o == nil || IsNil(o.DownloadUrl) {
		return nil, false
	}
	return o.DownloadUrl, true
}

// HasDownloadUrl returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasDownloadUrl() bool {
	if o != nil && !IsNil(o.DownloadUrl) {
		return true
	}

	return false
}

// SetDownloadUrl gets a reference to the given string and assigns it to the DownloadUrl field.
func (o *CollectionVersionResponse) SetDownloadUrl(v string) {
	o.DownloadUrl = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *CollectionVersionResponse) SetName(v string) {
	o.Name = &v
}

// GetNamespace returns the Namespace field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetNamespace() CollectionNamespaceResponse {
	if o == nil || IsNil(o.Namespace) {
		var ret CollectionNamespaceResponse
		return ret
	}
	return *o.Namespace
}

// GetNamespaceOk returns a tuple with the Namespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetNamespaceOk() (*CollectionNamespaceResponse, bool) {
	if o == nil || IsNil(o.Namespace) {
		return nil, false
	}
	return o.Namespace, true
}

// HasNamespace returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasNamespace() bool {
	if o != nil && !IsNil(o.Namespace) {
		return true
	}

	return false
}

// SetNamespace gets a reference to the given CollectionNamespaceResponse and assigns it to the Namespace field.
func (o *CollectionVersionResponse) SetNamespace(v CollectionNamespaceResponse) {
	o.Namespace = &v
}

// GetSignatures returns the Signatures field value
func (o *CollectionVersionResponse) GetSignatures() []CollectionVersionSignatureResponse {
	if o == nil {
		var ret []CollectionVersionSignatureResponse
		return ret
	}

	return o.Signatures
}

// GetSignaturesOk returns a tuple with the Signatures field value
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetSignaturesOk() ([]CollectionVersionSignatureResponse, bool) {
	if o == nil {
		return nil, false
	}
	return o.Signatures, true
}

// SetSignatures sets field value
func (o *CollectionVersionResponse) SetSignatures(v []CollectionVersionSignatureResponse) {
	o.Signatures = v
}

// GetMetadata returns the Metadata field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetMetadata() CollectionMetadataResponse {
	if o == nil || IsNil(o.Metadata) {
		var ret CollectionMetadataResponse
		return ret
	}
	return *o.Metadata
}

// GetMetadataOk returns a tuple with the Metadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetMetadataOk() (*CollectionMetadataResponse, bool) {
	if o == nil || IsNil(o.Metadata) {
		return nil, false
	}
	return o.Metadata, true
}

// HasMetadata returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasMetadata() bool {
	if o != nil && !IsNil(o.Metadata) {
		return true
	}

	return false
}

// SetMetadata gets a reference to the given CollectionMetadataResponse and assigns it to the Metadata field.
func (o *CollectionVersionResponse) SetMetadata(v CollectionMetadataResponse) {
	o.Metadata = &v
}

// GetGitUrl returns the GitUrl field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetGitUrl() string {
	if o == nil || IsNil(o.GitUrl) {
		var ret string
		return ret
	}
	return *o.GitUrl
}

// GetGitUrlOk returns a tuple with the GitUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetGitUrlOk() (*string, bool) {
	if o == nil || IsNil(o.GitUrl) {
		return nil, false
	}
	return o.GitUrl, true
}

// HasGitUrl returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasGitUrl() bool {
	if o != nil && !IsNil(o.GitUrl) {
		return true
	}

	return false
}

// SetGitUrl gets a reference to the given string and assigns it to the GitUrl field.
func (o *CollectionVersionResponse) SetGitUrl(v string) {
	o.GitUrl = &v
}

// GetGitCommitSha returns the GitCommitSha field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetGitCommitSha() string {
	if o == nil || IsNil(o.GitCommitSha) {
		var ret string
		return ret
	}
	return *o.GitCommitSha
}

// GetGitCommitShaOk returns a tuple with the GitCommitSha field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetGitCommitShaOk() (*string, bool) {
	if o == nil || IsNil(o.GitCommitSha) {
		return nil, false
	}
	return o.GitCommitSha, true
}

// HasGitCommitSha returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasGitCommitSha() bool {
	if o != nil && !IsNil(o.GitCommitSha) {
		return true
	}

	return false
}

// SetGitCommitSha gets a reference to the given string and assigns it to the GitCommitSha field.
func (o *CollectionVersionResponse) SetGitCommitSha(v string) {
	o.GitCommitSha = &v
}

// GetManifest returns the Manifest field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetManifest() map[string]interface{} {
	if o == nil || IsNil(o.Manifest) {
		var ret map[string]interface{}
		return ret
	}
	return o.Manifest
}

// GetManifestOk returns a tuple with the Manifest field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetManifestOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Manifest) {
		return map[string]interface{}{}, false
	}
	return o.Manifest, true
}

// HasManifest returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasManifest() bool {
	if o != nil && !IsNil(o.Manifest) {
		return true
	}

	return false
}

// SetManifest gets a reference to the given map[string]interface{} and assigns it to the Manifest field.
func (o *CollectionVersionResponse) SetManifest(v map[string]interface{}) {
	o.Manifest = v
}

// GetFiles returns the Files field value if set, zero value otherwise.
func (o *CollectionVersionResponse) GetFiles() map[string]interface{} {
	if o == nil || IsNil(o.Files) {
		var ret map[string]interface{}
		return ret
	}
	return o.Files
}

// GetFilesOk returns a tuple with the Files field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionResponse) GetFilesOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Files) {
		return map[string]interface{}{}, false
	}
	return o.Files, true
}

// HasFiles returns a boolean if a field has been set.
func (o *CollectionVersionResponse) HasFiles() bool {
	if o != nil && !IsNil(o.Files) {
		return true
	}

	return false
}

// SetFiles gets a reference to the given map[string]interface{} and assigns it to the Files field.
func (o *CollectionVersionResponse) SetFiles(v map[string]interface{}) {
	o.Files = v
}

func (o CollectionVersionResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CollectionVersionResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Version) {
		toSerialize["version"] = o.Version
	}
	if !IsNil(o.Href) {
		toSerialize["href"] = o.Href
	}
	toSerialize["created_at"] = o.CreatedAt
	toSerialize["updated_at"] = o.UpdatedAt
	if o.RequiresAnsible.IsSet() {
		toSerialize["requires_ansible"] = o.RequiresAnsible.Get()
	}
	if !IsNil(o.Marks) {
		toSerialize["marks"] = o.Marks
	}
	if !IsNil(o.Artifact) {
		toSerialize["artifact"] = o.Artifact
	}
	if !IsNil(o.Collection) {
		toSerialize["collection"] = o.Collection
	}
	if !IsNil(o.DownloadUrl) {
		toSerialize["download_url"] = o.DownloadUrl
	}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.Namespace) {
		toSerialize["namespace"] = o.Namespace
	}
	toSerialize["signatures"] = o.Signatures
	if !IsNil(o.Metadata) {
		toSerialize["metadata"] = o.Metadata
	}
	if !IsNil(o.GitUrl) {
		toSerialize["git_url"] = o.GitUrl
	}
	if !IsNil(o.GitCommitSha) {
		toSerialize["git_commit_sha"] = o.GitCommitSha
	}
	if !IsNil(o.Manifest) {
		toSerialize["manifest"] = o.Manifest
	}
	if !IsNil(o.Files) {
		toSerialize["files"] = o.Files
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CollectionVersionResponse) UnmarshalJSON(bytes []byte) (err error) {
	varCollectionVersionResponse := _CollectionVersionResponse{}

	if err = json.Unmarshal(bytes, &varCollectionVersionResponse); err == nil {
		*o = CollectionVersionResponse(varCollectionVersionResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "version")
		delete(additionalProperties, "href")
		delete(additionalProperties, "created_at")
		delete(additionalProperties, "updated_at")
		delete(additionalProperties, "requires_ansible")
		delete(additionalProperties, "marks")
		delete(additionalProperties, "artifact")
		delete(additionalProperties, "collection")
		delete(additionalProperties, "download_url")
		delete(additionalProperties, "name")
		delete(additionalProperties, "namespace")
		delete(additionalProperties, "signatures")
		delete(additionalProperties, "metadata")
		delete(additionalProperties, "git_url")
		delete(additionalProperties, "git_commit_sha")
		delete(additionalProperties, "manifest")
		delete(additionalProperties, "files")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCollectionVersionResponse struct {
	value *CollectionVersionResponse
	isSet bool
}

func (v NullableCollectionVersionResponse) Get() *CollectionVersionResponse {
	return v.value
}

func (v *NullableCollectionVersionResponse) Set(val *CollectionVersionResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableCollectionVersionResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableCollectionVersionResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCollectionVersionResponse(val *CollectionVersionResponse) *NullableCollectionVersionResponse {
	return &NullableCollectionVersionResponse{value: val, isSet: true}
}

func (v NullableCollectionVersionResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCollectionVersionResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


