/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.StringTokenizer;
import javax.crypto.Mac;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.ENUMERATED;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkcs10.CertificationRequest;
import org.mozilla.jss.pkcs10.CertificationRequestInfo;
import org.mozilla.jss.pkix.cmc.CMCCertId;
import org.mozilla.jss.pkix.cmc.CMCStatusInfoV2;
import org.mozilla.jss.pkix.cmc.DecryptedPOP;
import org.mozilla.jss.pkix.cmc.EncryptedPOP;
import org.mozilla.jss.pkix.cmc.GetCert;
import org.mozilla.jss.pkix.cmc.IdentityProofV2;
import org.mozilla.jss.pkix.cmc.LraPopWitness;
import org.mozilla.jss.pkix.cmc.OtherInfo;
import org.mozilla.jss.pkix.cmc.PKIData;
import org.mozilla.jss.pkix.cmc.PendInfo;
import org.mozilla.jss.pkix.cmc.PopLinkWitnessV2;
import org.mozilla.jss.pkix.cmc.ResponseBody;
import org.mozilla.jss.pkix.cmc.RevokeRequest;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.pkix.cmc.TaggedCertificationRequest;
import org.mozilla.jss.pkix.cmc.TaggedRequest;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.EncapsulatedContentInfo;
import org.mozilla.jss.pkix.cms.EncryptedContentInfo;
import org.mozilla.jss.pkix.cms.EnvelopedData;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cms.RecipientInfo;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.pkix.cms.SignerIdentifier;
import org.mozilla.jss.pkix.cms.SignerInfo;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.crmf.POPOSigningKey;
import org.mozilla.jss.pkix.crmf.ProofOfPossession;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class CMCRequest {
    public static final String PR_REQUEST_CMC = "CMC";
    public static final String PR_REQUEST_CRMF = "CRMF";
    public static final int ARGC = 1;
    public static final String HEADER = "-----BEGIN";
    public static final String TRAILER = "-----END";
    public static SubjectKeyIdentifierExtension skiExtn = null;

    void cleanArgs(String[] s) {
    }

    public static X509Certificate getCertificate(String tokenName, String nickname) throws Exception {
        CryptoManager manager = CryptoManager.getInstance();
        CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenName);
        StringBuffer certname = new StringBuffer();
        if (!token.equals((Object)manager.getInternalKeyStorageToken())) {
            certname.append(tokenName);
            certname.append(":");
        }
        certname.append(nickname);
        try {
            return manager.findCertByNickname(certname.toString());
        }
        catch (ObjectNotFoundException e) {
            throw new IOException("Signing Certificate not found");
        }
    }

    public static PrivateKey getPrivateKey(String tokenName, String nickname) throws Exception {
        X509Certificate cert = CMCRequest.getCertificate(tokenName, nickname);
        if (cert != null) {
            System.out.println("getPrivateKey: got signing cert");
        }
        return CryptoManager.getInstance().findPrivKeyByCert(cert);
    }

    static SignatureAlgorithm getSigningAlgFromPrivate(PrivateKey privKey) {
        String method = "getSigningAlgFromPrivate: ";
        System.out.println(method + "begins.");
        if (privKey == null) {
            System.out.println(method + "method param privKey cannot be null");
            System.exit(1);
        }
        SignatureAlgorithm signAlg = null;
        String signingKeyType = privKey.getAlgorithm();
        System.out.println(method + "found signingKeyType=" + signingKeyType);
        if (signingKeyType.equalsIgnoreCase("RSA")) {
            signAlg = SignatureAlgorithm.RSASignatureWithSHA256Digest;
        } else if (signingKeyType.equalsIgnoreCase("EC")) {
            signAlg = SignatureAlgorithm.ECSignatureWithSHA256Digest;
        } else {
            System.out.println(method + "Algorithm not supported:" + signingKeyType);
            return null;
        }
        System.out.println(method + "using SignatureAlgorithm: " + signAlg.toString());
        return signAlg;
    }

    static SignedData signData(X509Certificate signerCert, String tokenName, String nickname, CryptoManager manager, PKIData pkidata) {
        String method = "signData: ";
        SignedData req = null;
        System.out.println(method + "begins: ");
        if (signerCert == null || tokenName == null || nickname == null || manager == null || pkidata == null) {
            System.out.println(method + "method parameters cannot be null");
            System.exit(1);
        }
        try {
            PrivateKey privKey = null;
            SignerIdentifier si = null;
            BigInteger serialno = signerCert.getSerialNumber();
            byte[] certB = signerCert.getEncoded();
            X509CertImpl impl = new X509CertImpl(certB);
            X500Name issuerName = impl.getIssuerName();
            byte[] issuerByte = issuerName.getEncoded();
            ByteArrayInputStream istream = new ByteArrayInputStream(issuerByte);
            Name issuer = (Name)Name.getTemplate().decode((InputStream)istream);
            IssuerAndSerialNumber ias = new IssuerAndSerialNumber(issuer, new INTEGER(serialno.toString()));
            si = new SignerIdentifier(SignerIdentifier.ISSUER_AND_SERIALNUMBER, ias, null);
            privKey = CMCRequest.getPrivateKey(tokenName, nickname);
            if (privKey != null) {
                System.out.println(method + " got signer privKey");
            } else {
                System.out.println(method + " signer privKey not foudn on token");
                System.exit(1);
            }
            X509Certificate[] certChain = manager.buildCertificateChain(signerCert);
            req = CMCRequest.createSignedData(privKey, si, certChain, pkidata);
            System.out.println(method + "signed request generated.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return req;
    }

    static SignedData signData(PrivateKey privKey, PKIData pkidata) {
        return CMCRequest.signData(privKey, pkidata, null);
    }

    static SignedData signData(PrivateKey privKey, PKIData pkidata, SignerIdentifier test_cmc_si) {
        String method = "signData for useSharedSecret begins: ";
        System.out.println(method + "begins: ");
        SignedData req = null;
        if (privKey == null || pkidata == null) {
            System.out.println(method + "method parameters cannot be null");
            System.exit(1);
        }
        KeyIdentifier keyIdObj = null;
        try {
            SignerIdentifier si = null;
            if (test_cmc_si == null) {
                keyIdObj = (KeyIdentifier)skiExtn.get("key_id");
                si = new SignerIdentifier(SignerIdentifier.SUBJECT_KEY_IDENTIFIER, null, new OCTET_STRING(keyIdObj.getIdentifier()));
            } else {
                si = test_cmc_si;
            }
            req = CMCRequest.createSignedData(privKey, si, null, pkidata);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return req;
    }

    static SignedData createSignedData(PrivateKey privKey, SignerIdentifier signerId, X509Certificate[] certChain, PKIData pkidata) {
        String method = "createSignedData: ";
        System.out.println(method + "begins");
        if (privKey == null || signerId == null || pkidata == null) {
            System.out.println(method + "method parameters cannot be null");
            System.exit(1);
        }
        SignedData req = null;
        try {
            EncapsulatedContentInfo ci = new EncapsulatedContentInfo(OBJECT_IDENTIFIER.id_cct_PKIData, (ASN1Value)pkidata);
            DigestAlgorithm digestAlg = null;
            SignatureAlgorithm signAlg = CMCRequest.getSigningAlgFromPrivate(privKey);
            if (signAlg == null) {
                return null;
            }
            MessageDigest SHADigest = null;
            byte[] digest = null;
            try {
                SHADigest = MessageDigest.getInstance("SHA256");
                digestAlg = DigestAlgorithm.SHA256;
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                pkidata.encode((OutputStream)ostream);
                digest = SHADigest.digest(ostream.toByteArray());
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println(e);
                System.exit(1);
            }
            System.out.println(method + "digest created for pkidata");
            SignerInfo signInfo = new SignerInfo(signerId, null, null, OBJECT_IDENTIFIER.id_cct_PKIData, digest, signAlg, (org.mozilla.jss.crypto.PrivateKey)privKey);
            String digestAlgName = signInfo.getDigestEncryptionAlgorithm().toString();
            System.out.println(method + "digest algorithm =" + digestAlgName);
            SET signInfos = new SET();
            signInfos.addElement((ASN1Value)signInfo);
            SET digestAlgs = new SET();
            if (digestAlg != null) {
                AlgorithmIdentifier ai = new AlgorithmIdentifier(digestAlg.toOID(), null);
                digestAlgs.addElement((ASN1Value)ai);
            }
            SET certs = new SET();
            if (certChain != null) {
                System.out.println(method + "building cert chain");
                for (int i = 0; i < certChain.length; ++i) {
                    ANY cert = new ANY(certChain[i].getEncoded());
                    certs.addElement((ASN1Value)cert);
                }
            }
            req = new SignedData(digestAlgs, ci, certs, null, signInfos);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return req;
    }

    static ContentInfo getCMCBlob(SignedData signedData, byte[] data) {
        String method = "getCMCBlob: ";
        System.out.println(method + "begins");
        ContentInfo fullEnrollmentReq = null;
        if (signedData != null && data == null) {
            System.out.println("getCMCBlob: generating signed data");
            fullEnrollmentReq = new ContentInfo(signedData);
        } else if (data != null && signedData == null) {
            System.out.println("getCMCBlob: generating unsigned data");
            fullEnrollmentReq = new ContentInfo(data);
        } else if (signedData == null && data == null) {
            System.out.println("getCMCBlob: both params are null");
            System.exit(1);
        } else {
            System.out.println("getCMCBlob: both params are not null; only one of them can be used, the other must be null");
            System.exit(1);
        }
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bs);
            if (fullEnrollmentReq != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                fullEnrollmentReq.encode((OutputStream)os);
                ps.print(Utils.base64encode((byte[])os.toByteArray(), (boolean)true));
            }
            String asciiBASE64Blob = bs.toString();
            System.out.println("");
            System.out.println("The CMC enrollment request in base-64 encoded format:");
            System.out.println("");
            System.out.println(asciiBASE64Blob);
        }
        catch (Exception e) {
            System.out.println(method + " Exception:" + e.toString());
            System.exit(1);
        }
        return fullEnrollmentReq;
    }

    static PKIData createPKIData(String useSharedSecret, String[] rValue, String format, String transactionMgtEnable, String transactionMgtId, String identificationEnable, String identification, String identityProofEnable, String identityProofSharedSecret, String witnessSharedSecret, String identityProofV2Enable, String identityProofV2hashAlg, String identityProofV2macAlg, String popLinkWitnessV2Enable, String popLinkWitnessV2keyGenAlg, String popLinkWitnessV2macAlg, SEQUENCE controlSeq, SEQUENCE otherMsgSeq, int bpid, CryptoToken token, org.mozilla.jss.crypto.PrivateKey privk) {
        String method = "createPKIData: ";
        System.out.println(method + "begins");
        PKIData pkidata = null;
        try {
            TaggedRequest trq = null;
            PKCS10 pkcs = null;
            CertReqMsg certReqMsg = null;
            CertReqMsg new_certReqMsg = null;
            CertRequest new_certreq = null;
            PopLinkWitnessV2 popLinkWitnessV2Control = null;
            if (popLinkWitnessV2Enable.equals("true") && (popLinkWitnessV2Control = CMCRequest.createPopLinkWitnessV2Attr(bpid, controlSeq, witnessSharedSecret, popLinkWitnessV2keyGenAlg, popLinkWitnessV2macAlg, identificationEnable.equals("true") ? identification : null)) == null) {
                System.out.println(method + "createPopLinkWitnessV2Attr returned null...exit");
                System.exit(1);
            }
            SEQUENCE reqSequence = new SEQUENCE();
            try {
                for (int k = 0; k < rValue.length; ++k) {
                    System.out.println("k=" + k);
                    String asciiBASE64Blob = rValue[k];
                    byte[] decodedBytes = Utils.base64decode((String)asciiBASE64Blob);
                    if (format.equals("crmf")) {
                        System.out.println(method + " format: crmf");
                        ByteArrayInputStream reqBlob = new ByteArrayInputStream(decodedBytes);
                        SEQUENCE crmfMsgs = null;
                        try {
                            crmfMsgs = (SEQUENCE)new SEQUENCE.OF_Template((ASN1Template)new CertReqMsg.Template()).decode((InputStream)reqBlob);
                        }
                        catch (InvalidBERException ee) {
                            System.out.println(method + " This is not a crmf request. Or this request has an error.");
                            System.exit(1);
                        }
                        certReqMsg = (CertReqMsg)crmfMsgs.elementAt(0);
                        CertRequest certReq = certReqMsg.getCertReq();
                        CertTemplate certTemplate = certReq.getCertTemplate();
                        if (useSharedSecret.equals("true")) {
                            skiExtn = (SubjectKeyIdentifierExtension)CryptoUtil.getExtensionFromCertTemplate((CertTemplate)certTemplate, (ObjectIdentifier)PKIXExtensions.SubjectKey_Id);
                            if (skiExtn != null) {
                                System.out.println(method + " SubjectKeyIdentifier extension found in use_shared_secret request");
                            } else {
                                System.out.println(method + " SubjectKeyIdentifier extension missing in use_shared_secret request");
                                System.exit(1);
                            }
                        }
                        if (popLinkWitnessV2Enable.equals("true")) {
                            System.out.println(method + "popLinkWitnessV2 enabled. reconstructing crmf");
                            INTEGER certReqId = certReq.getCertReqId();
                            SEQUENCE controls = certReq.getControls();
                            controls.addElement((ASN1Value)new AVA(OBJECT_IDENTIFIER.id_cmc_popLinkWitnessV2, (ASN1Value)popLinkWitnessV2Control));
                            new_certreq = new CertRequest(certReqId, certTemplate, controls);
                            ProofOfPossession new_pop = null;
                            if (certReqMsg.hasPop()) {
                                if (privk == null) {
                                    System.out.println(method + "privateKey not found; can't regenerate new POP");
                                    System.exit(1);
                                }
                                if (token == null) {
                                    System.out.println(method + "token not found; can't regenerate new POP");
                                    System.exit(1);
                                }
                                new_pop = CMCRequest.createNewPOP(certReqMsg, new_certreq, token, privk);
                            } else {
                                System.out.println(method + "old certReqMsg has no pop, so will the new certReqMsg");
                            }
                            new_certReqMsg = new CertReqMsg(new_certreq, new_pop, null);
                            SEQUENCE seq = new SEQUENCE();
                            seq.addElement((ASN1Value)new_certReqMsg);
                            byte[] encodedNewCrmfMessage = ASN1Util.encode((ASN1Value)seq);
                            String b64String = Utils.base64encode((byte[])encodedNewCrmfMessage, (boolean)true);
                            System.out.println(method + "new CRMF b64encode completes.");
                            System.out.println("-----BEGIN CERTIFICATE REQUEST-----");
                            System.out.println(b64String);
                            System.out.println("-----END CERTIFICATE REQUEST-----");
                            System.out.println("");
                            trq = new TaggedRequest(TaggedRequest.CRMF, null, new_certReqMsg);
                        } else {
                            trq = new TaggedRequest(TaggedRequest.CRMF, null, certReqMsg);
                        }
                    } else if (format.equals("pkcs10")) {
                        System.out.println(method + " format: pkcs10");
                        try {
                            pkcs = new PKCS10(decodedBytes, true);
                        }
                        catch (Exception e2) {
                            System.out.println(method + " Excception:" + e2.toString());
                            System.exit(1);
                        }
                        if (useSharedSecret.equals("true")) {
                            try {
                                skiExtn = (SubjectKeyIdentifierExtension)CryptoUtil.getExtensionFromPKCS10((PKCS10)pkcs, (String)"SubjectKeyIdentifier");
                            }
                            catch (IOException e) {
                                System.out.println(method + "getting SubjectKeyIdentifiere..." + e);
                            }
                            if (skiExtn != null) {
                                System.out.println(method + " SubjectKeyIdentifier extension found");
                            } else {
                                System.out.println(method + " SubjectKeyIdentifier extension missing");
                                System.exit(1);
                            }
                        }
                        ByteArrayInputStream crInputStream = new ByteArrayInputStream(pkcs.toByteArray());
                        CertificationRequest cr = (CertificationRequest)CertificationRequest.getTemplate().decode((InputStream)crInputStream);
                        if (popLinkWitnessV2Enable.equals("true")) {
                            System.out.println(method + "popLinkWitnessV2 enabled. reconstructing pkcs#10");
                            CertificationRequestInfo certReqInfo = cr.getInfo();
                            INTEGER version = certReqInfo.getVersion();
                            Name subject = certReqInfo.getSubject();
                            SubjectPublicKeyInfo spkInfo = certReqInfo.getSubjectPublicKeyInfo();
                            Attribute attr = new Attribute(OBJECT_IDENTIFIER.id_cmc_popLinkWitnessV2, (ASN1Value)popLinkWitnessV2Control);
                            SET attrs = certReqInfo.getAttributes();
                            if (attrs == null) {
                                attrs = new SET();
                            }
                            attrs.addElement((ASN1Value)attr);
                            System.out.println(method + " new pkcs#10 Attribute created for id_cmc_popLinkWitnessV2.");
                            SignatureAlgorithm signAlg = CMCRequest.getSigningAlgFromPrivate((PrivateKey)privk);
                            if (signAlg == null) {
                                System.out.println(method + "signAlg not found");
                                System.exit(1);
                            }
                            CertificationRequestInfo new_certReqInfo = new CertificationRequestInfo(version, subject, spkInfo, attrs);
                            System.out.println(method + " new pkcs#10 CertificationRequestInfo created.");
                            CertificationRequest new_certRequest = new CertificationRequest(new_certReqInfo, (PrivateKey)privk, signAlg);
                            System.out.println(method + "new pkcs#10 CertificationRequest created.");
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            new_certRequest.encode((OutputStream)bos);
                            byte[] bb = bos.toByteArray();
                            System.out.println(method + "calling Utils.b64encode.");
                            String b64String = Utils.base64encode((byte[])bb, (boolean)true);
                            System.out.println(method + "new PKCS#10 b64encode completes.");
                            System.out.println("-----BEGIN CERTIFICATE REQUEST-----");
                            System.out.println(b64String);
                            System.out.println("-----END CERTIFICATE REQUEST-----");
                            System.out.println("");
                            TaggedCertificationRequest tcr = new TaggedCertificationRequest(new INTEGER((long)bpid++), new_certRequest);
                            trq = new TaggedRequest(TaggedRequest.PKCS10, tcr, null);
                        } else {
                            TaggedCertificationRequest tcr = new TaggedCertificationRequest(new INTEGER((long)bpid++), cr);
                            trq = new TaggedRequest(TaggedRequest.PKCS10, tcr, null);
                        }
                    } else {
                        System.out.println(method + " Unrecognized request format: " + format);
                        System.exit(1);
                    }
                    reqSequence.addElement(trq);
                }
            }
            catch (Exception e) {
                System.out.println(method + " Exception:" + e);
                System.exit(1);
            }
            if (transactionMgtEnable.equals("true")) {
                bpid = CMCRequest.addTransactionAttr(bpid, controlSeq, transactionMgtId, format, pkcs, certReqMsg);
            }
            if (identificationEnable.equals("true")) {
                bpid = CMCRequest.addIdentificationAttr(bpid, controlSeq, identification);
            }
            if (identityProofV2Enable.equals("true")) {
                bpid = CMCRequest.addIdentityProofV2Attr(bpid, controlSeq, reqSequence, witnessSharedSecret, identificationEnable.equals("true") ? identification : null, identityProofV2hashAlg, identityProofV2macAlg);
            } else if (identityProofEnable.equals("true")) {
                bpid = CMCRequest.addIdentityProofAttr(bpid, controlSeq, reqSequence, identityProofSharedSecret);
            }
            pkidata = new PKIData(controlSeq, reqSequence, new SEQUENCE(), otherMsgSeq);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return pkidata;
    }

    static ProofOfPossession createNewPOP(CertReqMsg old_certReqMsg, CertRequest new_certReq, CryptoToken token, org.mozilla.jss.crypto.PrivateKey privKey) {
        ProofOfPossession old_pop;
        String method = "createNewPOP: ";
        System.out.println(method + "begins");
        if (old_certReqMsg == null || new_certReq == null || token == null || privKey == null) {
            System.out.println(method + "method params cannot be null.");
            System.exit(1);
        }
        if ((old_pop = old_certReqMsg.getPop()) == null) {
            System.out.println(method + "no pop in old_certReqMsg.");
            System.exit(1);
        }
        POPOSigningKey PopOfsignKey = old_pop.getSignature();
        AlgorithmIdentifier algId = PopOfsignKey.getAlgorithmIdentifier();
        byte[] signature = null;
        try {
            SignatureAlgorithm signAlg = SignatureAlgorithm.fromOID((OBJECT_IDENTIFIER)algId.getOID());
            Signature signer = token.getSignatureContext(signAlg);
            signer.initSign(privKey);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            new_certReq.encode((OutputStream)bo);
            signer.update(bo.toByteArray());
            signature = signer.sign();
        }
        catch (Exception e) {
            System.out.println(method + e);
            System.exit(1);
        }
        System.out.println(method + "about to create POPOSigningKey");
        POPOSigningKey newPopOfSigningKey = new POPOSigningKey(null, algId, new BIT_STRING(signature, 0));
        System.out.println(method + "creating and returning newPopOfSigningKey");
        return ProofOfPossession.createSignature((POPOSigningKey)newPopOfSigningKey);
    }

    static void printUsage() {
        System.out.println("");
        System.out.println("Usage: CMCRequest <configuration file>");
        System.out.println("For example, CMCRequest CMCRequest.cfg");
        System.out.println("");
        System.out.println("The configuration file should look like as follows:");
        System.out.println("");
        System.out.println("#decryptedPop.enable: if true, this is in response to an encryptedPOP request from the server from previous request;");
        System.out.println("#    most all options other than the following are ignored:");
        System.out.println("# encryptedPopResponseFile, privKeyId, decryptedPopRequestFile");
        System.out.println("# where");
        System.out.println("#   encryptPopResponse was the output from previous request, and is now an input to the new request that is about to be generated");
        System.out.println("#   decryptedPopRequestFile is the output that is to be sent to the server as 2nd trip request in response to encryptedPOP");
        System.out.println("#   privKeyId: used for decrypting the encryptedPOP and creating decryptedPOP");
        System.out.println("");
        System.out.println("decryptedPop.enable=false");
        System.out.println("encryptedPopResponseFile=cmc.resp");
        System.out.println("request.privKeyId=");
        System.out.println("decryptedPopRequestFile=cmc.decreyptedPOP.req");
        System.out.println("");
        System.out.println("#numRequests: Total number of PKCS10 requests or CRMF requests.");
        System.out.println("numRequests=1");
        System.out.println("");
        System.out.println("#input: full path for the PKCS10 request or CRMF request,");
        System.out.println("#the content must be in Base-64 encoded format");
        System.out.println("# in case of revocation, input will be ignored");
        System.out.println("input=crmf.req");
        System.out.println("");
        System.out.println("#output: full path for the CMC request in binary format");
        System.out.println("output=cmc.req");
        System.out.println("");
        System.out.println("#tokenname: name of token where user signing cert can be found (default is internal)");
        System.out.println("tokenname=internal");
        System.out.println("");
        System.out.println("#nickname: nickname for user certificate which will be used");
        System.out.println("#to sign the CMC full request (enrollment or revocation).");
        System.out.println("");
        System.out.println("#request.useSharedSecret: if request.useSharedSecret is true, the CMC request will be");
        System.out.println("#signed with the pairing private key of the enrollment request;");
        System.out.println("#and in which case the nickname will be ignored");
        System.out.println("#If revRequest.sharedSecret is specified, then nickname will also be ignored.");
        System.out.println("nickname=CMS User Signing Certificate");
        System.out.println("");
        System.out.println("request.useSharedSecret=false");
        System.out.println("");
        System.out.println("#dbdir: directory for NSS database");
        System.out.println("dbdir=./");
        System.out.println("");
        System.out.println("#password: password for NSS database which stores the user signing");
        System.out.println("#certificate and keys");
        System.out.println("password=pass");
        System.out.println("");
        System.out.println("#format: request format, either pkcs10 or crmf");
        System.out.println("format=crmf");
        System.out.println("");
        System.out.println("#confirmCertAcceptance.enable: if true, then the request will");
        System.out.println("#contain this control. Otherwise, false.");
        System.out.println("confirmCertAcceptance.enable=false");
        System.out.println("");
        System.out.println("#confirmCertAcceptance.serial: The serial number for");
        System.out.println("#confirmCertAcceptance control");
        System.out.println("confirmCertAcceptance.serial=3");
        System.out.println("");
        System.out.println("#confirmCertAcceptance.issuer: The issuer name for");
        System.out.println("#confirmCertAcceptance control");
        System.out.println("confirmCertAcceptance.issuer=cn=Certificate Manager,c=us");
        System.out.println("");
        System.out.println("#getCert.enable: if true, then the request will contain this");
        System.out.println("#control. Otherwise, false.");
        System.out.println("getCert.enable=false");
        System.out.println("");
        System.out.println("#getCert.serial: The serial number for getCert control");
        System.out.println("getCert.serial=3");
        System.out.println("");
        System.out.println("#getCert.issuer: The issuer name for getCert control");
        System.out.println("getCert.issuer=cn=Certificate Manager,c=us");
        System.out.println("");
        System.out.println("#dataReturn.enable: if true, then the request will contain");
        System.out.println("#this control. Otherwise, false.");
        System.out.println("dataReturn.enable=false");
        System.out.println("");
        System.out.println("#dataReturn.data: data contained in the control.");
        System.out.println("dataReturn.data=test");
        System.out.println("");
        System.out.println("#transactionMgt.enable: if true, then the request will contain");
        System.out.println("#this control. Otherwise, false.");
        System.out.println("transactionMgt.enable=false");
        System.out.println("");
        System.out.println("#transactionMgt.id: transaction identifier. Verisign recommend");
        System.out.println("#transactionId to be MD5 hash of publicKey.");
        System.out.println("transactionMgt.id=");
        System.out.println("");
        System.out.println("#senderNonce.enable: if true, then the request will contain this");
        System.out.println("#control. Otherwise, false.");
        System.out.println("senderNonce.enable=false");
        System.out.println("");
        System.out.println("#senderNonce.id: sender nonce");
        System.out.println("senderNonce.id=");
        System.out.println("");
        System.out.println("#revRequest.enable: if true, then the request will contain this");
        System.out.println("#control. Otherwise, false.");
        System.out.println("revRequest.enable=false");
        System.out.println("");
        System.out.println("#revRequest.issuer: The issuer name for the certificate being");
        System.out.println("#revoked. It only needs to be specified when the request is unsigned,;");
        System.out.println("#as in the case when sharedSecret is used;");
        System.out.println("revRequest.issuer=cn=Certificate Manager,c=us");
        System.out.println("");
        System.out.println("#revRequest.sharedSecret: The sharedSecret");
        System.out.println("revRequest.sharedSecret=");
        System.out.println("");
        System.out.println("#revRequest.serial: The serial number for the certificate being");
        System.out.println("#revoked.");
        System.out.println("revRequest.serial=61");
        System.out.println("");
        System.out.println("#revRequest.reason: The reason for revoking this certificate: ");
        System.out.println("#                   unspecified, keyCompromise, caCompromise,");
        System.out.println("#                   affiliationChanged, superseded, cessationOfOperation,");
        System.out.println("#                   certificateHold, removeFromCRL");
        System.out.println("revRequest.reason=unspecified");
        System.out.println("");
        System.out.println("#revRequest.comment: The human readable comment");
        System.out.println("revRequest.comment=");
        System.out.println("");
        System.out.println("#revRequest.invalidityDatePresent: if true, the current time will be the");
        System.out.println("#                                  invalidityDate. If false, no invalidityDate");
        System.out.println("#                                  is present.");
        System.out.println("revRequest.invalidityDatePresent=false");
        System.out.println("");
        System.out.println("#identityProofV2.enable: if true, then the request will contain");
        System.out.println("#this control. Otherwise, false.");
        System.out.println("#Note that if both identityProof and identityProofV2");
        System.out.println("#  are enabled, identityProofV2 takes precedence; Only one of them can be active at a time");
        System.out.println("#Supported hashAlg are:");
        System.out.println("# SHA-256, SHA-384, and SHA-512");
        System.out.println("#Supported macAlg are:");
        System.out.println("# SHA-256-HMAC, SHA-384-HMAC, and SHA-512-HMAC");
        System.out.println("identityProofV2.enable=false");
        System.out.println("identityProofV2.hashAlg=SHA-256");
        System.out.println("identityProofV2.macAlg=SHA-256-HMAC");
        System.out.println("");
        System.out.println("#witness.sharedSecret works with identityProofV2 and popLinkWitnessV2");
        System.out.println("#witness.sharedSecret: Shared Secret");
        System.out.println("witness.sharedSecret=testing");
        System.out.println("");
        System.out.println("#identification works with identityProofV2 and popLinkWitnessV2");
        System.out.println("identification.enable=false");
        System.out.println("identification=testuser");
        System.out.println("");
        System.out.println("#popLinkWitnessV2.enable:  if true, then the underlying request will contain");
        System.out.println("#this control or attribute. Otherwise, false.");
        System.out.println("#Supported keyGenAlg are:");
        System.out.println("# SHA-256, SHA-384, and SHA-512");
        System.out.println("#Supported macAlg are:");
        System.out.println("# SHA-256-HMAC, SHA-384-HMAC, and SHA-512-HMAC");
        System.out.println("popLinkWitnessV2.enable=false");
        System.out.println("popLinkWitnessV2.keyGenAlg=SHA-256");
        System.out.println("popLinkWitnessV2.macAlg=SHA-256-HMAC");
        System.out.println("");
        System.out.println("");
        System.out.println("###############################");
        System.out.println("Note: The following controls are outdated and replaced by newer");
        System.out.println("      controls above.  They remain untouched, but also untested.");
        System.out.println("###############################");
        System.out.println("#identityProof.enable: if true, then the request will contain");
        System.out.println("#this control. Otherwise, false.");
        System.out.println("#Note that this control is updated by identityProofV2 above");
        System.out.println("identityProof.enable=false");
        System.out.println("");
        System.out.println("#identityProof.sharedSecret: Shared Secret");
        System.out.println("identityProof.sharedSecret=testing");
        System.out.println("");
        System.out.println("#popLinkWitness.enable:  if true, then the request will contain");
        System.out.println("#this control. Otherwise, false.");
        System.out.println("#If you want to test this control, make sure to use CRMFPopClient ");
        System.out.println("# to generate the CRMF request which will include the ");
        System.out.println("#idPOPLinkWitness attribute in the controls section of the ");
        System.out.println("#CertRequest structure.");
        System.out.println("popLinkWitness.enable=false");
        System.out.println("");
        System.out.println("#LraPopWitness.enable: if true, then the request will contain this");
        System.out.println("#control. Otherwise, false.");
        System.out.println("LraPopWitness.enable=false");
        System.out.println("");
        System.out.println("#LraPopWitness.bodyPartIDs: List of body part IDs");
        System.out.println("#Each id is separated by space.");
        System.out.println("LraPopWitness.bodyPartIDs=1");
        System.exit(1);
    }

    private static int addLraPopWitnessAttr(int bpid, SEQUENCE seq, String bodyPartIDs) {
        StringTokenizer tokenizer = new StringTokenizer(bodyPartIDs, " ");
        SEQUENCE bodyList = new SEQUENCE();
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            bodyList.addElement((ASN1Value)new INTEGER(s));
        }
        LraPopWitness lra = new LraPopWitness(new INTEGER(0L), bodyList);
        TaggedAttribute cont = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_lraPOPWitness, (ASN1Value)lra);
        System.out.println("Successfully create LRA POP witness control. bpid = " + (bpid - 1));
        System.out.println("");
        seq.addElement((ASN1Value)cont);
        return bpid;
    }

    private static int addConfirmCertAttr(int bpid, SEQUENCE seq, String confirmCertIssuer, String confirmCertSerial) {
        try {
            INTEGER serial = new INTEGER(confirmCertSerial);
            X500Name issuername = new X500Name(confirmCertIssuer);
            byte[] issuerbyte = issuername.getEncoded();
            ANY issuern = new ANY(issuerbyte);
            CMCCertId cmcCertId = new CMCCertId(issuern, serial, null);
            TaggedAttribute cmcCertIdControl = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_idConfirmCertAcceptance, (ASN1Value)cmcCertId);
            System.out.println("Successfully create confirm certificate acceptance control. bpid = " + (bpid - 1));
            System.out.println("");
            seq.addElement((ASN1Value)cmcCertIdControl);
        }
        catch (Exception e) {
            System.out.println("Error in creating confirm certificate acceptance control. Check the parameters.");
            System.exit(1);
        }
        return bpid;
    }

    private static ENUMERATED toCRLReason(String str) {
        if (str.equalsIgnoreCase("unspecified")) {
            return RevokeRequest.unspecified;
        }
        if (str.equalsIgnoreCase("keyCompromise")) {
            return RevokeRequest.keyCompromise;
        }
        if (str.equalsIgnoreCase("caCompromise")) {
            return RevokeRequest.cACompromise;
        }
        if (str.equalsIgnoreCase("affiliationChanged")) {
            return RevokeRequest.affiliationChanged;
        }
        if (str.equalsIgnoreCase("superseded")) {
            return RevokeRequest.superseded;
        }
        if (str.equalsIgnoreCase("cessationOfOperation")) {
            return RevokeRequest.cessationOfOperation;
        }
        if (str.equalsIgnoreCase("certificateHold")) {
            return RevokeRequest.certificateHold;
        }
        if (str.equalsIgnoreCase("removeFromCRL")) {
            return RevokeRequest.removeFromCRL;
        }
        System.out.println("Unrecognized CRL reason");
        System.exit(1);
        return RevokeRequest.unspecified;
    }

    private static int addIdentityProofV2Attr(int bpid, SEQUENCE seq, SEQUENCE reqSequence, String sharedSecret, String ident, String hashAlgString, String macAlgString) {
        AlgorithmIdentifier macAlg;
        AlgorithmIdentifier hashAlg;
        String method = "CMCRequest: addIdentityProofV2Attr: ";
        byte[] b = ASN1Util.encode((ASN1Value)reqSequence);
        byte[] key = null;
        byte[] finalDigest = null;
        if (hashAlgString == null) {
            hashAlgString = "SHA-256";
        }
        if (macAlgString == null) {
            macAlgString = "SHA-256-HMAC";
        }
        System.out.println(method + "hashAlg=" + hashAlgString + "; macAlg=" + macAlgString);
        Object toBeDigested = sharedSecret;
        if (ident != null) {
            toBeDigested = sharedSecret + ident;
        }
        try {
            MessageDigest hash = MessageDigest.getInstance(hashAlgString);
            key = hash.digest(((String)toBeDigested).getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println(method + "No such algorithm!");
            return -1;
        }
        try {
            Mac hmac = Mac.getInstance(CryptoUtil.getHMACAlgName((String)macAlgString), "Mozilla-JSS");
            Key secKey = CryptoUtil.importHmacSha1Key((byte[])key);
            hmac.init(secKey);
            hmac.update(b);
            finalDigest = hmac.doFinal();
        }
        catch (Exception ex) {
            System.out.println(method + "Can't calucualte hmac digest: " + ex);
            return -1;
        }
        try {
            hashAlg = new AlgorithmIdentifier(CryptoUtil.getHashAlgorithmOID((String)hashAlgString));
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println(method + "No such hashing algorithm:" + hashAlgString);
            return -1;
        }
        try {
            macAlg = new AlgorithmIdentifier(CryptoUtil.getHMACAlgorithmOID((String)macAlgString));
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println(method + "No such HMAC algorithm:" + macAlgString);
            return -1;
        }
        IdentityProofV2 idV2val = new IdentityProofV2(hashAlg, macAlg, new OCTET_STRING(finalDigest));
        TaggedAttribute identityProofV2 = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_identityProofV2, (ASN1Value)idV2val);
        seq.addElement((ASN1Value)identityProofV2);
        System.out.println("Identity Proof V2 control: ");
        System.out.print("   Value: ");
        for (int i = 0; i < finalDigest.length; ++i) {
            System.out.print(finalDigest[i] + " ");
        }
        System.out.println("");
        System.out.println("Successfully create identityProofV2 control. bpid = " + (bpid - 1));
        System.out.println("");
        return bpid;
    }

    private static int addIdentityProofAttr(int bpid, SEQUENCE seq, SEQUENCE reqSequence, String sharedSecret) {
        byte[] b = ASN1Util.encode((ASN1Value)reqSequence);
        byte[] key = null;
        byte[] finalDigest = null;
        try {
            MessageDigest SHA1Digest = MessageDigest.getInstance("SHA1");
            key = SHA1Digest.digest(sharedSecret.getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("CMCRequest::addIdentityProofAttr() - No such algorithm!");
            return -1;
        }
        try {
            Mac hmac = Mac.getInstance("HmacSHA1", "Mozilla-JSS");
            Key secKey = CryptoUtil.importHmacSha1Key((byte[])key);
            hmac.init(secKey);
            hmac.update(b);
            finalDigest = hmac.doFinal();
        }
        catch (Exception ex) {
            System.out.println("CMCRequest::addIdentityProofAttr() - Can't calculate hmac Digest!");
            return -1;
        }
        TaggedAttribute identityProof = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_identityProof, (ASN1Value)new OCTET_STRING(finalDigest));
        seq.addElement((ASN1Value)identityProof);
        System.out.println("Identity Proof control: ");
        System.out.print("   Value: ");
        for (int i = 0; i < finalDigest.length; ++i) {
            System.out.print(finalDigest[i] + " ");
        }
        System.out.println("");
        System.out.println("Successfully create identityProof control. bpid = " + (bpid - 1));
        System.out.println("");
        return bpid;
    }

    private static int addRevRequestAttr(int bpid, SEQUENCE seq, CryptoToken token, X509Certificate revokeSignCert, String revRequestIssuer, String revRequestSerial, String revRequestReason, String revRequestSharedSecret, String revRequestComment, String invalidityDatePresent, CryptoManager manager) {
        String method = "addRevRequestAttr: ";
        try {
            UTF8String comment = null;
            OCTET_STRING sharedSecret = null;
            GeneralizedTime d = null;
            X500Name issuerName = null;
            if (revRequestSerial == null || revRequestSerial.length() <= 0) {
                System.out.println(method + "revocation serial number must be supplied");
                System.exit(1);
            }
            if (revRequestReason == null || revRequestReason.length() <= 0) {
                System.out.println(method + "revocation reason must be supplied");
                System.exit(1);
            }
            CertId certId = new CertId(revRequestSerial);
            INTEGER snumber = new INTEGER(certId.toBigInteger());
            ENUMERATED reason = CMCRequest.toCRLReason(revRequestReason);
            if (revRequestSharedSecret != null && revRequestSharedSecret.length() > 0) {
                sharedSecret = new OCTET_STRING(revRequestSharedSecret.getBytes());
                if (revRequestIssuer == null) {
                    System.out.println(method + "issuer name must be supplied when shared secret is used");
                    System.exit(1);
                }
                System.out.println(method + "adding revRequestIssuer: " + revRequestIssuer);
                issuerName = new X500Name(revRequestIssuer);
            } else if (revokeSignCert == null) {
                System.out.println(method + "revokeSignCert must be supplied in the signing case");
                System.exit(1);
            }
            if (revRequestComment != null && revRequestComment.length() > 0) {
                comment = new UTF8String(revRequestComment);
            }
            if (invalidityDatePresent.equals("true")) {
                d = new GeneralizedTime(new Date());
            }
            if (sharedSecret == null) {
                System.out.println(method + "no sharedSecret found; request will be signed;");
                byte[] certB = revokeSignCert.getEncoded();
                X509CertImpl impl = new X509CertImpl(certB);
                issuerName = impl.getIssuerName();
            } else {
                System.out.println(method + "sharedSecret found; request will be unsigned;");
            }
            RevokeRequest revRequest = new RevokeRequest(new ANY(issuerName.getEncoded()), snumber, reason, d, sharedSecret, comment);
            TaggedAttribute revRequestControl = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_revokeRequest, (ASN1Value)revRequest);
            seq.addElement((ASN1Value)revRequestControl);
            System.out.println(method + "RevokeRequest control created.");
            return bpid;
        }
        catch (Exception e) {
            System.out.println("Error in creating revRequest control. Check the parameters. Exception=" + e.toString());
            System.exit(1);
            return bpid;
        }
    }

    private static int addGetCertAttr(int bpid, SEQUENCE seq, String issuer, String serial) {
        try {
            INTEGER serialno = new INTEGER(serial);
            X500Name issuername = new X500Name(issuer);
            byte[] issuerbyte = issuername.getEncoded();
            ANY issuern = new ANY(issuerbyte);
            GetCert getCert = new GetCert(issuern, serialno);
            TaggedAttribute getCertControl = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_getCert, (ASN1Value)getCert);
            System.out.println("Successfully create get certificate control. bpid = " + (bpid - 1));
            System.out.println("");
            seq.addElement((ASN1Value)getCertControl);
        }
        catch (Exception e) {
            System.out.println("Error in creating get certificate control. Check the parameters." + e);
            System.exit(1);
        }
        return bpid;
    }

    private static int addDataReturnAttr(int bpid, SEQUENCE seq, String str) {
        try {
            byte[] bvalue = str.getBytes();
            System.out.println("Data Return Control: ");
            StringBuffer ss = new StringBuffer("   Value: ");
            for (int m = 0; m < bvalue.length; ++m) {
                ss.append(bvalue[m] + " ");
            }
            System.out.println(ss.toString());
            OCTET_STRING s = new OCTET_STRING(bvalue);
            TaggedAttribute dataReturnControl = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_dataReturn, (ASN1Value)s);
            seq.addElement((ASN1Value)dataReturnControl);
            System.out.println("Successfully create data return control. bpid = " + (bpid - 1));
            System.out.println("");
        }
        catch (Exception e) {
            System.out.println("Error in creating data return control. Check the parameters.");
            System.exit(1);
        }
        return bpid;
    }

    private static int addTransactionAttr(int bpid, SEQUENCE seq, String id, String format, PKCS10 pkcs, CertReqMsg certReqMsg) {
        byte[] transId = null;
        Date date = new Date();
        String salt = "lala123" + date.toString();
        if (id == null || id.equals("")) {
            try {
                MessageDigest MD5Digest = MessageDigest.getInstance("MD5");
                if (format.equals("crmf")) {
                    CertRequest certreq = certReqMsg.getCertReq();
                    CertTemplate certTemplate = certreq.getCertTemplate();
                    SubjectPublicKeyInfo pkinfo = certTemplate.getPublicKey();
                    BIT_STRING bitString = pkinfo.getSubjectPublicKey();
                    byte[] b = bitString.getBits();
                    transId = MD5Digest.digest(b);
                } else if (format.equals("pkcs10")) {
                    transId = MD5Digest.digest(pkcs.getSubjectPublicKeyInfo().getKey());
                }
            }
            catch (Exception ex) {
                transId = salt.getBytes();
            }
        } else {
            transId = id.getBytes();
        }
        if (transId == null) {
            System.out.println("CMCRequest::addTransactionAttr() - transId is null!");
            return -1;
        }
        INTEGER ii = new INTEGER(1, transId);
        TaggedAttribute transactionId = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_transactionId, (ASN1Value)ii);
        System.out.println("Transaction ID control: ");
        System.out.println("   Value: " + ii.toString());
        System.out.println("Successfully create transaction management control. bpid = " + (bpid - 1));
        System.out.println("");
        seq.addElement((ASN1Value)transactionId);
        return bpid;
    }

    private static int addSenderNonceAttr(int bpid, SEQUENCE seq, String nonce) {
        String sn = nonce;
        if (nonce == null || nonce.equals("")) {
            byte[] dig;
            Date date = new Date();
            String salt = "lala123" + date.toString();
            try {
                MessageDigest SHA256Digest = MessageDigest.getInstance("SHA256");
                dig = SHA256Digest.digest(salt.getBytes());
            }
            catch (NoSuchAlgorithmException ex) {
                dig = salt.getBytes();
            }
            sn = Utils.base64encode((byte[])dig, (boolean)true);
        }
        byte[] bb = sn.getBytes();
        System.out.println("SenderNonce control: ");
        StringBuffer ss = new StringBuffer("   Value: ");
        for (int m = 0; m < bb.length; ++m) {
            ss.append(bb[m] + " ");
        }
        System.out.println(ss.toString());
        TaggedAttribute senderNonce = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_senderNonce, (ASN1Value)new OCTET_STRING(sn.getBytes()));
        System.out.println("Successfully create sender nonce control. bpid = " + (bpid - 1));
        System.out.println("");
        seq.addElement((ASN1Value)senderNonce);
        return bpid;
    }

    private static int addIdentificationAttr(int bpid, SEQUENCE seq, String ident) {
        UTF8String ident_s = null;
        if (ident == null) {
            System.out.println("Error in creating identification control: identification null");
            System.exit(1);
        } else {
            System.out.println("identification control: identification =" + ident);
        }
        try {
            if (ident.length() > 0) {
                ident_s = new UTF8String(ident);
            }
        }
        catch (CharConversionException e) {
            System.out.println("Error in creating identification control:" + e.toString());
            System.exit(1);
        }
        TaggedAttribute identVal = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_identification, (ASN1Value)ident_s);
        System.out.println("Successfully create identification control. bpid = " + (bpid - 1));
        System.out.println("");
        seq.addElement((ASN1Value)identVal);
        return bpid;
    }

    private static PopLinkWitnessV2 createPopLinkWitnessV2Attr(int bpid, SEQUENCE controlSeq, String sharedSecret, String keyGenAlgString, String macAlgString, String ident) {
        AlgorithmIdentifier macAlg;
        AlgorithmIdentifier keyGenAlg;
        String method = "createPopLinkWitnessV2Attr: ";
        System.out.println(method + "begins");
        if (sharedSecret == null) {
            System.out.println(method + "method param sharedSecret cannot be null");
            System.exit(1);
        }
        byte[] key = null;
        byte[] finalDigest = null;
        SecureRandom random = null;
        try {
            random = CryptoUtil.getRandomNumberGenerator();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        byte[] random_R = new byte[64];
        random.nextBytes(random_R);
        if (keyGenAlgString == null) {
            keyGenAlgString = "SHA-256";
        }
        if (macAlgString == null) {
            macAlgString = "SHA-256-HMAC";
        }
        System.out.println(method + "keyGenAlg=" + keyGenAlgString + "; macAlg=" + macAlgString);
        Object toBeDigested = sharedSecret;
        if (ident != null) {
            toBeDigested = sharedSecret + ident;
        }
        try {
            MessageDigest hash = MessageDigest.getInstance(keyGenAlgString);
            key = hash.digest(((String)toBeDigested).getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println(method + "No such algorithm!");
            return null;
        }
        try {
            Mac hmac = Mac.getInstance(CryptoUtil.getHMACAlgName((String)macAlgString), "Mozilla-JSS");
            Key secKey = CryptoUtil.importHmacSha1Key((byte[])key);
            hmac.init(secKey);
            hmac.update(random_R);
            finalDigest = hmac.doFinal();
        }
        catch (Exception ex) {
            System.out.println(method + "Can't calculate Hmac digest! " + ex);
            return null;
        }
        TaggedAttribute idPOPLinkRandom = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_idPOPLinkRandom, (ASN1Value)new OCTET_STRING(random_R));
        controlSeq.addElement((ASN1Value)idPOPLinkRandom);
        System.out.println(method + "Successfully created id_cmc_idPOPLinkRandom control. bpid = " + (bpid - 1));
        try {
            keyGenAlg = new AlgorithmIdentifier(CryptoUtil.getHashAlgorithmOID((String)keyGenAlgString));
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println(method + "No such hashing algorithm:" + keyGenAlgString);
            return null;
        }
        try {
            macAlg = new AlgorithmIdentifier(CryptoUtil.getHMACAlgorithmOID((String)macAlgString));
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println(method + "No such HMAC algorithm:" + macAlgString);
            return null;
        }
        PopLinkWitnessV2 popLinkWitnessV2 = new PopLinkWitnessV2(keyGenAlg, macAlg, new OCTET_STRING(finalDigest));
        System.out.println(method + "Successfully created PopLinkWitnessV2 control.");
        System.out.println(method + "returning...");
        System.out.println("");
        return popLinkWitnessV2;
    }

    private static int addPopLinkWitnessAttr(int bpid, SEQUENCE controlSeq) {
        byte[] seed = new byte[]{16, 83, 66, 36, 26, 42, 53, 60, 122, 82, 84, 86, 113, 101, 102, 76, 81, 52, 53, 35, 60, 66, 67, 69, 97, 79, 110, 67, 30, 42, 43, 49, 50, 52, 53, 54, 85, 81, 72, 20, 22, 41, 65, 66, 67, 123, 99, 68, 106, 18, 107, 60, 76, 63, 0, 20, 81, 97, 21, 34, 35, 95, 94, 105};
        TaggedAttribute idPOPLinkRandom = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_idPOPLinkRandom, (ASN1Value)new OCTET_STRING(seed));
        controlSeq.addElement((ASN1Value)idPOPLinkRandom);
        System.out.println("Successfully create PopLinkWitness control. bpid = " + (bpid - 1));
        System.out.println("");
        return bpid;
    }

    private static Object[] processEncryptedPopResponse(String prevResponse) {
        EncryptedPOP encryptedPop = null;
        String reqIdString = null;
        OCTET_STRING reqIdOS = null;
        String method = "processEncryptedPopResponse: ";
        System.out.println(method + " begins.");
        byte[] bb = new byte[10000];
        try (FileInputStream fis = new FileInputStream(prevResponse);){
            while (((InputStream)fis).available() > 0) {
                ((InputStream)fis).read(bb, 0, 10000);
            }
        }
        catch (Exception e) {
            System.out.println(method + "Error reading the response. Exception: " + e.toString());
            System.exit(1);
        }
        System.out.println(method + " previous response read.");
        SignedData cmcFullResp = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bb);
            ContentInfo cii = (ContentInfo)ContentInfo.getTemplate().decode((InputStream)bis);
            cmcFullResp = (SignedData)cii.getInterpretedContent();
            EncapsulatedContentInfo ci = cmcFullResp.getContentInfo();
            OBJECT_IDENTIFIER id = ci.getContentType();
            OBJECT_IDENTIFIER dataid = new OBJECT_IDENTIFIER("1.2.840.113549.1.7.1");
            if (!id.equals((Object)OBJECT_IDENTIFIER.id_cct_PKIResponse) && !id.equals((Object)dataid)) {
                System.out.println(method + "Invalid CMC Response Format");
            }
            if (!ci.hasContent()) {
                return null;
            }
            OCTET_STRING content1 = ci.getContent();
            ByteArrayInputStream bbis = new ByteArrayInputStream(content1.toByteArray());
            ResponseBody responseBody = (ResponseBody)new ResponseBody.Template().decode((InputStream)bbis);
            SEQUENCE controlSequence = responseBody.getControlSequence();
            int numControls = controlSequence.size();
            System.out.println(method + "Number of controls is " + numControls);
            for (int i = 0; i < numControls; ++i) {
                TaggedAttribute taggedAttr = (TaggedAttribute)controlSequence.elementAt(i);
                OBJECT_IDENTIFIER type = taggedAttr.getType();
                if (type.equals((Object)OBJECT_IDENTIFIER.id_cmc_statusInfoV2)) {
                    System.out.println(method + "Control #" + i + ": CMCStatusInfoV2");
                    System.out.println(method + "   OID: " + type.toString());
                    SET sts = taggedAttr.getValues();
                    int numSts = sts.size();
                    for (int j = 0; j < numSts; ++j) {
                        CMCStatusInfoV2 cst = (CMCStatusInfoV2)ASN1Util.decode((ASN1Template)CMCStatusInfoV2.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)sts.elementAt(j)));
                        SEQUENCE seq = cst.getBodyList();
                        StringBuilder s = new StringBuilder("   BodyList: ");
                        for (int k = 0; k < seq.size(); ++k) {
                            INTEGER n = (INTEGER)seq.elementAt(k);
                            s.append(n.toString() + " ");
                        }
                        System.out.println(method + s);
                        int st = cst.getStatus();
                        if (st != 0 && st != 5) {
                            OCTET_STRING pendToken;
                            OtherInfo oi;
                            OtherInfo.Type t;
                            String stString = cst.getStatusString();
                            if (stString != null) {
                                System.out.println(method + "   Status String: " + stString);
                            }
                            if ((t = (oi = cst.getOtherInfo()).getType()) == OtherInfo.FAIL) {
                                System.out.println(method + "   OtherInfo type: FAIL");
                                INTEGER failInfo = oi.getFailInfo();
                                if (failInfo == null) {
                                    System.out.println(method + "failInfo null...skipping");
                                    continue;
                                }
                                if (failInfo.intValue() == 8) {
                                    System.out.println(method + "     failInfo=" + OtherInfo.FAIL_INFO[failInfo.intValue()]);
                                    System.out.println(method + "   what we expected, as decryptedPOP.enable is true;");
                                    continue;
                                }
                                System.out.println(method + "failInfo=" + OtherInfo.FAIL_INFO[failInfo.intValue()]);
                                System.out.println(method + " not what we expected when encryptedPOP.enable is true;");
                                System.exit(1);
                                continue;
                            }
                            if (t != OtherInfo.PEND) continue;
                            System.out.println(method + "   OtherInfo type: PEND");
                            PendInfo pi = oi.getPendInfo();
                            if (pi == null) {
                                System.out.println(method + "PendInfo null...skipping");
                                continue;
                            }
                            System.out.println(method + "PendInfo present...processing...");
                            if (pi.getPendTime() != null) {
                                String datePattern = "dd/MMM/yyyy:HH:mm:ss z";
                                SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
                                Date d = pi.getPendTime().toDate();
                                System.out.println(method + "   Date: " + dateFormat.format(d));
                            }
                            if ((pendToken = pi.getPendToken()) != null) {
                                byte[] reqId = pendToken.toByteArray();
                                reqIdString = new String(reqId);
                                System.out.println(method + "   Pending request id: " + reqIdString);
                                continue;
                            }
                            System.out.println(method + "missing pendToken in response");
                            System.exit(1);
                            continue;
                        }
                        if (st != 0) continue;
                        System.out.println(method + "   Status: SUCCESS");
                        System.out.println(method + " not what we expected, because encryptedPOP.enable is true!!!! exit now");
                        System.exit(1);
                    }
                    continue;
                }
                if (type.equals((Object)OBJECT_IDENTIFIER.id_cmc_encryptedPOP)) {
                    System.out.println(method + "Control #" + i + ": CMC encrypted POP");
                    System.out.println(method + "   OID: " + type.toString());
                    SET encryptedPOPvals = taggedAttr.getValues();
                    encryptedPop = (EncryptedPOP)ASN1Util.decode((ASN1Template)EncryptedPOP.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)encryptedPOPvals.elementAt(0)));
                    System.out.println(method + "     encryptedPOP decoded successfully");
                    continue;
                }
                if (!type.equals((Object)OBJECT_IDENTIFIER.id_cmc_responseInfo)) continue;
                System.out.println(method + "Control #" + i + ": CMC ResponseInfo");
                SET riVals = taggedAttr.getValues();
                reqIdOS = (OCTET_STRING)ASN1Util.decode((ASN1Template)OCTET_STRING.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)riVals.elementAt(0)));
                byte[] reqIdBA = reqIdOS.toByteArray();
                BigInteger reqIdBI = new BigInteger(reqIdBA);
                System.out.println(method + "   requestID: " + reqIdBI.toString());
            }
        }
        catch (Exception e) {
            System.out.println(method + e);
            System.exit(1);
        }
        System.out.println(method + "ends");
        return new Object[]{encryptedPop, reqIdOS};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PKIData constructDecryptedPopRequest(Object[] encryptedPopInfo, String tokenName, org.mozilla.jss.crypto.PrivateKey privKey, boolean useOAEP) {
        PKIData pkidata = null;
        DecryptedPOP decryptedPop = null;
        String method = "constructDecryptedPopRequest: ";
        System.out.println(method + "begins");
        if (encryptedPopInfo == null || privKey == null) {
            System.out.println(method + "input params encryptedPopInfo and privKey cannot be null");
            System.exit(1);
        }
        EncryptedPOP encryptedPop = (EncryptedPOP)encryptedPopInfo[0];
        OCTET_STRING reqIdOS = (OCTET_STRING)encryptedPopInfo[1];
        if (encryptedPop == null || reqIdOS == null) {
            System.out.println(method + "encryptedPopInfo content encryptedPop and reqIdString cannot be null");
            System.exit(1);
        }
        byte[] challenge = null;
        try {
            SymmetricKey symKey;
            TaggedRequest request = encryptedPop.getRequest();
            AlgorithmIdentifier thePOPAlgID = encryptedPop.getThePOPAlgID();
            ASN1Value v = thePOPAlgID.getParameters();
            v = ((ANY)v).decodeWith((ASN1Template)new OCTET_STRING.Template());
            byte[] iv = ((OCTET_STRING)v).toByteArray();
            IVParameterSpec ivps = new IVParameterSpec(iv);
            AlgorithmIdentifier witnessAlgID = encryptedPop.getWitnessAlgID();
            OCTET_STRING witness = encryptedPop.getWitness();
            ContentInfo cms = encryptedPop.getContentInfo();
            EnvelopedData envData = (EnvelopedData)cms.getInterpretedContent();
            EncryptedContentInfo encCI = envData.getEncryptedContentInfo();
            SET recipients = envData.getRecipientInfos();
            RecipientInfo recipient = (RecipientInfo)ASN1Util.decode((ASN1Template)RecipientInfo.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)recipients.elementAt(0)));
            System.out.println(method + " previous response parsed.");
            CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenName);
            KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.RSA;
            if (useOAEP) {
                wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
            }
            if ((symKey = CryptoUtil.unwrap((CryptoToken)token, (SymmetricKey.Type)SymmetricKey.AES, (int)128, (SymmetricKey.Usage)SymmetricKey.Usage.DECRYPT, (org.mozilla.jss.crypto.PrivateKey)privKey, (byte[])recipient.getEncryptedKey().toByteArray(), (KeyWrapAlgorithm)wrapAlg)) == null) {
                System.out.println(method + "symKey returned null from CryptoUtil.unwrap(). Abort!");
                System.exit(1);
            }
            System.out.println(method + "symKey unwrapped.");
            challenge = CryptoUtil.decryptUsingSymmetricKey((CryptoToken)token, (IVParameterSpec)ivps, (byte[])encCI.getEncryptedContent().toByteArray(), (SymmetricKey)symKey, (EncryptionAlgorithm)EncryptionAlgorithm.AES_128_CBC);
            if (challenge == null) {
                System.out.println(method + "challenge returned null from CryptoUtil.decryptUsingSymmetricKey(). Abort!");
                System.exit(1);
            }
            System.out.println(method + "challenge decrypted.");
            try {
                MessageDigest hash = MessageDigest.getInstance(CryptoUtil.getNameFromHashAlgorithm((AlgorithmIdentifier)witnessAlgID));
                byte[] digest = hash.digest(challenge);
                boolean witnessChecked = Arrays.equals(digest, witness.toByteArray());
                CryptoUtil.obscureBytes((byte[])digest, (String)"random");
                if (witnessChecked) {
                    System.out.println(method + "Yay! witness verified");
                } else {
                    CryptoUtil.obscureBytes((byte[])challenge, (String)"random");
                    System.out.println(method + "Oops! witness failed to verify.  Must abort!");
                    System.exit(1);
                }
            }
            catch (Exception ex) {
                CryptoUtil.obscureBytes((byte[])challenge, (String)"random");
                System.out.println(method + ex);
                System.exit(1);
            }
            byte[] popProofValue = null;
            try {
                System.out.println(method + "calculating POP Proof Value");
                Mac hmac = Mac.getInstance("HmacSHA256", "Mozilla-JSS");
                Key secKey = CryptoUtil.importHmacSha1Key((byte[])challenge);
                hmac.init(secKey);
                hmac.update(ASN1Util.encode((ASN1Value)request));
                popProofValue = hmac.doFinal();
                System.out.println(method + "popProofValue length = " + popProofValue.length);
            }
            catch (Exception ex) {
                CryptoUtil.obscureBytes((byte[])challenge, (String)"random");
                System.out.println(method + "calculating POP Proof Value failed: " + ex);
                System.exit(1);
            }
            int bpid = 1;
            System.out.println(method + "constructing DecryptedPOP...");
            decryptedPop = new DecryptedPOP(new INTEGER((long)bpid++), thePOPAlgID, new OCTET_STRING(popProofValue));
            System.out.println(method + "DecryptedPOP constructed successfully");
            System.out.println(method + "adding decryptedPop control");
            TaggedAttribute decPop = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_decryptedPOP, (ASN1Value)decryptedPop);
            SEQUENCE reqSequence = new SEQUENCE();
            reqSequence.addElement((ASN1Value)request);
            SEQUENCE controlSeq = new SEQUENCE();
            controlSeq.addElement((ASN1Value)decPop);
            System.out.println(method + "decryptedPop control added");
            TaggedAttribute reqIdTA = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_regInfo, (ASN1Value)reqIdOS);
            controlSeq.addElement((ASN1Value)reqIdTA);
            System.out.println(method + "regInfo control added");
            SEQUENCE otherMsgSeq = new SEQUENCE();
            pkidata = new PKIData(controlSeq, reqSequence, new SEQUENCE(), otherMsgSeq);
            CryptoUtil.obscureBytes((byte[])challenge, (String)"random");
        }
        catch (Exception e) {
            System.out.println(method + e);
            System.exit(1);
        }
        finally {
            CryptoUtil.obscureBytes(challenge, (String)"random");
        }
        System.out.println(method + " completes.");
        return pkidata;
    }

    static void outputContentInfo(ContentInfo cmcblob, String ofilename) {
        try (FileOutputStream os = new FileOutputStream(ofilename);){
            cmcblob.encode((OutputStream)os);
            System.out.println("");
            System.out.println("");
            System.out.println("The CMC enrollment request in binary format is stored in " + ofilename);
        }
        catch (IOException e) {
            System.out.println("CMCRequest:  unable to open file " + ofilename + " for writing:\n" + e);
        }
    }

    static void processResignCMC(String ifilename, String ofilename, X509Certificate signerCert, String privKeyId, String tokenName, String nickname, CryptoManager cm) {
        try {
            byte[] origData;
            PKIData.Template pkidata_template;
            PKIData pkidata;
            OCTET_STRING os;
            EncapsulatedContentInfo eci;
            SignedData signedData;
            if (ifilename == null || ifilename.equals("")) {
                System.out.println("TEST_CMC: param input needed for test_cmc");
                System.exit(1);
            }
            if (ofilename == null || ofilename.equals("")) {
                System.out.println("TEST_CMC: param output needed for test_cmc");
                System.exit(1);
            }
            org.mozilla.jss.crypto.PrivateKey privk = null;
            if (signerCert == null) {
                if (privKeyId == null) {
                    System.out.println("TEST_CMC: signerCert not supplied, need privKeyId to re-sign.");
                    System.exit(1);
                } else {
                    System.out.println("TEST_CMC: got re-signing privKeyId: " + privKeyId);
                    byte[] keyIDb = CryptoUtil.decodeKeyID((String)privKeyId);
                    privk = CryptoUtil.findPrivateKey((byte[])keyIDb);
                    if (privk != null) {
                        System.out.println("TEST_CMC: got private key");
                    } else {
                        System.out.println("TEST_CMC: error getting private key null");
                        System.exit(1);
                    }
                }
            }
            byte[] data = null;
            try (FileInputStream inputBlob = new FileInputStream(ifilename);){
                data = new byte[((InputStream)inputBlob).available()];
                ((InputStream)inputBlob).read(data);
            }
            catch (FileNotFoundException e) {
                System.out.println("can''t find file " + ifilename + e);
                System.exit(1);
            }
            System.out.println("TEST_CMC: input read");
            ContentInfo.Template ci_template = new ContentInfo.Template();
            ContentInfo ci = (ContentInfo)ci_template.decode((InputStream)new ByteArrayInputStream(data));
            if (ci != null) {
                System.out.println("TEST_CMC: ContentInfo template decoded");
            }
            if ((signedData = (SignedData)ci.getInterpretedContent()) != null) {
                System.out.println("TEST_CMC: SignedData retrieved");
            }
            if ((eci = signedData.getContentInfo()) != null) {
                System.out.println("TEST_CMC: EncapsulatedContentInfo retrieved");
            }
            if ((os = eci.getContent()) != null) {
                System.out.println("TEST_CMC: orig data retrieved");
            }
            if ((pkidata = (PKIData)(pkidata_template = new PKIData.Template()).decode((InputStream)new ByteArrayInputStream(origData = os.toByteArray()))) != null) {
                System.out.println("TEST_CMC: PKIData decoded");
            }
            SignedData newSignedData = null;
            if (signerCert != null) {
                System.out.println("TEST_CMC: re-signing using signer cert:" + nickname);
                newSignedData = CMCRequest.signData(signerCert, tokenName, nickname, cm, pkidata);
            } else {
                System.out.println("TEST_CMC: re-signing using private key: " + privKeyId);
                SET signInfos = signedData.getSignerInfos();
                SignerInfo si = (SignerInfo)ASN1Util.decode((ASN1Template)SignerInfo.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)signInfos.elementAt(0)));
                newSignedData = CMCRequest.signData((PrivateKey)privk, pkidata, si.getSignerIdentifier());
            }
            if (newSignedData == null) {
                System.out.println("TEST_CMC: PKIData signing returned null");
                System.exit(1);
            }
            System.out.println("TEST_CMC: PKIData signed");
            ContentInfo cmcblob = CMCRequest.getCMCBlob(newSignedData, null);
            if (cmcblob == null) {
                System.out.println("TEST_CMC: getCMCBlob returned null");
                System.exit(1);
            }
            CMCRequest.outputContentInfo(cmcblob, ofilename);
            System.out.println("TEST_CMC: completed");
        }
        catch (Exception ex) {
            System.out.println("TEST_CMC: exception caught: " + ex);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] s) {
        String numRequests = null;
        String dbdir = null;
        String nickname = null;
        String tokenName = null;
        String ifilename = null;
        String ofilename = null;
        String password = null;
        String format = null;
        String privKeyId = null;
        String oaep = null;
        String decryptedPopEnable = "false";
        String encryptedPopResponseFile = null;
        String decryptedPopRequestFile = null;
        String confirmCertEnable = "false";
        String confirmCertIssuer = null;
        String confirmCertSerial = null;
        String getCertEnable = "false";
        String getCertIssuer = null;
        String getCertSerial = null;
        String dataReturnEnable = "false";
        String dataReturnData = null;
        String transactionMgtEnable = "false";
        String transactionMgtId = null;
        String senderNonceEnable = "false";
        String senderNonce = null;
        String revRequestEnable = "false";
        String revRequestIssuer = null;
        String revRequestSerial = null;
        String revRequestReason = null;
        String revRequestSharedSecret = null;
        String revRequestComment = null;
        String revRequestInvalidityDatePresent = "false";
        String identificationEnable = "false";
        String identification = null;
        String identityProofEnable = "false";
        String identityProofSharedSecret = null;
        String identityProofV2Enable = "false";
        String identityProofV2hashAlg = "SHA256";
        String identityProofV2macAlg = "SHA256";
        String witnessSharedSecret = null;
        String popLinkWitnessV2Enable = "false";
        String popLinkWitnessV2keyGenAlg = "SHA256";
        String popLinkWitnessV2macAlg = "SHA256";
        String popLinkWitnessEnable = "false";
        String bodyPartIDs = null;
        String lraPopWitnessEnable = "false";
        String useSharedSecret = "false";
        System.out.println("");
        if (s.length != 1) {
            System.out.println("Wrong number of parameters:" + s.length);
            CMCRequest.printUsage();
        }
        String configFile = s[0];
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(configFile))));
        }
        catch (FileNotFoundException e) {
            System.out.println("CMCRequest:  can't find configuration file: " + configFile);
            CMCRequest.printUsage();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            String str = "";
            while ((str = reader.readLine()) != null) {
                if ((str = str.trim()).startsWith("#") || str.length() <= 0) continue;
                int index = str.indexOf("=");
                String name = "";
                String val = "";
                if (index == -1) {
                    System.out.println("Error in configuration file: " + str);
                    System.exit(1);
                }
                name = str.substring(0, index);
                if (index != str.length() - 1) {
                    val = str.substring(index + 1);
                }
                if (name.equals("format")) {
                    format = val;
                    continue;
                }
                if (name.equals("dbdir")) {
                    dbdir = val;
                    continue;
                }
                if (name.equals("tokenname")) {
                    tokenName = val;
                    continue;
                }
                if (name.equals("nickname")) {
                    nickname = val;
                    continue;
                }
                if (name.equals("password")) {
                    password = val;
                    continue;
                }
                if (name.equals("output")) {
                    ofilename = val;
                    continue;
                }
                if (name.equals("input")) {
                    ifilename = val;
                    continue;
                }
                if (name.equals("numRequests")) {
                    numRequests = val;
                    continue;
                }
                if (name.equals("decryptedPop.enable")) {
                    decryptedPopEnable = val;
                    continue;
                }
                if (name.equals("encryptedPopResponseFile")) {
                    encryptedPopResponseFile = val;
                    continue;
                }
                if (name.equals("request.useSharedSecret") || name.equals("request.selfSign")) {
                    useSharedSecret = val;
                    continue;
                }
                if (name.equals("request.privKeyId")) {
                    privKeyId = val;
                    continue;
                }
                if (name.equals("decryptedPopRequestFile")) {
                    decryptedPopRequestFile = val;
                    continue;
                }
                if (name.equals("confirmCertAcceptance.serial")) {
                    confirmCertSerial = val;
                    continue;
                }
                if (name.equals("confirmCertAcceptance.issuer")) {
                    confirmCertIssuer = val;
                    continue;
                }
                if (name.equals("confirmCertAcceptance.enable")) {
                    confirmCertEnable = val;
                    continue;
                }
                if (name.equals("getCert.enable")) {
                    getCertEnable = val;
                    continue;
                }
                if (name.equals("getCert.issuer")) {
                    getCertIssuer = val;
                    continue;
                }
                if (name.equals("getCert.serial")) {
                    getCertSerial = val;
                    continue;
                }
                if (name.equals("dataReturn.enable")) {
                    dataReturnEnable = val;
                    continue;
                }
                if (name.equals("dataReturn.data")) {
                    dataReturnData = val;
                    continue;
                }
                if (name.equals("transactionMgt.enable")) {
                    transactionMgtEnable = val;
                    continue;
                }
                if (name.equals("transactionMgt.id")) {
                    transactionMgtId = val;
                    continue;
                }
                if (name.equals("senderNonce.enable")) {
                    senderNonceEnable = val;
                    continue;
                }
                if (name.equals("senderNonce")) {
                    senderNonce = val;
                    continue;
                }
                if (name.equals("revRequest.enable")) {
                    revRequestEnable = val;
                    continue;
                }
                if (name.equals("revRequest.issuer")) {
                    revRequestIssuer = val;
                    continue;
                }
                if (name.equals("revRequest.serial")) {
                    revRequestSerial = val;
                    continue;
                }
                if (name.equals("revRequest.reason")) {
                    revRequestReason = val;
                    continue;
                }
                if (name.equals("revRequest.sharedSecret")) {
                    revRequestSharedSecret = val;
                    continue;
                }
                if (name.equals("revRequest.comment")) {
                    revRequestComment = val;
                    continue;
                }
                if (name.equals("revRequest.invalidityDatePresent")) {
                    revRequestInvalidityDatePresent = val;
                    continue;
                }
                if (name.equals("identification.enable")) {
                    identificationEnable = val;
                    continue;
                }
                if (name.equals("identification")) {
                    identification = val;
                    continue;
                }
                if (name.equals("witness.sharedSecret")) {
                    witnessSharedSecret = val;
                    continue;
                }
                if (name.equals("identityProofV2.enable")) {
                    identityProofV2Enable = val;
                    continue;
                }
                if (name.equals("identityProofV2.hashAlg")) {
                    identityProofV2hashAlg = val;
                    continue;
                }
                if (name.equals("identityProofV2.macAlg")) {
                    identityProofV2macAlg = val;
                    continue;
                }
                if (name.equals("popLinkWitnessV2.enable")) {
                    popLinkWitnessV2Enable = val;
                    continue;
                }
                if (name.equals("popLinkWitnessV2.keyGenAlg")) {
                    popLinkWitnessV2keyGenAlg = val;
                    continue;
                }
                if (name.equals("popLinkWitnessV2.macAlg")) {
                    popLinkWitnessV2macAlg = val;
                    continue;
                }
                if (name.equals("identityProof.enable")) {
                    identityProofEnable = val;
                    continue;
                }
                if (name.equals("identityProof.sharedSecret")) {
                    identityProofSharedSecret = val;
                    continue;
                }
                if (name.equals("popLinkWitness.enable")) {
                    popLinkWitnessEnable = val;
                    continue;
                }
                if (name.equals("LraPopWitness.enable")) {
                    lraPopWitnessEnable = val;
                    continue;
                }
                if (name.equals("LraPopWitness.bodyPartIDs")) {
                    bodyPartIDs = val;
                    continue;
                }
                if (!name.equals("oaep")) continue;
                oaep = val;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CMCRequest.printUsage();
        }
        if (password == null) {
            System.out.println("Missing password.");
            CMCRequest.printUsage();
        }
        if (!useSharedSecret.equals("true") && revRequestSharedSecret == null && nickname == null) {
            System.out.println("Missing nickname.");
            CMCRequest.printUsage();
        }
        try {
            if (dbdir == null) {
                dbdir = ".";
            }
            String mPrefix = "";
            System.out.println("cert/key prefix = " + mPrefix);
            System.out.println("path = " + dbdir);
            CryptoManager.initialize((String)dbdir);
            CryptoToken token = null;
            CryptoManager cm = CryptoManager.getInstance();
            System.out.println("CryptoManger initialized");
            token = CryptoUtil.getKeyStorageToken(tokenName);
            if (CryptoUtil.isInternalToken(tokenName)) {
                tokenName = "internal";
            }
            cm.setThreadToken(token);
            Password pass = new Password(password.toCharArray());
            try {
                token.login((PasswordCallback)pass);
                System.out.println("token " + tokenName + " logged in...");
            }
            catch (Exception e) {
                System.out.println("login Exception: " + e.toString());
                System.exit(1);
            }
            finally {
                pass.clear();
            }
            X509Certificate signerCert = null;
            StringBuffer certname = new StringBuffer();
            if (!token.equals((Object)cm.getInternalKeyStorageToken())) {
                certname.append(tokenName);
                certname.append(":");
            }
            if (!(useSharedSecret.equals("true") && revRequestSharedSecret != null || nickname == null)) {
                certname.append(nickname);
                signerCert = cm.findCertByNickname(certname.toString());
                if (signerCert != null) {
                    System.out.println("got signerCert: " + certname.toString());
                }
            }
            if (format.equals("test_cmc")) {
                System.out.println("TEST_CMC: request format is test_cmc; re-signing the request");
                CMCRequest.processResignCMC(ifilename, ofilename, signerCert, privKeyId, tokenName, nickname, cm);
                System.exit(0);
            }
            ContentInfo cmcblob = null;
            PKIData pkidata = null;
            org.mozilla.jss.crypto.PrivateKey privk = null;
            if (useSharedSecret.equalsIgnoreCase("true") || decryptedPopEnable.equalsIgnoreCase("true") || popLinkWitnessV2Enable.equalsIgnoreCase("true")) {
                if (privKeyId == null) {
                    System.out.println("useSharedSecret or ecryptedPop.enable or popLinkWitnessV2 true, but privKeyId not specified.");
                    CMCRequest.printUsage();
                } else {
                    System.out.println("got request privKeyId: " + privKeyId);
                    byte[] keyIDb = CryptoUtil.decodeKeyID((String)privKeyId);
                    privk = CryptoUtil.findPrivateKey((byte[])keyIDb);
                    if (privk != null) {
                        System.out.println("got private key");
                    } else {
                        System.out.println("error getting private key null");
                        System.exit(1);
                    }
                }
            }
            boolean isSharedSecretRevoke = false;
            if (decryptedPopEnable.equalsIgnoreCase("true")) {
                if (encryptedPopResponseFile == null) {
                    System.out.println("ecryptedPop.enable = true, but encryptedPopResponseFile is not specified.");
                    CMCRequest.printUsage();
                }
                if (decryptedPopRequestFile == null) {
                    System.out.println("ecryptedPop.enable = true, but decryptedPopRequestFile is not specified.");
                    CMCRequest.printUsage();
                }
                ofilename = decryptedPopRequestFile;
                Object[] encryptedPopInfo = CMCRequest.processEncryptedPopResponse(encryptedPopResponseFile);
                if (encryptedPopInfo == null) {
                    System.out.println("processEncryptedPopResponse() returns null");
                    System.exit(1);
                }
                boolean useOAEP = false;
                if (oaep != null && oaep.equalsIgnoreCase("true")) {
                    useOAEP = true;
                }
                if ((pkidata = CMCRequest.constructDecryptedPopRequest(encryptedPopInfo, tokenName, privk, useOAEP)) == null) {
                    System.out.println("after constructDecryptedPopRequest, pkidata null. no good");
                    System.exit(1);
                }
            } else {
                int i;
                if (!revRequestEnable.equalsIgnoreCase("true") && ifilename == null) {
                    System.out.println("Missing input filename for PKCS10 or CRMF.");
                    CMCRequest.printUsage();
                }
                int num = 0;
                if (numRequests == null) {
                    System.out.println("Missing numRequests.");
                    CMCRequest.printUsage();
                } else {
                    try {
                        num = Integer.parseInt(numRequests);
                    }
                    catch (Exception ee) {
                        System.out.println("numRequests must be integer");
                        System.exit(1);
                    }
                }
                String[] ifiles = null;
                if (revRequestEnable.equalsIgnoreCase("false")) {
                    StringTokenizer tokenizer = new StringTokenizer(ifilename, " ");
                    ifiles = new String[num];
                    for (i = 0; i < num; ++i) {
                        String ss;
                        ifiles[i] = ss = tokenizer.nextToken();
                        if (ss != null) continue;
                        System.out.println("Missing input file for the request.");
                        System.exit(1);
                    }
                }
                if (ofilename == null) {
                    System.out.println("Missing output filename for the CMC request.");
                    CMCRequest.printUsage();
                }
                String[] requests = new String[num];
                for (i = 0; i < num && revRequestEnable.equalsIgnoreCase("false"); ++i) {
                    BufferedReader inputBlob = null;
                    try {
                        inputBlob = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(ifiles[i]))));
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("CMCRequest:  can't find file " + ifiles[i] + ":\n" + e);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    String asciiBASE64BlobChunk = "";
                    StringBuffer asciiBASE64Blob = new StringBuffer();
                    try {
                        while ((asciiBASE64BlobChunk = inputBlob.readLine()) != null) {
                            if (asciiBASE64BlobChunk.startsWith(HEADER) || asciiBASE64BlobChunk.startsWith(TRAILER)) continue;
                            asciiBASE64Blob.append(asciiBASE64BlobChunk.trim());
                        }
                        requests[i] = asciiBASE64Blob.toString();
                    }
                    catch (IOException e) {
                        System.out.println("CMCRequest:  Unexpected BASE64 encoded error encountered in readLine():\n" + e);
                    }
                    try {
                        inputBlob.close();
                        continue;
                    }
                    catch (IOException e) {
                        System.out.println("CMCRequest():  Unexpected BASE64 encoded error encountered in close():\n" + e);
                    }
                }
                SEQUENCE controlSeq = new SEQUENCE();
                int bpid = 1;
                if (confirmCertEnable.equalsIgnoreCase("true")) {
                    if (confirmCertIssuer.length() == 0 || confirmCertSerial.length() == 0) {
                        System.out.println("Illegal parameters for confirm certificate acceptance control");
                        CMCRequest.printUsage();
                        System.exit(1);
                    }
                    bpid = CMCRequest.addConfirmCertAttr(bpid, controlSeq, confirmCertIssuer, confirmCertSerial);
                }
                if (lraPopWitnessEnable.equalsIgnoreCase("true")) {
                    if (bodyPartIDs.length() == 0) {
                        System.out.println("Illegal parameters for Lra Pop Witness control");
                        CMCRequest.printUsage();
                        System.exit(1);
                    }
                    bpid = CMCRequest.addLraPopWitnessAttr(bpid, controlSeq, bodyPartIDs);
                }
                if (getCertEnable.equalsIgnoreCase("true")) {
                    if (getCertIssuer.length() == 0 || getCertSerial.length() == 0) {
                        System.out.println("Illegal parameters for get certificate control");
                        CMCRequest.printUsage();
                        System.exit(1);
                    }
                    bpid = CMCRequest.addGetCertAttr(bpid, controlSeq, getCertIssuer, getCertSerial);
                }
                if (dataReturnEnable.equalsIgnoreCase("true")) {
                    if (dataReturnData.length() == 0) {
                        System.out.println("Illegal parameters for data return control");
                        CMCRequest.printUsage();
                        System.exit(1);
                    }
                    bpid = CMCRequest.addDataReturnAttr(bpid, controlSeq, dataReturnData);
                }
                if (senderNonceEnable.equalsIgnoreCase("true")) {
                    bpid = CMCRequest.addSenderNonceAttr(bpid, controlSeq, senderNonce);
                }
                if (!popLinkWitnessV2Enable.equalsIgnoreCase("true") & popLinkWitnessEnable.equalsIgnoreCase("true")) {
                    bpid = CMCRequest.addPopLinkWitnessAttr(bpid, controlSeq);
                }
                SEQUENCE otherMsgSeq = new SEQUENCE();
                if (revRequestEnable.equalsIgnoreCase("true")) {
                    if (revRequestSharedSecret != null && revRequestSharedSecret.length() > 0) {
                        isSharedSecretRevoke = true;
                    }
                    bpid = CMCRequest.addRevRequestAttr(bpid, controlSeq, token, signerCert, revRequestIssuer, revRequestSerial, revRequestReason, revRequestSharedSecret, revRequestComment, revRequestInvalidityDatePresent, cm);
                    pkidata = new PKIData(controlSeq, new SEQUENCE(), new SEQUENCE(), new SEQUENCE());
                } else {
                    pkidata = CMCRequest.createPKIData(useSharedSecret, requests, format, transactionMgtEnable, transactionMgtId, identificationEnable, identification, identityProofEnable, identityProofSharedSecret, witnessSharedSecret, identityProofV2Enable, identityProofV2hashAlg, identityProofV2macAlg, popLinkWitnessV2Enable, popLinkWitnessV2keyGenAlg, popLinkWitnessV2macAlg, controlSeq, otherMsgSeq, bpid, token, privk);
                }
                if (pkidata == null) {
                    System.out.println("pkidata null after createPKIData(). Exiting with error");
                    System.exit(1);
                }
            }
            if (isSharedSecretRevoke) {
                cmcblob = CMCRequest.getCMCBlob(null, ASN1Util.encode((ASN1Value)pkidata));
            } else {
                SignedData signedData = null;
                if (useSharedSecret.equalsIgnoreCase("true")) {
                    System.out.println("useSharedSecret is true...");
                    signedData = CMCRequest.signData((PrivateKey)privk, pkidata);
                } else {
                    System.out.println("useSharedSecret is false...");
                    signedData = CMCRequest.signData(signerCert, tokenName, nickname, cm, pkidata);
                }
                if (signedData == null) {
                    System.out.println("signData() returns null. Exiting with error");
                    System.exit(1);
                }
                cmcblob = CMCRequest.getCMCBlob(signedData, null);
            }
            if (cmcblob == null) {
                System.out.println("getCMCBlob() returns null. Exiting with error");
                System.exit(1);
            }
            CMCRequest.outputContentInfo(cmcblob, ofilename);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

