/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Properties;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class HttpClient {
    private String _host = null;
    private int _port = 0;
    private boolean _secure = false;
    public static final int ARGC = 1;
    public static final int MAX_HTTP_RESPONSE_HEADER_LINES = 56;

    public HttpClient(String host, int port, String secure) throws Exception {
        this._host = host;
        this._port = port;
        if (secure.equals("true")) {
            this._secure = true;
        }
    }

    public static byte[] getBytesFromFile(String filename) throws IOException {
        int offset;
        File file = new File(filename);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Input file " + filename + " is too large. Must be smaller than 2147483647");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        try (FileInputStream is = new FileInputStream(file);){
            for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + filename);
        }
        return bytes;
    }

    public void send(String ifilename, String ofilename, String tokenName, String dbdir, String nickname, String password, String servlet, String clientmode, int numHeaderLines) throws Exception {
        if (this._secure) {
            this.secureSend(ifilename, ofilename, tokenName, dbdir, nickname, password, servlet, clientmode, numHeaderLines);
        } else {
            this.send(ifilename, ofilename, servlet, numHeaderLines);
        }
    }

    private void send(String ifilename, String ofilename, String servlet, int numHeaderLines) throws Exception {
        try (Socket socket = new Socket(this._host, this._port);
             DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
             InputStream is = socket.getInputStream();){
            this.sendRequest(servlet, dos, ifilename);
            this.handleResponse(ofilename, is, numHeaderLines);
        }
        catch (Exception e) {
            System.out.println("Error sending over Socket: " + e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void secureSend(String ifilename, String ofilename, String tokenName, String dbdir, String nickname, String password, String servlet, String clientmode, int numHeaderLines) throws Exception {
        try {
            InitializationValues vals = new InitializationValues(dbdir, "", "", "secmod.db");
            CryptoManager.initialize((InitializationValues)vals);
            CryptoManager cm = CryptoManager.getInstance();
            CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenName);
            if (CryptoUtil.isInternalToken((String)tokenName)) {
                tokenName = "internal";
            }
            cm.setThreadToken(token);
            Password pass = new Password(password.toCharArray());
            try {
                token.login((PasswordCallback)pass);
            }
            finally {
                pass.clear();
            }
            ClientHandshakeCB listener = new ClientHandshakeCB(this);
            try (SSLSocket sslSocket = new SSLSocket(this._host, this._port);){
                sslSocket.addHandshakeCompletedListener((SSLHandshakeCompletedListener)listener);
                sslSocket.enablePostHandshakeAuth(true);
                CryptoToken tt = cm.getThreadToken();
                System.out.println("after SSLSocket created, thread token is " + tt.getName());
                if (clientmode != null && clientmode.equals("true")) {
                    StringBuffer certname = new StringBuffer();
                    if (!token.equals((Object)cm.getInternalKeyStorageToken())) {
                        certname.append(tokenName);
                        certname.append(":");
                    }
                    certname.append(nickname);
                    X509Certificate cert = cm.findCertByNickname(certname.toString());
                    if (cert == null) {
                        System.out.println("client cert is null");
                    } else {
                        System.out.println("client cert is not null");
                    }
                    sslSocket.setUseClientMode(true);
                    sslSocket.setClientCertNickname(nickname);
                }
                sslSocket.forceHandshake();
                try (DataOutputStream dos = new DataOutputStream(sslSocket.getOutputStream());
                     InputStream is = sslSocket.getInputStream();){
                    this.sendRequest(servlet, dos, ifilename);
                    this.handleResponse(ofilename, is, numHeaderLines);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error sending over SSLSocket: " + e);
            throw e;
        }
    }

    private void sendRequest(String servlet, DataOutputStream dos, String ifilename) throws IOException {
        byte[] b = HttpClient.getBytesFromFile(ifilename);
        System.out.println("Total number of bytes read = " + b.length);
        if (servlet == null) {
            System.out.println("Missing servlet name.");
            HttpClient.printUsage();
        } else {
            System.out.println("writing to socket");
            String s = "POST " + servlet + " HTTP/1.0\r\n";
            dos.writeBytes(s);
        }
        dos.writeBytes("Content-length: " + b.length + "\r\n");
        dos.writeBytes("\r\n");
        dos.write(b);
        dos.flush();
    }

    private void handleResponse(String ofilename, InputStream is, int numHeaderLines) throws IOException {
        boolean startSaving = false;
        int sum = 0;
        boolean hack = false;
        Object catchHeaders = "";
        try (FileOutputStream fof = new FileOutputStream(ofilename);
             ByteArrayOutputStream bs = new ByteArrayOutputStream();
             PrintStream ps = new PrintStream(bs);){
            int r;
            while ((r = is.read()) != -1) {
                if (r == 10) {
                    ++sum;
                }
                if (sum < numHeaderLines) {
                    catchHeaders = (String)catchHeaders + (char)r;
                }
                if (sum == 5) {
                    startSaving = true;
                    continue;
                }
                if (!startSaving) continue;
                if (hack) {
                    fof.write(r);
                }
                if (hack) continue;
                hack = true;
            }
            System.out.println("\n##Response Headers begin##\n" + (String)catchHeaders + "\n##end##\n");
            byte[] bout = HttpClient.getBytesFromFile(ofilename);
            System.out.println("Total number of bytes read = " + bout.length);
            ps.print(Utils.base64encode((byte[])bout, (boolean)true));
            System.out.println(bs.toString());
            System.out.println("");
            System.out.println("The response in binary format is stored in " + ofilename);
            System.out.println("");
        }
    }

    static void printUsage() {
        System.out.println("");
        System.out.println("Usage: HttpClient <configuration file>");
        System.out.println("For example, HttpClient HttpClient.cfg");
        System.out.println("");
        System.out.println("The configuration file should look like as follows:");
        System.out.println("");
        System.out.println("#host: host name for the http server");
        System.out.println("host=host.example.com");
        System.out.println("");
        System.out.println("#port: port number");
        System.out.println("port=8443");
        System.out.println("");
        System.out.println("#secure: true for secure connection, false for nonsecure connection");
        System.out.println("secure=false");
        System.out.println("");
        System.out.println("#input: full path for the enrollment request, the content must be in binary format");
        System.out.println("input=~/cmcReqCRMFBin");
        System.out.println("");
        System.out.println("#output: full path for the response in binary format");
        System.out.println("#output could be parsed by running CMCResponse");
        System.out.println("output=~/cmcResp");
        System.out.println("");
        System.out.println("#dbdir: directory for NSS certificate/key databases");
        System.out.println("#This parameter will be ignored if secure=false");
        System.out.println("dbdir=/.dogtag/nssdb");
        System.out.println("");
        System.out.println("#password: password for NSS database");
        System.out.println("#This parameter will be ignored if secure=false and clientmode=false");
        System.out.println("password=");
        System.out.println("");
        System.out.println("#tokenname: name of token where SSL client authentication cert for nickname can be found (default is internal)");
        System.out.println("#This parameter will be ignored if secure=false");
        System.out.println("tokenname=internal");
        System.out.println("");
        System.out.println("#clientmode: true for client authentication, false for no client authentication");
        System.out.println("#This parameter will be ignored if secure=false");
        System.out.println("clientmode=false");
        System.out.println("");
        System.out.println("#nickname: nickname for client certificate");
        System.out.println("#This parameter will be ignored if clientmode=false");
        System.out.println("nickname=");
        System.out.println("");
        System.out.println("#servlet: target URL");
        System.out.println("#This parameter may include query parameters;");
        System.out.println("#  - reminder: profileId should be a profile that matches");
        System.out.println("#    the intended certificate; for certificates intended");
        System.out.println("#    for SSL (client or server), profiles should match");
        System.out.println("#    the key type (RSA or EC) of the keys generated for CSR;");
        System.out.println("servlet=/ca/ee/ca/profileSubmitCMCFull?profileId=caFullCMCUserCert");
        System.out.println("");
        System.exit(0);
    }

    public static void main(String[] args) {
        System.out.println("");
        if (args.length != 1) {
            System.out.println("Wrong number of parameters:" + args.length);
            HttpClient.printUsage();
        }
        String configFile = args[0];
        Properties config = new Properties();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(configFile))));){
            config.load(reader);
        }
        catch (FileNotFoundException e) {
            System.out.println("HttpClient:  can't find configuration file: " + configFile);
            HttpClient.printUsage();
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("Error loading config from file: " + e);
            HttpClient.printUsage();
            return;
        }
        String host = config.getProperty("host");
        String portstr = config.getProperty("port");
        String secure = config.getProperty("secure");
        String tokenName = config.getProperty("tokenname");
        String dbdir = config.getProperty("dbdir");
        String nickname = config.getProperty("nickname");
        String password = config.getProperty("password");
        String ofilename = config.getProperty("output");
        String ifilename = config.getProperty("input");
        String clientmode = config.getProperty("clientmode");
        String servlet = config.getProperty("servlet");
        String numHeaderLinesStr = config.getProperty("numHeaderLines");
        if (host == null) {
            System.out.println("Missing host name.");
            HttpClient.printUsage();
        }
        if (portstr == null) {
            System.out.println("Missing port number.");
            HttpClient.printUsage();
        }
        if (servlet == null) {
            System.out.println("Missing servlet name.");
            HttpClient.printUsage();
        }
        if (ifilename == null) {
            System.out.println("Missing input filename for the enrollment request.");
            HttpClient.printUsage();
        }
        if (ofilename == null) {
            System.out.println("Missing output filename for the response.");
            HttpClient.printUsage();
        }
        int port = Integer.parseInt(portstr);
        if (secure != null && secure.equals("true")) {
            if (dbdir == null) {
                System.out.println("Missing directory name for the cert7.db.");
                HttpClient.printUsage();
            }
            if (clientmode != null && clientmode.equals("true")) {
                if (password == null) {
                    System.out.println("Missing password for the cert7.db.");
                    HttpClient.printUsage();
                }
                if (nickname == null) {
                    System.out.println("Missing nickname for the client certificate");
                    HttpClient.printUsage();
                }
            }
        }
        int numHeaderLines = 5;
        if (numHeaderLinesStr != null && ((numHeaderLines = Integer.parseInt(numHeaderLinesStr)) < 1 || numHeaderLines > 56)) {
            System.out.println("numHeaderLines " + numHeaderLines + " out of range: 1 - 56");
            System.exit(1);
        }
        try {
            HttpClient client = new HttpClient(host, port, secure);
            client.send(ifilename, ofilename, tokenName, dbdir, nickname, password, servlet, clientmode, numHeaderLines);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
        }
    }

    static class ClientHandshakeCB
    implements SSLHandshakeCompletedListener {
        Object sc;

        public ClientHandshakeCB(Object sc) {
            this.sc = sc;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
            System.out.println("handshake happened");
        }
    }
}

