/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmsutil.ocsp.BasicOCSPResponse;
import com.netscape.cmsutil.ocsp.CertStatus;
import com.netscape.cmsutil.ocsp.GoodInfo;
import com.netscape.cmsutil.ocsp.OCSPProcessor;
import com.netscape.cmsutil.ocsp.OCSPRequest;
import com.netscape.cmsutil.ocsp.OCSPResponse;
import com.netscape.cmsutil.ocsp.ResponseBytes;
import com.netscape.cmsutil.ocsp.ResponseData;
import com.netscape.cmsutil.ocsp.RevokedInfo;
import com.netscape.cmsutil.ocsp.SingleResponse;
import com.netscape.cmsutil.ocsp.UnknownInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.dogtagpki.util.logging.PKILogger;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.INTEGER;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPClient {
    public static Logger logger = LoggerFactory.getLogger(OCSPClient.class);

    public Options createOptions() throws UnknownHostException {
        Options options = new Options();
        Option option = new Option("d", true, "Security database location (default: current directory)");
        option.setArgName("database");
        options.addOption(option);
        option = new Option("h", true, "OCSP server hostname (default: " + InetAddress.getLocalHost().getCanonicalHostName() + ")");
        option.setArgName("hostname");
        options.addOption(option);
        option = new Option("p", true, "OCSP server port number (default: 8080)");
        option.setArgName("port");
        options.addOption(option);
        option = new Option("t", true, "OCSP service path (default: /ocsp/ee/ocsp)");
        option.setArgName("path");
        options.addOption(option);
        option = new Option("c", true, "CA certificate nickname (default: CA Signing Certificate)");
        option.setArgName("nickname");
        options.addOption(option);
        option = new Option("n", true, "Number of submissions (default: 1)");
        option.setArgName("times");
        options.addOption(option);
        option = new Option(null, "serial", true, "Serial number of certificate to be checked");
        option.setArgName("serial");
        options.addOption(option);
        option = new Option(null, "input", true, "Input file containing DER-encoded OCSP request");
        option.setArgName("input");
        options.addOption(option);
        option = new Option(null, "output", true, "Output file to store DER-encoded OCSP response");
        option.setArgName("output");
        options.addOption(option);
        options.addOption("v", "verbose", false, "Run in verbose mode.");
        options.addOption(null, "debug", false, "Run in debug mode.");
        options.addOption(null, "help", false, "Show help message.");
        return options;
    }

    public static void printHelp() throws Exception {
        System.out.println("Usage: OCSPClient [OPTIONS]");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -d <database>        Security database location (default: current directory)");
        System.out.println("  -h <hostname>        OCSP server hostname (default: " + InetAddress.getLocalHost().getCanonicalHostName() + ")");
        System.out.println("  -p <port>            OCSP server port number (default: 8080)");
        System.out.println("  -t <path>            OCSP service path (default: /ocsp/ee/ocsp)");
        System.out.println("  -c <nickname>        CA certificate nickname (defaut: CA Signing Certificate)");
        System.out.println("  -n <times>           Number of submissions (default: 1)");
        System.out.println();
        System.out.println("  --serial <serial>    Serial number of certificate to be checked");
        System.out.println("  --input <input>      Input file containing DER-encoded OCSP request");
        System.out.println("  --output <output>    Output file to store DER-encoded OCSP response");
        System.out.println();
        System.out.println("  -v, --verbose        Run in verbose mode.");
        System.out.println("      --debug          Run in debug mode.");
        System.out.println("      --help           Show help message.");
    }

    public void execute(String[] args) throws Exception {
        block26: {
            OCSPRequest request;
            DefaultParser parser = new DefaultParser();
            Options options = this.createOptions();
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("help")) {
                OCSPClient.printHelp();
                return;
            }
            if (cmd.hasOption("debug")) {
                PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.DEBUG);
            } else if (cmd.hasOption("verbose")) {
                PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.INFO);
            }
            String databaseDir = cmd.getOptionValue("d", ".");
            String hostname = cmd.getOptionValue("h", InetAddress.getLocalHost().getCanonicalHostName());
            int port = Integer.parseInt(cmd.getOptionValue("p", "8080"));
            String path = cmd.getOptionValue("t", "/ocsp/ee/ocsp");
            String caNickname = cmd.getOptionValue("c", "CA Signing Certificate");
            int times = Integer.parseInt(cmd.getOptionValue("n", "1"));
            String input = cmd.getOptionValue("input");
            String serial = cmd.getOptionValue("serial");
            String output = cmd.getOptionValue("output");
            if (times < 1) {
                throw new Exception("Invalid number of submissions");
            }
            logger.info("Initializing security database: " + databaseDir);
            CryptoManager.initialize((String)databaseDir);
            String url = "http://" + hostname + ":" + port + path;
            OCSPProcessor processor = new OCSPProcessor();
            if (serial != null) {
                logger.info("Creating request for serial number " + serial);
                CertId certID = new CertId(serial);
                BigInteger serialNumber = certID.toBigInteger();
                request = processor.createRequest(caNickname, serialNumber);
            } else if (input != null) {
                logger.info("Loading request from " + input);
                try (FileInputStream in = new FileInputStream(input);){
                    byte[] data = new byte[in.available()];
                    in.read(data);
                    request = processor.createRequest(data);
                }
            } else {
                throw new Exception("Missing serial number or input file.");
            }
            OCSPResponse response = null;
            for (int i = 0; i < times; ++i) {
                logger.info("Submitting OCSP request");
                response = processor.submitRequest(url, request);
                ResponseBytes bytes = response.getResponseBytes();
                BasicOCSPResponse basic = (BasicOCSPResponse)BasicOCSPResponse.getTemplate().decode((InputStream)new ByteArrayInputStream(bytes.getResponse().toByteArray()));
                ResponseData rd = basic.getResponseData();
                for (int j = 0; j < rd.getResponseCount(); ++j) {
                    SingleResponse sr = rd.getResponseAt(j);
                    if (sr == null) {
                        throw new Exception("No OCSP Response data.");
                    }
                    INTEGER serialNumber = sr.getCertID().getSerialNumber();
                    CertId certID = new CertId((BigInteger)serialNumber);
                    System.out.println("CertID.serialNumber=" + certID.toHexString());
                    CertStatus status = sr.getCertStatus();
                    if (status instanceof GoodInfo) {
                        System.out.println("CertStatus=Good");
                        continue;
                    }
                    if (status instanceof UnknownInfo) {
                        System.out.println("CertStatus=Unknown");
                        continue;
                    }
                    if (!(status instanceof RevokedInfo)) continue;
                    System.out.println("CertStatus=Revoked");
                }
            }
            if (output == null) break block26;
            logger.info("Storing response into " + output);
            try (FileOutputStream out = new FileOutputStream(output);){
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                response.encode((OutputStream)os);
                out.write(os.toByteArray());
            }
            System.out.println("Success: Output " + output);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            OCSPClient client = new OCSPClient();
            client.execute(args);
        }
        catch (Exception e) {
            Object message = e.getClass().getSimpleName();
            if (e.getMessage() != null) {
                message = (String)message + ": " + e.getMessage();
            }
            if (logger.isInfoEnabled()) {
                logger.error((String)message, (Throwable)e);
            } else {
                logger.error((String)message);
            }
            System.exit(1);
        }
    }
}

