/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.client;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.client.ClientCLI;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ClientCertFindCLI.class);
    public ClientCLI clientCLI;

    public ClientCertFindCLI(ClientCLI clientCLI) {
        super("cert-find", "Find certificates in NSS database", (CLI)clientCLI);
        this.clientCLI = clientCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        this.options.addOption(null, "ca", false, "Find CA certificates only");
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CryptoManager manager = CryptoManager.getInstance();
        X509Certificate[] certs = cmd.hasOption("ca") ? manager.getCACerts() : manager.getPermCerts();
        if (certs == null || certs.length == 0) {
            MainCLI.printMessage("No certificates found");
            return;
        }
        MainCLI.printMessage(certs.length + " certificate(s) found");
        boolean first = true;
        for (X509Certificate cert : certs) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            ClientCLI.printCertInfo(cert);
        }
        MainCLI.printMessage("Number of entries returned " + certs.length);
    }
}

