/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.client;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.client.ClientCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.nss.NSSDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertModifyCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ClientCertModifyCLI.class);
    public ClientCLI clientCLI;

    public ClientCertModifyCLI(ClientCLI clientCLI) {
        super("cert-mod", "Modify certificate in NSS database", (CLI)clientCLI);
        this.clientCLI = clientCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <nickname> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "trust", true, "Trust flags. Default: u,u,u.");
        option.setArgName("trust flags");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length > 1) {
            throw new Exception("Too many arguments specified.");
        }
        if (cmdArgs.length == 0) {
            throw new Exception("Missing certificate nickname.");
        }
        MainCLI mainCLI = this.clientCLI.mainCLI;
        String nickname = cmdArgs[0];
        NSSDatabase nssdb = mainCLI.getNSSDatabase();
        String trustFlags = cmd.getOptionValue("trust", "u,u,u");
        String[] command = new String[]{"/usr/bin/certutil", "-M", "-d", nssdb.getPath().toString(), "-n", nickname, "-t", trustFlags};
        try {
            this.runExternal(command);
        }
        catch (Exception e) {
            throw new Exception("Unable to modify certificate", e);
        }
        MainCLI.printMessage("Modified certificate \"" + nickname + "\"");
    }
}

