/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.job;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.cmstools.cli.SubsystemCLI;
import com.netscape.cmstools.job.JobFindCLI;
import com.netscape.cmstools.job.JobShowCLI;
import com.netscape.cmstools.job.JobStartCLI;
import java.util.Map;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.job.JobClient;
import org.dogtagpki.job.JobInfo;

public class JobCLI
extends CLI {
    JobClient jobClient;

    public JobCLI(SubsystemCLI parent) {
        super("job", "Job management commands", (CLI)parent);
        this.addModule((CLI)new JobFindCLI(this));
        this.addModule((CLI)new JobShowCLI(this));
        this.addModule((CLI)new JobStartCLI(this));
    }

    public JobClient getJobClient() throws Exception {
        if (this.jobClient != null) {
            return this.jobClient;
        }
        SubsystemCLI subsystemCLI = (SubsystemCLI)this.parent;
        String subsystem = subsystemCLI.getName();
        PKIClient client = this.getClient();
        this.jobClient = new JobClient(client, subsystem);
        return this.jobClient;
    }

    public static void printJob(JobInfo jobInfo) {
        Map params;
        System.out.println("  Job ID: " + jobInfo.getID());
        System.out.println("  Enabled: " + jobInfo.isEnabled());
        String cron = jobInfo.getCron();
        if (cron != null) {
            System.out.println("  Cron: " + cron);
        }
        System.out.println("  Plugin: " + jobInfo.getPluginName());
        String owner = jobInfo.getOwner();
        if (owner != null) {
            System.out.println("  Owner: " + owner);
        }
        if (!(params = jobInfo.getParameters()).isEmpty()) {
            System.out.println();
            System.out.println("  Parameters:");
            for (String name : params.keySet()) {
                String value = (String)params.get(name);
                System.out.println("  - " + name + ": " + value);
            }
        }
    }
}

