/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs7;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs7.PKCS7CertCLI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.Cert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7CertFindCLI
extends CommandCLI {
    private static Logger logger = LoggerFactory.getLogger(PKCS7CertFindCLI.class);
    public PKCS7CertCLI certCLI;

    public PKCS7CertFindCLI(PKCS7CertCLI certCLI) {
        super("find", "Find certificates in PKCS #7 file", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] [nicknames...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "pkcs7", true, "PKCS #7 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs7-file", true, "DEPRECATED: PKCS #7 file");
        option.setArgName("path");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String filename = cmd.getOptionValue("pkcs7");
        if (filename == null && (filename = cmd.getOptionValue("pkcs7-file")) != null) {
            logger.warn("The --pkcs7-file has been deprecated. Use --pkcs7 instead.");
        }
        if (filename == null) {
            throw new Exception("Missing PKCS #7 file.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        logger.info("Loading PKCS #7 data from " + filename);
        String str = new String(Files.readAllBytes(Paths.get(filename, new String[0]))).trim();
        PKCS7 pkcs7 = new PKCS7(str);
        X509Certificate[] certs = pkcs7.getCertificates();
        if (certs == null || certs.length == 0) {
            System.out.println("PKCS #7 data contains no certificates");
            return;
        }
        certs = Cert.sortCertificateChain((X509Certificate[])certs);
        boolean first = true;
        for (X509Certificate cert : certs) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            PKCS7CertCLI.printCertInfo(cert);
        }
    }
}

