/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.range;

import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.range.RangeCLI;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.common.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeRequestCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(RangeRequestCLI.class);
    public RangeCLI rangeCLI;

    public RangeRequestCLI(RangeCLI rangeCLI) {
        super("request", "Request range", (CLI)rangeCLI);
        this.rangeCLI = rangeCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <type>", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "session", true, "Session ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "install-token", true, "Install token");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "output-format", true, "Output format: text (default), json");
        option.setArgName("format");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing range type");
        }
        String type = cmdArgs[0];
        String installToken = cmd.getOptionValue("install-token");
        String sessionID = installToken != null ? new String(Files.readAllBytes(Paths.get(installToken, new String[0]))) : cmd.getOptionValue("session");
        if (sessionID == null) {
            throw new Exception("Missing session ID or install token");
        }
        String outputFormat = cmd.getOptionValue("output-format", "text");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        SubsystemClient subsystemClient = this.rangeCLI.subsystemCLI.getSubsystemClient();
        Range range = subsystemClient.requestRange(type, sessionID);
        if ("json".equalsIgnoreCase(outputFormat)) {
            System.out.println(range.toJSON());
        } else {
            System.out.println("  Begin: " + range.getBegin());
            System.out.println("  End: " + range.getEnd());
        }
    }
}

