/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.system;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.system.SecurityDomainCLI;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;

public class SecurityDomainJoinCLI
extends CommandCLI {
    public SecurityDomainCLI securityDomainCLI;

    public SecurityDomainJoinCLI(SecurityDomainCLI securityDomainCLI) {
        super("join", "Join security domain", (CLI)securityDomainCLI);
        this.securityDomainCLI = securityDomainCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <host ID>", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "session", true, "Session ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "install-token", true, "Install token");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "type", true, "Subsystem type");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "hostname", true, "Hostname");
        option.setArgName("hostname");
        this.options.addOption(option);
        option = new Option(null, "unsecure-port", true, "Unsecure port (default: 8080)");
        option.setArgName("port");
        this.options.addOption(option);
        option = new Option(null, "secure-port", true, "Secure port (default: 8443)");
        option.setArgName("port");
        this.options.addOption(option);
        this.options.addOption(null, "domain-manager", false, "Domain manager");
        this.options.addOption(null, "clone", false, "Clone");
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing host ID");
        }
        String hostID = cmdArgs[0];
        String installToken = cmd.getOptionValue("install-token");
        String sessionID = installToken != null ? new String(Files.readAllBytes(Paths.get(installToken, new String[0]))) : cmd.getOptionValue("session");
        if (sessionID == null) {
            throw new Exception("Missing session ID or install token");
        }
        String type = cmd.getOptionValue("type");
        if (type == null) {
            throw new Exception("Missing subsystem type");
        }
        String hostname = cmd.getOptionValue("hostname");
        if (hostname == null) {
            throw new Exception("Missing hostname");
        }
        String unsecurePort = cmd.getOptionValue("unsecure-port", "8080");
        String securePort = cmd.getOptionValue("secure-port", "8443");
        boolean domainManager = cmd.hasOption("domain-manager");
        boolean clone = cmd.hasOption("clone");
        MultivaluedHashMap content = new MultivaluedHashMap();
        content.putSingle((Object)"sessionID", (Object)sessionID);
        content.putSingle((Object)"list", (Object)(type + "List"));
        content.putSingle((Object)"type", (Object)type);
        content.putSingle((Object)"name", (Object)hostID);
        content.putSingle((Object)"host", (Object)hostname);
        content.putSingle((Object)"httpport", (Object)unsecurePort);
        content.putSingle((Object)"sport", (Object)securePort);
        content.putSingle((Object)"agentsport", (Object)securePort);
        content.putSingle((Object)"adminsport", (Object)securePort);
        content.putSingle((Object)"eeclientauthsport", (Object)securePort);
        content.putSingle((Object)"dm", (Object)(domainManager ? "true" : "false"));
        content.putSingle((Object)"clone", (Object)(clone ? "true" : "false"));
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        PKIClient client = mainCLI.getClient();
        String response = (String)client.post("ca/admin/ca/updateDomainXML", (MultivaluedMap)content, String.class);
        if (StringUtils.isEmpty((CharSequence)response)) {
            logger.error("Missing response");
            throw new Exception("Missing response");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(response.getBytes());
        XMLObject obj = new XMLObject((InputStream)bis);
        String status = obj.getValue("Status");
        logger.info("Status: " + status);
        if (status.equals("0")) {
            return;
        }
        if (status.equals("1")) {
            throw new Exception("Authentication failure");
        }
        String error = obj.getValue("Error");
        throw new Exception(error);
    }
}

