/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.user;

import com.netscape.certsrv.user.UserClient;
import com.netscape.certsrv.user.UserCollection;
import com.netscape.certsrv.user.UserData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.user.UserCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(UserFindCLI.class);
    public UserCLI userCLI;

    public UserFindCLI(UserCLI userCLI) {
        super("find", "Find users", (CLI)userCLI);
        this.userCLI = userCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [FILTER] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        String filter = cmdArgs.length > 0 ? cmdArgs[0] : null;
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        UserClient userClient = this.userCLI.getUserClient();
        UserCollection response = userClient.findUsers(filter, start, size);
        MainCLI.printMessage(response.getTotal() + " entries matched");
        if (response.getTotal() == 0) {
            return;
        }
        Collection entries = response.getEntries();
        boolean first = true;
        for (UserData userData : entries) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            UserCLI.printUser(userData);
        }
        MainCLI.printMessage("Number of entries returned " + entries.size());
    }
}

