/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.cert;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.request.CMSRequestInfo;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CertRequestInfo
extends CMSRequestInfo {
    public static final String REQ_COMPLETE = "complete";
    public static final String RES_SUCCESS = "success";
    public static final String RES_ERROR = "error";
    protected CertId certId;
    protected String certURL;
    protected String certRequestType;
    protected String operationResult;
    protected String errorMessage;

    public void setCertRequestType(String certRequestType) {
        this.certRequestType = certRequestType;
    }

    public String getCertRequestType() {
        return this.certRequestType;
    }

    public void setCertURL(String certURL) {
        this.certURL = certURL;
    }

    public String getCertURL() {
        return this.certURL;
    }

    public CertId getCertId() {
        return this.certId;
    }

    public void setCertId(CertId certId) {
        this.certId = certId;
    }

    public String getOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(String operationResult) {
        this.operationResult = operationResult;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.certId == null ? 0 : this.certId.hashCode());
        result = 31 * result + (this.certRequestType == null ? 0 : this.certRequestType.hashCode());
        result = 31 * result + (this.certURL == null ? 0 : this.certURL.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertRequestInfo other = (CertRequestInfo)obj;
        if (this.certId == null ? other.certId != null : !this.certId.equals(other.certId)) {
            return false;
        }
        if (this.certRequestType == null ? other.certRequestType != null : !this.certRequestType.equals(other.certRequestType)) {
            return false;
        }
        return !(this.certURL == null ? other.certURL != null : !this.certURL.equals(other.certURL));
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Element toDOM(Document document) {
        Element subjectDNElement;
        Element infoElement = document.createElement("CertRequestInfo");
        this.toDOM(document, infoElement);
        if (this.certId != null) {
            subjectDNElement = document.createElement("certID");
            subjectDNElement.appendChild(document.createTextNode(this.certId.toHexString()));
            infoElement.appendChild(subjectDNElement);
            infoElement.setAttribute("id", this.certId.toHexString());
        }
        if (this.certURL != null) {
            subjectDNElement = document.createElement("certURL");
            subjectDNElement.appendChild(document.createTextNode(this.certURL));
            infoElement.appendChild(subjectDNElement);
        }
        if (this.certRequestType != null) {
            Element issuerDNElement = document.createElement("certRequestType");
            issuerDNElement.appendChild(document.createTextNode(this.certRequestType));
            infoElement.appendChild(issuerDNElement);
        }
        if (this.operationResult != null) {
            Element statusElement = document.createElement("operationResult");
            statusElement.appendChild(document.createTextNode(this.operationResult));
            infoElement.appendChild(statusElement);
        }
        if (this.errorMessage != null) {
            Element typeElement = document.createElement("errorMessage");
            typeElement.appendChild(document.createTextNode(this.errorMessage));
            infoElement.appendChild(typeElement);
        }
        return infoElement;
    }

    public static CertRequestInfo fromDOM(Element infoElement) {
        NodeList typeList;
        NodeList operationResultList;
        NodeList certRequestTypeList;
        CertRequestInfo info = new CertRequestInfo();
        CMSRequestInfo.fromDOM(infoElement, info);
        NodeList certIDLList = infoElement.getElementsByTagName("certID");
        if (certIDLList.getLength() > 0) {
            String value = certIDLList.item(0).getTextContent();
            info.setCertId(new CertId(value));
        } else {
            String id = infoElement.getAttribute("id");
            info.setCertId(StringUtils.isEmpty((CharSequence)id) ? null : new CertId(id));
        }
        NodeList certURLList = infoElement.getElementsByTagName("certURL");
        if (certURLList.getLength() > 0) {
            String value = certURLList.item(0).getTextContent();
            info.setCertURL(value);
        }
        if ((certRequestTypeList = infoElement.getElementsByTagName("certRequestType")).getLength() > 0) {
            String value = certRequestTypeList.item(0).getTextContent();
            info.setCertRequestType(value);
        }
        if ((operationResultList = infoElement.getElementsByTagName("operationResult")).getLength() > 0) {
            String value = operationResultList.item(0).getTextContent();
            info.setOperationResult(value);
        }
        if ((typeList = infoElement.getElementsByTagName("errorMessage")).getLength() > 0) {
            String value = typeList.item(0).getTextContent();
            info.setErrorMessage(value);
        }
        return info;
    }

    @Override
    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element element = this.toDOM(document);
        document.appendChild(element);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static CertRequestInfo fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element element = document.getDocumentElement();
        return CertRequestInfo.fromDOM(element);
    }
}

