/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.cert;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.profile.PolicyDefault;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfilePolicy;
import com.netscape.certsrv.profile.ProfilePolicySet;
import com.netscape.certsrv.request.RequestId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CertReviewResponse
extends CertEnrollmentRequest {
    @JsonProperty(value="ProfilePolicySet")
    protected List<ProfilePolicySet> policySets = new ArrayList<ProfilePolicySet>();
    @JsonProperty
    protected String nonce;
    @JsonProperty
    protected RequestId requestId;
    @JsonProperty
    protected String requestType;
    @JsonProperty
    protected String requestStatus;
    @JsonProperty
    protected String requestOwner;
    @JsonProperty
    protected String requestCreationTime;
    @JsonProperty
    protected String requestModificationTime;
    @JsonProperty
    protected String requestNotes;
    @JsonProperty
    protected String profileApprovedBy;
    @JsonProperty
    protected String profileSetId;
    @JsonProperty
    protected String profileIsVisible;
    @JsonProperty
    protected String profileName;
    @JsonProperty
    protected String profileDescription;
    @JsonProperty
    protected String profileRemoteHost;
    @JsonProperty
    protected String profileRemoteAddr;

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public void setRequestId(RequestId requestId) {
        this.requestId = requestId;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public String getRequestOwner() {
        return this.requestOwner;
    }

    public void setRequestOwner(String requestOwner) {
        this.requestOwner = requestOwner;
    }

    public String getRequestCreationTime() {
        return this.requestCreationTime;
    }

    public void setRequestCreationTime(String requestCreationTime) {
        this.requestCreationTime = requestCreationTime;
    }

    public String getRequestModificationTime() {
        return this.requestModificationTime;
    }

    public void setRequestModificationTime(String requestModificationTime) {
        this.requestModificationTime = requestModificationTime;
    }

    public String getRequestNotes() {
        return this.requestNotes;
    }

    public void setRequestNotes(String requestNotes) {
        this.requestNotes = requestNotes;
    }

    public String getProfileApprovedBy() {
        return this.profileApprovedBy;
    }

    public void setProfileApprovedBy(String profileApprovedBy) {
        this.profileApprovedBy = profileApprovedBy;
    }

    public String getProfileSetId() {
        return this.profileSetId;
    }

    public void setProfileSetId(String profileSetId) {
        this.profileSetId = profileSetId;
    }

    public String getProfileIsVisible() {
        return this.profileIsVisible;
    }

    public void setProfileIsVisible(String profileIsVisible) {
        this.profileIsVisible = profileIsVisible;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileDescription() {
        return this.profileDescription;
    }

    public void setProfileDescription(String profileDescription) {
        this.profileDescription = profileDescription;
    }

    public String getProfileRemoteHost() {
        return this.profileRemoteHost;
    }

    public void setProfileRemoteHost(String profileRemoteHost) {
        this.profileRemoteHost = profileRemoteHost;
    }

    public String getProfileRemoteAddr() {
        return this.profileRemoteAddr;
    }

    public void setProfileRemoteAddr(String profileRemoteAddr) {
        this.profileRemoteAddr = profileRemoteAddr;
    }

    public List<ProfilePolicySet> getPolicySets() {
        return this.policySets;
    }

    public void setPolicySets(List<ProfilePolicySet> policySets) {
        this.policySets = policySets;
    }

    public void addProfilePolicySet(ProfilePolicySet policySet) {
        this.policySets.add(policySet);
    }

    public void removeProfilePolicySet(ProfilePolicySet policySet) {
        this.policySets.remove(policySet);
    }

    @Override
    public HashMap<String, String> toParams() {
        HashMap<String, String> ret = super.toParams();
        if (this.requestId != null) {
            ret.put("requestId", this.requestId.toString());
        }
        if (this.requestNotes != null) {
            ret.put("requestNotes", this.requestNotes);
        }
        if (this.nonce != null) {
            ret.put("nonces", this.nonce);
        }
        if (this.requestType != null) {
            ret.put("requestType", this.requestType);
        }
        for (ProfilePolicySet policySet : this.policySets) {
            for (ProfilePolicy policy : policySet.getPolicies()) {
                PolicyDefault def = policy.getDef();
                List<ProfileAttribute> attrs = def.getAttributes();
                for (ProfileAttribute attr : attrs) {
                    ret.put(attr.getName(), attr.getValue());
                }
            }
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.nonce, this.policySets, this.profileApprovedBy, this.profileDescription, this.profileIsVisible, this.profileName, this.profileRemoteAddr, this.profileRemoteHost, this.profileSetId, this.requestCreationTime, this.requestId, this.requestModificationTime, this.requestNotes, this.requestOwner, this.requestStatus, this.requestType);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertReviewResponse other = (CertReviewResponse)obj;
        return Objects.equals(this.nonce, other.nonce) && Objects.equals(this.policySets, other.policySets) && Objects.equals(this.profileApprovedBy, other.profileApprovedBy) && Objects.equals(this.profileDescription, other.profileDescription) && Objects.equals(this.profileIsVisible, other.profileIsVisible) && Objects.equals(this.profileName, other.profileName) && Objects.equals(this.profileRemoteAddr, other.profileRemoteAddr) && Objects.equals(this.profileRemoteHost, other.profileRemoteHost) && Objects.equals(this.profileSetId, other.profileSetId) && Objects.equals(this.requestCreationTime, other.requestCreationTime) && Objects.equals(this.requestId, other.requestId) && Objects.equals(this.requestModificationTime, other.requestModificationTime) && Objects.equals(this.requestNotes, other.requestNotes) && Objects.equals(this.requestOwner, other.requestOwner) && Objects.equals(this.requestStatus, other.requestStatus) && Objects.equals(this.requestType, other.requestType);
    }
}

