/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.dbs.keydb;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.netscape.certsrv.util.JSONSerializer;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeyId
implements JSONSerializer {
    protected byte[] value;

    public KeyId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Missing key ID");
        }
        if (!(id = id.trim()).startsWith("0x")) {
            this.value = new BigInteger(id).toByteArray();
            return;
        }
        id = id.substring(2);
        try {
            this.value = Hex.decodeHex((String)id);
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    public KeyId(byte[] bytes) {
        this.value = bytes;
    }

    public KeyId(BigInteger id) {
        this.value = id.toByteArray();
    }

    public KeyId(int id) {
        this.value = BigInteger.valueOf(id).toByteArray();
    }

    public BigInteger toBigInteger() {
        return new BigInteger(this.value);
    }

    public String toString() {
        return this.toBigInteger().toString();
    }

    @JsonValue
    public String toHexString() {
        return "0x" + Hex.encodeHexString((byte[])this.value);
    }

    public byte[] toByteArray() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyId other = (KeyId)obj;
        return Arrays.equals(this.value, other.value);
    }
}

