/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.ldap;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.ConflictingOperationException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import netscape.ldap.LDAPException;

public class LDAPExceptionConverter {
    public static PKIException toPKIException(LDAPException e) {
        switch (e.getLDAPResultCode()) {
            case 20: {
                return new ConflictingOperationException("Attribute or value exists.", (Throwable)e);
            }
            case 32: {
                return new ResourceNotFoundException("No such object.", (Throwable)e);
            }
            case 16: {
                return new ResourceNotFoundException("No such attribute.", (Throwable)e);
            }
            case 34: {
                return new BadRequestException("Invalid DN syntax.", (Throwable)e);
            }
            case 21: {
                return new BadRequestException("Invalid attribute syntax.", (Throwable)e);
            }
            case 68: {
                return new ConflictingOperationException("Entry already exists.", (Throwable)e);
            }
        }
        return new PKIException("LDAP error (" + e.getLDAPResultCode() + "): " + e.getMessage(), (Throwable)e);
    }
}

