/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ldap;

import netscape.ldap.LDAPControl;

public class LDAPUtil {
    public static String SPECIAL_CHARS = "*()\\\u0000";

    public static String escapeFilter(Object object) {
        StringBuilder sb = new StringBuilder();
        for (char c : object.toString().toCharArray()) {
            if (SPECIAL_CHARS.indexOf(c) >= 0) {
                sb.append('\\');
                if (c < '\u0010') {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapeRDNValue(Object value) {
        return LDAPUtil.escapeRDNValue(value.toString(), false);
    }

    public static String escapeRDNValue(String value, boolean doubleEscape) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == ',' || c == '=' || c == '+' || c == '<' || c == '>' || c == '#' || c == ';' || c == '\r' || c == '\n' || c == '\\' || c == '\"') {
                if (c == '\\' && i + 1 < value.length()) {
                    char nextC = value.charAt(i + 1);
                    if (c == '\\' && (nextC == ',' || nextC == '=' || nextC == '+' || nextC == '<' || nextC == '>' || nextC == '#' || nextC == ';' || nextC == '\r' || nextC == '\n' || nextC == '\\' || nextC == '\"')) {
                        if (doubleEscape) {
                            sb.append('\\');
                        }
                    } else {
                        sb.append('\\');
                        if (doubleEscape) {
                            sb.append('\\');
                        }
                    }
                } else {
                    sb.append('\\');
                    if (doubleEscape) {
                        sb.append('\\');
                    }
                }
            }
            if (c == '\r') {
                sb.append("0D");
                continue;
            }
            if (c == '\n') {
                sb.append("0A");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static LDAPControl getControl(Class<? extends LDAPControl> cls, LDAPControl[] controls) {
        if (controls != null) {
            for (LDAPControl control : controls) {
                if (!cls.isInstance(control)) continue;
                return control;
            }
        }
        return null;
    }
}

