/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps.apdu;

import org.dogtagpki.tps.apdu.APDU;
import org.dogtagpki.tps.main.TPSBuffer;
import org.dogtagpki.tps.main.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APDUResponse
extends APDU {
    public static Logger logger = LoggerFactory.getLogger(APDUResponse.class);

    public APDUResponse() {
    }

    public APDUResponse(TPSBuffer theData) {
        this.setData(theData);
    }

    public APDUResponse(APDUResponse cpy) {
        super(cpy);
    }

    public byte getSW1() {
        return this.data == null || this.data.size() < 2 ? (byte)0 : this.data.at(this.data.size() - 2);
    }

    public byte getSW2() {
        return this.data == null || this.data.size() < 2 ? (byte)0 : this.data.at(this.data.size() - 1);
    }

    public boolean checkResult() {
        boolean result = false;
        byte sw1 = this.getSW1();
        byte sw2 = this.getSW2();
        int int1 = sw1 & 0xFF;
        int int2 = sw2 & 0xFF;
        logger.debug("APDUResponse.checkResult: sw1: 0x" + Util.intToHex(int1) + " sw2: 0x" + Util.intToHex(int2));
        if (sw1 == -112 && sw2 == 0) {
            result = true;
        }
        return result;
    }

    public byte[] getResultCodeBytes() {
        byte[] result = new byte[]{this.getSW1(), this.getSW2()};
        return result;
    }

    public TPSBuffer getResultDataNoCode() {
        TPSBuffer theData = this.getData();
        TPSBuffer result = null;
        int len = theData.size();
        if (len > 2) {
            result = theData.substr(0, len - 2);
        }
        return result;
    }

    public static void main(String[] args) {
        APDUResponse resp = new APDUResponse();
        resp.dump();
    }
}

