/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps.msg;

import org.dogtagpki.tps.apdu.APDU;
import org.dogtagpki.tps.apdu.SelectAPDU;
import org.dogtagpki.tps.main.TPSBuffer;
import org.dogtagpki.tps.main.Util;
import org.dogtagpki.tps.msg.TPSMessage;

public class TokenPDURequestMsg
extends TPSMessage {
    public TokenPDURequestMsg(APDU apdu) {
        this.put("msg_type", this.msgTypeToInt(TPSMessage.MsgType.MSG_TOKEN_PDU_REQUEST));
        if (apdu != null) {
            TPSBuffer encoding = apdu.getEncoding();
            int apduSize = encoding.size();
            String apdu_value = Util.uriEncodeInHex(encoding.toBytesArray());
            this.put("pdu_size", apduSize);
            this.put("pdu_data", apdu_value);
        }
    }

    public static void main(String[] args) {
        SelectAPDU apdu = null;
        byte[] select_aid = new byte[]{-96, 0, 0, 0, 3, 0, 0};
        TPSBuffer select = new TPSBuffer(select_aid);
        apdu = new SelectAPDU(4, 0, select);
        TokenPDURequestMsg request = new TokenPDURequestMsg(apdu);
        System.out.println(request.encode());
    }
}

