/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CRLConfig;
import com.netscape.ca.CRLExtensionsConfig;
import com.netscape.ca.CRLIssuingPoint;
import com.netscape.ca.CRLIssuingPointConfig;
import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotDefined;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.dogtagpki.server.ca.CMSCRLExtension;
import org.mozilla.jss.netscape.security.extensions.AuthInfoAccessExtension;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.DeltaCRLIndicatorExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.FreshestCRLExtension;
import org.mozilla.jss.netscape.security.x509.HoldInstructionExtension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSCRLExtensions {
    public static Logger logger = LoggerFactory.getLogger(CMSCRLExtensions.class);
    public static final String PROP_ENABLE = "enable";
    public static final String PROP_CLASS = "class";
    public static final String PROP_TYPE = "type";
    public static final String PROP_CRITICAL = "critical";
    public static final String PROP_CRL_EXT = "CRLExtension";
    public static final String PROP_CRL_ENTRY_EXT = "CRLEntryExtension";
    private CRLIssuingPoint mCRLIssuingPoint;
    private CRLIssuingPointConfig mConfig;
    private CRLExtensionsConfig mCRLExtConfig;
    private Vector<String> mCRLExtensionNames = new Vector();
    private Vector<String> mCRLEntryExtensionNames = new Vector();
    private Vector<String> mEnabledCRLExtensions = new Vector();
    private Vector<String> mCriticalCRLExtensions = new Vector();
    private Hashtable<String, String> mCRLExtensionClassNames = new Hashtable();
    private Hashtable<String, String> mCRLExtensionIDs = new Hashtable();
    private static final Vector<String> mDefaultCRLExtensionNames = new Vector();
    private static final Vector<String> mDefaultCRLEntryExtensionNames = new Vector();
    private static final Vector<String> mDefaultEnabledCRLExtensions = new Vector();
    private static final Vector<String> mDefaultCriticalCRLExtensions = new Vector();
    private static final Hashtable<String, String> mDefaultCRLExtensionClassNames = new Hashtable();
    private static final Hashtable<String, String> mDefaultCRLExtensionIDs = new Hashtable();

    public CMSCRLExtensions(CRLIssuingPoint crlIssuingPoint, CRLIssuingPointConfig config) {
        CAEngineConfig mFileConfig;
        boolean modifiedConfig = false;
        CAEngine engine = CAEngine.getInstance();
        this.mConfig = config;
        this.mCRLExtConfig = config.getExtensionsConfig();
        this.mCRLIssuingPoint = crlIssuingPoint;
        CAEngineConfig crlExtConfig = mFileConfig = engine.getConfig();
        StringTokenizer st = new StringTokenizer(this.mCRLExtConfig.getName(), ".");
        while (st.hasMoreTokens()) {
            String subStoreName = st.nextToken();
            ConfigStore newConfig = crlExtConfig.getSubStore(subStoreName, ConfigStore.class);
            if (newConfig == null) continue;
            crlExtConfig = newConfig;
        }
        if (crlExtConfig != null) {
            Enumeration enumExts = crlExtConfig.getSubStoreNames().elements();
            while (enumExts.hasMoreElements()) {
                String extName = (String)enumExts.nextElement();
                ConfigStore extConfig = crlExtConfig.getSubStore(extName, ConfigStore.class);
                if (extConfig == null) continue;
                modifiedConfig |= this.getEnableProperty(extName, extConfig);
                modifiedConfig |= this.getCriticalProperty(extName, extConfig);
                modifiedConfig |= this.getTypeProperty(extName, extConfig);
                modifiedConfig |= this.getClassProperty(extName, extConfig);
            }
            if (modifiedConfig) {
                try {
                    mFileConfig.commit(true);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_SAVE_CONF", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
            }
        }
    }

    private boolean getEnableProperty(String extName, ConfigStore extConfig) {
        boolean modifiedConfig = false;
        try {
            if (extConfig.getBoolean(PROP_ENABLE)) {
                this.mEnabledCRLExtensions.addElement(extName);
            }
        }
        catch (EPropertyNotFound e) {
            extConfig.putBoolean(PROP_ENABLE, mDefaultEnabledCRLExtensions.contains(extName));
            modifiedConfig = true;
            if (mDefaultEnabledCRLExtensions.contains(extName)) {
                this.mEnabledCRLExtensions.addElement(extName);
            }
            logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_NO_ENABLE", (Object[])new Object[]{extName, mDefaultEnabledCRLExtensions.contains(extName) ? "true" : "false"}), (Throwable)e);
        }
        catch (EPropertyNotDefined e) {
            extConfig.putBoolean(PROP_ENABLE, mDefaultEnabledCRLExtensions.contains(extName));
            modifiedConfig = true;
            if (mDefaultEnabledCRLExtensions.contains(extName)) {
                this.mEnabledCRLExtensions.addElement(extName);
            }
            logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_UNDEFINE_ENABLE", (Object[])new Object[]{extName, mDefaultEnabledCRLExtensions.contains(extName) ? "true" : "false"}), (Throwable)e);
        }
        catch (EBaseException e) {
            extConfig.putBoolean(PROP_ENABLE, mDefaultEnabledCRLExtensions.contains(extName));
            modifiedConfig = true;
            if (mDefaultEnabledCRLExtensions.contains(extName)) {
                this.mEnabledCRLExtensions.addElement(extName);
            }
            logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_INVALID_ENABLE", (Object[])new Object[]{extName, mDefaultEnabledCRLExtensions.contains(extName) ? "true" : "false"}), (Throwable)e);
        }
        return modifiedConfig;
    }

    private boolean getCriticalProperty(String extName, ConfigStore extConfig) {
        boolean modifiedConfig = false;
        try {
            if (extConfig.getBoolean(PROP_CRITICAL)) {
                this.mCriticalCRLExtensions.addElement(extName);
            }
        }
        catch (EPropertyNotFound e) {
            extConfig.putBoolean(PROP_CRITICAL, mDefaultCriticalCRLExtensions.contains(extName));
            modifiedConfig = true;
            if (mDefaultCriticalCRLExtensions.contains(extName)) {
                this.mCriticalCRLExtensions.addElement(extName);
            }
            logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_NO_CRITICAL", (Object[])new Object[]{extName, mDefaultEnabledCRLExtensions.contains(extName) ? "true" : "false"}), (Throwable)e);
        }
        catch (EPropertyNotDefined e) {
            extConfig.putBoolean(PROP_CRITICAL, mDefaultCriticalCRLExtensions.contains(extName));
            modifiedConfig = true;
            if (mDefaultCriticalCRLExtensions.contains(extName)) {
                this.mCriticalCRLExtensions.addElement(extName);
            }
            logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_UNDEFINE_CRITICAL", (Object[])new Object[]{extName, mDefaultEnabledCRLExtensions.contains(extName) ? "true" : "false"}), (Throwable)e);
        }
        catch (EBaseException e) {
            extConfig.putBoolean(PROP_CRITICAL, mDefaultCriticalCRLExtensions.contains(extName));
            modifiedConfig = true;
            if (mDefaultCriticalCRLExtensions.contains(extName)) {
                this.mCriticalCRLExtensions.addElement(extName);
            }
            logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_INVALID_CRITICAL", (Object[])new Object[]{extName, mDefaultEnabledCRLExtensions.contains(extName) ? "true" : "false"}), (Throwable)e);
        }
        return modifiedConfig;
    }

    private boolean getTypeProperty(String extName, ConfigStore extConfig) {
        boolean modifiedConfig = false;
        String extType = null;
        try {
            extType = extConfig.getString(PROP_TYPE);
            if (extType.length() > 0) {
                if (extType.equals(PROP_CRL_ENTRY_EXT)) {
                    this.mCRLEntryExtensionNames.addElement(extName);
                } else if (extType.equals(PROP_CRL_EXT)) {
                    this.mCRLExtensionNames.addElement(extName);
                } else if (mDefaultCRLEntryExtensionNames.contains(extName)) {
                    extConfig.putString(PROP_TYPE, PROP_CRL_ENTRY_EXT);
                    modifiedConfig = true;
                    this.mCRLEntryExtensionNames.addElement(extName);
                    logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_INVALID_EXT", (Object[])new Object[]{extName, PROP_CRL_ENTRY_EXT}));
                } else if (mDefaultCRLExtensionNames.contains(extName)) {
                    extConfig.putString(PROP_TYPE, PROP_CRL_EXT);
                    modifiedConfig = true;
                    this.mCRLExtensionNames.addElement(extName);
                    logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_INVALID_EXT", (Object[])new Object[]{extName, PROP_CRL_EXT}));
                } else {
                    logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_INVALID_EXT", (Object[])new Object[]{extName, ""}));
                }
            } else {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_UNDEFINE_EXT", (Object[])new Object[]{extName}));
            }
        }
        catch (EPropertyNotFound e) {
            if (mDefaultCRLEntryExtensionNames.contains(extName)) {
                extConfig.putString(PROP_TYPE, PROP_CRL_ENTRY_EXT);
                modifiedConfig = true;
            } else if (mDefaultCRLExtensionNames.contains(extName)) {
                extConfig.putString(PROP_TYPE, PROP_CRL_EXT);
                modifiedConfig = true;
            }
            logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_MISSING_EXT", (Object[])new Object[]{extName}), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_INVALID_EXT", (Object[])new Object[]{extName, ""}), (Throwable)e);
        }
        return modifiedConfig;
    }

    private boolean getClassProperty(String extName, ConfigStore extConfig) {
        boolean modifiedConfig;
        block10: {
            modifiedConfig = false;
            String extClass = null;
            try {
                extClass = extConfig.getString(PROP_CLASS);
                if (extClass.length() > 0) {
                    this.mCRLExtensionClassNames.put(extName, extClass);
                    try {
                        String id;
                        CMSCRLExtension cmsCRLExt;
                        Class<?> crlExtClass = Class.forName(extClass);
                        if (crlExtClass != null && (cmsCRLExt = (CMSCRLExtension)crlExtClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) != null && (id = cmsCRLExt.getCRLExtOID()) != null) {
                            this.mCRLExtensionIDs.put(id, extName);
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        logger.warn("CMSCRLExtensions: " + e.getMessage(), (Throwable)e);
                    }
                    break block10;
                }
                if (mDefaultCRLExtensionClassNames.containsKey(extName)) {
                    extClass = this.mCRLExtensionClassNames.get(extName);
                    extConfig.putString(PROP_CLASS, extClass);
                    modifiedConfig = true;
                }
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_CLASS_NOT_DEFINED", (Object[])new Object[]{extName}));
            }
            catch (EPropertyNotFound e) {
                if (mDefaultCRLExtensionClassNames.containsKey(extName)) {
                    extClass = mDefaultCRLExtensionClassNames.get(extName);
                    extConfig.putString(PROP_CLASS, extClass);
                    modifiedConfig = true;
                }
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_CLASS_MISSING", (Object[])new Object[]{extName}), (Throwable)e);
            }
            catch (EBaseException e) {
                if (mDefaultCRLExtensionClassNames.containsKey(extName)) {
                    extClass = mDefaultCRLExtensionClassNames.get(extName);
                    extConfig.putString(PROP_CLASS, extClass);
                    modifiedConfig = true;
                }
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_CLASS_INVALID", (Object[])new Object[]{extName}), (Throwable)e);
            }
        }
        return modifiedConfig;
    }

    public boolean isCRLExtension(String extName) {
        return this.mCRLExtensionNames.contains(extName);
    }

    public boolean isCRLEntryExtension(String extName) {
        return this.mCRLEntryExtensionNames.contains(extName);
    }

    public boolean isCRLExtensionEnabled(String extName) {
        return (this.mCRLExtensionNames.contains(extName) || this.mCRLEntryExtensionNames.contains(extName)) && this.mEnabledCRLExtensions.contains(extName);
    }

    public boolean isCRLExtensionCritical(String extName) {
        return this.mCriticalCRLExtensions.contains(extName);
    }

    public String getCRLExtensionName(String id) {
        String name = null;
        if (this.mCRLExtensionIDs.containsKey(id)) {
            name = this.mCRLExtensionIDs.get(id);
        }
        return name;
    }

    public Vector<String> getCRLExtensionNames() {
        return new Vector<String>(this.mCRLExtensionNames);
    }

    public Vector<String> getCRLEntryExtensionNames() {
        return new Vector<String>(this.mCRLEntryExtensionNames);
    }

    public void addToCRLExtensions(CRLExtensions crlExts, String extName, Extension ext) {
        if (this.mCRLExtensionClassNames.containsKey(extName)) {
            String name = this.mCRLExtensionClassNames.get(extName);
            try {
                CMSCRLExtension cmsCRLExt;
                Class<?> extClass = Class.forName(name);
                if (extClass != null && (cmsCRLExt = (CMSCRLExtension)extClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) != null) {
                    if (ext != null) {
                        if (this.isCRLExtensionCritical(extName) ^ ext.isCritical()) {
                            ext = cmsCRLExt.setCRLExtensionCriticality(ext, this.isCRLExtensionCritical(extName));
                        }
                    } else {
                        ext = cmsCRLExt.getCRLExtension(this.mCRLExtConfig.getSubStore(extName, ConfigStore.class), this.mCRLIssuingPoint, this.isCRLExtensionCritical(extName));
                    }
                    if (crlExts != null && ext != null) {
                        crlExts.set(extName, ext);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("CMSCRLExtensions: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public NameValuePairs getConfigParams(String id) {
        NameValuePairs nvp = null;
        if (this.mCRLEntryExtensionNames.contains(id) || this.mCRLExtensionNames.contains(id)) {
            String name;
            nvp = new NameValuePairs();
            if (this.mEnabledCRLExtensions.contains(id)) {
                nvp.put((Object)PROP_ENABLE, (Object)"true");
            } else {
                nvp.put((Object)PROP_ENABLE, (Object)"false");
            }
            if (this.mCriticalCRLExtensions.contains(id)) {
                nvp.put((Object)PROP_CRITICAL, (Object)"true");
            } else {
                nvp.put((Object)PROP_CRITICAL, (Object)"false");
            }
            if (this.mCRLExtensionClassNames.containsKey(id) && (name = this.mCRLExtensionClassNames.get(id)) != null) {
                String idName;
                try {
                    CMSCRLExtension cmsCRLExt;
                    Class<?> extClass = Class.forName(name);
                    if (extClass != null && (cmsCRLExt = (CMSCRLExtension)extClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) != null) {
                        cmsCRLExt.getConfigParams(this.mCRLExtConfig.getSubStore(id, ConfigStore.class), nvp);
                    }
                }
                catch (Exception e) {
                    logger.warn("CMSCRLExtensions: " + e.getMessage(), (Throwable)e);
                }
                int i = name.lastIndexOf(46);
                if (i > -1 && i + 1 < name.length() && (idName = name.substring(i + 1)) != null) {
                    nvp.put((Object)"implName", (Object)idName);
                }
            }
        }
        return nvp;
    }

    public void setConfigParams(String id, NameValuePairs nvp, ConfigStore config) {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        String ipId = (String)nvp.get((Object)"id");
        CRLIssuingPoint ip = null;
        if (ipId != null && ca != null) {
            ip = engine.getCRLIssuingPoint(ipId);
        }
        for (Map.Entry entry : nvp.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (name.equals(PROP_ENABLE)) {
                if (!value.equals("true") && !value.equals("false")) continue;
                if (value.equals("true") && !this.mEnabledCRLExtensions.contains(id)) {
                    this.mEnabledCRLExtensions.addElement(id);
                }
                if (value.equals("false")) {
                    this.mEnabledCRLExtensions.remove(id);
                }
            }
            if (name.equals(PROP_CRITICAL)) {
                if (!value.equals("true") && !value.equals("false")) continue;
                if (value.equals("true") && !this.mCriticalCRLExtensions.contains(id)) {
                    this.mCriticalCRLExtensions.addElement(id);
                }
                if (value.equals("false")) {
                    this.mCriticalCRLExtensions.remove(id);
                }
            }
            if (name.equals("onlyContainsCACerts")) {
                NameValuePairs crlIssuingPointPairs = null;
                boolean crlCACertsOnly = false;
                boolean issuingDistPointExtEnabled = false;
                CMSCRLExtensions cmsCRLExtensions = null;
                if (ip != null) {
                    cmsCRLExtensions = ip.getCRLExtensions();
                }
                if (cmsCRLExtensions != null) {
                    issuingDistPointExtEnabled = cmsCRLExtensions.isCRLExtensionEnabled("IssuingDistributionPoint");
                }
                logger.debug("issuingDistPointExtEnabled = " + issuingDistPointExtEnabled);
                if (!value.equals("true") && !value.equals("false")) continue;
                if (ip != null && issuingDistPointExtEnabled) {
                    crlCACertsOnly = ip.isCACertsOnly();
                    logger.debug("CRLCACertsOnly is: " + crlCACertsOnly);
                    crlIssuingPointPairs = new NameValuePairs();
                }
                String newValue = "";
                boolean modifiedCRLConfig = false;
                if (value.equals("true") && issuingDistPointExtEnabled && !crlCACertsOnly) {
                    logger.debug(" value = true and CRLCACertsOnly is already false.");
                    crlIssuingPointPairs.put((Object)"caCertsOnly", (Object)"true");
                    newValue = "true";
                    ip.updateConfig(crlIssuingPointPairs);
                    modifiedCRLConfig = true;
                }
                if (value.equals("false") && issuingDistPointExtEnabled && ip != null) {
                    crlIssuingPointPairs.put((Object)"caCertsOnly", (Object)"false");
                    ip.updateConfig(crlIssuingPointPairs);
                    newValue = "false";
                    modifiedCRLConfig = true;
                }
                if (modifiedCRLConfig) {
                    CAConfig caConfig = ca.getConfigStore();
                    CRLConfig crlConfig = caConfig.getCRLConfig();
                    CRLIssuingPointConfig ipConfig = crlConfig.getCRLIssuingPointConfig(ipId);
                    try {
                        ipConfig.putString("caCertsOnly", newValue);
                        ipConfig.commit(true);
                    }
                    catch (EBaseException e) {
                        logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CRLEXTS_SAVE_CONF", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                }
            }
            config.putString(name, value);
        }
    }

    public String getClassPath(String name) {
        Enumeration<String> enum1 = this.mCRLExtensionClassNames.elements();
        while (enum1.hasMoreElements()) {
            String idName;
            int i;
            String extClassName = enum1.nextElement();
            if (extClassName == null || (i = extClassName.lastIndexOf(46)) <= -1 || i + 1 >= extClassName.length() || (idName = extClassName.substring(i + 1)) == null || !name.equals(idName)) continue;
            return extClassName;
        }
        return null;
    }

    static {
        mDefaultCRLExtensionNames.addElement("AuthorityKeyIdentifier");
        mDefaultCRLExtensionNames.addElement("IssuerAlternativeName");
        mDefaultCRLExtensionNames.addElement("CRLNumber");
        mDefaultCRLExtensionNames.addElement("DeltaCRLIndicator");
        mDefaultCRLExtensionNames.addElement("IssuingDistributionPoint");
        mDefaultCRLExtensionNames.addElement("FreshestCRL");
        mDefaultCRLExtensionNames.addElement("AuthorityInformationAccess");
        mDefaultCRLEntryExtensionNames.addElement("CRLReason");
        mDefaultCRLEntryExtensionNames.addElement("InvalidityDate");
        mDefaultEnabledCRLExtensions.addElement("CRLNumber");
        mDefaultEnabledCRLExtensions.addElement("CRLReason");
        mDefaultEnabledCRLExtensions.addElement("InvalidityDate");
        mDefaultCriticalCRLExtensions.addElement("DeltaCRLIndicator");
        mDefaultCriticalCRLExtensions.addElement("IssuingDistributionPoint");
        mDefaultCRLExtensionIDs.put(PKIXExtensions.AuthorityKey_Id.toString(), "AuthorityKeyIdentifier");
        mDefaultCRLExtensionIDs.put(PKIXExtensions.IssuerAlternativeName_Id.toString(), "IssuerAlternativeName");
        mDefaultCRLExtensionIDs.put(PKIXExtensions.CRLNumber_Id.toString(), "CRLNumber");
        mDefaultCRLExtensionIDs.put(PKIXExtensions.DeltaCRLIndicator_Id.toString(), "DeltaCRLIndicator");
        mDefaultCRLExtensionIDs.put(PKIXExtensions.IssuingDistributionPoint_Id.toString(), "IssuingDistributionPoint");
        mDefaultCRLExtensionIDs.put(PKIXExtensions.ReasonCode_Id.toString(), "CRLReason");
        mDefaultCRLExtensionIDs.put(PKIXExtensions.HoldInstructionCode_Id.toString(), "HoldInstruction");
        mDefaultCRLExtensionIDs.put(PKIXExtensions.InvalidityDate_Id.toString(), "InvalidityDate");
        mDefaultCRLExtensionIDs.put(PKIXExtensions.FreshestCRL_Id.toString(), "FreshestCRL");
        mDefaultCRLExtensionIDs.put(AuthInfoAccessExtension.ID.toString(), "AuthorityInformationAccess");
        mDefaultCRLExtensionClassNames.put("AuthorityKeyIdentifier", "com.netscape.cms.crl.CMSAuthorityKeyIdentifierExtension");
        mDefaultCRLExtensionClassNames.put("IssuerAlternativeName", "com.netscape.cms.crl.CMSIssuerAlternativeNameExtension");
        mDefaultCRLExtensionClassNames.put("CRLNumber", "com.netscape.cms.crl.CMSCRLNumberExtension");
        mDefaultCRLExtensionClassNames.put("DeltaCRLIndicator", "com.netscape.cms.crl.CMSDeltaCRLIndicatorExtension");
        mDefaultCRLExtensionClassNames.put("IssuingDistributionPoint", "com.netscape.cms.crl.CMSIssuingDistributionPointExtension");
        mDefaultCRLExtensionClassNames.put("CRLReason", "com.netscape.cms.crl.CMSCRLReasonExtension");
        mDefaultCRLExtensionClassNames.put("HoldInstruction", "com.netscape.cms.crl.CMSHoldInstructionExtension");
        mDefaultCRLExtensionClassNames.put("InvalidityDate", "com.netscape.cms.crl.CMSInvalidityDateExtension");
        mDefaultCRLExtensionClassNames.put("FreshestCRL", "com.netscape.cms.crl.CMSFreshestCRLExtension");
        mDefaultCRLExtensionClassNames.put("AuthorityInformationAccess", "com.netscape.cms.crl.CMSAuthInfoAccessExtension");
        try {
            OIDMap.addAttribute((String)DeltaCRLIndicatorExtension.class.getName(), (String)"2.5.29.27", (String)"DeltaCRLIndicator");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        try {
            OIDMap.addAttribute((String)HoldInstructionExtension.class.getName(), (String)"2.5.29.23", (String)"HoldInstruction");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        try {
            OIDMap.addAttribute((String)InvalidityDateExtension.class.getName(), (String)"2.5.29.24", (String)"InvalidityDate");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        try {
            OIDMap.addAttribute((String)FreshestCRLExtension.class.getName(), (String)"2.5.29.46", (String)"FreshestCRL");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

