/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.fasterxml.jackson.databind.JsonNode;
import com.netscape.ca.KeyRetriever;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmsutil.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalProcessKeyRetriever
implements KeyRetriever {
    public static Logger logger = LoggerFactory.getLogger(ExternalProcessKeyRetriever.class);
    protected String executable;

    public ExternalProcessKeyRetriever(ConfigStore config) {
        if (config == null) {
            throw new IllegalArgumentException("Missing config");
        }
        try {
            this.executable = config.getString("executable");
        }
        catch (EPropertyNotFound e) {
            throw new IllegalArgumentException("Missing 'executable' config property");
        }
        catch (EBaseException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyRetriever.Result retrieveKey(String nickname, Collection<String> hostPorts) {
        logger.info("ExternalProcessKeyRetriever: Retrieving " + nickname + " key");
        Stack<String> command = new Stack<String>();
        command.push(this.executable);
        command.push(nickname);
        for (String hostPort : hostPorts) {
            String host = hostPort.split(":")[0];
            command.push(host);
            logger.debug("ExternalProcessKeyRetriever: Command: " + command);
            ProcessBuilder pb = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.INHERIT);
            try {
                Process p = pb.start();
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    logger.warn("Unable to retrieve " + nickname + " key from " + host + ": RC=" + exitValue);
                    continue;
                }
                KeyRetriever.Result result = this.parseResult(p.getInputStream());
                return result;
            }
            catch (Throwable e) {
                logger.warn("Unable to retrieve " + nickname + " key from " + host + ": " + e.getMessage(), e);
            }
            finally {
                command.pop();
            }
        }
        logger.error("Unable to retrieve " + nickname + " key");
        return null;
    }

    private KeyRetriever.Result parseResult(InputStream in) throws IOException {
        String result = new String(in.readAllBytes());
        logger.debug("ExternalProcessKeyRetriever: Result:\n" + result);
        JsonNode root = new JSONObject(result).getJsonNode();
        JsonNode certNode = root.path("certificate");
        if (certNode.isMissingNode()) {
            throw new RuntimeException("Missing \"certificate\" node");
        }
        if (!certNode.isTextual()) {
            throw new RuntimeException("Invalid \"certificate\" node: " + certNode);
        }
        String cert = certNode.textValue();
        if (StringUtils.isEmpty((CharSequence)cert)) {
            throw new RuntimeException("Missing \"certificate\" value");
        }
        JsonNode wrappedKeyNode = root.path("wrapped_key");
        if (wrappedKeyNode.isMissingNode()) {
            throw new RuntimeException("Missing \"wrapped_key\" node");
        }
        byte[] pao = wrappedKeyNode.binaryValue();
        if (pao.length == 0) {
            throw new RuntimeException("Missing \"wrapped_key\" value");
        }
        return new KeyRetriever.Result(cert.getBytes(), pao);
    }
}

