/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFileAuth
extends AuthManager
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(FlatFileAuth.class);
    protected static final String PROP_FILENAME = "fileName";
    protected static final String PROP_KEYATTRIBUTES = "keyAttributes";
    protected static final String PROP_AUTHATTRS = "authAttributes";
    protected static final String PROP_DEFERONFAILURE = "deferOnFailure";
    protected String mFilename = "config/pwfile";
    protected long mFileLastRead = 0L;
    protected String mKeyAttributes = "UID";
    protected String mAuthAttrs = "PWD";
    protected boolean mDeferOnFailure = true;
    private static final String DATE_PATTERN = "yyyy-MM-dd-HH-mm-ss";
    private static SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    protected static String[] mConfigParams = new String[]{"fileName", "keyAttributes", "authAttributes", "deferOnFailure"};
    protected String FFAUTH = "FlatFileAuth";
    String[] reqCreds = null;
    String[] authAttrs = null;
    String[] keyAttrs = null;
    protected Hashtable<String, Hashtable<String, String>> entries = null;

    public String[] getExtendedPluginInfo() {
        String[] s = new String[]{"fileName;string;Pathname of password file", "keyAttributes;string;Comma-separated list of attributes which together form a unique identifier for the user", "authAttributes;string;Comma-separated list of attributes which are used for further authentication", "deferOnFailure;boolean;if user is not found, defer the request to the queue for manual-authentication (true), or simply rejected the request (false)"};
        return s;
    }

    protected String getPropertyS(String propertyName, String s) throws EBaseException {
        String p;
        try {
            p = this.mConfig.getString(propertyName);
        }
        catch (EPropertyNotFound e) {
            this.mConfig.put(propertyName, s);
            p = s;
        }
        return p;
    }

    public boolean isSSLClientRequired() {
        return false;
    }

    protected boolean getPropertyB(String propertyName, boolean b) throws EBaseException {
        boolean p;
        try {
            p = this.mConfig.getBoolean(propertyName);
        }
        catch (EPropertyNotFound e) {
            this.mConfig.put(propertyName, b ? "true" : "false");
            p = b;
        }
        return p;
    }

    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
        try {
            this.mFilename = this.getPropertyS(PROP_FILENAME, this.mFilename);
            this.mKeyAttributes = this.getPropertyS(PROP_KEYATTRIBUTES, this.mKeyAttributes);
            this.mAuthAttrs = this.getPropertyS(PROP_AUTHATTRS, this.mAuthAttrs);
            this.mDeferOnFailure = this.getPropertyB(PROP_DEFERONFAILURE, this.mDeferOnFailure);
        }
        catch (EBaseException e) {
            return;
        }
        this.keyAttrs = this.splitOnComma(this.mKeyAttributes);
        this.authAttrs = this.splitOnComma(this.mAuthAttrs);
        String[][] stringArrays = new String[][]{this.keyAttrs, this.authAttrs};
        this.reqCreds = this.unionOfStrings(stringArrays);
        logger.debug("FlatFileAuth: mFilename      = " + this.mFilename);
        logger.debug("FlatFileAuth: mKeyAttributes = " + this.mKeyAttributes);
        logger.debug("FlatFileAuth: mAuthAttrs     = " + this.mAuthAttrs);
        for (int i = 0; i < stringArrays.length; ++i) {
            for (int j = 0; j < stringArrays[i].length; ++j) {
                logger.debug("FlatFileAuth: stringArrays[" + i + "][" + j + "] = " + stringArrays[i][j]);
            }
        }
        try {
            File file = new File(this.mFilename);
            this.mFileLastRead = file.lastModified();
            this.entries = this.readFile(file, this.keyAttrs);
            logger.debug("FlatFileAuth: " + CMS.getLogMessage((String)"CMS_AUTH_READ_ENTRIES", (Object[])new Object[]{this.mFilename}));
        }
        catch (IOException e) {
            throw new EBaseException(this.mName + " authentication: Could not open file " + this.mFilename + "   (" + e.getMessage() + ")");
        }
        catch (StringIndexOutOfBoundsException ee) {
            logger.warn("FlatFileAuth: " + CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{ee.toString()}));
        }
    }

    public String[] unionOfStrings(String[][] stringArrays) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        for (int i = 0; i < stringArrays.length; ++i) {
            String[] sa = stringArrays[i];
            for (int j = 0; j < sa.length; ++j) {
                logger.debug("FlatFileAuth: unionOfStrings: " + i + "," + j + " = " + sa[j]);
                ht.put(sa[j], "");
            }
        }
        String[] s = new String[ht.size()];
        Enumeration e = ht.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            s[i] = (String)e.nextElement();
            ++i;
        }
        return s;
    }

    private String[] splitOnComma(String s) {
        logger.debug("FlatFileAuth: Splitting String: " + s + " on commas");
        StringTokenizer st = new StringTokenizer(s, ",", false);
        String[] sa = new String[st.countTokens()];
        logger.debug("FlatFileAuth:    countTokens:" + st.countTokens());
        for (int i = 0; i < sa.length; ++i) {
            String p = st.nextToken().trim();
            logger.debug("FlatFileAuth:    token " + i + " = " + p);
            sa[i] = p;
        }
        return sa;
    }

    private String joinStringArray(String[] s, String sep) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i]);
            if (i >= s.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    private synchronized void updateFile(String key) {
        try {
            String name = this.writeFile(key);
            if (name != null) {
                File orgFile = new File(this.mFilename);
                long lastModified = orgFile.lastModified();
                File newFile = new File(name);
                this.mFileLastRead = lastModified > this.mFileLastRead ? lastModified : newFile.lastModified();
                if (orgFile.renameTo(new File(name.substring(0, name.length() - 1)))) {
                    if (!newFile.renameTo(new File(this.mFilename))) {
                        logger.warn("FlatFileAuth: " + CMS.getLogMessage((String)"RENAME_FILE_ERROR", (Object[])new Object[]{name, this.mFilename}));
                        File file = new File(name.substring(0, name.length() - 1));
                        file.renameTo(new File(this.mFilename));
                    }
                } else {
                    logger.warn("FlatFileAuth: " + CMS.getLogMessage((String)"RENAME_FILE_ERROR", (Object[])new Object[]{this.mFilename, name.substring(0, name.length() - 1)}));
                }
            }
        }
        catch (Exception e) {
            logger.warn("FlatFileAuth: " + CMS.getLogMessage((String)"FILE_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    private String writeFile(String key) {
        String name = this.mFilename + "." + mDateFormat.format(new Date()) + "~";
        boolean done = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.mFilename));
             BufferedWriter writer = new BufferedWriter(new FileWriter(name));){
            String line;
            boolean commentOutNextLine = false;
            while ((line = reader.readLine()) != null) {
                if (commentOutNextLine) {
                    writer.write("#");
                    commentOutNextLine = false;
                }
                if (line.indexOf(key) > -1) {
                    writer.write("#");
                    commentOutNextLine = true;
                }
                writer.write(line);
                writer.newLine();
            }
            done = true;
        }
        catch (Exception e) {
            logger.warn("FlatFileAuth: " + CMS.getLogMessage((String)"FILE_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        try {
            if (!done) {
                long s1 = 0L;
                long s2 = 0L;
                File f1 = new File(this.mFilename);
                File f2 = new File(name);
                if (f1.exists()) {
                    s1 = f1.length();
                }
                if (f2.exists()) {
                    s2 = f2.length();
                }
                if (s1 > 0L && s2 > 0L && s2 > s1) {
                    done = true;
                } else {
                    if (f2.exists()) {
                        f2.delete();
                    }
                    name = null;
                }
            }
        }
        catch (Exception e) {
            logger.warn("FlatFileAuth: " + CMS.getLogMessage((String)"FILE_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        return name;
    }

    protected Hashtable<String, Hashtable<String, String>> readFile(File f, String[] keys) throws IOException {
        logger.debug("FlatFileAuth: Reading file: " + f.getName());
        Hashtable<String, Hashtable<String, String>> allusers = new Hashtable<String, Hashtable<String, String>>();
        Hashtable<String, String> entry = null;
        try (BufferedReader file = new BufferedReader(new FileReader(f));){
            String line;
            int linenum = 0;
            while ((line = file.readLine()) != null) {
                int colon;
                ++linenum;
                if ((line = line.trim()).length() > 0 && line.charAt(0) == '#') continue;
                if (entry == null) {
                    entry = new Hashtable<String, String>();
                }
                if ((colon = line.indexOf(58)) == -1) {
                    if (!line.trim().equals("")) {
                        throw new IOException(this.FFAUTH + ": Parsing error, colon missing from line " + linenum + " of " + f.getName());
                    }
                    if (entry.size() <= 0) continue;
                    this.putEntry(allusers, entry, keys);
                    entry = null;
                    continue;
                }
                String attr = line.substring(0, colon).trim();
                String val = line.substring(colon + 1).trim();
                entry.put(attr, val);
            }
        }
        this.putEntry(allusers, entry, keys);
        return allusers;
    }

    private void putEntry(Hashtable<String, Hashtable<String, String>> allUsers, Hashtable<String, String> entry, String[] keys) {
        if (entry == null) {
            return;
        }
        String key = "";
        logger.debug("FlatFileAuth: keys.length = " + keys.length);
        for (int i = 0; i < keys.length; ++i) {
            String s = entry.get(keys[i]);
            logger.debug("FlatFileAuth:  concatenating: " + s);
            if (s == null) continue;
            key = key.concat(s);
        }
        logger.debug("FlatFileAuth: putting: key " + key);
        allUsers.put(key, entry);
    }

    void printAllEntries() {
        Enumeration<String> e = this.entries.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            logger.debug("FlatFileAuth: * " + key + " *");
            Hashtable<String, String> ht = this.entries.get(key);
            Enumeration<String> f = ht.keys();
            while (f.hasMoreElements()) {
                String fkey = f.nextElement();
                logger.debug("FlatFileAuth:    " + fkey + " -> " + ht.get(fkey));
            }
        }
    }

    private AuthToken doAuthentication(Hashtable<String, String> user, AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        AuthToken authToken = new AuthToken((AuthManager)this);
        for (int i = 0; i < this.authAttrs.length; ++i) {
            String uservalue;
            String ffvalue = user.get(this.authAttrs[i]);
            if (ffvalue.equals(uservalue = (String)authCred.get(this.authAttrs[i]))) continue;
            throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
        }
        return authToken;
    }

    private void reReadPwFile() {
        try {
            File file = new File(this.mFilename);
            long pwfilelastmodified = file.lastModified();
            if (pwfilelastmodified > this.mFileLastRead) {
                this.mFileLastRead = pwfilelastmodified;
                this.entries = this.readFile(file, this.keyAttrs);
            }
        }
        catch (Exception e) {
            logger.warn("FlatFileAuth: " + CMS.getLogMessage((String)"READ_FILE_ERROR", (Object[])new Object[]{this.mFilename, e.getMessage()}));
        }
    }

    public AuthToken authenticate(AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        String dn;
        AuthToken authToken = null;
        String keyForUser = "";
        this.reReadPwFile();
        for (int i = 0; i < this.keyAttrs.length; ++i) {
            logger.debug("FlatFileAuth: concatenating string i=" + i + "  keyAttrs[" + i + "] = " + this.keyAttrs[i]);
            String credential = (String)authCred.get(this.keyAttrs[i]);
            if (credential == null) {
                throw new EMissingCredential(CMS.getUserMessage((String)"CMS_AUTHENTICATION_NULL_CREDENTIAL", (String[])new String[]{this.keyAttrs[i]}));
            }
            keyForUser = keyForUser.concat((String)authCred.get(this.keyAttrs[i]));
        }
        logger.info("FlatFileAuth: authenticating user: finding user from key: " + keyForUser);
        Hashtable<String, String> user = this.entries.get(keyForUser);
        try {
            if (user == null) {
                logger.warn("FlatFileAuth: " + CMS.getLogMessage((String)"CMS_AUTH_USER_NOT_FOUND", (Object[])new Object[0]));
                throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
            }
            authToken = this.doAuthentication(user, authCred);
        }
        catch (EInvalidCredentials e) {
            if (this.mDeferOnFailure) {
                logger.warn("FlatFileAuth: Since defering on failure - ignore invalid creds");
            }
            throw e;
        }
        if (user != null && (dn = user.get("dn")) != null && authToken != null) {
            authToken.set("tokenCertSubject", dn);
        }
        if (user != null && authToken != null) {
            this.entries.remove(keyForUser);
            this.updateFile(keyForUser);
        }
        return authToken;
    }

    public String[] getRequiredCreds() {
        logger.debug("FlatFileAuth: getRequiredCreds returning: " + this.joinStringArray(this.reqCreds, ","));
        return this.reqCreds;
    }

    public String[] getConfigParams() {
        return mConfigParams;
    }

    public void shutdown() {
    }

    public void init(ConfigStore config) throws EProfileException {
    }

    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHENTICATION_AGENT_NAME", (String[])new String[0]);
    }

    public Enumeration<String> getValueNames() {
        return null;
    }

    public boolean isValueWriteable(String name) {
        return false;
    }

    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    public void populate(AuthToken token, Request request) throws EProfileException {
    }

    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHENTICATION_AGENT_TEXT", (String[])new String[0]);
    }
}

