/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.property.EPropertyException;
import com.netscape.cmscore.apps.CMS;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AVAValueConverter;
import org.mozilla.jss.netscape.security.x509.Attribute;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AttributeConfig {
    public static Logger logger = LoggerFactory.getLogger(AttributeConfig.class);
    protected ObjectIdentifier mAttributeOID = null;
    protected Attribute mAttribute = null;

    public AttributeConfig(String attrName, String attrValue) throws EPropertyException {
        X500NameAttrMap map = X500NameAttrMap.getDefault();
        if (attrName == null || attrName.length() == 0) {
            throw new EPropertyException(CMS.getUserMessage((String)"CMS_PROFILE_SUBJDIR_EMPTY_ATTRNAME", (String[])new String[]{attrName}));
        }
        if (attrValue == null || attrValue.length() == 0) {
            throw new EPropertyException(CMS.getUserMessage((String)"CMS_PROFILE_SUBJDIR_EMPTY_ATTRVAL", (String[])new String[]{attrValue}));
        }
        try {
            this.mAttributeOID = new ObjectIdentifier(attrName);
        }
        catch (Exception e) {
            logger.warn("SubjectDirAttributesExtDefault: invalid OID syntax: " + attrName + ": " + e.getMessage(), (Throwable)e);
        }
        if (this.mAttributeOID == null) {
            this.mAttributeOID = map.getOid(attrName);
            if (this.mAttributeOID == null) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{attrName}));
            }
            try {
                AttributeConfig.checkValue(this.mAttributeOID, attrValue);
            }
            catch (IOException e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{e.getMessage()}));
            }
        }
        try {
            this.mAttribute = new Attribute(this.mAttributeOID, this.str2MultiValues(attrValue));
        }
        catch (IOException e) {
            throw new EPropertyException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{e.getMessage()}));
        }
    }

    private static void checkValue(ObjectIdentifier oid, String val) throws IOException {
        AVAValueConverter c = X500NameAttrMap.getDefault().getValueConverter(oid);
        DerValue derval = c.getValue(val);
    }

    private Vector<String> str2MultiValues(String attrValue) {
        StringTokenizer tokenizer = new StringTokenizer(attrValue, ",");
        Vector<String> v = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            v.addElement(tokenizer.nextToken());
        }
        return v;
    }
}

