/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class nsTokenDeviceKeySubjectNameDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(nsTokenDeviceKeySubjectNameDefault.class);
    public static final String PROP_PARAMS = "params";
    public static final String CONFIG_DNPATTERN = "dnpattern";
    public static final String VAL_NAME = "name";
    protected static String DEFAULT_DNPATTERN = "Token Key Device - $request.tokencuid$";
    protected ConfigStore mParamsConfig;

    public nsTokenDeviceKeySubjectNameDefault() {
        this.addConfigName(CONFIG_DNPATTERN);
        this.addValueName(CONFIG_DNPATTERN);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        logger.debug("nsTokenDeviceKeySubjectNameDefault: in getConfigDescriptor, name=" + name);
        if (name.equals(CONFIG_DNPATTERN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        logger.debug("nsTokenDeviceKeySubjectNameDefault: in getValueDescriptor name=" + name);
        if (name.equals(VAL_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        logger.debug("nsTokenDeviceKeySubjectNameDefault: in setValue, value=" + value);
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NAME)) {
            X500Name x500name = null;
            try {
                x500name = new X500Name(value);
            }
            catch (IOException e) {
                logger.warn("nsTokenDeviceKeySubjectNameDefault: setValue " + e.getMessage(), (Throwable)e);
            }
            logger.debug("nsTokenDeviceKeySubjectNameDefault: setValue name=" + x500name);
            try {
                info.set("subject", (Object)new CertificateSubjectName(x500name));
            }
            catch (Exception e) {
                logger.error("nsTokenDeviceKeySubjectNameDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        logger.debug("nsTokenDeviceKeySubjectNameDefault: in getValue, name=" + name);
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NAME)) {
            CertificateSubjectName sn = null;
            try {
                logger.debug("nsTokenDeviceKeySubjectNameDefault: getValue info=" + info);
                sn = (CertificateSubjectName)info.get("subject");
                logger.debug("nsTokenDeviceKeySubjectNameDefault: getValue name=" + sn);
                return sn.toString();
            }
            catch (Exception e) {
                logger.warn("nsTokenDeviceKeySubjectNameDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        logger.debug("nsTokenDeviceKeySubjectNameDefault: in getText");
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[]{this.getConfig(CONFIG_DNPATTERN)});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        X500Name name = null;
        logger.debug("nsTokenDeviceKeySubjectNameDefault: in populate");
        try {
            String subjectName = this.getSubjectName(request);
            logger.debug("subjectName=" + subjectName);
            if (subjectName == null || subjectName.equals("")) {
                return;
            }
            name = new X500Name(subjectName);
        }
        catch (IOException e) {
            logger.warn("nsTokenDeviceKeySubjectNameDefault: populate " + e.getMessage(), (Throwable)e);
        }
        if (name == null) {
            // empty if block
        }
        try {
            info.set("subject", (Object)new CertificateSubjectName(name));
        }
        catch (Exception e) {
            logger.warn("nsTokenDeviceKeySubjectNameDefault: populate " + e.getMessage(), (Throwable)e);
        }
    }

    private String getSubjectName(Request request) throws EProfileException, IOException {
        logger.debug("nsTokenDeviceKeySubjectNameDefault: in getSubjectName");
        String pattern = this.getConfig(CONFIG_DNPATTERN);
        if (pattern == null || pattern.equals("")) {
            pattern = " ";
        }
        String sbjname = "";
        if (request != null) {
            logger.debug("pattern = " + pattern);
            sbjname = this.mapPattern(request, pattern);
            logger.debug("nsTokenDeviceKeySubjectNameDefault: getSubjectName(): subject name mapping done");
        }
        return sbjname;
    }
}

