/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapAnonConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class nsTokenUserKeySubjectNameDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(nsTokenUserKeySubjectNameDefault.class);
    public static final String PROP_LDAP = "ldap";
    public static final String PROP_PARAMS = "params";
    public static final String CONFIG_DNPATTERN = "dnpattern";
    public static final String CONFIG_LDAP_ENABLE = "ldap.enable";
    public static final String CONFIG_LDAP_SEARCH_NAME = "ldap.searchName";
    public static final String CONFIG_LDAP_STRING_ATTRS = "ldapStringAttributes";
    public static final String CONFIG_LDAP_HOST = "ldap.ldapconn.host";
    public static final String CONFIG_LDAP_PORT = "ldap.ldapconn.port";
    public static final String CONFIG_LDAP_SEC_CONN = "ldap.ldapconn.secureConn";
    public static final String CONFIG_LDAP_VER = "ldap.ldapconn.Version";
    public static final String CONFIG_LDAP_BASEDN = "ldap.basedn";
    public static final String CONFIG_LDAP_MIN_CONN = "ldap.minConns";
    public static final String CONFIG_LDAP_MAX_CONN = "ldap.maxConns";
    public static final String VAL_NAME = "name";
    public static final String CONFIG_LDAP_VERS = "2,3";
    protected static String DEFAULT_DNPATTERN = "CN=$request.uid$, E=$request.mail$";
    boolean mldapInitialized = false;
    boolean mldapEnabled = false;
    protected ConfigStore mInstConfig;
    protected LDAPConfig mLdapConfig;
    protected ConfigStore mParamsConfig;
    protected String mBaseDN = null;
    protected LdapAnonConnFactory mConnFactory;
    protected String[] mLdapStringAttrs = null;

    public nsTokenUserKeySubjectNameDefault() {
        this.addConfigName(CONFIG_DNPATTERN);
        this.addConfigName(CONFIG_LDAP_ENABLE);
        this.addConfigName(CONFIG_LDAP_SEARCH_NAME);
        this.addConfigName(CONFIG_LDAP_STRING_ATTRS);
        this.addConfigName(CONFIG_LDAP_HOST);
        this.addConfigName(CONFIG_LDAP_PORT);
        this.addConfigName(CONFIG_LDAP_SEC_CONN);
        this.addConfigName(CONFIG_LDAP_VER);
        this.addConfigName(CONFIG_LDAP_BASEDN);
        this.addConfigName(CONFIG_LDAP_MIN_CONN);
        this.addConfigName(CONFIG_LDAP_MAX_CONN);
        this.addValueName(CONFIG_DNPATTERN);
        this.addValueName(CONFIG_LDAP_ENABLE);
        this.addValueName(CONFIG_LDAP_SEARCH_NAME);
        this.addValueName(CONFIG_LDAP_STRING_ATTRS);
        this.addValueName(CONFIG_LDAP_HOST);
        this.addValueName(CONFIG_LDAP_PORT);
        this.addValueName(CONFIG_LDAP_SEC_CONN);
        this.addValueName(CONFIG_LDAP_VER);
        this.addValueName(CONFIG_LDAP_BASEDN);
        this.addValueName(CONFIG_LDAP_MIN_CONN);
        this.addValueName(CONFIG_LDAP_MAX_CONN);
    }

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
        this.mInstConfig = config;
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        logger.debug("nsTokenUserKeySubjectNameDefault: in getConfigDescriptor, name=" + name);
        if (name.equals(CONFIG_DNPATTERN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_STRING_ATTRS)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_TOKENKEY_LDAP_STRING_ATTRS", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_ENABLE)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_TOKENKEY_LDAP_ENABLE", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_SEARCH_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_TOKENKEY_LDAP_SEARCH_NAME", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_HOST)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_TOKENKEY_LDAP_HOST_NAME", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_PORT)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_TOKENKEY_LDAP_PORT_NUMBER", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_SEC_CONN)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_TOKENKEY_LDAP_SECURE_CONN", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_VER)) {
            return new Descriptor("choice", CONFIG_LDAP_VERS, "3", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_TOKENKEY_LDAP_VERSION", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_BASEDN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_TOKENKEY_LDAP_BASEDN", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_MIN_CONN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_TOKENKEY_LDAP_MIN_CONN", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_MAX_CONN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_TOKENKEY_LDAP_MAX_CONN", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        logger.debug("nsTokenUserKeySubjectNameDefault: in getValueDescriptor name=" + name);
        if (name.equals(VAL_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        logger.debug("nsTokenUserKeySubjectNameDefault: in setValue, value=" + value);
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NAME)) {
            X500Name x500name = null;
            try {
                x500name = new X500Name(value);
            }
            catch (IOException e) {
                logger.warn("nsTokenUserKeySubjectNameDefault: setValue " + e.getMessage(), (Throwable)e);
            }
            logger.debug("nsTokenUserKeySubjectNameDefault: setValue name=" + x500name);
            try {
                info.set("subject", (Object)new CertificateSubjectName(x500name));
            }
            catch (Exception e) {
                logger.error("nsTokenUserKeySubjectNameDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        logger.debug("nsTokenUserKeySubjectNameDefault: in getValue, name=" + name);
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NAME)) {
            CertificateSubjectName sn = null;
            try {
                logger.debug("nsTokenUserKeySubjectNameDefault: getValue info=" + info);
                sn = (CertificateSubjectName)info.get("subject");
                logger.debug("nsTokenUserKeySubjectNameDefault: getValue name=" + sn);
                return sn.toString();
            }
            catch (Exception e) {
                logger.warn("nsTokenUserKeySubjectNameDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        logger.debug("nsTokenUserKeySubjectNameDefault: in getText");
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[]{this.getConfig(CONFIG_DNPATTERN)});
    }

    public void ldapInit() throws EProfileException {
        if (this.mldapInitialized) {
            return;
        }
        logger.debug("nsTokenUserKeySubjectNameDefault: ldapInit(): begin");
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        PKISocketConfig socketConfig = cs.getSocketConfig();
        try {
            String ldapStringAttrs;
            this.mParamsConfig = this.mInstConfig.getSubStore(PROP_PARAMS, ConfigStore.class);
            this.mLdapConfig = (LDAPConfig)this.mParamsConfig.getSubStore(PROP_LDAP, LDAPConfig.class);
            this.mldapEnabled = this.mParamsConfig.getBoolean(CONFIG_LDAP_ENABLE, false);
            if (!this.mldapEnabled) {
                return;
            }
            this.mBaseDN = this.mParamsConfig.getString(CONFIG_LDAP_BASEDN, null);
            this.mConnFactory = new LdapAnonConnFactory("nsTokenUserKeySubjectNameDefault");
            this.mConnFactory.setCMSEngine((CMSEngine)engine);
            this.mConnFactory.init(socketConfig, this.mLdapConfig);
            String pattern = this.mParamsConfig.getString(CONFIG_DNPATTERN, null);
            if (pattern == null || pattern.length() == 0) {
                pattern = DEFAULT_DNPATTERN;
            }
            if ((ldapStringAttrs = this.mParamsConfig.getString(CONFIG_LDAP_STRING_ATTRS, null)) != null && ldapStringAttrs.length() != 0) {
                StringTokenizer pAttrs = new StringTokenizer(ldapStringAttrs, ",", false);
                this.mLdapStringAttrs = new String[pAttrs.countTokens()];
                for (int i = 0; i < this.mLdapStringAttrs.length; ++i) {
                    this.mLdapStringAttrs[i] = ((String)pAttrs.nextElement()).trim();
                }
            }
            logger.debug("nsTokenUserKeySubjectNameDefault: ldapInit(): done");
            this.mldapInitialized = true;
        }
        catch (Exception e) {
            logger.error("nsTokenUserKeySubjectNameDefault: ldapInit(): " + e.getMessage(), (Throwable)e);
            throw new EProfileException("ldap init failure: " + e.toString());
        }
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        X500Name name = null;
        logger.debug("nsTokenUserKeySubjectNameDefault: in populate");
        this.ldapInit();
        try {
            String subjectName = this.getSubjectName(request);
            logger.debug("subjectName=" + subjectName);
            if (subjectName == null || subjectName.equals("")) {
                return;
            }
            name = new X500Name(subjectName);
        }
        catch (IOException e) {
            logger.warn("nsTokenUserKeySubjectNameDefault: populate " + e.getMessage(), (Throwable)e);
        }
        if (name == null) {
            // empty if block
        }
        try {
            info.set("subject", (Object)new CertificateSubjectName(name));
        }
        catch (Exception e) {
            logger.warn("nsTokenUserKeySubjectNameDefault: populate " + e.getMessage(), (Throwable)e);
        }
    }

    private String getSubjectName(Request request) throws EProfileException, IOException {
        logger.debug("nsTokenUserKeySubjectNameDefault: in getSubjectName");
        String pattern = this.getConfig(CONFIG_DNPATTERN);
        if (pattern == null || pattern.equals("")) {
            pattern = " ";
        }
        String sbjname = "";
        if (!this.mldapInitialized) {
            if (request != null) {
                logger.debug("pattern = " + pattern);
                sbjname = this.mapPattern(request, pattern);
                logger.debug("nsTokenUserKeySubjectNameDefault: getSubjectName(): subject name mapping done");
            }
            return sbjname;
        }
        String searchName = this.getConfig(CONFIG_LDAP_SEARCH_NAME);
        if (searchName == null || searchName.equals("")) {
            searchName = "uid";
        }
        LDAPConnection conn = null;
        String userdn = null;
        try {
            if (this.mConnFactory == null) {
                conn = null;
                logger.error("nsTokenUserKeySubjectNameDefault: getSubjectName(): no LDAP connection");
                throw new EProfileException("no LDAP connection");
            }
            conn = this.mConnFactory.getConn();
            if (conn == null) {
                logger.error("nsTokenUserKeySubjectNameDefault::getSubjectName() - no LDAP connection");
                throw new EProfileException("no LDAP connection");
            }
            logger.debug("nsTokenUserKeySubjectNameDefault: getSubjectName(): got LDAP connection");
            logger.debug("nsTokenUserKeySubjectNameDefault: getSubjectName(): about to search with basedn = " + this.mBaseDN);
            LDAPSearchResults res = conn.search(this.mBaseDN, 2, "(" + searchName + "=" + request.getExtDataInString("uid") + ")", null, false);
            if (!res.hasMoreElements()) {
                logger.error("nsTokenUserKeySubjectNameDefault: getSubjectName(): " + searchName + " does not exist");
                throw new EProfileException("id does not exist");
            }
            LDAPEntry entry = res.next();
            userdn = entry.getDN();
            logger.debug("nsTokenUserKeySubjectNameDefault: getSubjectName(): retrieved entry for " + searchName + " = " + request.getExtDataInString("uid"));
            entry = null;
            logger.debug("nsTokenUserKeySubjectNameDefault: getSubjectName(): about to search with " + this.mLdapStringAttrs.length + " attributes");
            LDAPSearchResults results = conn.search(userdn, 0, "objectclass=*", this.mLdapStringAttrs, false);
            if (!results.hasMoreElements()) {
                logger.error("nsTokenUserKeySubjectNameDefault: getSubjectName(): no attributes");
                throw new EProfileException("no ldap attributes found");
            }
            entry = results.next();
            for (int i = 0; i < this.mLdapStringAttrs.length; ++i) {
                LDAPAttribute la = entry.getAttribute(this.mLdapStringAttrs[i]);
                if (la == null) continue;
                String[] sla = la.getStringValueArray();
                logger.debug("nsTokenUserKeySubjectNameDefault: getSubjectName(): got attribute: " + this.mLdapStringAttrs[i] + "=" + LDAPUtil.escapeRDNValue((Object)sla[0]));
                request.setExtData(this.mLdapStringAttrs[i], LDAPUtil.escapeRDNValue((Object)sla[0]));
            }
            logger.debug("pattern = " + pattern);
            sbjname = this.mapPattern(request, pattern);
            logger.debug("nsTokenUserKeySubjectNameDefault: getSubjectName(): subject name mapping done");
            logger.debug("nsTokenUserKeySubjectNameDefault: getSubjectName(): attributes set in request");
        }
        catch (Exception e) {
            logger.error("nsTokenUserKeySubjectNameDefault: getSubjectName(): " + e.getMessage(), (Throwable)e);
            throw new EProfileException("getSubjectName() failure: " + e.toString());
        }
        finally {
            try {
                if (conn != null) {
                    this.mConnFactory.returnConn(conn);
                }
            }
            catch (Exception e) {
                throw new EProfileException("nsTokenUserKeySubjectNameDefault: getSubjectName(): connection return failure");
            }
        }
        return sbjname;
    }
}

