/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.mappers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.publish.Mapper;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.security.cert.X509Certificate;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCertSubjMap
extends Mapper
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LdapCertSubjMap.class);
    public static final String LDAP_CERTSUBJNAME_ATTR = "certSubjectName";
    protected String mSearchBase = null;
    protected String mCertSubjNameAttr = "certSubjectName";
    protected boolean mUseAllEntries = false;
    protected ConfigStore mConfig;
    boolean mInited = false;

    public LdapCertSubjMap() {
    }

    public LdapCertSubjMap(String searchBase) {
        if (searchBase == null) {
            throw new IllegalArgumentException("a null argument to constructor " + ((Object)((Object)this)).getClass().getName());
        }
        this.mSearchBase = searchBase;
        this.mInited = true;
    }

    public LdapCertSubjMap(String searchBase, String certSubjNameAttr, String certAttr) {
        if (searchBase == null || certSubjNameAttr == null || certAttr == null) {
            throw new IllegalArgumentException("a null argument to constructor " + ((Object)((Object)this)).getClass().getName());
        }
        this.mCertSubjNameAttr = certSubjNameAttr;
        this.mSearchBase = searchBase;
        this.mInited = true;
    }

    public LdapCertSubjMap(String searchBase, String certSubjNameAttr, String certAttr, boolean useAllEntries) {
        if (searchBase == null || certSubjNameAttr == null || certAttr == null) {
            throw new IllegalArgumentException("a null argument to constructor " + ((Object)((Object)this)).getClass().getName());
        }
        this.mCertSubjNameAttr = certSubjNameAttr;
        this.mSearchBase = searchBase;
        this.mUseAllEntries = useAllEntries;
        this.mInited = true;
    }

    public String getImplName() {
        return "LdapCertSubjMap";
    }

    public String getDescription() {
        return "LdapCertSubjMap";
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("certSubjNameAttr=" + this.mCertSubjNameAttr);
        v.addElement("searchBase=");
        v.addElement("useAllEntries=" + this.mUseAllEntries);
        return v;
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"certSubjNameAttr;string;Name of Ldap attribute containing cert subject name", "searchBase;string;Base DN to search from", "useAllEntries;boolean;Use all entries for publishing", "HELP_TOKEN;configuration-ldappublish-mapper-certsubjmapper", "HELP_TEXT;This plugin assumes you want to publish to an LDAP entry which has an attribute whose contents are equal to the cert subject name"};
        return params;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        if (this.mCertSubjNameAttr == null) {
            v.addElement("certSubjNameAttr=");
        } else {
            v.addElement("certSubjNameAttr=" + this.mCertSubjNameAttr);
        }
        if (this.mSearchBase == null) {
            v.addElement("searchBase=");
        } else {
            v.addElement("searchBase=" + this.mSearchBase);
        }
        v.addElement("useAllEntries=" + this.mUseAllEntries);
        return v;
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void init(ConfigStore config) throws EBaseException {
        if (this.mInited) {
            return;
        }
        this.mConfig = config;
        this.mCertSubjNameAttr = config.getString("certSubjNameAttr", LDAP_CERTSUBJNAME_ATTR);
        this.mSearchBase = config.getString("searchBase");
        this.mUseAllEntries = config.getBoolean("useAllEntries", false);
        this.mInited = true;
    }

    public String map(LDAPConnection conn, Object obj) throws ELdapException {
        if (conn == null) {
            return null;
        }
        X500Name subjectDN = null;
        try {
            X509Certificate cert = (X509Certificate)obj;
            subjectDN = (X500Name)cert.getSubjectDN();
            logger.debug("LdapCertSubjMap: cert subject dn:" + subjectDN);
        }
        catch (ClassCastException e) {
            logger.warn("LdapCertSubjMap: " + e.getMessage(), (Throwable)e);
            try {
                X509CRLImpl crl = (X509CRLImpl)obj;
                subjectDN = (X500Name)crl.getIssuerDN();
                logger.debug("LdapCertSubjMap: crl issuer dn: " + subjectDN);
            }
            catch (ClassCastException ex) {
                logger.warn(CMS.getLogMessage((String)"PUBLISH_NOT_SUPPORTED_OBJECT", (Object[])new Object[0]), (Throwable)ex);
                return null;
            }
        }
        try {
            String[] attrs = new String[]{"1.1"};
            logger.info("LdapCertSubjMap: search " + this.mSearchBase + " (" + this.mCertSubjNameAttr + "=" + subjectDN + ") " + this.mCertSubjNameAttr);
            LDAPSearchResults results = conn.search(this.mSearchBase, 2, "(" + this.mCertSubjNameAttr + "=" + subjectDN + ")", attrs, false);
            LDAPEntry entry = results.next();
            if (results.hasMoreElements()) {
                logger.warn(CMS.getLogMessage((String)"PUBLISH_MORE_THAN_ONE_ENTRY", (Object[])new Object[]{"", subjectDN.toString()}));
            }
            if (entry != null) {
                logger.info("LdapCertSubjMap: entry found");
                return entry.getDN();
            }
            return null;
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}));
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_DN_MAP_EXCEPTION", (Object[])new Object[]{"LDAPException", e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH_FOUND", (String[])new String[]{e.toString()}));
        }
    }

    public String map(LDAPConnection conn, Request req, Object obj) throws ELdapException {
        return this.map(conn, obj);
    }

    public Vector<String> mapAll(LDAPConnection conn, Object obj) throws ELdapException {
        Vector<String> v = new Vector<String>();
        if (conn == null) {
            return null;
        }
        X500Name subjectDN = null;
        try {
            X509Certificate cert = (X509Certificate)obj;
            subjectDN = (X500Name)cert.getSubjectDN();
            logger.debug("LdapCertSubjMap: cert subject dn:" + subjectDN);
        }
        catch (ClassCastException e) {
            logger.warn(CMS.getLogMessage((String)"PUBLISH_NOT_SUPPORTED_OBJECT", (Object[])new Object[0]), (Throwable)e);
            return v;
        }
        try {
            String[] attrs = new String[]{"1.1"};
            logger.info("LdapCertSubjMap: search " + this.mSearchBase + " (" + this.mCertSubjNameAttr + "=" + subjectDN + ") " + this.mCertSubjNameAttr);
            LDAPSearchResults results = conn.search(this.mSearchBase, 2, "(" + this.mCertSubjNameAttr + "=" + subjectDN + ")", attrs, false);
            while (results.hasMoreElements()) {
                LDAPEntry entry = results.next();
                String dn = entry.getDN();
                v.addElement(dn);
                logger.debug("LdapCertSubjMap: dn=" + dn);
            }
            logger.debug("LdapCertSubjMap: Number of entries: " + v.size());
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}));
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_DN_MAP_EXCEPTION", (Object[])new Object[]{"LDAPException", e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH_FOUND", (String[])new String[]{e.toString()}));
        }
        return v;
    }

    public Vector<String> mapAll(LDAPConnection conn, Request req, Object obj) throws ELdapException {
        return this.mapAll(conn, obj);
    }

    public String getSearchBase() {
        return this.mSearchBase;
    }

    public String getCertSubjNameAttr() {
        return this.mCertSubjNameAttr;
    }

    public boolean useAllEntries() {
        return this.mUseAllEntries;
    }
}

