/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.mappers;

import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cms.publish.mappers.MapRDNPattern;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Vector;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDNPattern {
    public static Logger logger = LoggerFactory.getLogger(MapDNPattern.class);
    protected String[] mReqAttrs = null;
    protected String[] mCertAttrs = null;
    protected MapRDNPattern[] mRDNPatterns = null;
    protected String mPatternString = null;
    protected String mTestDN = null;

    public MapDNPattern(String pattern) throws ELdapException {
        if (pattern == null || pattern.equals("")) {
            logger.debug("MapDNPattern: null pattern");
        } else {
            this.mPatternString = pattern;
            PushbackReader in = new PushbackReader(new StringReader(pattern));
            this.parse(in);
        }
    }

    public MapDNPattern(PushbackReader in) throws ELdapException {
        this.parse(in);
    }

    private void parse(PushbackReader in) throws ELdapException {
        Vector<MapRDNPattern> rdnPatterns = new Vector<MapRDNPattern>();
        MapRDNPattern rdnPattern = null;
        int lastChar = -1;
        do {
            rdnPattern = new MapRDNPattern(in);
            rdnPatterns.addElement(rdnPattern);
            try {
                lastChar = in.read();
            }
            catch (IOException e) {
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
            }
        } while (lastChar == 44);
        this.mRDNPatterns = new MapRDNPattern[rdnPatterns.size()];
        rdnPatterns.copyInto(this.mRDNPatterns);
        Vector<String> reqAttrs = new Vector<String>();
        for (int i = 0; i < this.mRDNPatterns.length; ++i) {
            String[] rdnAttrs = this.mRDNPatterns[i].getReqAttrs();
            if (rdnAttrs == null || rdnAttrs.length <= 0) continue;
            for (int j = 0; j < rdnAttrs.length; ++j) {
                reqAttrs.addElement(rdnAttrs[j]);
            }
        }
        this.mReqAttrs = new String[reqAttrs.size()];
        reqAttrs.copyInto(this.mReqAttrs);
        Vector<String> certAttrs = new Vector<String>();
        for (int i = 0; i < this.mRDNPatterns.length; ++i) {
            String[] rdnAttrs = this.mRDNPatterns[i].getCertAttrs();
            if (rdnAttrs == null || rdnAttrs.length <= 0) continue;
            for (int j = 0; j < rdnAttrs.length; ++j) {
                certAttrs.addElement(rdnAttrs[j]);
            }
        }
        this.mCertAttrs = new String[certAttrs.size()];
        certAttrs.copyInto(this.mCertAttrs);
    }

    public String formDN(Request req, X500Name subject, CertificateExtensions ext) throws ELdapException {
        StringBuffer formedDN = new StringBuffer();
        for (int i = 0; i < this.mRDNPatterns.length; ++i) {
            String rdn;
            if (this.mTestDN != null) {
                this.mRDNPatterns[i].mTestDN = this.mTestDN;
            }
            if ((rdn = this.mRDNPatterns[i].formRDN(req, subject, ext)) != null && rdn.length() != 0) {
                if (formedDN.length() != 0) {
                    formedDN.append(",");
                }
            } else {
                throw new ELdapException("pattern not matched");
            }
            formedDN.append(rdn);
        }
        return formedDN.toString();
    }

    public String[] getReqAttrs() {
        return (String[])this.mReqAttrs.clone();
    }

    public String[] getCertAttrs() {
        return (String[])this.mCertAttrs.clone();
    }
}

