/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.CRLRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caGetInfo", urlPatterns={"/ee/ca/getInfo"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="ID", value="caGetInfo"), @WebInitParam(name="resourceID", value="certServer.ee.crl"), @WebInitParam(name="interface", value="ee")})
public class GetInfo
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GetInfo.class);
    private static final long serialVersionUID = 1909881831730252799L;
    private CertificateAuthority mCA;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        this.mCA = engine.getCA();
        this.mTemplates.remove(CMSRequest.SUCCESS);
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        EBaseException error = null;
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        String template = req.getParameter("template");
        Object formFile = "";
        if (template == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE_1", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]));
        }
        formFile = template + ".template";
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        logger.debug("*** formFile = " + (String)formFile);
        try {
            form = this.getTemplate((String)formFile, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{formFile, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        try {
            this.process(header);
        }
        catch (EBaseException e) {
            error = e;
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void process(ArgBlock header) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        CRLRepository crlRepository = engine.getCRLRepository();
        if (this.mCA != null) {
            Object crlIssuingPoints = "";
            Object crlNumbers = "";
            Object deltaNumbers = "";
            Object crlSizes = "";
            Object deltaSizes = "";
            Object crlDescriptions = "";
            StringBuffer crlSplits = new StringBuffer();
            Object recentChanges = "";
            Object crlTesting = "";
            boolean isDeltaCRLEnabled = false;
            String masterHost = cs.getString("master.ca.agent.host", "");
            String masterPort = cs.getString("master.ca.agent.port", "");
            if (masterHost != null && masterHost.length() > 0 && masterPort != null && masterPort.length() > 0) {
                Vector<String> ipNames = crlRepository.getIssuingPointsNames();
                for (int i = 0; i < ipNames.size(); ++i) {
                    String ipName = (String)ipNames.elementAt(i);
                    CRLIssuingPointRecord crlRecord = null;
                    try {
                        crlRecord = crlRepository.readCRLIssuingPointRecord(ipName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (crlRecord == null) continue;
                    if (((String)crlIssuingPoints).length() > 0) {
                        crlIssuingPoints = (String)crlIssuingPoints + "+";
                    }
                    crlIssuingPoints = (String)crlIssuingPoints + ipName;
                    BigInteger crlNumber = crlRecord.getCRLNumber();
                    if (((String)crlNumbers).length() > 0) {
                        crlNumbers = (String)crlNumbers + "+";
                    }
                    if (crlNumber != null) {
                        crlNumbers = (String)crlNumbers + crlNumber.toString();
                    }
                    if (((String)crlSizes).length() > 0) {
                        crlSizes = (String)crlSizes + "+";
                    }
                    crlSizes = (String)crlSizes + (crlRecord.getCRLSize() != null ? crlRecord.getCRLSize().toString() : "-1");
                    if (((String)deltaSizes).length() > 0) {
                        deltaSizes = (String)deltaSizes + "+";
                    }
                    long dSize = -1L;
                    if (crlRecord.getDeltaCRLSize() != null) {
                        dSize = crlRecord.getDeltaCRLSize();
                    }
                    deltaSizes = (String)deltaSizes + dSize;
                    BigInteger deltaNumber = crlRecord.getDeltaCRLNumber();
                    if (((String)deltaNumbers).length() > 0) {
                        deltaNumbers = (String)deltaNumbers + "+";
                    }
                    if (deltaNumber != null && dSize > -1L) {
                        deltaNumbers = (String)deltaNumbers + deltaNumber.toString();
                        isDeltaCRLEnabled |= true;
                    } else {
                        deltaNumbers = (String)deltaNumbers + "0";
                    }
                    if (((String)recentChanges).length() > 0) {
                        recentChanges = (String)recentChanges + "+";
                    }
                    recentChanges = (String)recentChanges + "-, -, -";
                    if (((String)crlTesting).length() > 0) {
                        crlTesting = (String)crlTesting + "+";
                    }
                    crlTesting = (String)crlTesting + "0";
                }
            } else {
                for (CRLIssuingPoint ip : engine.getCRLIssuingPoints()) {
                    if (!ip.isCRLIssuingPointEnabled()) continue;
                    if (((String)crlIssuingPoints).length() > 0) {
                        crlIssuingPoints = (String)crlIssuingPoints + "+";
                    }
                    crlIssuingPoints = (String)crlIssuingPoints + ip.getId();
                    BigInteger crlNumber = ip.getCRLNumber();
                    if (((String)crlNumbers).length() > 0) {
                        crlNumbers = (String)crlNumbers + "+";
                    }
                    if (crlNumber != null) {
                        crlNumbers = (String)crlNumbers + crlNumber.toString();
                    }
                    BigInteger deltaNumber = ip.getDeltaCRLNumber();
                    if (((String)deltaNumbers).length() > 0) {
                        deltaNumbers = (String)deltaNumbers + "+";
                    }
                    if (deltaNumber != null) {
                        deltaNumbers = (String)deltaNumbers + deltaNumber.toString();
                    }
                    if (((String)crlSizes).length() > 0) {
                        crlSizes = (String)crlSizes + "+";
                    }
                    crlSizes = (String)crlSizes + ip.getCRLSize();
                    if (((String)deltaSizes).length() > 0) {
                        deltaSizes = (String)deltaSizes + "+";
                    }
                    deltaSizes = (String)deltaSizes + ip.getDeltaCRLSize();
                    if (((String)crlDescriptions).length() > 0) {
                        crlDescriptions = (String)crlDescriptions + "+";
                    }
                    crlDescriptions = (String)crlDescriptions + ip.getDescription();
                    if (((String)recentChanges).length() > 0) {
                        recentChanges = (String)recentChanges + "+";
                    }
                    recentChanges = ip.isCRLUpdateInProgress() == 2 ? (String)recentChanges + "Publishing CRL #" + ip.getCRLNumber() : (ip.isCRLUpdateInProgress() == 1 ? (String)recentChanges + "Creating CRL #" + ip.getNextCRLNumber() : (String)recentChanges + ip.getNumberOfRecentlyRevokedCerts() + ", " + ip.getNumberOfRecentlyUnrevokedCerts() + ", " + ip.getNumberOfRecentlyExpiredCerts());
                    isDeltaCRLEnabled |= ip.isDeltaCRLEnabled();
                    if (crlSplits.length() > 0) {
                        crlSplits.append("+");
                    }
                    Vector<Long> splits = ip.getSplitTimes();
                    for (int i = 0; i < splits.size(); ++i) {
                        crlSplits.append(splits.elementAt(i));
                        if (i + 1 >= splits.size()) continue;
                        crlSplits.append(",");
                    }
                    if (((String)crlTesting).length() > 0) {
                        crlTesting = (String)crlTesting + "+";
                    }
                    crlTesting = (String)crlTesting + (ip.isCRLCacheTestingEnabled() ? "1" : "0");
                }
            }
            header.addStringValue("crlIssuingPoints", (String)crlIssuingPoints);
            header.addStringValue("crlDescriptions", (String)crlDescriptions);
            header.addStringValue("crlNumbers", (String)crlNumbers);
            header.addStringValue("deltaNumbers", (String)deltaNumbers);
            header.addStringValue("crlSizes", (String)crlSizes);
            header.addStringValue("deltaSizes", (String)deltaSizes);
            header.addStringValue("crlSplits", crlSplits.toString());
            header.addStringValue("crlTesting", (String)crlTesting);
            header.addBooleanValue("isDeltaCRLEnabled", isDeltaCRLEnabled);
            header.addStringValue("master_host", masterHost);
            header.addStringValue("master_port", masterPort);
            header.addStringValue("masterCRLIssuingPoint", "MasterCRL");
            CRLIssuingPoint ip0 = engine.getCRLIssuingPoint("MasterCRL");
            if (ip0 != null) {
                header.addStringValue("defaultAlgorithm", ip0.getSigningAlgorithm());
            }
            if (((String)recentChanges).length() > 0) {
                header.addStringValue("recentChanges", (String)recentChanges);
            }
            Object validAlgorithms = null;
            String[] allAlgorithms = this.mCA.getCASigningAlgorithms();
            if (allAlgorithms == null) {
                logger.debug("GetInfo: signing algorithms set to All algorithms");
                allAlgorithms = AlgorithmId.ALL_SIGNING_ALGORITHMS;
            }
            for (int i = 0; i < allAlgorithms.length; ++i) {
                validAlgorithms = i > 0 ? (String)validAlgorithms + "+" + allAlgorithms[i] : allAlgorithms[i];
            }
            if (validAlgorithms != null) {
                header.addStringValue("validAlgorithms", (String)validAlgorithms);
            }
        }
    }
}

