/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.request.Request;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.netscape.security.pkcs.ContentInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.pkcs.SignerInfo;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkix.cmmf.CertOrEncCert;
import org.mozilla.jss.pkix.cmmf.CertRepContent;
import org.mozilla.jss.pkix.cmmf.CertResponse;
import org.mozilla.jss.pkix.cmmf.CertifiedKeyPair;
import org.mozilla.jss.pkix.cmmf.PKIStatusInfo;

public class ImportCertsTemplateFiller
implements ICMSTemplateFiller {
    public static final String CRMF_REQID = "crmfReqId";
    public static final String ISSUED_CERT_SERIAL = "serialNo";
    public static final String CERT_TYPE = "certType";
    public static final String BASE64_CERT = "base64Cert";
    public static final String CERT_PRETTYPRINT = "certPrettyPrint";
    public static final String CERT_FINGERPRINT = "certFingerprint";
    public static final String CERT_NICKNAME = "certNickname";
    public static final String CMMF_RESP = "cmmfResponse";
    public static final String PKCS7_RESP = "pkcs7ChainBase64";

    public CMSTemplateParams getTemplateParams(CMSRequest cmsReq, IAuthority authority, Locale locale, Exception e) throws Exception {
        Certificate[] certs = (Certificate[])cmsReq.getResult();
        return certs instanceof X509CertImpl[] ? this.getX509TemplateParams(cmsReq, authority, locale, e) : null;
    }

    public CMSTemplateParams getX509TemplateParams(CMSRequest cmsReq, IAuthority authority, Locale locale, Exception e) throws Exception {
        ArgBlock httpParams;
        String certType;
        BigInteger keyRecSerialNo;
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams params = new CMSTemplateParams(header, fixed);
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        String host = httpReq.getServerName();
        int port = httpReq.getServerPort();
        String scheme = httpReq.getScheme();
        String format = httpReq.getParameter("format");
        if (format != null && format.equals("cmc")) {
            fixed.set("importCMC", (Object)"false");
        }
        String agentPort = "" + port;
        fixed.set("agentHost", (Object)host);
        fixed.set("agentPort", (Object)agentPort);
        fixed.set("host", (Object)host);
        fixed.set("port", (Object)port);
        fixed.set("scheme", (Object)scheme);
        Request r = cmsReq.getRequest();
        if (r != null) {
            fixed.set("requestId", (Object)r.getRequestId().toString());
        }
        if (r != null && (keyRecSerialNo = r.getExtDataInBigInteger("keyRecord")) != null) {
            fixed.set("keyrecId", (Object)keyRecSerialNo.toString());
        }
        if ((certType = (httpParams = cmsReq.getHttpParams()).getValueAsString(CERT_TYPE, null)) != null) {
            fixed.set(CERT_TYPE, (Object)certType);
        }
        fixed.set("authorityName", (Object)authority.getOfficialName());
        CertificateChain cachain = ((CertificateAuthority)authority).getCACertChain();
        X509Certificate[] cacerts = cachain.getChain();
        String replyTo = httpParams.getValueAsString("replyTo", null);
        if (replyTo != null) {
            fixed.set("replyTo", (Object)replyTo);
        }
        X509CertImpl[] userChain = new X509CertImpl[cacerts.length + 1];
        int m = 1;
        for (int n = 0; n < cacerts.length; ++n) {
            userChain[m] = (X509CertImpl)cacerts[n];
            ++m;
        }
        X509CertImpl[] certs = (X509CertImpl[])cmsReq.getResult();
        String crmfReqId = cmsReq.getExtData(CRMF_REQID);
        if (crmfReqId == null) {
            crmfReqId = (String)cmsReq.getResult(CRMF_REQID);
        }
        if (crmfReqId != null) {
            fixed.set(CRMF_REQID, (Object)crmfReqId);
        }
        CertRepContent certRepContent = null;
        if (CMSServlet.doCMMFResponse((ArgBlock)httpParams)) {
            byte[][] caPubs = new byte[cacerts.length][];
            for (int j = 0; j < cacerts.length; ++j) {
                caPubs[j] = ((X509CertImpl)cacerts[j]).getEncoded();
            }
            certRepContent = new CertRepContent((byte[][])caPubs);
            String certnickname = cmsReq.getHttpParams().getValueAsString(CERT_NICKNAME, null);
            if (certnickname == null) {
                fixed.set(CERT_NICKNAME, (Object)certs[0].getSubjectName().toString());
            } else {
                fixed.set(CERT_NICKNAME, (Object)certnickname);
            }
        }
        if (CMSServlet.clientIsMSIE((HttpServletRequest)cmsReq.getHttpReq()) && (certType == null || certType.equals("client"))) {
            userChain[0] = certs[0];
            PKCS7 p7 = new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), (X509Certificate[])userChain, new SignerInfo[0]);
            byte[] p7Bytes = p7.getBytes();
            String p7Str = Utils.base64encode((byte[])p7Bytes, (boolean)true);
            header.set(PKCS7_RESP, (Object)p7Str);
        }
        for (int i = 0; i < certs.length; ++i) {
            int j;
            ArgBlock repeat = new ArgBlock();
            X509CertImpl cert = certs[i];
            BigInteger serialNo = cert.getSerialNumber();
            repeat.addBigIntegerValue(ISSUED_CERT_SERIAL, serialNo, 16);
            byte[] certEncoded = cert.getEncoded();
            String b64 = Utils.base64encode((byte[])certEncoded, (boolean)true);
            String b64cert = "-----BEGIN CERTIFICATE-----\n" + b64 + "-----END CERTIFICATE-----";
            repeat.set(BASE64_CERT, (Object)b64cert);
            String prettyPrintRequested = cmsReq.getHttpParams().getValueAsString(CERT_PRETTYPRINT, null);
            if (prettyPrintRequested == null) {
                prettyPrintRequested = "true";
            }
            String ppStr = "";
            if (!prettyPrintRequested.equals("false")) {
                CertPrettyPrint pp = new CertPrettyPrint((Certificate)cert);
                ppStr = pp.toString(locale);
            }
            repeat.set(CERT_PRETTYPRINT, (Object)ppStr);
            X509CertImpl[] certsInChain = new X509CertImpl[1];
            if (cacerts != null) {
                for (j = 0; j < cacerts.length; ++j) {
                    if (cert.equals((Object)cacerts[j])) {
                        certsInChain = new X509CertImpl[cacerts.length];
                        break;
                    }
                    certsInChain = new X509CertImpl[cacerts.length + 1];
                }
            }
            certsInChain[0] = cert;
            if (cacerts != null) {
                for (j = 0; j < cacerts.length; ++j) {
                    if (cert.equals((Object)cacerts[j])) continue;
                    certsInChain[j + 1] = (X509CertImpl)cacerts[j];
                }
            }
            try {
                PKCS7 p7 = new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), (X509Certificate[])certsInChain, new SignerInfo[0]);
                byte[] p7Bytes = p7.getBytes();
                String p7Str = Utils.base64encode((byte[])p7Bytes, (boolean)true);
                repeat.addStringValue(PKCS7_RESP, p7Str);
            }
            catch (Exception ex) {
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_FORMING_PKCS7_ERROR", (String[])new String[0]));
            }
            String fingerprint = null;
            try {
                fingerprint = CertUtils.getFingerPrints((Certificate)cert);
            }
            catch (CertificateEncodingException ex) {
                throw new EBaseException(CMS.getUserMessage((Locale)locale, (String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{ex.toString()}));
            }
            catch (NoSuchAlgorithmException ex) {
                throw new EBaseException(CMS.getUserMessage((Locale)locale, (String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{ex.toString()}));
            }
            if (fingerprint != null && fingerprint.length() > 0) {
                repeat.set(CERT_FINGERPRINT, (Object)fingerprint);
            }
            if (CMSServlet.doCMMFResponse((ArgBlock)httpParams) && crmfReqId != null && (certType == null || certType.equals("client"))) {
                PKIStatusInfo status = new PKIStatusInfo(0);
                CertifiedKeyPair certifiedKP = new CertifiedKeyPair(new CertOrEncCert(certEncoded));
                CertResponse resp = new CertResponse(new INTEGER(crmfReqId), status, certifiedKP);
                certRepContent.addCertResponse(resp);
            }
            params.addRepeatRecord(repeat);
        }
        if (CMSServlet.doCMMFResponse((ArgBlock)httpParams)) {
            ByteArrayOutputStream certRepOut = new ByteArrayOutputStream();
            certRepContent.encode((OutputStream)certRepOut);
            byte[] certRepBytes = certRepOut.toByteArray();
            String certRepB64 = Utils.base64encode((byte[])certRepBytes, (boolean)true);
            BufferedReader certRepB64lines = new BufferedReader(new StringReader(certRepB64));
            StringWriter certRepStringOut = new StringWriter();
            String oneLine = null;
            boolean first = true;
            while ((oneLine = certRepB64lines.readLine()) != null) {
                if (first) {
                    certRepStringOut.write(oneLine);
                    first = false;
                    continue;
                }
                certRepStringOut.write("\n" + oneLine);
            }
            String certRepString = certRepStringOut.toString();
            fixed.set(CMMF_RESP, (Object)certRepString);
        }
        return params;
    }
}

