/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.common;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.pkcs.ContentInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.pkcs.SignerInfo;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public abstract class CAServlet
extends CMSServlet {
    protected boolean checkImportCertToNav(HttpServletResponse httpResp, ArgBlock httpParams, X509CertImpl cert) throws EBaseException {
        if (!httpParams.getValueAsBoolean("importCert", false)) {
            return false;
        }
        boolean importCAChain = httpParams.getValueAsBoolean("importCAChain", true);
        boolean emailCert = httpParams.getValueAsBoolean("emailCert", false);
        String importMimeType = emailCert ? httpParams.getValueAsString("importCertMimeType", "application/x-x509-email-cert") : httpParams.getValueAsString("importCertMimeType", "application/x-x509-user-cert");
        this.importCertToNav(httpResp, cert, importMimeType, importCAChain);
        return true;
    }

    public void importCertToNav(HttpServletResponse httpResp, X509CertImpl cert, String contentType, boolean importCAChain) throws EBaseException {
        ServletOutputStream out = null;
        byte[] encoding = null;
        logger.debug("CMSServlet: importCertToNav contentType=" + contentType + " importCAChain=" + importCAChain);
        try {
            out = httpResp.getOutputStream();
            if (importCAChain) {
                CertificateChain caChain = null;
                X509Certificate[] caCerts = null;
                PKCS7 p7 = null;
                CAEngine engine = CAEngine.getInstance();
                CertificateAuthority ca = engine.getCA();
                caChain = ca.getCACertChain();
                caCerts = caChain.getChain();
                X509CertImpl[] userChain = new X509CertImpl[caCerts.length + 1];
                userChain[0] = cert;
                int m = 1;
                for (int n = 0; n < caCerts.length; ++n) {
                    userChain[m] = (X509CertImpl)caCerts[n];
                    ++m;
                }
                p7 = new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), (X509Certificate[])userChain, new SignerInfo[0]);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                p7.encodeSignedData((OutputStream)bos, false);
                encoding = bos.toByteArray();
                logger.debug("CMServlet: return P7 " + Utils.base64encode((byte[])encoding, (boolean)true));
            } else {
                encoding = cert.getEncoded();
                logger.debug("CMServlet: return Certificate " + Utils.base64encode((byte[])encoding, (boolean)true));
            }
            httpResp.setContentType(contentType);
            out.write(encoding);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_RET_CERT_IMPORT_ERR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_RETURNING_CERT", (Object[])new Object[0]), (Exception)e);
        }
        catch (CertificateEncodingException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_NO_ENCODED_IMP_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_ENCODING_ISSUED_CERT", (Object[])new Object[0]), (Exception)e);
        }
    }

    protected boolean isSystemCertificate(BigInteger serialNo) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        X509CertImpl caCert = ca.getCACert();
        return caCert != null && caCert.getSubjectDN().equals(caCert.getIssuerDN()) && caCert.getSerialNumber().equals(serialNo);
    }
}

