/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.processors;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.AuthEvent;
import com.netscape.certsrv.logging.event.AuthzEvent;
import com.netscape.certsrv.logging.event.RoleAssumeEvent;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.usrgrp.CertUserLocator;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.servlet.common.CMSGateway;
import com.netscape.cms.servlet.processors.Processor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.authorization.AuthzSubsystem;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmscore.usrgrp.ExactMatchCertUserLocator;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.util.StatsSubsystem;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthorizationConfig;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAProcessor
extends Processor {
    public static Logger logger = LoggerFactory.getLogger(CAProcessor.class);
    public static final String ARG_REQUEST_OWNER = "requestOwner";
    public static final String HDR_LANG = "accept-language";
    public static final String ARG_PROFILE = "profile";
    public static final String ARG_REQUEST_NOTES = "requestNotes";
    public static final String ARG_RENEWAL_PROFILE_ID = "rprofileId";
    public static final String ARG_PROFILE_IS_ENABLED = "profileIsEnable";
    public static final String ARG_PROFILE_IS_VISIBLE = "profileIsVisible";
    public static final String ARG_PROFILE_ENABLED_BY = "profileEnableBy";
    public static final String ARG_PROFILE_APPROVED_BY = "profileApprovedBy";
    public static final String ARG_PROFILE_NAME = "profileName";
    public static final String ARG_PROFILE_DESC = "profileDesc";
    public static final String ARG_PROFILE_REMOTE_HOST = "profileRemoteHost";
    public static final String ARG_PROFILE_REMOTE_ADDR = "profileRemoteAddr";
    public static final String ARG_PROFILE_SET_ID = "profileSetId";
    public static final String ARG_OUTPUT_LIST = "outputList";
    public static final String ARG_OUTPUT_ID = "outputId";
    public static final String ARG_OUTPUT_SYNTAX = "outputSyntax";
    public static final String ARG_OUTPUT_CONSTRAINT = "outputConstraint";
    public static final String ARG_OUTPUT_NAME = "outputName";
    public static final String ARG_OUTPUT_VAL = "outputVal";
    public static final String ARG_REQUEST_LIST = "requestList";
    public static final String ARG_REQUEST_ID = "requestId";
    public static final String ARG_REQUEST_TYPE = "requestType";
    public static final String ARG_REQUEST_STATUS = "requestStatus";
    public static final String ARG_REQUEST_CREATION_TIME = "requestCreationTime";
    public static final String ARG_REQUEST_MODIFICATION_TIME = "requestModificationTime";
    public static final String ARG_REQUEST_NONCE = "nonce";
    public static final String ARG_OP = "op";
    public static final String ARG_REQUESTS = "requests";
    public static final String ARG_ERROR_CODE = "errorCode";
    public static final String ARG_ERROR_REASON = "errorReason";
    public static final String CERT_ATTR = "javax.servlet.request.X509Certificate";
    public static final String PROP_AUTHZ_MGR = "AuthzMgr";
    public static final String PROP_ACL = "ACLinfo";
    public static final String AUTHZ_MGR_BASIC = "BasicAclAuthz";
    public static final String AUTHZ_MGR_LDAP = "DirAclAuthz";
    public static final String PROFILE_ID = "profileId";
    public static final String AUTH_ID = "authId";
    public static final String ACL_METHOD = "aclMethod";
    public static final String AUTHZ_RESOURCE_NAME = "authzResourceName";
    public static final String AUTH_MGR = "authMgr";
    public static final String AUTHZ_MGR = "authzMgr";
    public static final String GET_CLIENT_CERT = "getClientCert";
    public static final String ACL_INFO = "ACLinfo";
    public static final String PROFILE_SUB_ID = "profileSubId";
    protected String profileID;
    protected String profileSubId;
    protected String aclMethod;
    protected String authzResourceName;
    protected String authMgr;
    protected String getClientCert = "false";
    protected AuthzSubsystem authz;
    protected UGSubsystem ug;
    protected CertUserLocator ul;
    protected RequestRepository requestRepository;
    protected RequestQueue queue;
    protected ProfileSubsystem ps;
    protected CertificateRepository certdb;
    protected LinkedHashSet<String> statEvents = new LinkedHashSet();

    public CAProcessor(String id, Locale locale) {
        super(id, locale);
    }

    public String getACLMethod(String aclInfo, String authzMgr, String id) throws EBaseException {
        EngineConfig cs = this.engine.getConfig();
        String srcType = "ldap";
        AuthzSubsystem authz = this.engine.getAuthzSubsystem();
        try {
            AuthorizationConfig authzConfig = cs.getAuthorizationConfig();
            srcType = authzConfig.getSourceType();
        }
        catch (EBaseException e) {
            logger.warn("CAProcessor: " + CMS.getLogMessage((String)"ADMIN_SRVLT_FAIL_SRC_TYPE", (Object[])new Object[0]));
        }
        String aclMethod = null;
        if (!srcType.equalsIgnoreCase("web.xml")) {
            aclMethod = AUTHZ_MGR_LDAP;
            logger.debug("CAProcessor: " + CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_LDAP_NOT_XML", (Object[])new Object[]{id}));
            return aclMethod;
        }
        logger.debug("CAProcessor: " + CMS.getLogMessage((String)"ADMIN_SRVLT_AUTHZ_INITED", (Object[])new Object[]{""}));
        aclMethod = authzMgr;
        if (aclMethod == null || !aclMethod.equalsIgnoreCase(AUTHZ_MGR_BASIC)) {
            logger.warn("CAProcessor: " + CMS.getLogMessage((String)"ADMIN_SRVLT_PROP_ACL_NOT_SPEC", (Object[])new Object[]{PROP_AUTHZ_MGR, id, AUTHZ_MGR_LDAP}));
            return aclMethod;
        }
        if (aclInfo == null) {
            logger.warn("CAProcessor: " + CMS.getLogMessage((String)"ADMIN_SRVLT_PROP_ACL_NOT_SPEC", (Object[])new Object[]{"ACLinfo", id, AUTHZ_MGR_LDAP}));
            return aclMethod;
        }
        authz.addACLInfo(aclMethod, aclInfo);
        logger.debug("CAProcessor: " + CMS.getLogMessage((String)"ADMIN_SRVLT_AUTHZ_MGR_INIT_DONE", (Object[])new Object[]{id}));
        return aclMethod;
    }

    public void init() throws EPropertyNotFound, EBaseException {
        CAEngine caEngine = (CAEngine)this.engine;
        CAEngineConfig config = caEngine.getConfig();
        this.authz = this.engine.getAuthzSubsystem();
        this.ug = this.engine.getUGSubsystem();
        this.ul = new ExactMatchCertUserLocator();
        this.ul.setCMSEngine(this.engine);
        ConfigStore cs = config.getSubStore("processor." + this.id, ConfigStore.class);
        this.profileID = cs.getString(PROFILE_ID, "").isEmpty() ? null : cs.getString(PROFILE_ID);
        this.authzResourceName = cs.getString(AUTHZ_RESOURCE_NAME, "").isEmpty() ? null : cs.getString(AUTHZ_RESOURCE_NAME);
        this.authMgr = cs.getString(AUTH_MGR, "").isEmpty() ? null : cs.getString(AUTH_MGR);
        this.getClientCert = cs.getString(GET_CLIENT_CERT, "").isEmpty() ? "false" : cs.getString(GET_CLIENT_CERT);
        this.profileSubId = cs.getString(PROFILE_SUB_ID, "").isEmpty() ? ARG_PROFILE : cs.getString(PROFILE_SUB_ID);
        String aclInfo = cs.getString("ACLinfo", "").isEmpty() ? null : cs.getString("ACLinfo");
        String authzMgr = cs.getString(AUTHZ_MGR, "").isEmpty() ? null : cs.getString(AUTHZ_MGR);
        this.aclMethod = this.getACLMethod(aclInfo, authzMgr, this.id);
        this.requestRepository = this.engine.getRequestRepository();
        this.queue = this.engine.getRequestQueue();
        if (this.queue == null) {
            throw new EBaseException("CAProcessor: cannot get request queue");
        }
        if (this.profileSubId == null || this.profileSubId.equals("")) {
            this.profileSubId = ARG_PROFILE;
        }
        this.ps = caEngine.getProfileSubsystem(this.profileSubId);
        if (this.ps == null) {
            throw new EBaseException("CAProcessor: Profile Subsystem not found");
        }
        this.certdb = caEngine.getCertificateRepository();
        if (this.certdb == null) {
            throw new EBaseException("CAProcessor: Certificate repository not found");
        }
    }

    public String getProfileID() {
        return this.profileID;
    }

    public ProfileSubsystem getProfileSubsystem() {
        return this.ps;
    }

    public String getAuthenticationManager() {
        return this.authMgr;
    }

    public void startTiming(String event) {
        CAEngine engine = CAEngine.getInstance();
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        if (statsSub != null) {
            statsSub.startTiming(event, true);
        }
        this.statEvents.add(event);
    }

    public void endTiming(String event) {
        CAEngine engine = CAEngine.getInstance();
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        if (statsSub != null) {
            statsSub.endTiming(event);
        }
        this.statEvents.remove(event);
    }

    public void endAllEvents() {
        CAEngine engine = CAEngine.getInstance();
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        if (statsSub != null) {
            Iterator iter = this.statEvents.iterator();
            while (iter.hasNext()) {
                String event = (String)iter.next();
                statsSub.endTiming(event);
                iter.remove();
            }
        }
    }

    public Request getRequest(String rid) throws EBaseException {
        return this.requestRepository.readRequest(new RequestId(rid));
    }

    protected Request getOriginalRequest(BigInteger certSerial, CertRecord rec) throws EBaseException {
        MetaInfo metaInfo = (MetaInfo)rec.get("certMetaInfo");
        if (metaInfo == null) {
            logger.error("getOriginalRequest: cert record locating MetaInfo failed for serial number " + certSerial);
            return null;
        }
        String rid = (String)metaInfo.get(ARG_REQUEST_ID);
        if (rid == null) {
            logger.error("getOriginalRequest: cert record locating request id in MetaInfo failed for serial number " + certSerial);
            return null;
        }
        return this.requestRepository.readRequest(new RequestId(rid));
    }

    protected void printParameterValues(HashMap<String, String> data) {
        logger.debug("CAProcessor: Input Parameters:");
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String paramName = entry.getKey();
            if (CMS.isSensitive((String)paramName)) {
                logger.debug("CAProcessor: - " + paramName + ": (sensitive)");
                continue;
            }
            logger.debug("CAProcessor: - " + paramName + ": " + entry.getValue());
        }
    }

    public static X509Certificate getSSLClientCertificate(HttpServletRequest httpReq) throws EBaseException {
        X509Certificate cert = null;
        logger.debug(CMS.getLogMessage((String)"CMSGW_GETTING_SSL_CLIENT_CERT", (Object[])new Object[0]));
        X509Certificate[] allCerts = (X509Certificate[])httpReq.getAttribute(CERT_ATTR);
        if (allCerts == null || allCerts.length == 0) {
            throw new EBaseException("You did not provide a valid certificate for this operation");
        }
        cert = allCerts[0];
        if (cert == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_SSL_CL_CERT_FAIL", (Object[])new Object[0]));
            return null;
        }
        try {
            byte[] certEncoded = cert.getEncoded();
            cert = new X509CertImpl(certEncoded);
        }
        catch (CertificateEncodingException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_SSL_CL_CERT_FAIL_ENCODE", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            return null;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_SSL_CL_CERT_FAIL_DECODE", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            return null;
        }
        return cert;
    }

    protected static Hashtable<String, String> toHashtable(HttpServletRequest req) {
        Hashtable<String, String> httpReqHash = new Hashtable<String, String>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            httpReqHash.put(name, req.getParameter(name));
        }
        return httpReqHash;
    }

    public AuthToken authenticate(AuthManager authenticator, HttpServletRequest request, Request origReq, SessionContext context, AuthCredentials credentials) throws EBaseException {
        AuthToken authToken = this.authenticate(authenticator, request, credentials);
        if (authToken != null) {
            String ouid = origReq.getExtDataInString("auth_token.uid");
            if (ouid == null) {
                String sdn = (String)context.get((Object)"origSubjectDN");
                if (sdn != null && (ouid = this.getUidFromDN(sdn)) != null) {
                    logger.warn("CAProcessor: renewal: authToken original uid not found");
                }
            } else {
                logger.debug("CAProcessor: renewal: authToken original uid found in orig request auth_token");
            }
            String auid = authToken.getInString("uid");
            if (auid != null) {
                logger.debug("CAProcessor: renewal: authToken uid found:" + auid);
                if (ouid != null) {
                    context.put((Object)"orig_req.auth_token.uid", (Object)ouid);
                    logger.debug("CAProcessor: renewal: authToken original uid found:" + ouid);
                } else {
                    logger.warn("CAProcessor: renewal: authToken original uid not found");
                }
            } else {
                logger.debug("CAProcessor: renewal: authToken uid not found:");
                if (ouid != null) {
                    logger.debug("CAProcessor: renewal: origReq uid not null:" + ouid + ". Setting authtoken");
                    authToken.set("uid", ouid);
                    context.put((Object)"userid", (Object)ouid);
                } else {
                    logger.warn("CAProcessor: renewal: origReq uid not found");
                }
            }
            String userdn = origReq.getExtDataInString("auth_token.userdn");
            if (userdn != null) {
                logger.debug("CAProcessor: renewal: origReq userdn not null:" + userdn + ". Setting authtoken");
                authToken.set("userdn", userdn);
            } else {
                logger.warn("CAProcessor: renewal: origReq userdn not found");
            }
        } else {
            logger.warn("CAProcessor: renewal: authToken null");
        }
        return authToken;
    }

    public AuthToken authenticate(AuthManager authenticator, HttpServletRequest request, AuthCredentials credentials) throws EBaseException {
        if (credentials == null) {
            credentials = new AuthCredentials();
            Enumeration authNames = authenticator.getValueNames();
            if (authNames != null) {
                while (authNames.hasMoreElements()) {
                    String authName = (String)authNames.nextElement();
                    credentials.set(authName, (Object)request.getParameter(authName));
                }
            }
        }
        credentials.set("clientHost", (Object)request.getRemoteHost());
        AuthToken authToken = authenticator.authenticate(credentials);
        logger.debug("CAProcessor: Token: " + authToken);
        SessionContext sc = SessionContext.getContext();
        if (sc != null) {
            sc.put((Object)"authManagerId", (Object)authenticator.getName());
            String userid = authToken.getInString("userid");
            if (userid != null) {
                sc.put((Object)"userid", (Object)userid);
            }
        }
        return authToken;
    }

    public AuthToken authenticate(HttpServletRequest request, Request origReq, AuthManager authenticator, SessionContext context, boolean isRenewal, AuthCredentials credentials) throws EBaseException {
        this.startTiming("profile_authentication");
        logger.debug("authenticate: authentication required.");
        String uid_cred = "Unidentified";
        String uid_attempted_cred = "Unidentified";
        Enumeration authIds = authenticator.getValueNames();
        if (authIds != null) {
            while (authIds.hasMoreElements()) {
                String authName = (String)authIds.nextElement();
                String value = request.getParameter(authName);
                if (value == null || !authName.equals("uid")) continue;
                uid_attempted_cred = value;
            }
        }
        Auditor auditor = this.engine.getAuditor();
        Object authSubjectID = this.auditSubjectID();
        String authMgrID = authenticator.getName();
        AuthToken authToken = null;
        try {
            authToken = isRenewal ? this.authenticate(authenticator, request, origReq, context, credentials) : this.authenticate(authenticator, request, credentials);
        }
        catch (EAuthException e) {
            logger.error("CAProcessor: authentication error: " + e.getMessage(), (Throwable)e);
            authSubjectID = (String)authSubjectID + " : " + uid_cred;
            auditor.log((LogEvent)AuthEvent.createFailureEvent((String)authSubjectID, (String)authMgrID, (String)uid_attempted_cred));
            throw e;
        }
        catch (EBaseException e) {
            logger.error("CAProcessor: " + e.getMessage(), (Throwable)e);
            authSubjectID = (String)authSubjectID + " : " + uid_cred;
            auditor.log((LogEvent)AuthEvent.createFailureEvent((String)authSubjectID, (String)authMgrID, (String)uid_attempted_cred));
            throw e;
        }
        uid_cred = authToken.getInString("uid");
        if (uid_cred == null || uid_cred.length() == 0) {
            uid_cred = "Unidentified";
        }
        authSubjectID = (String)authSubjectID + " : " + uid_cred;
        auditor.log((LogEvent)AuthEvent.createSuccessEvent((String)authSubjectID, (String)authMgrID));
        this.endTiming("profile_authentication");
        return authToken;
    }

    public AuthToken authenticate(HttpServletRequest httpReq) throws EBaseException {
        return this.authenticate(httpReq, this.authMgr);
    }

    public void saveAuthToken(AuthToken token, Request request) {
        logger.info("CAProcessor: saving authentication token into request:");
        request.setExtData("AUTH_TOKEN", token);
        Enumeration e = token.getElements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            logger.info("- " + name + ":");
            String[] values = token.getInStringArray(name);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    logger.debug("  - " + values[i]);
                    request.setExtData("AUTH_TOKEN-" + name + "(" + i + ")", values[i]);
                }
                continue;
            }
            String value = token.getInString(name);
            if (value == null) continue;
            logger.debug("  - " + value);
            request.setExtData("AUTH_TOKEN-" + name, value);
        }
    }

    public AuthToken authenticate(HttpServletRequest httpReq, String authMgrName) throws EBaseException {
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = "$Unidentified$";
        String auditAuthMgrID = "$Unidentified$";
        String auditUID = "$Unidentified$";
        try {
            ArgBlock httpArgs = new ArgBlock(CAProcessor.toHashtable(httpReq));
            SessionContext ctx = SessionContext.getContext();
            String ip = httpReq.getRemoteAddr();
            logger.debug("IP: " + ip);
            if (ip != null) {
                ctx.put((Object)"ipAddress", (Object)ip);
            }
            logger.debug("AuthMgrName: " + authMgrName);
            if (authMgrName != null) {
                ctx.put((Object)"authManagerId", (Object)authMgrName);
            }
            ctx.put((Object)"locale", (Object)this.locale);
            X509Certificate clientCert = null;
            logger.debug("processor." + this.id + ".getClientCert: " + this.getClientCert);
            if (this.getClientCert != null && this.getClientCert.equals("true")) {
                logger.debug("CAProcessor: retrieving SSL certificate");
                clientCert = CAProcessor.getSSLClientCertificate(httpReq);
            }
            if (authMgrName == null) {
                logger.error("CAProcessor: no authMgrName");
                return null;
            }
            if (clientCert == null) {
                logger.debug("CAProcessor: no client certificate found");
            } else {
                String certUID = clientCert.getSubjectDN().getName();
                logger.debug("CAProcessor: cert UID: " + certUID);
                if (certUID != null && !(certUID = certUID.trim()).equals("")) {
                    auditUID = certUID;
                }
            }
            auditAuthMgrID = authMgrName;
            CMSGateway gateway = this.engine.getCMSGateway();
            AuthToken authToken = gateway.checkAuthManager(httpReq, httpArgs, clientCert, authMgrName);
            if (authToken == null) {
                return null;
            }
            String userid = authToken.getInString("userid");
            logger.debug("CAProcessor: user ID: " + userid);
            if (userid != null) {
                ctx.put((Object)"userid", (Object)userid);
            }
            auditSubjectID = this.auditSubjectID();
            auditor.log((LogEvent)AuthEvent.createSuccessEvent((String)auditSubjectID, (String)auditAuthMgrID));
            return authToken;
        }
        catch (EBaseException eAudit1) {
            auditor.log((LogEvent)AuthEvent.createFailureEvent((String)auditSubjectID, (String)auditAuthMgrID, (String)auditUID));
            throw eAudit1;
        }
    }

    String getUidFromDN(String userdn) {
        StringTokenizer st = new StringTokenizer(userdn, ",");
        while (st.hasMoreTokens()) {
            String n;
            String t = st.nextToken();
            int i = t.indexOf("=");
            if (i == -1 || !(n = t.substring(0, i)).equalsIgnoreCase("uid")) continue;
            String v = t.substring(i + 1);
            logger.debug("CAProcessor: UID found:" + v);
            return v;
        }
        return null;
    }

    public AuthzToken authorize(String authzMgrName, String resource, AuthToken authToken, String exp) throws EBaseException {
        AuthzToken authzToken = null;
        logger.debug("CAProcessor.authorize(" + authzMgrName + ", " + resource + ")");
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditGroupID = this.auditGroupID();
        String auditACLResource = resource;
        String auditOperation = "enroll";
        try {
            authzToken = this.authz.authorize(authzMgrName, authToken, exp);
            if (authzToken != null) {
                auditor.log((LogEvent)AuthzEvent.createSuccessEvent((String)auditSubjectID, (String)auditACLResource, (String)auditOperation));
                auditor.log((LogEvent)RoleAssumeEvent.createSuccessEvent((String)auditSubjectID, (String)auditGroupID));
            } else {
                auditor.log((LogEvent)AuthzEvent.createFailureEvent((String)auditSubjectID, (String)auditACLResource, (String)auditOperation));
                auditor.log((LogEvent)RoleAssumeEvent.createFailureEvent((String)auditSubjectID, (String)auditGroupID));
            }
            return authzToken;
        }
        catch (EBaseException e) {
            auditor.log((LogEvent)AuthzEvent.createFailureEvent((String)auditSubjectID, (String)auditACLResource, (String)auditOperation));
            auditor.log((LogEvent)RoleAssumeEvent.createFailureEvent((String)auditSubjectID, (String)auditGroupID));
            throw e;
        }
    }

    public AuthzToken authorize(String authzMgrName, AuthToken authToken, String resource, String operation) {
        logger.debug("CAProcessor.authorize(" + authzMgrName + ")");
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditGroupID = this.auditGroupID();
        String auditID = auditSubjectID;
        String auditACLResource = resource;
        String auditOperation = operation;
        SessionContext auditContext = SessionContext.getExistingContext();
        String authManagerId = null;
        if (auditContext != null && (authManagerId = (String)auditContext.get((Object)"authManagerId")) != null && authManagerId.equals("TokenAuth") && (auditSubjectID.equals("$NonRoleUser$") || auditSubjectID.equals("$Unidentified$"))) {
            logger.debug("CAProcessor: in authorize... TokenAuth auditSubjectID unavailable, changing to auditGroupID");
            auditID = auditGroupID;
        }
        if (auditACLResource != null) {
            auditACLResource = auditACLResource.trim();
        }
        if (auditOperation != null) {
            auditOperation = auditOperation.trim();
        }
        if (authzMgrName == null) {
            return null;
        }
        String roles = this.auditGroups(auditSubjectID);
        try {
            AuthzToken authzTok = this.authz.authorize(authzMgrName, authToken, resource, operation);
            if (authzTok != null) {
                auditor.log((LogEvent)AuthzEvent.createSuccessEvent((String)auditSubjectID, (String)auditACLResource, (String)auditOperation));
                if (roles != null) {
                    auditor.log((LogEvent)RoleAssumeEvent.createSuccessEvent((String)auditID, (String)roles));
                }
            } else {
                auditor.log((LogEvent)AuthzEvent.createFailureEvent((String)auditSubjectID, (String)auditACLResource, (String)auditOperation));
                if (roles != null) {
                    auditor.log((LogEvent)RoleAssumeEvent.createFailureEvent((String)auditID, (String)roles));
                }
            }
            return authzTok;
        }
        catch (Exception eAudit1) {
            auditor.log((LogEvent)AuthzEvent.createFailureEvent((String)auditSubjectID, (String)auditACLResource, (String)auditOperation));
            if (roles != null) {
                auditor.log((LogEvent)RoleAssumeEvent.createFailureEvent((String)auditID, (String)roles));
            }
            return null;
        }
    }

    public void authorize(String profileId, Profile profile, AuthToken authToken) throws EBaseException {
        if (authToken != null) {
            logger.debug("CertProcessor authToken not null");
            String acl = profile.getAuthzAcl();
            logger.debug("CAProcessor: authz using acl: " + acl);
            if (acl != null && acl.length() > 0) {
                String resource = profileId + ".authz.acl";
                this.authorize(this.aclMethod, resource, authToken, acl);
            }
        }
    }

    protected String auditRequesterID(Request request) {
        String id;
        String requesterID = "$Unidentified$";
        if (request != null && (id = request.getRequestId().toHexString()) != null) {
            requesterID = id.trim();
        }
        return requesterID;
    }

    protected String auditSubjectID() {
        logger.debug("CAProcessor: in auditSubjectID");
        String subjectID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        if (auditContext != null) {
            subjectID = (String)auditContext.get((Object)"userid");
            logger.debug("CAProcessor auditSubjectID: subjectID: " + subjectID);
            subjectID = subjectID != null ? subjectID.trim() : "$NonRoleUser$";
        } else {
            subjectID = "$Unidentified$";
        }
        return subjectID;
    }

    protected String auditGroupID() {
        logger.debug("CAProcessor: in auditGroupID");
        String groupID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        if (auditContext != null) {
            groupID = (String)auditContext.get((Object)"groupid");
            logger.debug("CAProcessor auditGroupID: groupID: " + groupID);
            groupID = groupID != null ? groupID.trim() : "$NonRoleUser$";
        } else {
            groupID = "$Unidentified$";
        }
        return groupID;
    }

    protected String auditGroups(String SubjectID) {
        if (SubjectID == null || SubjectID.equals("$Unidentified$")) {
            return null;
        }
        Enumeration groups = null;
        try {
            groups = this.ug.findGroups("*");
        }
        catch (Exception e) {
            return null;
        }
        StringBuffer membersString = new StringBuffer();
        while (groups.hasMoreElements()) {
            Group group = (Group)groups.nextElement();
            if (!group.isMember(SubjectID)) continue;
            if (membersString.length() != 0) {
                membersString.append(", ");
            }
            membersString.append(group.getGroupID());
        }
        if (membersString.length() == 0) {
            return null;
        }
        return membersString.toString();
    }

    public void validateNonce(HttpServletRequest servletRequest, String name, Object id, Long nonce) throws EBaseException {
        logger.info("CAProcessor: Nonce: " + nonce);
        if (nonce == null) {
            throw new BadRequestException("Missing nonce.");
        }
        CAEngine engine = CAEngine.getInstance();
        Map<Object, Long> nonces = engine.getNonces(servletRequest, name);
        Long storedNonce = nonces.get(id);
        if (storedNonce == null) {
            logger.warn("CAProcessor: Nonce for " + name + " " + id + " does not exist");
            throw new BadRequestException("Nonce for " + name + " " + id + " does not exist");
        }
        if (!nonce.equals(storedNonce)) {
            logger.warn("CAProcessor: Invalid nonce: " + nonce);
            throw new ForbiddenException("Invalid nonce: " + nonce);
        }
        nonces.remove(id);
        logger.debug("CAProcessor: Nonce verified");
    }
}

