/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.DBSSession;
import com.netscape.cmscore.dbs.DBSearchResults;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.Repository;
import java.math.BigInteger;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.jss.netscape.security.x509.RevokedCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLRepository
extends Repository {
    public static Logger logger = LoggerFactory.getLogger(CRLRepository.class);
    public static final String PROP_INCREMENT = "crldbInc";
    private final String mLdapCRLIssuingPointName = "cn";

    public CRLRepository(DBSubsystem dbSubsystem) {
        super(dbSubsystem, 10);
    }

    public void init() throws Exception {
        String incrementNo;
        logger.info("CRLRepository: Initializing CRL repository");
        DatabaseConfig dbConfig = this.dbSubsystem.getDBConfigStore();
        this.mBaseDN = "ou=crlIssuingPoints,ou=ca," + this.dbSubsystem.getBaseDN();
        logger.info("CRLRepository: - base DN: " + this.mBaseDN);
        this.rangeDN = dbConfig.getRequestRangeDN() + "," + this.dbSubsystem.getBaseDN();
        logger.info("CRLRepository: - range DN: " + this.rangeDN);
        this.minSerialName = "beginRequestNumber";
        String minSerial = dbConfig.getBeginRequestNumber();
        if (minSerial != null) {
            this.mMinSerialNo = new BigInteger(minSerial, this.mRadix);
        }
        logger.info("CRLRepository: - min serial: " + this.mMinSerialNo);
        this.maxSerialName = "endRequestNumber";
        String maxSerial = dbConfig.getEndRequestNumber();
        if (maxSerial != null) {
            this.mMaxSerialNo = new BigInteger(maxSerial, this.mRadix);
        }
        logger.info("CRLRepository: - max serial: " + this.mMaxSerialNo);
        this.nextMinSerialName = "nextBeginRequestNumber";
        String nextMinSerial = dbConfig.getNextBeginRequestNumber();
        this.mNextMinSerialNo = nextMinSerial == null || nextMinSerial.equals("-1") ? null : new BigInteger(nextMinSerial, this.mRadix);
        logger.info("CRLRepository: - next min serial: " + this.mNextMinSerialNo);
        this.nextMaxSerialName = "nextEndRequestNumber";
        String nextMaxSerial = dbConfig.getNextEndRequestNumber();
        this.mNextMaxSerialNo = nextMaxSerial == null || nextMaxSerial.equals("-1") ? null : new BigInteger(nextMaxSerial, this.mRadix);
        logger.info("CRLRepository: - next max serial: " + this.mNextMaxSerialNo);
        String lowWaterMark = dbConfig.getRequestLowWaterMark();
        if (lowWaterMark != null) {
            this.mLowWaterMarkNo = new BigInteger(lowWaterMark, this.mRadix);
        }
        if ((incrementNo = dbConfig.getRequestIncrement()) != null) {
            this.mIncrementNo = new BigInteger(incrementNo, this.mRadix);
        }
    }

    public void removeAllObjects() throws EBaseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCRLIssuingPointRecord(CRLIssuingPointRecord rec) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + rec.getId() + "," + this.mBaseDN;
            logger.info("CRLRepository: Adding " + name);
            s.add(name, (IDBObj)rec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getIssuingPointsNames() throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String[] attrs = new String[]{"id", "objectclass"};
            String filter = "objectclass=" + CRLIssuingPointRecord.class.getName();
            DBSearchResults res = s.search(this.mBaseDN, filter, attrs);
            Vector<String> v = new Vector<String>();
            while (res.hasMoreElements()) {
                CRLIssuingPointRecord nextelement = (CRLIssuingPointRecord)res.nextElement();
                logger.debug("CRLRepository getIssuingPointsNames(): name = " + nextelement.getId());
                v.addElement(nextelement.getId());
            }
            Vector<String> vector = v;
            return vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRLIssuingPointRecord readCRLIssuingPointRecord(String id) throws EBaseException {
        CRLIssuingPointRecord rec = null;
        try (DBSSession s = null;){
            s = this.dbSubsystem.createSession();
            String name = "cn=" + id + "," + this.mBaseDN;
            logger.info("CRLRepository: Reading " + name);
            rec = (CRLIssuingPointRecord)s.read(name);
        }
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCRLIssuingPointRecord(String id) throws EBaseException {
        try (DBSSession s = null;){
            s = this.dbSubsystem.createSession();
            String name = "cn=" + id + "," + this.mBaseDN;
            logger.info("CRLRepository: Deleting " + name);
            if (s != null) {
                s.delete(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyCRLIssuingPointRecord(String id, ModificationSet mods) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + id + "," + this.mBaseDN;
            logger.info("CRLRepository: Modifying " + name);
            if (s != null) {
                s.modify(name, mods);
            }
        }
    }

    public void updateCRLIssuingPointRecord(String id, byte[] newCRL, Date thisUpdate, Date nextUpdate, BigInteger crlNumber, Long crlSize) throws EBaseException {
        ModificationSet mods = new ModificationSet();
        if (newCRL != null) {
            mods.add("certificaterevocationlist", 2, (Object)newCRL);
        }
        if (nextUpdate != null) {
            mods.add("nextUpdate", 2, (Object)nextUpdate);
        }
        mods.add("thisUpdate", 2, (Object)thisUpdate);
        mods.add("crlNumber", 2, (Object)crlNumber);
        mods.add("crlSize", 2, (Object)crlSize);
        this.modifyCRLIssuingPointRecord(id, mods);
    }

    public void updateCRLIssuingPointRecord(String id, byte[] newCRL, Date thisUpdate, Date nextUpdate, BigInteger crlNumber, Long crlSize, Hashtable<BigInteger, RevokedCertificate> revokedCerts, Hashtable<BigInteger, RevokedCertificate> unrevokedCerts, Hashtable<BigInteger, RevokedCertificate> expiredCerts) throws EBaseException {
        logger.info("CRLReposiotry: Updating CRL issuing point record");
        ModificationSet mods = new ModificationSet();
        if (newCRL != null) {
            mods.add("certificaterevocationlist", 2, (Object)newCRL);
        }
        if (nextUpdate != null) {
            mods.add("nextUpdate", 2, (Object)nextUpdate);
        }
        mods.add("thisUpdate", 2, (Object)thisUpdate);
        mods.add("crlNumber", 2, (Object)crlNumber);
        mods.add("crlSize", 2, (Object)crlSize);
        if (revokedCerts != null) {
            mods.add("revokedCerts", 2, revokedCerts);
        }
        if (unrevokedCerts != null) {
            mods.add("unrevokedCerts", 2, unrevokedCerts);
        }
        if (expiredCerts != null) {
            mods.add("expiredCerts", 2, expiredCerts);
        }
        if (revokedCerts != null || unrevokedCerts != null) {
            mods.add("firstUnsaved", 2, (Object)"-1");
        }
        this.modifyCRLIssuingPointRecord(id, mods);
    }

    public void updateRevokedCerts(String id, Hashtable<BigInteger, RevokedCertificate> revokedCerts, Hashtable<BigInteger, RevokedCertificate> unrevokedCerts) throws EBaseException {
        logger.info("CRLReposiotry: Updating revoked certificates");
        ModificationSet mods = new ModificationSet();
        mods.add("revokedCerts", 2, revokedCerts);
        mods.add("unrevokedCerts", 2, unrevokedCerts);
        mods.add("firstUnsaved", 2, (Object)"-1");
        this.modifyCRLIssuingPointRecord(id, mods);
    }

    public void updateExpiredCerts(String id, Hashtable<BigInteger, RevokedCertificate> expiredCerts) throws EBaseException {
        ModificationSet mods = new ModificationSet();
        mods.add("expiredCerts", 2, expiredCerts);
        this.modifyCRLIssuingPointRecord(id, mods);
    }

    public void updateCRLCache(String id, Long crlSize, Hashtable<BigInteger, RevokedCertificate> revokedCerts, Hashtable<BigInteger, RevokedCertificate> unrevokedCerts, Hashtable<BigInteger, RevokedCertificate> expiredCerts) throws EBaseException {
        ModificationSet mods = new ModificationSet();
        if (crlSize != null) {
            mods.add("crlSize", 2, (Object)crlSize);
        }
        mods.add("revokedCerts", 2, revokedCerts);
        mods.add("unrevokedCerts", 2, unrevokedCerts);
        mods.add("expiredCerts", 2, expiredCerts);
        mods.add("firstUnsaved", 2, (Object)"-1");
        this.modifyCRLIssuingPointRecord(id, mods);
    }

    public void updateDeltaCRL(String id, BigInteger deltaCRLNumber, Long deltaCRLSize, Date nextUpdate, byte[] deltaCRL) throws EBaseException {
        ModificationSet mods = new ModificationSet();
        if (deltaCRLNumber != null) {
            mods.add("deltaNumber", 2, (Object)deltaCRLNumber);
        }
        if (deltaCRLSize != null) {
            mods.add("deltaSize", 2, (Object)deltaCRLSize);
        }
        if (nextUpdate != null) {
            mods.add("nextUpdate", 2, (Object)nextUpdate);
        }
        if (deltaCRL != null) {
            mods.add("deltaRevocationList", 2, (Object)deltaCRL);
        }
        this.modifyCRLIssuingPointRecord(id, mods);
    }

    public void updateFirstUnsaved(String id, String firstUnsaved) throws EBaseException {
        ModificationSet mods = new ModificationSet();
        if (firstUnsaved != null) {
            mods.add("firstUnsaved", 2, (Object)firstUnsaved);
        }
        this.modifyCRLIssuingPointRecord(id, mods);
    }

    public BigInteger getLastSerialNumberInRange(BigInteger serial_low_bound, BigInteger serial_upper_bound) throws EBaseException {
        return null;
    }
}

