/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.LdapConnFactory;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldapconn.LDAPAuthenticationConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapAuthInfo;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmsutil.password.PasswordStore;
import netscape.ldap.LDAPConnection;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnModule {
    public static Logger logger = LoggerFactory.getLogger(LdapConnModule.class);
    protected ConfigStore mConfig;
    protected LdapBoundConnFactory mLdapConnFactory = null;
    private boolean mInited = false;

    public LdapConnModule() {
    }

    public LdapConnModule(LdapBoundConnFactory factory) {
        this.mLdapConnFactory = factory;
        this.mInited = true;
    }

    public void init(ConfigStore config) throws EBaseException {
        logger.debug("LdapConnModule: init called");
        if (this.mInited) {
            logger.debug("LdapConnModule: already initialized. return.");
            return;
        }
        logger.debug("LdapConnModule: init begins");
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PasswordStore passwordStore = engine.getPasswordStore();
        this.mConfig = config;
        LDAPConfig ldap = (LDAPConfig)this.mConfig.getSubStore("ldap", LDAPConfig.class);
        LDAPConnectionConfig connConfig = ldap.getConnectionConfig();
        LdapConnInfo connInfo = new LdapConnInfo(connConfig);
        LDAPAuthenticationConfig authConfig = ldap.getAuthenticationConfig();
        LdapAuthInfo authInfo = new LdapAuthInfo();
        authInfo.setPasswordStore(passwordStore);
        authInfo.init(authConfig, connConfig.getString("host"), connConfig.getInteger("port"), connInfo.getSecure());
        int minConns = this.mConfig.getInteger("minConns", 3);
        int maxConns = this.mConfig.getInteger("maxConns", 15);
        logger.debug("Creating LdapBoundConnFactory for LdapConnModule.");
        this.mLdapConnFactory = new LdapBoundConnFactory("LDAPConnModule", minConns, maxConns, connInfo, authInfo);
        this.mLdapConnFactory.setCMSEngine((CMSEngine)engine);
        this.mLdapConnFactory.init(socketConfig, passwordStore);
        this.mInited = true;
        logger.debug("LdapConnModule: init ends");
    }

    public LdapConnFactory getLdapConnFactory() {
        return this.mLdapConnFactory;
    }

    public LDAPConnection getConn() throws ELdapException {
        return this.mLdapConnFactory.getConn();
    }

    public void returnConn(LDAPConnection conn) throws ELdapException {
        this.mLdapConnFactory.returnConn(conn);
    }
}

