/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.ldap.LdapAndExpression;
import com.netscape.cmscore.ldap.LdapExpression;
import com.netscape.cmscore.ldap.LdapOrExpression;
import com.netscape.cmscore.ldap.LdapSimpleExpression;
import com.netscape.cmscore.ldap.PredicateTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPredicateParser {
    public static Logger logger = LoggerFactory.getLogger(LdapPredicateParser.class);
    public static final int OP_AND = 1;
    public static final int OP_OR = 2;
    public static final int EXPRESSION = 0;
    public static final String AND = "AND";
    public static final String OR = "OR";
    private static final char COMMA = ',';

    public static LdapExpression parse(String predicateExpression) throws ELdapException {
        int size;
        if (predicateExpression == null || predicateExpression.length() == 0) {
            return null;
        }
        PredicateTokenizer pt = new PredicateTokenizer(predicateExpression);
        if (pt == null || !pt.hasMoreTokens()) {
            return null;
        }
        String token = pt.nextToken();
        if (LdapPredicateParser.getOP(token) != 0) {
            logger.error("Malformed expression: " + predicateExpression);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_BAD_LDAP_EXPRESSION", (String[])new String[]{predicateExpression}));
        }
        LdapExpression current = LdapPredicateParser.parseExpression(token);
        boolean malformed = false;
        Vector<LdapExpression> expSet = new Vector<LdapExpression>();
        int prevType = 0;
        while (pt.hasMoreTokens()) {
            token = pt.nextToken();
            int curType = LdapPredicateParser.getOP(token);
            if (prevType != 0 && curType != 0 || prevType == 0 && curType == 0) {
                malformed = true;
                break;
            }
            if (curType != 0) {
                prevType = curType;
                continue;
            }
            if (prevType == 2) {
                expSet.addElement(current);
                current = LdapPredicateParser.parseExpression(token);
                prevType = curType;
                continue;
            }
            if (prevType != 1) continue;
            current = new LdapAndExpression(current, LdapPredicateParser.parseExpression(token));
            prevType = curType;
        }
        if (malformed) {
            logger.error("Malformed expression: " + predicateExpression);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_BAD_LDAP_EXPRESSION", (String[])new String[]{predicateExpression}));
        }
        if (current != null) {
            expSet.addElement(current);
        }
        if ((size = expSet.size()) == 0) {
            return null;
        }
        LdapOrExpression orExp = new LdapOrExpression((LdapExpression)expSet.elementAt(0), null);
        for (int i = 1; i < size; ++i) {
            orExp = new LdapOrExpression(orExp, (LdapExpression)expSet.elementAt(i));
        }
        return orExp;
    }

    private static int getOP(String token) {
        if (token.equalsIgnoreCase(AND)) {
            return 1;
        }
        if (token.equalsIgnoreCase(OR)) {
            return 2;
        }
        return 0;
    }

    private static LdapExpression parseExpression(String input) throws ELdapException {
        LdapSimpleExpression exp;
        int commaIndex = input.indexOf(44);
        if (commaIndex < 0) {
            return LdapSimpleExpression.parse(input);
        }
        int currentIndex = 0;
        Vector<LdapSimpleExpression> expVector = new Vector<LdapSimpleExpression>();
        while (commaIndex > 0) {
            exp = (LdapSimpleExpression)LdapSimpleExpression.parse(input.substring(currentIndex, commaIndex));
            expVector.addElement(exp);
            currentIndex = commaIndex + 1;
            commaIndex = input.indexOf(44, currentIndex);
        }
        if (currentIndex < input.length() - 1) {
            exp = (LdapSimpleExpression)LdapSimpleExpression.parse(input.substring(currentIndex));
            expVector.addElement(exp);
        }
        int size = expVector.size();
        LdapSimpleExpression exp1 = (LdapSimpleExpression)expVector.elementAt(0);
        LdapSimpleExpression exp2 = (LdapSimpleExpression)expVector.elementAt(1);
        LdapAndExpression andExp = new LdapAndExpression(exp1, exp2);
        for (int i = 2; i < size; ++i) {
            andExp = new LdapAndExpression(andExp, (LdapExpression)expVector.elementAt(i));
        }
        return andExp;
    }

    public static void main(String[] args) {
    }
}

