/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.ct.sct;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.cmscore.base.ConfigStore;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.dogtagpki.ct.LogServer;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCTProcessor {
    public static Logger logger = LoggerFactory.getLogger(SCTProcessor.class);
    protected ConfigStore mConfig;

    public void init() throws Exception {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        this.mConfig = cs.getCAConfig().getSubStore("certTransparency", ConfigStore.class);
    }

    public CTmode getCTmode() throws EPropertyNotFound, EBaseException {
        String method = "SCTProcessor.CTmode: ";
        String mode = this.mConfig.getString("mode", "disabled");
        logger.debug(method + "CT mode =" + mode);
        switch (mode) {
            case "disabled": {
                return CTmode.disabled;
            }
            case "enabled": {
                return CTmode.enabled;
            }
            case "perProfile": {
                return CTmode.perProfile;
            }
        }
        throw new EPropertyNotFound(method + "unknown CT mode: " + mode);
    }

    public List<LogServer> getLogServerConfig() throws EPropertyNotFound, EBaseException, MalformedURLException {
        ConfigStore logSubstore = this.mConfig.getSubStore("log", ConfigStore.class);
        int numberOfLogServers = logSubstore.getInteger("num");
        ArrayList<LogServer> logServers = new ArrayList<LogServer>();
        for (int id = 1; id <= numberOfLogServers; ++id) {
            logger.debug("Loading configuration for logserver ID: " + id);
            LogServer logServerConfig = new LogServer();
            ConfigStore logServerSubstore = logSubstore.getSubStore(String.valueOf(id), ConfigStore.class);
            logServerConfig.setId(id);
            logServerConfig.setEnabled(logServerSubstore.getBoolean("enable"));
            logger.debug("logserver enabled: " + logServerConfig.isEnabled());
            if (!logServerConfig.isEnabled()) {
                logger.info("Logserver ID: " + id + " has been disabled. Skipping this specific logserver");
                continue;
            }
            logServerConfig.setPublicKey(logServerSubstore.getString("pubKey"));
            logServerConfig.setVersion(logServerSubstore.getInteger("version"));
            URL url = new URL(logServerSubstore.getString("url"));
            logServerConfig.setUrl(url);
            logServers.add(logServerConfig);
        }
        return logServers;
    }

    public static enum CTmode {
        disabled,
        enabled,
        perProfile;

    }
}

