/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AVAValueConverter;
import org.mozilla.jss.netscape.security.x509.Attribute;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;

class AttributeConfig {
    protected static final String PROP_ATTRIBUTE_NAME = "attributeName";
    protected static final String PROP_WTG_VALUE = "whereToGetValue";
    protected static final String PROP_VALUE = "value";
    protected static final String USE_REQUEST_ATTR = "Request Attribute";
    protected static final String USE_FIXED = "Fixed Value";
    protected String mAttributeName = null;
    protected String mWhereToGetValue = null;
    protected String mValue = null;
    protected String mPrefix = null;
    protected String mReqAttr = null;
    protected ObjectIdentifier mAttributeOID = null;
    protected String mName = null;
    protected ConfigStore mConfig;
    protected Attribute mAttribute = null;
    protected static final String ATTRIBUTE_NAME_INFO = "Attribute name.";
    protected static final String WTG_VALUE_INFO = "whereToGetValue;choice(Request Attribute,Fixed Value);Get value from a request attribute or use a fixed value specified below.";
    protected static final String VALUE_INFO = "value;string;Request attribute name or a fixed value to put into the extension.";

    public AttributeConfig(String name, ConfigStore config, boolean enabled) throws EBaseException {
        X500NameAttrMap map = X500NameAttrMap.getDefault();
        this.mName = name;
        this.mConfig = config;
        if (enabled) {
            this.mAttributeName = this.mConfig.getString(PROP_ATTRIBUTE_NAME);
            this.mWhereToGetValue = this.mConfig.getString(PROP_WTG_VALUE);
            this.mValue = this.mConfig.getString(PROP_VALUE);
        } else {
            this.mAttributeName = this.mConfig.getString(PROP_ATTRIBUTE_NAME, "");
            this.mWhereToGetValue = this.mConfig.getString(PROP_WTG_VALUE, USE_REQUEST_ATTR);
            this.mValue = this.mConfig.getString(PROP_VALUE, "");
        }
        if (this.mAttributeName.length() > 0) {
            this.mAttributeOID = map.getOid(this.mAttributeName);
            if (this.mAttributeOID == null) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{this.mAttributeName}));
            }
        }
        if (this.mWhereToGetValue.equalsIgnoreCase(USE_REQUEST_ATTR)) {
            this.mWhereToGetValue = USE_REQUEST_ATTR;
            if (enabled && this.mValue.length() == 0) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_GET_PROPERTY_FAILED", (String[])new String[]{PROP_VALUE}));
            }
            int dot = this.mValue.indexOf(46);
            if (dot != -1) {
                this.mPrefix = this.mValue.substring(0, dot);
                this.mReqAttr = this.mValue.substring(dot + 1);
                if (this.mPrefix == null || this.mPrefix.length() == 0 || this.mReqAttr == null || this.mReqAttr.length() == 0) {
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{this.mValue}));
                }
            } else {
                this.mPrefix = null;
                this.mReqAttr = this.mValue;
            }
        } else if (this.mWhereToGetValue.equalsIgnoreCase(USE_FIXED)) {
            this.mWhereToGetValue = USE_FIXED;
            if (this.mAttributeOID != null) {
                try {
                    AttributeConfig.checkValue(this.mAttributeOID, this.mValue);
                    this.mAttribute = new Attribute(this.mAttributeOID, this.mValue);
                }
                catch (Exception e) {
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{this.mAttributeName, e.getMessage()}));
                }
            }
        } else if (enabled || this.mWhereToGetValue.length() > 0) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_VALUE_FOR_TYPE", (String[])new String[]{PROP_WTG_VALUE, "Must be either 'Request Attribute' or 'Fixed Value'."}));
        }
    }

    public static void getDefaultParams(String name, Vector<String> v) {
        String nameDot = name + ".";
        v.addElement(nameDot + "attributeName=");
        v.addElement(nameDot + "whereToGetValue=Request Attribute");
        v.addElement(nameDot + "value=");
    }

    public static void getExtendedPluginInfo(String name, Vector<String> v) {
        String nameDot = name + ".";
        String attrChoices = AttributeConfig.getAllNames();
        v.addElement(nameDot + "attributeName;choice(" + attrChoices + ");Attribute name.");
        v.addElement(nameDot + WTG_VALUE_INFO);
        v.addElement(nameDot + VALUE_INFO);
    }

    public void getInstanceParams(Vector<String> v) {
        String nameDot = this.mName + ".";
        v.addElement(nameDot + "attributeName=" + this.mAttributeName);
        v.addElement(nameDot + "whereToGetValue=" + this.mWhereToGetValue);
        v.addElement(nameDot + "value=" + this.mValue);
    }

    public Attribute formAttr(Request req) throws IOException {
        String val = req.getExtDataInString(this.mPrefix, this.mReqAttr);
        if (val == null || val.length() == 0) {
            return null;
        }
        AttributeConfig.checkValue(this.mAttributeOID, val);
        return new Attribute(this.mAttributeOID, val);
    }

    private static String getAllNames() {
        Enumeration n = X500NameAttrMap.getDefault().getAllNames();
        StringBuffer sb = new StringBuffer();
        sb.append((String)n.nextElement());
        while (n.hasMoreElements()) {
            sb.append(",");
            sb.append((String)n.nextElement());
        }
        return sb.toString();
    }

    private static void checkValue(ObjectIdentifier oid, String val) throws IOException {
        AVAValueConverter c = X500NameAttrMap.getDefault().getValueConverter(oid);
        DerValue derval = c.getValue(val);
    }
}

