/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.legacy.server.policy.extensions.Subtree;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.GeneralSubtree;
import org.mozilla.jss.netscape.security.x509.GeneralSubtrees;
import org.mozilla.jss.netscape.security.x509.NameConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameConstraintsExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(NameConstraintsExt.class);
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_NUM_PERMITTEDSUBTREES = "numPermittedSubtrees";
    protected static final String PROP_NUM_EXCLUDEDSUBTREES = "numExcludedSubtrees";
    protected static final String PROP_PERMITTEDSUBTREES = "permittedSubtrees";
    protected static final String PROP_EXCLUDEDSUBTREES = "excludedSubtrees";
    protected static final boolean DEF_CRITICAL = true;
    protected static final int DEF_NUM_PERMITTEDSUBTREES = 8;
    protected static final int DEF_NUM_EXCLUDEDSUBTREES = 8;
    protected boolean mEnabled = false;
    protected ConfigStore mConfig;
    protected boolean mCritical = true;
    protected int mNumPermittedSubtrees = 0;
    protected int mNumExcludedSubtrees = 0;
    protected Subtree[] mPermittedSubtrees = null;
    protected Subtree[] mExcludedSubtrees = null;
    protected NameConstraintsExtension mNameConstraintsExtension = null;
    protected Vector<String> mInstanceParams = new Vector();
    private static Vector<String> mDefParams = new Vector();

    public NameConstraintsExt() {
        this.NAME = "NameConstraintsExt";
        this.DESC = "Sets Name Constraints Extension on subordinate CA certificates";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
        this.mEnabled = this.mConfig.getBoolean("enable", false);
        this.mCritical = this.mConfig.getBoolean(PROP_CRITICAL, true);
        this.mNumPermittedSubtrees = this.mConfig.getInteger(PROP_NUM_PERMITTEDSUBTREES, 8);
        this.mNumExcludedSubtrees = this.mConfig.getInteger(PROP_NUM_EXCLUDEDSUBTREES, 8);
        if (this.mNumPermittedSubtrees < 0) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{PROP_NUM_PERMITTEDSUBTREES, "value must be greater than or equal to 0"}));
        }
        if (this.mNumExcludedSubtrees < 0) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{PROP_NUM_EXCLUDEDSUBTREES, "value must be greater than or equal to 0"}));
        }
        if (this.mNumPermittedSubtrees > 0) {
            this.mPermittedSubtrees = this.form_subtrees(PROP_PERMITTEDSUBTREES, this.mNumPermittedSubtrees);
            logger.debug("NameConstraintsExt: formed permitted subtrees");
        }
        if (this.mNumExcludedSubtrees > 0) {
            this.mExcludedSubtrees = this.form_subtrees(PROP_EXCLUDEDSUBTREES, this.mNumExcludedSubtrees);
            logger.debug("NameConstraintsExt: formed excluded subtrees");
        }
        if (this.mEnabled) {
            try {
                Vector<GeneralSubtree> permittedSubtrees = new Vector<GeneralSubtree>();
                for (int i = 0; i < this.mNumPermittedSubtrees; ++i) {
                    permittedSubtrees.addElement(this.mPermittedSubtrees[i].mGeneralSubtree);
                }
                Vector<GeneralSubtree> excludedSubtrees = new Vector<GeneralSubtree>();
                for (int j = 0; j < this.mNumExcludedSubtrees; ++j) {
                    excludedSubtrees.addElement(this.mExcludedSubtrees[j].mGeneralSubtree);
                }
                GeneralSubtrees psb = null;
                if (permittedSubtrees.size() > 0) {
                    psb = new GeneralSubtrees(permittedSubtrees);
                }
                GeneralSubtrees esb = null;
                if (excludedSubtrees.size() > 0) {
                    esb = new GeneralSubtrees(excludedSubtrees);
                }
                this.mNameConstraintsExtension = new NameConstraintsExtension(this.mCritical, psb, esb);
                logger.debug("NameConstraintsExt: formed Name Constraints Extension " + this.mNameConstraintsExtension);
            }
            catch (IOException e) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{"Error initializing Name Constraints Extension: " + e}));
            }
        }
        this.mInstanceParams.addElement("critical=" + this.mCritical);
        this.mInstanceParams.addElement("numPermittedSubtrees=" + this.mNumPermittedSubtrees);
        this.mInstanceParams.addElement("numExcludedSubtrees=" + this.mNumExcludedSubtrees);
        if (this.mNumPermittedSubtrees > 0) {
            for (int i = 0; i < this.mPermittedSubtrees.length; ++i) {
                this.mPermittedSubtrees[i].getInstanceParams(this.mInstanceParams);
            }
        }
        if (this.mNumExcludedSubtrees > 0) {
            for (int j = 0; j < this.mExcludedSubtrees.length; ++j) {
                this.mExcludedSubtrees[j].getInstanceParams(this.mInstanceParams);
            }
        }
    }

    Subtree[] form_subtrees(String subtreesName, int numSubtrees) throws EBaseException {
        Subtree[] subtrees = new Subtree[numSubtrees];
        for (int i = 0; i < numSubtrees; ++i) {
            Subtree subtree;
            String subtreeName = subtreesName + i;
            ConfigStore subtreeConfig = this.mConfig.getSubStore(subtreeName, ConfigStore.class);
            subtrees[i] = subtree = new Subtree(subtreeName, subtreeConfig, this.mEnabled);
        }
        return subtrees;
    }

    public PolicyResult apply(Request req) {
        if (this.mNameConstraintsExtension == null) {
            return PolicyResult.ACCEPTED;
        }
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        try {
            NameConstraintsExtension nameConstraintsExt = null;
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            try {
                if (extensions != null) {
                    nameConstraintsExt = (NameConstraintsExtension)extensions.get("NameConstraints");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (nameConstraintsExt != null) {
                if (this.agentApproved(req)) {
                    logger.debug("NameConstraintsExt: request id from agent " + req.getRequestId() + " already has name constraints - accepted");
                    return PolicyResult.ACCEPTED;
                }
                logger.debug("NameConstraintsExt: request id " + req.getRequestId() + " from user  already has name constraints - deleted");
                extensions.delete("NameConstraints");
            }
            if (extensions == null) {
                certInfo.set("version", (Object)new CertificateVersion(2));
                extensions = new CertificateExtensions();
                certInfo.set("extensions", (Object)extensions);
            }
            extensions.set("NameConstraints", (Object)this.mNameConstraintsExtension);
            logger.debug("NameConstraintsExt: added Name Constraints Extension to request " + req.getRequestId());
            return PolicyResult.ACCEPTED;
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"POLICY_ERROR_NAME_CONST_EXTENSION", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.warn(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Certificate Info Error");
            return PolicyResult.REJECTED;
        }
    }

    public Vector<String> getInstanceParams() {
        return this.mInstanceParams;
    }

    public Vector<String> getDefaultParams() {
        return mDefParams;
    }

    public String[] getExtendedPluginInfo() {
        Vector<String> theparams = new Vector<String>();
        theparams.addElement("critical;boolean;RFC 2459 recommendation: MUST be critical.");
        theparams.addElement("numPermittedSubtrees;number;See RFC 2459 sec 4.2.1.11");
        theparams.addElement("numExcludedSubtrees;number;See RFC 2459 sec 4.2.1.11");
        for (int k = 0; k < 8; ++k) {
            Subtree.getExtendedPluginInfo(PROP_PERMITTEDSUBTREES + k, theparams);
        }
        for (int l = 0; l < 8; ++l) {
            Subtree.getExtendedPluginInfo(PROP_EXCLUDEDSUBTREES + l, theparams);
        }
        theparams.addElement("HELP_TOKEN;configuration-policyrules-nameconstraints");
        theparams.addElement("HELP_TEXT;Adds Name Constraints Extension. See RFC 2459");
        Object[] info = new String[theparams.size()];
        theparams.copyInto(info);
        return info;
    }

    static {
        mDefParams.addElement("critical=true");
        mDefParams.addElement("numPermittedSubtrees=8");
        mDefParams.addElement("numExcludedSubtrees=8");
        for (int k = 0; k < 8; ++k) {
            Subtree.getDefaultParams(PROP_PERMITTEDSUBTREES + k, mDefParams);
        }
        for (int l = 0; l < 8; ++l) {
            Subtree.getDefaultParams(PROP_EXCLUDEDSUBTREES + l, mDefParams);
        }
    }
}

