/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmsutil.json.JSONObject;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.tks.TKSEngine;
import org.dogtagpki.server.tks.TKSEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTransportCert
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(ImportTransportCert.class);
    private static final long serialVersionUID = 7490067757951541235L;
    private static final String SUCCESS = "0";
    private static final String AUTH_FAILURE = "2";

    public void init(ServletConfig sc) throws ServletException {
        logger.debug("ImportTransportCert: initializing...");
        super.init(sc);
        logger.debug("ImportTransportCert: done initializing...");
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        logger.debug("UpdateUpdater: processing...");
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        TKSEngine engine = TKSEngine.getInstance();
        TKSEngineConfig cs = engine.getConfig();
        AuthToken authToken = null;
        try {
            authToken = this.authenticate(cmsReq);
            logger.debug("ImportTransportCert authentication successful.");
        }
        catch (Exception e) {
            logger.error("ImportTransportCert: authentication failed: " + e.getMessage(), (Throwable)e);
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_BAD_SERV_OUT_STREAM", (Object[])new Object[]{"", e.toString()}));
            this.outputError(httpResp, AUTH_FAILURE, "Error: Not authenticated", null);
            return;
        }
        if (authToken == null) {
            logger.error("ImportTransportCert: authentication failed.");
            this.outputError(httpResp, AUTH_FAILURE, "Error: Not authenticated", null);
            return;
        }
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "modify");
            logger.debug("ImportTransportCert authorization successful.");
        }
        catch (EAuthzAccessDenied e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.outputError(httpResp, "Error: Not authorized");
            return;
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.outputError(httpResp, "Error: Encountered problem during authorization.");
            return;
        }
        if (authzToken == null) {
            this.outputError(httpResp, "Error: Not authorized");
            return;
        }
        String certsString = httpReq.getParameter("certificate");
        try {
            CryptoManager cm = CryptoManager.getInstance();
            logger.debug("ImportTransportCert: Importing certificate");
            X509Certificate cert = cm.importCACertPackage(Utils.base64decode((String)certsString));
            String nickName = cert.getNickname();
            logger.debug("ImportTransportCert: nickname " + nickName);
            cs.putString("tks.drm_transport_cert_nickname", nickName);
            logger.debug("ImportTransportCert: Commiting configuration");
            cs.commit(false);
            logger.debug("ImportTransportCert: Sending response");
            JSONObject jsonObj = new JSONObject();
            ObjectNode responseNode = jsonObj.getMapper().createObjectNode();
            jsonObj.getRootNode().set("Response", (JsonNode)responseNode);
            responseNode.put("Status", SUCCESS);
            this.outputResult(httpResp, "application/json", jsonObj.toByteArray());
        }
        catch (Exception e) {
            logger.warn("ImportTransportCert: Failed to send the output " + e.getMessage(), (Throwable)e);
        }
    }

    protected void setDefaultTemplates(ServletConfig sc) {
    }

    protected void renderTemplate(CMSRequest cmsReq, String templateName, ICMSTemplateFiller filler) throws IOException {
    }

    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage((String)lang), UserInfo.getUserCountry((String)lang));
        return locale;
    }
}

