/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tks.servlet;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.ComputeRandomDataRequestProcessedEvent;
import com.netscape.certsrv.logging.event.ComputeSessionKeyRequestProcessedEvent;
import com.netscape.certsrv.logging.event.DiversifyKeyRequestProcessedEvent;
import com.netscape.certsrv.logging.event.EncryptDataRequestProcessedEvent;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.MGF1ParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.tks.TKSEngine;
import org.dogtagpki.server.tks.TKSEngineConfig;
import org.dogtagpki.server.tks.TPSConnectorConfig;
import org.dogtagpki.server.tks.servlet.GPParams;
import org.dogtagpki.server.tks.servlet.SecureChannelProtocol;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.symkey.SessionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(TokenServlet.class);
    private static final long serialVersionUID = 8687436109695172791L;
    protected static final String PROP_ENABLED = "enabled";
    protected static final String TRANSPORT_KEY_NAME = "sharedSecret";
    private static final String INFO = "TokenServlet";
    public static int ERROR = 1;
    String mKeyNickName = null;
    String mNewKeyNickName = null;
    String mCurrentUID = null;
    PrettyPrintFormat pp = new PrettyPrintFormat(":");
    public static final byte[] C_MACDerivationConstant = new byte[]{1, 1};
    public static final byte[] ENCDerivationConstant = new byte[]{1, -126};
    public static final byte[] DEKDerivationConstant = new byte[]{1, -127};
    public static final byte[] R_MACDerivationConstant = new byte[]{1, 2};
    final char[] bytesToHex_hexArray = "0123456789ABCDEF".toCharArray();

    public static String trim(String a) {
        StringBuffer newa = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(a, "\n");
        while (tokens.hasMoreTokens()) {
            newa.append(tokens.nextToken());
        }
        return newa.toString();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public String getServletInfo() {
        return INFO;
    }

    protected String URLdecode(String s) {
        if (s == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '+') {
                out.write(32);
                continue;
            }
            if (c == '%') {
                int c1 = Character.digit(s.charAt(++i), 16);
                int c2 = Character.digit(s.charAt(++i), 16);
                out.write((char)(c1 * 16 + c2));
                continue;
            }
            out.write(c);
        }
        return out.toString();
    }

    private void setDefaultSlotAndKeyName(HttpServletRequest req) {
        try {
            String newKeyInfoMap;
            String newMappingValue;
            String keySet = req.getParameter("keySet");
            if (keySet == null || keySet.equals("")) {
                keySet = "defKeySet";
            }
            logger.debug("keySet selected: " + keySet);
            TKSEngine engine = TKSEngine.getInstance();
            TKSEngineConfig config = engine.getConfig();
            String masterKeyPrefix = config.getString("tks.master_key_prefix", null);
            String temp = req.getParameter("KeyInfo");
            String keyInfoMap = "tks." + keySet + ".mk_mappings." + temp;
            String mappingValue = config.getString(keyInfoMap, null);
            if (mappingValue != null) {
                StringTokenizer st = new StringTokenizer(mappingValue, ":");
                int tokenNumber = 0;
                while (st.hasMoreTokens()) {
                    String currentToken = st.nextToken();
                    if (tokenNumber == 1) {
                        this.mKeyNickName = currentToken;
                    }
                    ++tokenNumber;
                }
            }
            if (req.getParameter("newKeyInfo") != null && (newMappingValue = config.getString(newKeyInfoMap = "tks." + keySet + ".mk_mappings." + (temp = req.getParameter("newKeyInfo")), null)) != null) {
                StringTokenizer st = new StringTokenizer(newMappingValue, ":");
                int tokenNumber = 0;
                while (st.hasMoreTokens()) {
                    String currentToken = st.nextToken();
                    if (tokenNumber == 1) {
                        this.mNewKeyNickName = currentToken;
                    }
                    ++tokenNumber;
                }
            }
            logger.debug("Setting masteter keky prefix to: " + masterKeyPrefix);
            SecureChannelProtocol.setDefaultPrefix(masterKeyPrefix);
        }
        catch (Exception e) {
            logger.warn("Exception in TokenServlet::setDefaultSlotAndKeyName: " + e.getMessage(), (Throwable)e);
        }
    }

    private static byte read_setting_nistSP800_108KdfOnKeyVersion(String keySet) throws Exception {
        TKSEngine engine = TKSEngine.getInstance();
        TKSEngineConfig config = engine.getConfig();
        String nistSP800_108KdfOnKeyVersion_map = "tks." + keySet + ".nistSP800-108KdfOnKeyVersion";
        String nistSP800_108KdfOnKeyVersion_value = config.getString(nistSP800_108KdfOnKeyVersion_map, "00");
        short nistSP800_108KdfOnKeyVersion_short = 0;
        if (nistSP800_108KdfOnKeyVersion_value == null) {
            throw new Exception("Required configuration value \"" + nistSP800_108KdfOnKeyVersion_map + "\" missing from configuration file.");
        }
        try {
            nistSP800_108KdfOnKeyVersion_short = Short.parseShort(nistSP800_108KdfOnKeyVersion_value, 16);
            if (nistSP800_108KdfOnKeyVersion_short < 0 || nistSP800_108KdfOnKeyVersion_short > 255) {
                throw new Exception("Out of range.");
            }
        }
        catch (Throwable t) {
            throw new Exception("Configuration value \"" + nistSP800_108KdfOnKeyVersion_map + "\" is in incorrect format. Correct format is \"" + nistSP800_108KdfOnKeyVersion_map + "=xx\" where xx is key version specified in ASCII-HEX format.", t);
        }
        byte nistSP800_108KdfOnKeyVersion_byte = (byte)nistSP800_108KdfOnKeyVersion_short;
        return nistSP800_108KdfOnKeyVersion_byte;
    }

    private static boolean read_setting_nistSP800_108KdfUseCuidAsKdd(String keySet) throws Exception {
        TKSEngine engine = TKSEngine.getInstance();
        TKSEngineConfig config = engine.getConfig();
        String setting_map = "tks." + keySet + ".nistSP800-108KdfUseCuidAsKdd";
        String setting_str = config.getString(setting_map, "false");
        boolean setting_boolean = false;
        if (setting_str == null) {
            throw new Exception("Required configuration value \"" + setting_map + "\" missing from configuration file.");
        }
        try {
            setting_boolean = Boolean.parseBoolean(setting_str);
        }
        catch (Throwable t) {
            throw new Exception("Configuration value \"" + setting_map + "\" is in incorrect format.  Should be either \"true\" or \"false\".", t);
        }
        return setting_boolean;
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int thisChar = bytes[i] & 0xFF;
            hexChars[i * 2] = this.bytesToHex_hexArray[thisChar >>> 4];
            hexChars[i * 2 + 1] = this.bytesToHex_hexArray[thisChar & 0xF];
        }
        return new String(hexChars);
    }

    private String log_string_from_keyInfo(byte[] xkeyInfo) {
        return xkeyInfo == null ? "null" : (xkeyInfo.length < 1 ? "invalid" : "0x" + Integer.toHexString(xkeyInfo[0] & 0xFF));
    }

    private String log_string_from_specialDecoded_byte_array(byte[] specialDecoded) {
        return specialDecoded == null ? "null" : this.bytesToHex(specialDecoded);
    }

    private void processComputeSessionKeySCP02(HttpServletRequest req, HttpServletResponse resp) throws EBaseException {
        String rServersideKeygen;
        StringTokenizer st;
        String keyInfoMap;
        String mappingValue;
        logger.debug("TokenServlet.processComputeSessionKeySCP02 entering..");
        String auditMessage = null;
        Object errorMsg = "";
        Object badParams = "";
        String transportKeyName = "";
        boolean missingParam = false;
        String selectedToken = null;
        String keyNickName = null;
        byte[] drm_trans_wrapped_desKey = null;
        byte[] xKDD = null;
        byte nistSP800_108KdfOnKeyVersion = -1;
        boolean nistSP800_108KdfUseCuidAsKdd = false;
        TKSEngine engine = TKSEngine.getInstance();
        TKSEngineConfig config = engine.getConfig();
        Auditor auditor = engine.getAuditor();
        boolean isCryptoValidate = false;
        byte[] xCUID = null;
        byte[] session_key = null;
        Exception missingSettingException = null;
        String rCUID = req.getParameter("tokencuid");
        String rKDD = req.getParameter("KDD");
        String rKeyInfo = req.getParameter("KeyInfo");
        if (rKeyInfo == null || rKeyInfo.equals("")) {
            badParams = (String)badParams + " KeyInfo,";
            logger.debug("TokenServlet: processComputeSessionKeySCP02(): missing request parameter: key info");
            missingParam = true;
        }
        byte[] keyInfo = Utils.SpecialDecode((String)rKeyInfo);
        String keySet = req.getParameter("keySet");
        if (keySet == null || keySet.equals("")) {
            keySet = "defKeySet";
        }
        logger.debug("TokenServlet.processComputeSessionKeySCP02: keySet selected: " + keySet + " keyInfo: " + rKeyInfo);
        boolean serversideKeygen = false;
        String rDerivationConstant = req.getParameter("derivationConstant");
        String rSequenceCounter = req.getParameter("sequenceCounter");
        if (rDerivationConstant == null || rDerivationConstant.equals("")) {
            badParams = (String)badParams + " derivation_constant,";
            logger.debug("TokenServlet.processComputeSessionKeySCP02(): missing request parameter: derivation constant.");
            missingParam = true;
        }
        if (rSequenceCounter == null || rSequenceCounter.equals("")) {
            badParams = (String)badParams + " sequence_counter,";
            logger.debug("TokenServlet.processComputeSessionKeySCP02(): missing request parameter: sequence counter.");
            missingParam = true;
        }
        SessionContext sContext = SessionContext.getContext();
        String agentId = "";
        if (sContext != null) {
            agentId = (String)sContext.get((Object)"userid");
        }
        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_COMPUTE_SESSION_KEY_REQUEST_4", (Object[])new Object[]{rCUID, rKDD, "Success", agentId});
        auditor.log(auditMessage);
        if (!missingParam) {
            xCUID = Utils.SpecialDecode((String)rCUID);
            if (xCUID == null || xCUID.length != 10) {
                badParams = (String)badParams + " CUID length,";
                logger.debug("TokenServlet.processCompureSessionKeySCP02: Invalid CUID length");
                missingParam = true;
            }
            if (rKDD == null || rKDD.length() == 0) {
                logger.debug("TokenServlet.processComputeSessionKeySCP02(): missing request parameter: KDD");
                badParams = (String)badParams + " KDD,";
                missingParam = true;
            }
            if ((xKDD = Utils.SpecialDecode((String)rKDD)) == null || xKDD.length != 10) {
                badParams = (String)badParams + " KDD length,";
                logger.debug("TokenServlet.processComputeSessionKeySCP02: Invalid KDD length");
                missingParam = true;
            }
            if ((keyInfo = Utils.SpecialDecode((String)rKeyInfo)) == null || keyInfo.length != 2) {
                badParams = (String)badParams + " KeyInfo length,";
                logger.debug("TokenServlet.processComputeSessionKeySCP02: Invalid key info length.");
                missingParam = true;
            }
            try {
                nistSP800_108KdfOnKeyVersion = TokenServlet.read_setting_nistSP800_108KdfOnKeyVersion(keySet);
                nistSP800_108KdfUseCuidAsKdd = TokenServlet.read_setting_nistSP800_108KdfUseCuidAsKdd(keySet);
                logger.debug("TokenServlet: ComputeSessionKeySCP02():  keyInfo[0] = 0x" + Integer.toHexString(keyInfo[0] & 0xFF) + ",  xkeyInfo[1] = 0x" + Integer.toHexString(keyInfo[1] & 0xFF));
                logger.debug("TokenServlet: ComputeSessionKeySCP02():  Nist SP800-108 KDF will be used for key versions >= 0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF));
                if (nistSP800_108KdfUseCuidAsKdd) {
                    logger.debug("TokenServlet: ComputeSessionKeySCP02():  Nist SP800-108 KDF (if used) will use CUID instead of KDD.");
                } else {
                    logger.debug("TokenServlet: ComputeSessionKeySCP02():  Nist SP800-108 KDF (if used) will use KDD.");
                }
            }
            catch (Exception e) {
                missingSettingException = e;
                logger.warn("TokenServlet: Exception reading Nist SP800-108 KDF config values: " + e.getMessage(), (Throwable)e);
            }
        }
        if ((mappingValue = config.getString(keyInfoMap = "tks." + keySet + ".mk_mappings." + rKeyInfo, null)) == null) {
            selectedToken = config.getString("tks.defaultSlot", "internal");
            keyNickName = rKeyInfo;
        } else {
            st = new StringTokenizer(mappingValue, ":");
            if (st.hasMoreTokens()) {
                selectedToken = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                keyNickName = st.nextToken();
            }
        }
        keyInfoMap = "tks." + keySet + ".mk_mappings." + rKeyInfo;
        try {
            mappingValue = config.getString(keyInfoMap, null);
        }
        catch (EBaseException e1) {
            logger.warn("TokenServlet: " + e1.getMessage(), (Throwable)e1);
        }
        if (mappingValue == null) {
            try {
                selectedToken = config.getString("tks.defaultSlot", "internal");
            }
            catch (EBaseException e) {
                logger.warn("TokenServlet: " + e.getMessage(), (Throwable)e);
            }
            keyNickName = rKeyInfo;
        } else {
            st = new StringTokenizer(mappingValue, ":");
            if (st.hasMoreTokens()) {
                selectedToken = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                keyNickName = st.nextToken();
            }
        }
        logger.debug("TokenServlet: processComputeSessionKeySCP02(): final keyNickname: " + keyNickName);
        String useSoftToken_s = null;
        try {
            useSoftToken_s = config.getString("tks.useSoftToken", "true");
        }
        catch (EBaseException e1) {
            logger.warn("TokenServlet: " + e1.getMessage(), (Throwable)e1);
        }
        if (!useSoftToken_s.equalsIgnoreCase("true")) {
            useSoftToken_s = "false";
        }
        if ((rServersideKeygen = req.getParameter("serversideKeygen")).equals("true")) {
            logger.debug("TokenServlet.processComputeSessionKeySCP02: serversideKeygen requested");
            serversideKeygen = true;
        } else {
            logger.debug("TokenServlet.processComputeSessionKeySCP02: serversideKeygen not requested");
        }
        transportKeyName = null;
        try {
            transportKeyName = this.getSharedSecretName(config);
        }
        catch (EBaseException e1) {
            logger.warn("TokenServlet: Can't find transport key name: " + e1.getMessage(), (Throwable)e1);
        }
        logger.debug("TokenServlet: processComputeSessionKeySCP02(): tksSharedSymKeyName: " + transportKeyName);
        try {
            isCryptoValidate = config.getBoolean("cardcryptogram.validate.enable", true);
        }
        catch (EBaseException e1) {
            // empty catch block
        }
        byte[] macKeyArray = null;
        byte[] sequenceCounter = null;
        byte[] derivationConstant = null;
        boolean errorFound = false;
        String dek_wrapped_desKeyString = null;
        String keycheck_s = null;
        if (selectedToken != null && keyNickName != null && transportKeyName != null && missingSettingException == null) {
            try {
                macKeyArray = Utils.SpecialDecode((String)config.getString("tks." + keySet + ".mac_key"));
                sequenceCounter = Utils.SpecialDecode((String)rSequenceCounter);
                derivationConstant = Utils.SpecialDecode((String)rDerivationConstant);
                session_key = SessionKey.ComputeSessionKeySCP02((String)selectedToken, (String)keyNickName, (byte[])keyInfo, (byte)nistSP800_108KdfOnKeyVersion, (boolean)nistSP800_108KdfUseCuidAsKdd, (byte[])xCUID, (byte[])xKDD, (byte[])macKeyArray, (byte[])sequenceCounter, (byte[])derivationConstant, (String)useSoftToken_s, (String)keySet, (String)transportKeyName);
                if (session_key == null) {
                    logger.warn("TokenServlet.computeSessionKeySCP02:Tried ComputeSessionKey, got NULL ");
                    throw new EBaseException("Can't compute session key for SCP02!");
                }
                if (derivationConstant[0] == DEKDerivationConstant[0] && derivationConstant[1] == DEKDerivationConstant[1] && serversideKeygen) {
                    logger.debug("TokenServlet.computeSessionKeySCP02: We have the server side keygen case while generating the dek session key, wrap and return symkeys for the drm and token.");
                    PK11SymKey desKey = null;
                    PK11SymKey dekKey = null;
                    if (useSoftToken_s.equals("true")) {
                        logger.debug("TokenServlet.computeSessionKeySCP02: key encryption key generated on internal");
                        desKey = SessionKey.GenerateSymkey((String)"internal");
                    } else {
                        logger.debug("TokenServlet.computeSessionKeySCP02: key encryption key generated on " + selectedToken);
                        desKey = SessionKey.GenerateSymkey((String)selectedToken);
                    }
                    if (desKey == null) {
                        logger.error("TokenServlet.computeSessionKeySCP02: key encryption key generation failed for " + rCUID);
                        throw new EBaseException("TokenServlet.computeSessionKeySCP02: can't generate key encryption key");
                    }
                    logger.debug("TokenServlet.computeSessionKeySCP02: key encryption key generated for " + rCUID);
                    CryptoToken token = null;
                    token = useSoftToken_s.equals("true") ? CryptoUtil.getCryptoToken(null) : CryptoUtil.getCryptoToken((String)selectedToken);
                    PK11SymKey sharedSecret = this.getSharedSecretKey();
                    if (sharedSecret == null) {
                        throw new EBaseException("TokenServlet.computeSessionKeySCP02: Can't find share secret sym key!");
                    }
                    dekKey = SessionKey.UnwrapSessionKeyWithSharedSecret((String)token.getName(), (PK11SymKey)sharedSecret, (byte[])session_key);
                    if (dekKey == null) {
                        throw new EBaseException("TokenServlet.computeSessionKeySCP02: Can't unwrap DEK key onto the token!");
                    }
                    byte[] encDesKey = SessionKey.ECBencrypt((PK11SymKey)dekKey, (PK11SymKey)desKey);
                    if (encDesKey == null) {
                        throw new EBaseException("TokenServlet.computeSessionKeySCP02: Can't encrypt DEK key!");
                    }
                    dek_wrapped_desKeyString = Utils.SpecialEncode((byte[])encDesKey);
                    byte[] keycheck = SessionKey.ComputeKeyCheck((PK11SymKey)desKey);
                    if (keycheck == null) {
                        throw new EBaseException("TokenServlet.computeSessionKeySCP02: Can't compute key check for encrypted DEK key!");
                    }
                    keycheck_s = Utils.SpecialEncode((byte[])keycheck);
                    String drmTransNickname = config.getString("tks.drm_transport_cert_nickname", "");
                    if (drmTransNickname == null || drmTransNickname == "") {
                        logger.error("TokenServlet.computeSessionKeySCP02:did not find DRM transport certificate nickname");
                        throw new EBaseException("can't find DRM transport certificate nickname");
                    }
                    logger.debug("TokenServlet.computeSessionKeySCP02:drmtransport_cert_nickname=" + drmTransNickname);
                    X509Certificate drmTransCert = null;
                    drmTransCert = CryptoManager.getInstance().findCertByNickname(drmTransNickname);
                    PublicKey pubKey = drmTransCert.getPublicKey();
                    String pubKeyAlgo = pubKey.getAlgorithm();
                    KeyWrapper keyWrapper = null;
                    if (pubKeyAlgo.equals("EC")) {
                        keyWrapper = token.getKeyWrapper(KeyWrapAlgorithm.AES_ECB);
                        keyWrapper.initWrap(pubKey, null);
                    } else {
                        boolean useOAEP = config.getUseOAEPKeyWrap();
                        KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.RSA;
                        if (useOAEP) {
                            wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
                        }
                        keyWrapper = token.getKeyWrapper(wrapAlg);
                        OAEPParameterSpec params = null;
                        if (useOAEP) {
                            params = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
                        }
                        keyWrapper.initWrap(pubKey, params);
                    }
                    drm_trans_wrapped_desKey = keyWrapper.wrap((SymmetricKey)desKey);
                    logger.debug("computeSessionKey.computeSessionKeySCP02:desKey wrapped with drm transportation key.");
                    logger.debug("computeSessionKey.computeSessionKeySCP02:desKey: Just unwrapped the dekKey onto the token to be wrapped on the way out.");
                }
            }
            catch (Exception e) {
                logger.warn("TokenServlet.computeSessionKeySCP02 Computing Session Key: " + e.getMessage(), (Throwable)e);
                errorFound = true;
            }
        }
        String status = "0";
        String value = "";
        String outputString = "";
        boolean statusDeclared = false;
        if (session_key != null && session_key.length > 0 && !errorFound) {
            outputString = Utils.SpecialEncode(session_key);
        } else {
            status = "1";
            statusDeclared = true;
        }
        if (!(selectedToken != null && keyNickName != null || statusDeclared)) {
            status = "4";
            statusDeclared = true;
        }
        if (missingSettingException != null && !statusDeclared) {
            status = "6";
            statusDeclared = true;
        }
        if (missingParam) {
            status = "3";
        }
        String drm_trans_wrapped_desKeyString = null;
        if (!status.equals("0")) {
            if (status.equals("1")) {
                errorMsg = "Problem generating session key info.";
            }
            if (status.equals("4")) {
                errorMsg = "Problem obtaining token information.";
            }
            if (status.equals("3")) {
                if (((String)badParams).endsWith(",")) {
                    badParams = ((String)badParams).substring(0, ((String)badParams).length() - 1);
                }
                errorMsg = "Missing input parameters :" + (String)badParams;
            }
            if (status.equals("6")) {
                errorMsg = "Problem reading required configuration value.";
            }
        } else if (serversideKeygen) {
            if (drm_trans_wrapped_desKey != null && drm_trans_wrapped_desKey.length > 0) {
                drm_trans_wrapped_desKeyString = Utils.SpecialEncode(drm_trans_wrapped_desKey);
            }
            sb = new StringBuffer();
            sb.append("status=0&");
            sb.append("sessionKey=");
            sb.append(outputString);
            if (drm_trans_wrapped_desKeyString != null) {
                sb.append("&drm_trans_desKey=");
                sb.append(drm_trans_wrapped_desKeyString);
            }
            if (dek_wrapped_desKeyString != null) {
                sb.append("&kek_wrapped_desKey=");
                sb.append(dek_wrapped_desKeyString);
            }
            if (keycheck_s != null) {
                sb.append("&keycheck=");
                sb.append(keycheck_s);
            }
            value = sb.toString();
        } else {
            sb = new StringBuffer();
            sb.append("status=0&");
            sb.append("sessionKey=");
            sb.append(outputString);
            value = sb.toString();
        }
        try {
            resp.setContentLength(value.length());
            logger.debug("TokenServlet:outputString.length " + value.length());
            ServletOutputStream ooss = resp.getOutputStream();
            ooss.write(value.getBytes());
            ooss.flush();
            this.mRenderResult = false;
        }
        catch (IOException e) {
            logger.warn("TokenServlet: " + e.getMessage(), (Throwable)e);
        }
        if (status.equals("0")) {
            event = ComputeSessionKeyRequestProcessedEvent.success((String)this.log_string_from_specialDecoded_byte_array(xCUID), (String)this.log_string_from_specialDecoded_byte_array(xKDD), (String)status, (String)agentId, (String)(isCryptoValidate ? "true" : "false"), (String)(serversideKeygen ? "true" : "false"), (String)selectedToken, (String)keyNickName, (String)keySet, (String)this.log_string_from_keyInfo(keyInfo), (String)("0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF)), (String)Boolean.toString(nistSP800_108KdfUseCuidAsKdd));
            auditor.log((LogEvent)event);
        } else {
            event = ComputeSessionKeyRequestProcessedEvent.failure((String)this.log_string_from_specialDecoded_byte_array(xCUID), (String)this.log_string_from_specialDecoded_byte_array(xKDD), (String)status, (String)agentId, (String)(isCryptoValidate ? "true" : "false"), (String)(serversideKeygen ? "true" : "false"), (String)selectedToken, (String)keyNickName, (String)keySet, (String)this.log_string_from_keyInfo(keyInfo), (String)("0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF)), (String)Boolean.toString(nistSP800_108KdfUseCuidAsKdd), (String)errorMsg);
            auditor.log((LogEvent)event);
        }
    }

    private void processComputeSessionKey(HttpServletRequest req, HttpServletResponse resp) throws EBaseException {
        byte[] xkeyInfo;
        byte[] xKDD;
        byte[] xCUID;
        boolean sameCardCrypto;
        String keyNickName;
        String selectedToken;
        String keycheck_s;
        String kek_wrapped_desKeyString;
        String agentId;
        byte[] enc_session_key;
        byte[] host_cryptogram;
        byte[] session_key;
        Exception missingSetting_exception;
        boolean missingParam;
        boolean isCryptoValidate;
        Auditor auditor;
        byte[] drm_trans_wrapped_desKey;
        boolean serversideKeygen;
        String keySet;
        Object badParams;
        Object errorMsg;
        boolean nistSP800_108KdfUseCuidAsKdd;
        byte nistSP800_108KdfOnKeyVersion;
        block80: {
            String rServersideKeygen;
            nistSP800_108KdfOnKeyVersion = -1;
            nistSP800_108KdfUseCuidAsKdd = false;
            String auditMessage = null;
            errorMsg = "";
            badParams = "";
            String transportKeyName = "";
            String rCUID = req.getParameter("tokencuid");
            String rKDD = req.getParameter("KDD");
            if (rKDD == null || rKDD.length() == 0) {
                logger.debug("TokenServlet: KDD not supplied, set to CUID before TPS change");
                rKDD = rCUID;
            }
            if ((keySet = req.getParameter("keySet")) == null || keySet.equals("")) {
                keySet = "defKeySet";
            }
            logger.debug("keySet selected: " + keySet);
            serversideKeygen = false;
            drm_trans_wrapped_desKey = null;
            SymmetricKey desKey = null;
            TKSEngine engine = TKSEngine.getInstance();
            TKSEngineConfig config = engine.getConfig();
            auditor = engine.getAuditor();
            isCryptoValidate = true;
            missingParam = false;
            missingSetting_exception = null;
            session_key = null;
            byte[] card_crypto = null;
            host_cryptogram = null;
            enc_session_key = null;
            SessionContext sContext = SessionContext.getContext();
            agentId = "";
            if (sContext != null) {
                agentId = (String)sContext.get((Object)"userid");
            }
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_COMPUTE_SESSION_KEY_REQUEST_4", (Object[])new Object[]{rCUID, rKDD, "Success", agentId});
            auditor.log(auditMessage);
            kek_wrapped_desKeyString = null;
            keycheck_s = null;
            logger.debug("processComputeSessionKey:");
            String useSoftToken_s = config.getString("tks.useSoftToken", "true");
            if (!useSoftToken_s.equalsIgnoreCase("true")) {
                useSoftToken_s = "false";
            }
            if ((rServersideKeygen = req.getParameter("serversideKeygen")).equals("true")) {
                logger.debug("TokenServlet: serversideKeygen requested");
                serversideKeygen = true;
            } else {
                logger.debug("TokenServlet: serversideKeygen not requested");
            }
            try {
                isCryptoValidate = config.getBoolean("cardcryptogram.validate.enable", true);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            transportKeyName = this.getSharedSecretName(config);
            String rcard_challenge = req.getParameter("card_challenge");
            String rhost_challenge = req.getParameter("host_challenge");
            String rKeyInfo = req.getParameter("KeyInfo");
            String rcard_cryptogram = req.getParameter("card_cryptogram");
            if (rCUID == null || rCUID.equals("")) {
                logger.debug("TokenServlet: ComputeSessionKey(): missing request parameter: CUID");
                badParams = (String)badParams + " CUID,";
                missingParam = true;
            }
            if (rKDD == null || rKDD.length() == 0) {
                logger.debug("TokenServlet: ComputeSessionKey(): missing request parameter: KDD");
                badParams = (String)badParams + " KDD,";
                missingParam = true;
            }
            if (rcard_challenge == null || rcard_challenge.equals("")) {
                badParams = (String)badParams + " card_challenge,";
                logger.debug("TokenServlet: ComputeSessionKey(): missing request parameter: card challenge");
                missingParam = true;
            }
            if (rhost_challenge == null || rhost_challenge.equals("")) {
                badParams = (String)badParams + " host_challenge,";
                logger.debug("TokenServlet: ComputeSessionKey(): missing request parameter: host challenge");
                missingParam = true;
            }
            if (rKeyInfo == null || rKeyInfo.equals("")) {
                badParams = (String)badParams + " KeyInfo,";
                logger.debug("TokenServlet: ComputeSessionKey(): missing request parameter: key info");
                missingParam = true;
            }
            selectedToken = null;
            keyNickName = null;
            sameCardCrypto = true;
            xCUID = null;
            xKDD = null;
            xkeyInfo = null;
            if (!missingParam) {
                byte[] xhost_challenge;
                byte[] xcard_challenge;
                xCUID = Utils.SpecialDecode((String)rCUID);
                if (xCUID == null || xCUID.length != 10) {
                    badParams = (String)badParams + " CUID length,";
                    logger.debug("TokenServlet: Invalid CUID length");
                    missingParam = true;
                }
                if ((xKDD = Utils.SpecialDecode((String)rKDD)) == null || xKDD.length != 10) {
                    badParams = (String)badParams + " KDD length,";
                    logger.debug("TokenServlet: Invalid KDD length");
                    missingParam = true;
                }
                if ((xkeyInfo = Utils.SpecialDecode((String)rKeyInfo)) == null || xkeyInfo.length != 2) {
                    badParams = (String)badParams + " KeyInfo length,";
                    logger.debug("TokenServlet: Invalid key info length.");
                    missingParam = true;
                }
                if ((xcard_challenge = Utils.SpecialDecode((String)rcard_challenge)) == null || xcard_challenge.length != 8) {
                    badParams = (String)badParams + " card_challenge length,";
                    logger.debug("TokenServlet: Invalid card challenge length.");
                    missingParam = true;
                }
                if ((xhost_challenge = Utils.SpecialDecode((String)rhost_challenge)) == null || xhost_challenge.length != 8) {
                    badParams = (String)badParams + " host_challenge length,";
                    logger.debug("TokenServlet: Invalid host challenge length");
                    missingParam = true;
                }
            }
            if (!missingParam) {
                byte[] card_challenge = Utils.SpecialDecode((String)rcard_challenge);
                byte[] host_challenge = Utils.SpecialDecode((String)rhost_challenge);
                byte[] keyInfo = Utils.SpecialDecode((String)rKeyInfo);
                try {
                    nistSP800_108KdfOnKeyVersion = TokenServlet.read_setting_nistSP800_108KdfOnKeyVersion(keySet);
                    nistSP800_108KdfUseCuidAsKdd = TokenServlet.read_setting_nistSP800_108KdfUseCuidAsKdd(keySet);
                    logger.debug("TokenServlet: ComputeSessionKey():  xkeyInfo[0] = 0x" + Integer.toHexString(xkeyInfo[0] & 0xFF) + ",  xkeyInfo[1] = 0x" + Integer.toHexString(xkeyInfo[1] & 0xFF));
                    logger.debug("TokenServlet: ComputeSessionKey():  Nist SP800-108 KDF will be used for key versions >= 0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF));
                    if (nistSP800_108KdfUseCuidAsKdd) {
                        logger.debug("TokenServlet: ComputeSessionKey():  Nist SP800-108 KDF (if used) will use CUID instead of KDD.");
                    } else {
                        logger.debug("TokenServlet: ComputeSessionKey():  Nist SP800-108 KDF (if used) will use KDD.");
                    }
                }
                catch (Exception e) {
                    missingSetting_exception = e;
                    logger.warn("TokenServlet: Exception reading Nist SP800-108 KDF config values: " + e.getMessage(), (Throwable)e);
                }
                String keyInfoMap = "tks." + keySet + ".mk_mappings." + rKeyInfo;
                String mappingValue = config.getString(keyInfoMap, null);
                if (mappingValue == null) {
                    selectedToken = config.getString("tks.defaultSlot", "internal");
                    keyNickName = rKeyInfo;
                } else {
                    StringTokenizer st = new StringTokenizer(mappingValue, ":");
                    if (st.hasMoreTokens()) {
                        selectedToken = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        keyNickName = st.nextToken();
                    }
                }
                if (selectedToken != null && keyNickName != null && missingSetting_exception == null) {
                    try {
                        byte[] authKeyArray;
                        byte[] macKeyArray = Utils.SpecialDecode((String)config.getString("tks." + keySet + ".mac_key"));
                        logger.debug("TokenServlet about to try ComputeSessionKey selectedToken=" + selectedToken + " keyNickName=" + keyNickName);
                        SecureChannelProtocol protocol = new SecureChannelProtocol();
                        SymmetricKey macKey = protocol.computeSessionKey_SCP01("mac", selectedToken, keyNickName, card_challenge, host_challenge, keyInfo, nistSP800_108KdfOnKeyVersion, nistSP800_108KdfUseCuidAsKdd, xCUID, xKDD, macKeyArray, useSoftToken_s, keySet, transportKeyName);
                        session_key = protocol.wrapSessionKey(selectedToken, macKey, null);
                        if (session_key == null) {
                            logger.error("TokenServlet:Tried ComputeSessionKey, got NULL ");
                            throw new Exception("Can't compute session key!");
                        }
                        byte[] encKeyArray = Utils.SpecialDecode((String)config.getString("tks." + keySet + ".auth_key"));
                        SymmetricKey encKey = protocol.computeSessionKey_SCP01("enc", selectedToken, keyNickName, card_challenge, host_challenge, keyInfo, nistSP800_108KdfOnKeyVersion, nistSP800_108KdfUseCuidAsKdd, xCUID, xKDD, encKeyArray, useSoftToken_s, keySet, transportKeyName);
                        enc_session_key = protocol.wrapSessionKey(selectedToken, encKey, null);
                        if (enc_session_key == null) {
                            logger.error("TokenServlet:Tried ComputeEncSessionKey, got NULL ");
                            throw new Exception("Can't compute enc session key!");
                        }
                        if (serversideKeygen) {
                            logger.debug("TokenServlet: calling ComputeKekKey");
                            byte[] kekKeyArray = Utils.SpecialDecode((String)config.getString("tks." + keySet + ".kek_key"));
                            SymmetricKey kek_key = protocol.computeKEKKey_SCP01(selectedToken, keyNickName, keyInfo, nistSP800_108KdfOnKeyVersion, nistSP800_108KdfUseCuidAsKdd, xCUID, xKDD, kekKeyArray, useSoftToken_s, keySet, transportKeyName);
                            logger.debug("TokenServlet: called ComputeKekKey");
                            if (kek_key == null) {
                                logger.error("TokenServlet:Tried ComputeKekKey, got NULL ");
                                throw new Exception("Can't compute kek key!");
                            }
                            logger.debug("computeSessionKey:kek key len =" + kek_key.getLength());
                            if (useSoftToken_s.equals("true")) {
                                logger.debug("TokenServlet: key encryption key generated on internal");
                                desKey = protocol.generateSymKey("internal");
                            } else {
                                logger.debug("TokenServlet: key encryption key generated on " + selectedToken);
                                desKey = protocol.generateSymKey(selectedToken);
                            }
                            if (desKey == null) {
                                logger.error("TokenServlet: key encryption key generation failed for CUID=" + TokenServlet.trim(this.pp.toHexString(xCUID)) + ", KDD=" + TokenServlet.trim(this.pp.toHexString(xKDD)));
                                throw new Exception("can't generate key encryption key");
                            }
                            logger.debug("TokenServlet: key encryption key generated for CUID=" + TokenServlet.trim(this.pp.toHexString(xCUID)) + ", KDD=" + TokenServlet.trim(this.pp.toHexString(xKDD)));
                            byte[] encDesKey = protocol.ecbEncrypt(kek_key, desKey, selectedToken);
                            kek_wrapped_desKeyString = Utils.SpecialEncode((byte[])encDesKey);
                            byte[] keycheck = protocol.computeKeyCheck(desKey, selectedToken);
                            keycheck_s = Utils.SpecialEncode((byte[])keycheck);
                            String drmTransNickname = config.getString("tks.drm_transport_cert_nickname", "");
                            if (drmTransNickname == null || drmTransNickname == "") {
                                logger.error("TokenServlet:did not find DRM transport certificate nickname");
                                throw new Exception("can't find DRM transport certificate nickname");
                            }
                            logger.debug("TokenServlet:drmtransport_cert_nickname=" + drmTransNickname);
                            X509Certificate drmTransCert = null;
                            drmTransCert = CryptoManager.getInstance().findCertByNickname(drmTransNickname);
                            CryptoToken token = null;
                            token = useSoftToken_s.equals("true") ? CryptoUtil.getCryptoToken(null) : CryptoUtil.getCryptoToken((String)selectedToken);
                            PublicKey pubKey = drmTransCert.getPublicKey();
                            String pubKeyAlgo = pubKey.getAlgorithm();
                            logger.debug("Transport Cert Key Algorithm: " + pubKeyAlgo);
                            KeyWrapper keyWrapper = null;
                            if (pubKeyAlgo.equals("EC")) {
                                keyWrapper = token.getKeyWrapper(KeyWrapAlgorithm.AES_ECB);
                                keyWrapper.initWrap(pubKey, null);
                            } else {
                                boolean useOAEP = config.getUseOAEPKeyWrap();
                                KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.RSA;
                                if (useOAEP) {
                                    wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
                                }
                                keyWrapper = token.getKeyWrapper(wrapAlg);
                                OAEPParameterSpec params = null;
                                if (useOAEP) {
                                    params = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
                                }
                                keyWrapper.initWrap(pubKey, params);
                            }
                            logger.debug("desKey token " + desKey.getOwningToken().getName() + " token: " + token.getName());
                            drm_trans_wrapped_desKey = keyWrapper.wrap(desKey);
                            logger.debug("computeSessionKey:desKey wrapped with drm transportation key.");
                        }
                        if ((host_cryptogram = protocol.computeCryptogram_SCP01(selectedToken, keyNickName, card_challenge, host_challenge, xkeyInfo, nistSP800_108KdfOnKeyVersion, nistSP800_108KdfUseCuidAsKdd, xCUID, xKDD, 0, authKeyArray = Utils.SpecialDecode((String)config.getString("tks." + keySet + ".auth_key")), useSoftToken_s, keySet, transportKeyName)) == null) {
                            logger.error("TokenServlet:Tried ComputeCryptogram, got NULL ");
                            throw new Exception("Can't compute host cryptogram!");
                        }
                        card_crypto = protocol.computeCryptogram_SCP01(selectedToken, keyNickName, card_challenge, host_challenge, xkeyInfo, nistSP800_108KdfOnKeyVersion, nistSP800_108KdfUseCuidAsKdd, xCUID, xKDD, 1, authKeyArray, useSoftToken_s, keySet, transportKeyName);
                        if (card_crypto == null) {
                            logger.error("TokenServlet:Tried ComputeCryptogram, got NULL ");
                            throw new Exception("Can't compute card cryptogram!");
                        }
                        if (isCryptoValidate) {
                            if (rcard_cryptogram == null) {
                                logger.error("TokenServlet: ComputeCryptogram(): missing card cryptogram");
                                throw new Exception("Missing card cryptogram");
                            }
                            byte[] input_card_crypto = Utils.SpecialDecode((String)rcard_cryptogram);
                            if (card_crypto.length == input_card_crypto.length) {
                                for (int i = 0; i < card_crypto.length; ++i) {
                                    if (card_crypto[i] == input_card_crypto[i]) continue;
                                    sameCardCrypto = false;
                                    break;
                                }
                            } else {
                                sameCardCrypto = false;
                            }
                        }
                        logger.info("processComputeSessionKey for CUID=" + TokenServlet.trim(this.pp.toHexString(xCUID)) + ", KDD=" + TokenServlet.trim(this.pp.toHexString(xKDD)));
                    }
                    catch (Exception e) {
                        logger.warn("TokenServlet Computing Session Key: " + e.getMessage(), (Throwable)e);
                        if (!isCryptoValidate) break block80;
                        sameCardCrypto = false;
                    }
                }
            }
        }
        Object value = "";
        resp.setContentType("text/html");
        String outputString = "";
        String encSessionKeyString = "";
        String drm_trans_wrapped_desKeyString = "";
        String cryptogram = "";
        String status = "0";
        if (session_key != null && session_key.length > 0) {
            outputString = Utils.SpecialEncode(session_key);
        } else {
            status = "1";
        }
        if (enc_session_key != null && enc_session_key.length > 0) {
            encSessionKeyString = Utils.SpecialEncode(enc_session_key);
        } else {
            status = "1";
        }
        if (serversideKeygen) {
            if (drm_trans_wrapped_desKey != null && drm_trans_wrapped_desKey.length > 0) {
                drm_trans_wrapped_desKeyString = Utils.SpecialEncode(drm_trans_wrapped_desKey);
            } else {
                status = "1";
            }
        }
        if (host_cryptogram != null && host_cryptogram.length > 0) {
            cryptogram = Utils.SpecialEncode(host_cryptogram);
        } else if (status.equals("0")) {
            status = "2";
        }
        if ((selectedToken == null || keyNickName == null) && status.equals("0")) {
            status = "4";
        }
        if (!sameCardCrypto && status.equals("0")) {
            status = "5";
        }
        if (missingSetting_exception != null) {
            status = "6";
        }
        if (missingParam) {
            status = "3";
        }
        if (!status.equals("0")) {
            if (status.equals("1")) {
                errorMsg = "Problem generating session key info.";
            }
            if (status.equals("2")) {
                errorMsg = "Problem creating host_cryptogram.";
            }
            if (status.equals("5")) {
                errorMsg = "Card cryptogram mismatch. Token likely has incorrect keys.";
            }
            if (status.equals("4")) {
                errorMsg = "Problem obtaining token information.";
            }
            if (status.equals("6")) {
                errorMsg = "Problem reading required configuration value.";
            }
            if (status.equals("3")) {
                if (((String)badParams).endsWith(",")) {
                    badParams = ((String)badParams).substring(0, ((String)badParams).length() - 1);
                }
                errorMsg = "Missing input parameters :" + (String)badParams;
            }
            value = "status=" + status;
        } else if (serversideKeygen) {
            sb = new StringBuffer();
            sb.append("status=0&");
            sb.append("sessionKey=");
            sb.append(outputString);
            sb.append("&hostCryptogram=");
            sb.append(cryptogram);
            sb.append("&encSessionKey=");
            sb.append(encSessionKeyString);
            sb.append("&kek_wrapped_desKey=");
            sb.append(kek_wrapped_desKeyString);
            sb.append("&keycheck=");
            sb.append(keycheck_s);
            sb.append("&drm_trans_desKey=");
            sb.append(drm_trans_wrapped_desKeyString);
            value = sb.toString();
        } else {
            sb = new StringBuffer();
            sb.append("status=0&");
            sb.append("sessionKey=");
            sb.append(outputString);
            sb.append("&hostCryptogram=");
            sb.append(cryptogram);
            sb.append("&encSessionKey=");
            sb.append(encSessionKeyString);
            value = sb.toString();
        }
        try {
            resp.setContentLength(((String)value).length());
            logger.debug("TokenServlet:outputString.length " + ((String)value).length());
            ServletOutputStream ooss = resp.getOutputStream();
            ooss.write(((String)value).getBytes());
            ooss.flush();
            this.mRenderResult = false;
        }
        catch (IOException e) {
            logger.warn("TokenServlet: " + e.getMessage(), (Throwable)e);
        }
        if (status.equals("0")) {
            event = ComputeSessionKeyRequestProcessedEvent.success((String)this.log_string_from_specialDecoded_byte_array(xCUID), (String)this.log_string_from_specialDecoded_byte_array(xKDD), (String)status, (String)agentId, (String)(isCryptoValidate ? "true" : "false"), (String)(serversideKeygen ? "true" : "false"), (String)selectedToken, (String)keyNickName, (String)keySet, (String)this.log_string_from_keyInfo(xkeyInfo), (String)("0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF)), (String)Boolean.toString(nistSP800_108KdfUseCuidAsKdd));
            auditor.log((LogEvent)event);
        } else {
            event = ComputeSessionKeyRequestProcessedEvent.failure((String)this.log_string_from_specialDecoded_byte_array(xCUID), (String)this.log_string_from_specialDecoded_byte_array(xKDD), (String)status, (String)agentId, (String)(isCryptoValidate ? "true" : "false"), (String)(serversideKeygen ? "true" : "false"), (String)selectedToken, (String)keyNickName, (String)keySet, (String)this.log_string_from_keyInfo(xkeyInfo), (String)("0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF)), (String)Boolean.toString(nistSP800_108KdfUseCuidAsKdd), (String)errorMsg);
            auditor.log((LogEvent)event);
        }
    }

    private String getSharedSecretName(TKSEngineConfig cs) throws EBaseException {
        boolean useNewNames = cs.getBoolean("tks.useNewSharedSecretNames", false);
        if (useNewNames) {
            Collection<String> tpsList = cs.getTPSConnectorIDs();
            String firstSharedSecretName = null;
            if (!tpsList.isEmpty()) {
                for (String tpsID : tpsList) {
                    String csUid;
                    TPSConnectorConfig tpsConfig = cs.getTPSConnectorConfig(tpsID);
                    String sharedSecretName = tpsConfig.getNickname();
                    if (firstSharedSecretName == null) {
                        firstSharedSecretName = sharedSecretName;
                    }
                    if (sharedSecretName.isEmpty() || this.mCurrentUID == null || !this.mCurrentUID.equalsIgnoreCase(csUid = tpsConfig.getUserID())) continue;
                    logger.debug("TokenServlet.getSharedSecretName: found a match of the user id! " + csUid);
                    return sharedSecretName;
                }
                if (firstSharedSecretName != null) {
                    return firstSharedSecretName;
                }
            }
            logger.error("getSharedSecretName: no shared secret has been configured");
            throw new EBaseException("No shared secret has been configured");
        }
        return cs.getString("tks.tksSharedSymKeyName", TRANSPORT_KEY_NAME);
    }

    private void processDiversifyKey(HttpServletRequest req, HttpServletResponse resp) throws EBaseException {
        String useSoftToken_s;
        String method = "TokenServlet.processDiversifyKey: ";
        String oldKeyNickName = null;
        String newKeyNickName = null;
        byte nistSP800_108KdfOnKeyVersion = -1;
        boolean nistSP800_108KdfUseCuidAsKdd = false;
        byte[] xkeyInfo = null;
        byte[] xnewkeyInfo = null;
        Exception missingSetting_exception = null;
        boolean missingParam = false;
        Object errorMsg = "";
        Object badParams = "";
        byte[] xWrappedDekKey = null;
        TKSEngine engine = TKSEngine.getInstance();
        TKSEngineConfig config = engine.getConfig();
        Auditor auditor = engine.getAuditor();
        String rnewKeyInfo = req.getParameter("newKeyInfo");
        String newMasterKeyName = req.getParameter("newKeyInfo");
        String oldMasterKeyName = req.getParameter("KeyInfo");
        String rCUID = req.getParameter("tokencuid");
        String rKDD = req.getParameter("KDD");
        if (rKDD == null || rKDD.length() == 0) {
            logger.debug("TokenServlet: KDD not supplied, set to CUID before TPS change");
            rKDD = rCUID;
        }
        String rProtocol = req.getParameter("protocol");
        String rWrappedDekKey = req.getParameter("wrappedDekKey");
        logger.debug(method + "rWrappedDekKey: " + rWrappedDekKey);
        int protocol = 1;
        String auditMessage = "";
        String keySet = req.getParameter("keySet");
        if (keySet == null || keySet.equals("")) {
            keySet = "defKeySet";
        }
        logger.debug("keySet selected: " + keySet);
        SessionContext sContext = SessionContext.getContext();
        String agentId = "";
        if (sContext != null) {
            agentId = (String)sContext.get((Object)"userid");
        }
        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_DIVERSIFY_KEY_REQUEST_6", (Object[])new Object[]{rCUID, rKDD, "Success", agentId, oldMasterKeyName, newMasterKeyName});
        auditor.log(auditMessage);
        if (rCUID == null || rCUID.equals("")) {
            badParams = (String)badParams + " CUID,";
            logger.debug("TokenServlet: processDiversifyKey(): missing request parameter: CUID");
            missingParam = true;
        }
        if (rKDD == null || rKDD.length() == 0) {
            logger.debug("TokenServlet: processDiversifyKey(): missing request parameter: KDD");
            badParams = (String)badParams + " KDD,";
            missingParam = true;
        }
        if (rnewKeyInfo == null || rnewKeyInfo.equals("")) {
            badParams = (String)badParams + " newKeyInfo,";
            logger.debug("TokenServlet: processDiversifyKey(): missing request parameter: newKeyInfo");
            missingParam = true;
        }
        if (oldMasterKeyName == null || oldMasterKeyName.equals("")) {
            badParams = (String)badParams + " KeyInfo,";
            logger.debug("TokenServlet: processDiversifyKey(): missing request parameter: KeyInfo");
            missingParam = true;
        }
        byte[] xCUID = null;
        byte[] xKDD = null;
        xkeyInfo = null;
        xnewkeyInfo = null;
        if (!missingParam) {
            xkeyInfo = Utils.SpecialDecode((String)oldMasterKeyName);
            if (xkeyInfo == null || xkeyInfo.length != 2 && xkeyInfo.length != 3) {
                badParams = (String)badParams + " KeyInfo length,";
                logger.debug("TokenServlet: Invalid key info length");
                missingParam = true;
            }
            if ((xnewkeyInfo = Utils.SpecialDecode((String)newMasterKeyName)) == null || xnewkeyInfo.length != 2 && xnewkeyInfo.length != 3) {
                badParams = (String)badParams + " NewKeyInfo length,";
                logger.debug("TokenServlet: Invalid new key info length");
                missingParam = true;
            }
            if (rProtocol != null) {
                try {
                    protocol = Integer.parseInt(rProtocol);
                }
                catch (NumberFormatException e) {
                    protocol = 1;
                }
            }
            logger.debug("process DiversifyKey: protocol value: " + protocol);
            if (protocol == 2) {
                if (rWrappedDekKey == null || rWrappedDekKey.equals("")) {
                    badParams = (String)badParams + " WrappedDekKey,";
                    logger.debug("TokenServlet: processDiversifyKey(): missing request parameter: WrappedDekKey, with SCP02.");
                    missingParam = true;
                } else {
                    logger.debug("process DiversifyKey: wrappedDekKey value: " + rWrappedDekKey);
                    xWrappedDekKey = Utils.SpecialDecode((String)rWrappedDekKey);
                }
            }
        }
        if (!(useSoftToken_s = config.getString("tks.useSoftToken", "true")).equalsIgnoreCase("true")) {
            useSoftToken_s = "false";
        }
        byte[] KeySetData = null;
        if (!missingParam) {
            xCUID = Utils.SpecialDecode((String)rCUID);
            if (xCUID == null || xCUID.length != 10) {
                badParams = (String)badParams + " CUID length,";
                logger.debug("TokenServlet: Invalid CUID length");
                missingParam = true;
            }
            if ((xKDD = Utils.SpecialDecode((String)rKDD)) == null || xKDD.length != 10) {
                badParams = (String)badParams + " KDD length,";
                logger.debug("TokenServlet: Invalid KDD length");
                missingParam = true;
            }
        }
        if (!missingParam) {
            try {
                nistSP800_108KdfOnKeyVersion = TokenServlet.read_setting_nistSP800_108KdfOnKeyVersion(keySet);
                nistSP800_108KdfUseCuidAsKdd = TokenServlet.read_setting_nistSP800_108KdfUseCuidAsKdd(keySet);
                logger.debug("TokenServlet: processDiversifyKey():  xkeyInfo[0] (old) = 0x" + Integer.toHexString(xkeyInfo[0] & 0xFF) + ",  xkeyInfo[1] (old) = 0x" + Integer.toHexString(xkeyInfo[1] & 0xFF) + ",  xnewkeyInfo[0] = 0x" + Integer.toHexString(xnewkeyInfo[0] & 0xFF) + ",  xnewkeyInfo[1] = 0x" + Integer.toHexString(xnewkeyInfo[1] & 0xFF));
                logger.debug("TokenServlet: processDiversifyKey():  Nist SP800-108 KDF will be used for key versions >= 0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF));
                if (nistSP800_108KdfUseCuidAsKdd) {
                    logger.debug("TokenServlet: processDiversifyKey():  Nist SP800-108 KDF (if used) will use CUID instead of KDD.");
                } else {
                    logger.debug("TokenServlet: processDiversifyKey():  Nist SP800-108 KDF (if used) will use KDD.");
                }
            }
            catch (Exception e) {
                missingSetting_exception = e;
                logger.warn("TokenServlet: Exception reading Nist SP800-108 KDF config values: " + e.getMessage(), (Throwable)e);
            }
            if (this.mKeyNickName != null) {
                oldMasterKeyName = this.mKeyNickName;
            }
            if (this.mNewKeyNickName != null) {
                newMasterKeyName = this.mNewKeyNickName;
            }
            String tokKeyInfo = req.getParameter("KeyInfo");
            tokKeyInfo = tokKeyInfo.substring(0, 6);
            String oldKeyInfoMap = "tks." + keySet + ".mk_mappings." + tokKeyInfo;
            logger.debug(method + " oldKeyInfoMap: " + oldKeyInfoMap);
            String oldMappingValue = config.getString(oldKeyInfoMap, null);
            String oldSelectedToken = null;
            if (oldMappingValue == null) {
                oldSelectedToken = config.getString("tks.defaultSlot", "internal");
                oldKeyNickName = req.getParameter("KeyInfo");
            } else {
                StringTokenizer st = new StringTokenizer(oldMappingValue, ":");
                oldSelectedToken = st.nextToken();
                oldKeyNickName = st.nextToken();
            }
            String newKeyInfoMap = "tks.mk_mappings." + rnewKeyInfo.substring(0, 6);
            logger.debug(method + " newKeyInfoMap: " + newKeyInfoMap);
            String newMappingValue = config.getString(newKeyInfoMap, null);
            String newSelectedToken = null;
            if (newMappingValue == null) {
                newSelectedToken = config.getString("tks.defaultSlot", "internal");
                newKeyNickName = rnewKeyInfo;
            } else {
                StringTokenizer st = new StringTokenizer(newMappingValue, ":");
                newSelectedToken = st.nextToken();
                newKeyNickName = st.nextToken();
            }
            logger.debug("process DiversifyKey for oldSelectedToke=" + oldSelectedToken + " newSelectedToken=" + newSelectedToken + " oldKeyNickName=" + oldKeyNickName + " newKeyNickName=" + newKeyNickName);
            byte[] kekKeyArray = this.getDeveKeyArray("kek_key", (ConfigStore)config, keySet);
            byte[] macKeyArray = this.getDeveKeyArray("auth_key", (ConfigStore)config, keySet);
            byte[] encKeyArray = this.getDeveKeyArray("mac_key", (ConfigStore)config, keySet);
            GPParams gp3Params = TokenServlet.readGPSettings(keySet);
            SecureChannelProtocol secProtocol = new SecureChannelProtocol(protocol);
            if (missingSetting_exception == null) {
                if (protocol == 1 || protocol == 3) {
                    KeySetData = secProtocol.diversifyKey(oldSelectedToken, newSelectedToken, oldKeyNickName, newKeyNickName, xkeyInfo, xnewkeyInfo, nistSP800_108KdfOnKeyVersion, nistSP800_108KdfUseCuidAsKdd, xCUID, xKDD, kekKeyArray, encKeyArray, macKeyArray, useSoftToken_s, keySet, (byte)protocol, gp3Params);
                } else if (protocol == 2) {
                    KeySetData = SessionKey.DiversifyKey((String)oldSelectedToken, (String)newSelectedToken, (String)oldKeyNickName, (String)newKeyNickName, (byte[])xkeyInfo, (byte[])xnewkeyInfo, (byte)nistSP800_108KdfOnKeyVersion, (boolean)nistSP800_108KdfUseCuidAsKdd, (byte[])xCUID, (byte[])xKDD, (byte[])(protocol == 2 ? xWrappedDekKey : kekKeyArray), (String)useSoftToken_s, (String)keySet, (byte)((byte)protocol));
                }
                logger.debug("TokenServlet.processDiversifyKey: New keyset data obtained");
                if (KeySetData == null || KeySetData.length <= 1) {
                    logger.info("process DiversifyKey: Missing MasterKey in Slot");
                }
                logger.info("process DiversifyKey for CUID=" + TokenServlet.trim(this.pp.toHexString(xCUID)) + ", KDD=" + TokenServlet.trim(this.pp.toHexString(xKDD)) + ";from oldMasterKeyName=" + oldSelectedToken + ":" + oldKeyNickName + ";to newMasterKeyName=" + newSelectedToken + ":" + newKeyNickName);
                resp.setContentType("text/html");
            }
        }
        Object value = "";
        String status = "0";
        if (KeySetData != null && KeySetData.length > 1) {
            value = "status=0&keySetData=" + Utils.SpecialEncode(KeySetData);
            logger.debug("TokenServlet:process DiversifyKey.encode returning KeySetData");
        } else if (missingSetting_exception != null) {
            status = "6";
            errorMsg = "Problem reading required configuration value.";
            value = "status=" + status;
        } else if (missingParam) {
            status = "3";
            if (((String)badParams).endsWith(",")) {
                badParams = ((String)badParams).substring(0, ((String)badParams).length() - 1);
            }
            errorMsg = "Missing input parameters: " + (String)badParams;
            value = "status=" + status;
        } else {
            errorMsg = "Problem diversifying key data.";
            status = "1";
            value = "status=" + status;
        }
        resp.setContentLength(((String)value).length());
        logger.debug("TokenServlet:outputString.length " + ((String)value).length());
        try {
            ServletOutputStream ooss = resp.getOutputStream();
            ooss.write(((String)value).getBytes());
            ooss.flush();
            this.mRenderResult = false;
        }
        catch (Exception e) {
            logger.warn("TokenServlet:process DiversifyKey: " + e.getMessage(), (Throwable)e);
        }
        if (status.equals("0")) {
            event = DiversifyKeyRequestProcessedEvent.success((String)this.log_string_from_specialDecoded_byte_array(xCUID), (String)this.log_string_from_specialDecoded_byte_array(xKDD), (String)status, (String)agentId, (String)oldKeyNickName, newKeyNickName, (String)keySet, (String)this.log_string_from_keyInfo(xkeyInfo), (String)this.log_string_from_keyInfo(xnewkeyInfo), (String)("0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF)), (String)Boolean.toString(nistSP800_108KdfUseCuidAsKdd));
            auditor.log((LogEvent)event);
        } else {
            event = DiversifyKeyRequestProcessedEvent.failure((String)this.log_string_from_specialDecoded_byte_array(xCUID), (String)this.log_string_from_specialDecoded_byte_array(xKDD), (String)status, (String)agentId, (String)oldKeyNickName, newKeyNickName, (String)keySet, (String)this.log_string_from_keyInfo(xkeyInfo), (String)this.log_string_from_keyInfo(xnewkeyInfo), (String)("0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF)), (String)Boolean.toString(nistSP800_108KdfUseCuidAsKdd), (String)errorMsg);
            auditor.log((LogEvent)event);
        }
    }

    private void processEncryptData(HttpServletRequest req, HttpServletResponse resp) throws EBaseException {
        String useSoftToken_s;
        String keySet;
        byte nistSP800_108KdfOnKeyVersion = -1;
        boolean nistSP800_108KdfUseCuidAsKdd = false;
        Exception missingSetting_exception = null;
        boolean missingParam = false;
        byte[] data = null;
        boolean isRandom = true;
        Object errorMsg = "";
        Object badParams = "";
        TKSEngine engine = TKSEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        Auditor auditor = engine.getAuditor();
        TKSEngineConfig config = engine.getConfig();
        byte[] encryptedData = null;
        String rdata = req.getParameter("data");
        String rKeyInfo = req.getParameter("KeyInfo");
        String rCUID = req.getParameter("tokencuid");
        String protocolValue = req.getParameter("protocol");
        String rKDD = req.getParameter("KDD");
        if (rKDD == null || rKDD.length() == 0) {
            logger.debug("TokenServlet: KDD not supplied, set to CUID before TPS change");
            rKDD = rCUID;
        }
        if ((keySet = req.getParameter("keySet")) == null || keySet.equals("")) {
            keySet = "defKeySet";
        }
        SessionContext sContext = SessionContext.getContext();
        String agentId = "";
        if (sContext != null) {
            agentId = (String)sContext.get((Object)"userid");
        }
        logger.debug("keySet selected: " + keySet);
        String s_isRandom = config.getString("tks.EncryptData.isRandom", "true");
        if (s_isRandom.equalsIgnoreCase("false")) {
            logger.debug("TokenServlet: processEncryptData(): Random number not to be generated");
            isRandom = false;
        } else {
            logger.debug("TokenServlet: processEncryptData(): Random number generation required");
            isRandom = true;
        }
        String auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_ENCRYPT_DATA_REQUEST_5", (Object[])new Object[]{rCUID, rKDD, "Success", agentId, s_isRandom});
        auditor.log(auditMessage);
        GPParams gp3Params = TokenServlet.readGPSettings(keySet);
        if (isRandom) {
            if (rdata == null || rdata.equals("")) {
                logger.debug("TokenServlet: processEncryptData(): no data in request.  Generating random number as data");
            } else {
                logger.debug("TokenServlet: processEncryptData(): contain data in request, however, random generation on TKS is required. Generating...");
            }
            try {
                SecureRandom random = jssSubsystem.getRandomNumberGenerator();
                data = new byte[16];
                random.nextBytes(data);
            }
            catch (Exception e) {
                logger.warn("TokenServlet: processEncryptData():" + e.getMessage(), (Throwable)e);
                badParams = (String)badParams + " Random Number,";
                missingParam = true;
            }
        } else if (!isRandom && (rdata == null || rdata.equals(""))) {
            logger.debug("TokenServlet: processEncryptData(): missing request parameter: data.");
            badParams = (String)badParams + " data,";
            missingParam = true;
        }
        if (rCUID == null || rCUID.equals("")) {
            badParams = (String)badParams + " CUID,";
            logger.debug("TokenServlet: processEncryptData(): missing request parameter: CUID");
            missingParam = true;
        }
        if (rKDD == null || rKDD.length() == 0) {
            logger.debug("TokenServlet: processDiversifyKey(): missing request parameter: KDD");
            badParams = (String)badParams + " KDD,";
            missingParam = true;
        }
        if (rKeyInfo == null || rKeyInfo.equals("")) {
            badParams = (String)badParams + " KeyInfo,";
            logger.debug("TokenServlet: processEncryptData(): missing request parameter: key info");
            missingParam = true;
        }
        byte[] xCUID = null;
        byte[] xKDD = null;
        byte[] xkeyInfo = null;
        if (!missingParam) {
            xCUID = Utils.SpecialDecode((String)rCUID);
            if (xCUID == null || xCUID.length != 10) {
                badParams = (String)badParams + " CUID length,";
                logger.debug("TokenServlet: Invalid CUID length");
                missingParam = true;
            }
            if ((xKDD = Utils.SpecialDecode((String)rKDD)) == null || xKDD.length != 10) {
                badParams = (String)badParams + " KDD length,";
                logger.debug("TokenServlet: Invalid KDD length");
                missingParam = true;
            }
            if ((xkeyInfo = Utils.SpecialDecode((String)rKeyInfo)) == null || xkeyInfo.length != 2 && xkeyInfo.length != 3) {
                badParams = (String)badParams + " KeyInfo length,";
                logger.debug("TokenServlet: Invalid key info length");
                missingParam = true;
            }
        }
        if (!(useSoftToken_s = config.getString("tks.useSoftToken", "true")).equalsIgnoreCase("true")) {
            useSoftToken_s = "false";
        }
        String selectedToken = null;
        String keyNickName = null;
        if (!missingParam) {
            try {
                nistSP800_108KdfOnKeyVersion = TokenServlet.read_setting_nistSP800_108KdfOnKeyVersion(keySet);
                nistSP800_108KdfUseCuidAsKdd = TokenServlet.read_setting_nistSP800_108KdfUseCuidAsKdd(keySet);
                logger.debug("TokenServlet: processEncryptData():  xkeyInfo[0] = 0x" + Integer.toHexString(xkeyInfo[0] & 0xFF) + ",  xkeyInfo[1] = 0x" + Integer.toHexString(xkeyInfo[1] & 0xFF));
                logger.debug("TokenServlet: processEncryptData():  Nist SP800-108 KDF will be used for key versions >= 0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF));
                if (nistSP800_108KdfUseCuidAsKdd) {
                    logger.debug("TokenServlet: processEncryptData():  Nist SP800-108 KDF (if used) will use CUID instead of KDD.");
                } else {
                    logger.debug("TokenServlet: processEncryptData():  Nist SP800-108 KDF (if used) will use KDD.");
                }
            }
            catch (Exception e) {
                missingSetting_exception = e;
                logger.warn("TokenServlet: Exception reading Nist SP800-108 KDF config values: " + e.getMessage(), (Throwable)e);
            }
            if (!isRandom) {
                data = Utils.SpecialDecode((String)rdata);
            }
            byte[] keyInfo = Utils.SpecialDecode((String)rKeyInfo);
            String keyInfoMap = "tks." + keySet + ".mk_mappings." + rKeyInfo.substring(0, 6);
            String mappingValue = config.getString(keyInfoMap, null);
            if (mappingValue == null) {
                selectedToken = config.getString("tks.defaultSlot", "internal");
                keyNickName = rKeyInfo;
            } else {
                StringTokenizer st = new StringTokenizer(mappingValue, ":");
                selectedToken = st.nextToken();
                keyNickName = st.nextToken();
            }
            int protocolInt = 1;
            try {
                protocolInt = Integer.parseInt(protocolValue);
            }
            catch (NumberFormatException nfe) {
                protocolInt = 1;
            }
            logger.debug("TokenServerlet.encryptData: protocol input: " + protocolInt);
            if (protocolInt <= 0 || protocolInt > 20) {
                logger.debug("TokenServerlet.encryptData: unfamliar protocl, assume default of 1.");
                protocolInt = 1;
            }
            byte[] kekKeyArray = Utils.SpecialDecode((String)config.getString("tks." + keySet + ".kek_key"));
            if (missingSetting_exception == null) {
                SecureChannelProtocol protocol = new SecureChannelProtocol(protocolInt);
                encryptedData = protocolInt != 3 ? protocol.encryptData(selectedToken, keyNickName, data, keyInfo, nistSP800_108KdfOnKeyVersion, nistSP800_108KdfUseCuidAsKdd, xCUID, xKDD, kekKeyArray, useSoftToken_s, keySet) : protocol.encryptData_SCP03(selectedToken, keyNickName, data, xkeyInfo, nistSP800_108KdfOnKeyVersion, nistSP800_108KdfUseCuidAsKdd, xCUID, xKDD, kekKeyArray, useSoftToken_s, keySet, gp3Params);
                logger.info("process EncryptData for CUID=" + TokenServlet.trim(this.pp.toHexString(xCUID)) + ", KDD=" + TokenServlet.trim(this.pp.toHexString(xKDD)));
            }
        }
        resp.setContentType("text/html");
        Object value = "";
        String status = "0";
        if (encryptedData != null && encryptedData.length > 0) {
            value = "status=0&data=" + Utils.SpecialEncode((byte[])data) + "&encryptedData=" + Utils.SpecialEncode(encryptedData);
        } else if (missingSetting_exception != null) {
            status = "6";
            errorMsg = "Problem reading required configuration value.";
            value = "status=" + status;
        } else if (missingParam) {
            if (((String)badParams).endsWith(",")) {
                badParams = ((String)badParams).substring(0, ((String)badParams).length() - 1);
            }
            errorMsg = "Missing input parameters: " + (String)badParams;
            status = "3";
            value = "status=" + status;
        } else {
            errorMsg = "Problem encrypting data.";
            status = "1";
            value = "status=" + status;
        }
        try {
            resp.setContentLength(((String)value).length());
            logger.debug("TokenServlet:outputString.lenght " + ((String)value).length());
            ServletOutputStream ooss = resp.getOutputStream();
            ooss.write(((String)value).getBytes());
            ooss.flush();
            this.mRenderResult = false;
        }
        catch (Exception e) {
            logger.warn("TokenServlet: " + e.getMessage(), (Throwable)e);
        }
        if (status.equals("0")) {
            event = EncryptDataRequestProcessedEvent.success((String)this.log_string_from_specialDecoded_byte_array(xCUID), (String)this.log_string_from_specialDecoded_byte_array(xKDD), (String)status, (String)agentId, (String)s_isRandom, (String)selectedToken, (String)keyNickName, (String)keySet, (String)this.log_string_from_keyInfo(xkeyInfo), (String)("0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF)), (String)Boolean.toString(nistSP800_108KdfUseCuidAsKdd));
            auditor.log((LogEvent)event);
        } else {
            event = EncryptDataRequestProcessedEvent.failure((String)this.log_string_from_specialDecoded_byte_array(xCUID), (String)this.log_string_from_specialDecoded_byte_array(xKDD), (String)status, (String)agentId, (String)s_isRandom, (String)selectedToken, (String)keyNickName, (String)keySet, (String)this.log_string_from_keyInfo(xkeyInfo), (String)("0x" + Integer.toHexString(nistSP800_108KdfOnKeyVersion & 0xFF)), (String)Boolean.toString(nistSP800_108KdfUseCuidAsKdd), (String)errorMsg);
            auditor.log((LogEvent)event);
        }
    }

    private void processComputeRandomData(HttpServletRequest req, HttpServletResponse resp) throws EBaseException {
        String sDataSize;
        byte[] randomData = null;
        String status = "0";
        Object errorMsg = "";
        Object badParams = "";
        boolean missingParam = false;
        int dataSize = 0;
        logger.debug("TokenServlet::processComputeRandomData");
        SessionContext sContext = SessionContext.getContext();
        TKSEngine engine = TKSEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        Auditor auditor = engine.getAuditor();
        String agentId = "";
        if (sContext != null) {
            agentId = (String)sContext.get((Object)"userid");
        }
        if ((sDataSize = req.getParameter("dataNumBytes")) == null || sDataSize.equals("")) {
            logger.debug("TokenServlet::processComputeRandomData missing param dataNumBytes");
            badParams = (String)badParams + " Random Data size, ";
            missingParam = true;
            status = "1";
        } else {
            try {
                dataSize = Integer.parseInt(sDataSize.trim());
            }
            catch (NumberFormatException nfe) {
                logger.warn("TokenServlet::processComputeRandomData invalid data size input: " + nfe.getMessage(), (Throwable)nfe);
                badParams = (String)badParams + " Random Data size, ";
                missingParam = true;
                status = "1";
            }
        }
        logger.debug("TokenServlet::processComputeRandomData data size requested: " + dataSize);
        String auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_COMPUTE_RANDOM_DATA_REQUEST_2", (Object[])new Object[]{"Success", agentId});
        auditor.log(auditMessage);
        if (!missingParam) {
            try {
                SecureRandom random = jssSubsystem.getRandomNumberGenerator();
                randomData = new byte[dataSize];
                random.nextBytes(randomData);
            }
            catch (Exception e) {
                logger.warn("TokenServlet::processComputeRandomData:" + e.getMessage(), (Throwable)e);
                errorMsg = "Can't generate random data!";
                status = "2";
            }
        }
        String randomDataOut = "";
        if (status.equals("0")) {
            if (randomData != null && randomData.length == dataSize) {
                randomDataOut = Utils.SpecialEncode((byte[])randomData);
            } else {
                status = "2";
                errorMsg = "Can't convert random data!";
            }
        }
        if (status.equals("1") && missingParam) {
            if (((String)badParams).endsWith(",")) {
                badParams = ((String)badParams).substring(0, ((String)badParams).length() - 1);
            }
            errorMsg = "Missing input parameters :" + (String)badParams;
        }
        resp.setContentType("text/html");
        Object value = "";
        value = "status=" + status;
        if (status.equals("0")) {
            value = (String)value + "&randomData=" + randomDataOut;
        }
        try {
            resp.setContentLength(((String)value).length());
            logger.debug("TokenServler::processComputeRandomData :outputString.length " + ((String)value).length());
            ServletOutputStream ooss = resp.getOutputStream();
            ooss.write(((String)value).getBytes());
            ooss.flush();
            this.mRenderResult = false;
        }
        catch (Exception e) {
            logger.warn("TokenServlet::processComputeRandomData " + e.getMessage(), (Throwable)e);
        }
        if (status.equals("0")) {
            event = ComputeRandomDataRequestProcessedEvent.success((String)status, (String)agentId);
            auditor.log((LogEvent)event);
        } else {
            event = ComputeRandomDataRequestProcessedEvent.failure((String)status, (String)agentId, (String)errorMsg);
            auditor.log((LogEvent)event);
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        this.mCurrentUID = (String)authToken.get("uid");
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "execute");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            try {
                resp.setContentType("text/html");
                String value = "unauthorized=";
                logger.debug("TokenServlet: Unauthorized");
                resp.setContentLength(value.length());
                ServletOutputStream ooss = resp.getOutputStream();
                ooss.write(value.getBytes());
                ooss.flush();
                this.mRenderResult = false;
            }
            catch (Exception e) {
                logger.warn("TokenServlet: " + e.getMessage(), (Throwable)e);
            }
            return;
        }
        String temp = req.getParameter("card_challenge");
        String protocol = req.getParameter("protocol");
        String derivationConstant = req.getParameter("derivationConstant");
        this.setDefaultSlotAndKeyName(req);
        if (temp != null && protocol == null) {
            this.processComputeSessionKey(req, resp);
        } else if (req.getParameter("data") != null) {
            this.processEncryptData(req, resp);
        } else if (req.getParameter("newKeyInfo") != null) {
            this.processDiversifyKey(req, resp);
        } else if (req.getParameter("dataNumBytes") != null) {
            this.processComputeRandomData(req, resp);
        } else if (protocol != null && protocol.contains("2") && derivationConstant != null) {
            this.processComputeSessionKeySCP02(req, resp);
        } else if (protocol != null && protocol.contains("3")) {
            this.processComputeSessionKeysSCP03(req, resp);
        } else {
            throw new EBaseException("Process: Can't decide upon function to call!");
        }
    }

    private void processComputeSessionKeysSCP03(HttpServletRequest req, HttpServletResponse resp) throws EBaseException {
        ArrayList<String> serverSideValues;
        byte[] xkeyInfo;
        byte[] xKDD;
        byte[] xCUID;
        boolean sameCardCrypto;
        String keyNickName;
        String selectedToken;
        String keycheck_s;
        String kek_wrapped_desKeyString;
        String agentId;
        byte[] enc_session_key;
        byte[] host_cryptogram;
        byte[] kek_session_key;
        byte[] mac_session_key;
        Object missingSetting_exception;
        boolean missingParam;
        boolean isCryptoValidate;
        Auditor auditor;
        boolean serversideKeygen;
        String keySet;
        Object badParams;
        Object errorMsg;
        block70: {
            String method = "processComputeSessionKeysSCP03:";
            logger.debug(method + " entering ...");
            String auditMessage = null;
            errorMsg = "";
            badParams = "";
            String transportKeyName = "";
            String rCUID = req.getParameter("tokencuid");
            String rKDD = req.getParameter("KDD");
            if (rKDD == null || rKDD.length() == 0) {
                logger.debug("TokenServlet: KDD not supplied, set to CUID before TPS change");
                rKDD = rCUID;
            }
            if ((keySet = req.getParameter("keySet")) == null || keySet.equals("")) {
                keySet = "defKeySet";
            }
            logger.debug("keySet selected: " + keySet);
            GPParams gp3Params = TokenServlet.readGPSettings(keySet);
            serversideKeygen = false;
            TKSEngine engine = TKSEngine.getInstance();
            TKSEngineConfig config = engine.getConfig();
            auditor = engine.getAuditor();
            isCryptoValidate = true;
            missingParam = false;
            missingSetting_exception = null;
            mac_session_key = null;
            kek_session_key = null;
            byte[] card_crypto = null;
            host_cryptogram = null;
            enc_session_key = null;
            SessionContext sContext = SessionContext.getContext();
            agentId = "";
            if (sContext != null) {
                agentId = (String)sContext.get((Object)"userid");
            }
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_COMPUTE_SESSION_KEY_REQUEST_4", (Object[])new Object[]{rCUID, rKDD, "Success", agentId});
            auditor.log(auditMessage);
            kek_wrapped_desKeyString = null;
            keycheck_s = null;
            String useSoftToken_s = config.getString("tks.useSoftToken", "true");
            if (!useSoftToken_s.equalsIgnoreCase("true")) {
                useSoftToken_s = "false";
            }
            logger.debug(method + " useSoftToken: " + useSoftToken_s);
            String rServersideKeygen = req.getParameter("serversideKeygen");
            if (rServersideKeygen.equals("true")) {
                serversideKeygen = true;
            }
            logger.debug(method + " serversideKeygen: " + serversideKeygen);
            try {
                isCryptoValidate = config.getBoolean("cardcryptogram.validate.enable", true);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            logger.debug(method + " Do crypto validation: " + isCryptoValidate);
            transportKeyName = this.getSharedSecretName(config);
            String rcard_challenge = req.getParameter("card_challenge");
            String rhost_challenge = req.getParameter("host_challenge");
            String rKeyInfo = req.getParameter("KeyInfo");
            String rcard_cryptogram = req.getParameter("card_cryptogram");
            if (rCUID == null || rCUID.equals("")) {
                logger.debug(method + " missing request parameter: CUID");
                badParams = (String)badParams + " CUID,";
                missingParam = true;
            }
            if (rKDD == null || rKDD.length() == 0) {
                logger.debug(method + " missing request parameter: KDD");
                badParams = (String)badParams + " KDD,";
                missingParam = true;
            }
            if (rcard_challenge == null || rcard_challenge.equals("")) {
                badParams = (String)badParams + " card_challenge,";
                logger.debug(method + " missing request parameter: card challenge");
                missingParam = true;
            }
            if (rhost_challenge == null || rhost_challenge.equals("")) {
                badParams = (String)badParams + " host_challenge,";
                logger.debug(method + " missing request parameter: host challenge");
                missingParam = true;
            }
            if (rcard_cryptogram == null || rcard_cryptogram.equals("")) {
                badParams = (String)badParams + " card_cryptogram,";
                logger.debug(method + " missing request parameter: card_cryptogram");
                missingParam = true;
            }
            if (rKeyInfo == null || rKeyInfo.equals("")) {
                badParams = (String)badParams + " KeyInfo,";
                logger.debug(method + "missing request parameter: key info");
                missingParam = true;
            }
            selectedToken = null;
            keyNickName = null;
            sameCardCrypto = true;
            xCUID = null;
            xKDD = null;
            xkeyInfo = null;
            byte[] xcard_challenge = null;
            byte[] xhost_challenge = null;
            if (!missingParam) {
                xCUID = Utils.SpecialDecode((String)rCUID);
                if (xCUID == null || xCUID.length != 10) {
                    badParams = (String)badParams + " CUID length,";
                    logger.debug("TokenServlet: Invalid CUID length");
                    missingParam = true;
                }
                if ((xKDD = Utils.SpecialDecode((String)rKDD)) == null || xKDD.length != 10) {
                    badParams = (String)badParams + " KDD length,";
                    logger.debug("TokenServlet: Invalid KDD length");
                    missingParam = true;
                }
                if ((xkeyInfo = Utils.SpecialDecode((String)rKeyInfo)) == null || xkeyInfo.length != 3) {
                    badParams = (String)badParams + " KeyInfo length,";
                    logger.debug("TokenServlet: Invalid key info length.");
                    missingParam = true;
                }
                if ((xcard_challenge = Utils.SpecialDecode((String)rcard_challenge)) == null || xcard_challenge.length != 8) {
                    badParams = (String)badParams + " card_challenge length,";
                    logger.debug("TokenServlet: Invalid card challenge length.");
                    missingParam = true;
                }
                if ((xhost_challenge = Utils.SpecialDecode((String)rhost_challenge)) == null || xhost_challenge.length != 8) {
                    badParams = (String)badParams + " host_challenge length,";
                    logger.debug("TokenServlet: Invalid host challenge length");
                    missingParam = true;
                }
            }
            serverSideValues = null;
            if (!missingParam) {
                byte[] card_challenge = Utils.SpecialDecode((String)rcard_challenge);
                byte[] host_challenge = Utils.SpecialDecode((String)rhost_challenge);
                String keyInfoMap = "tks." + keySet + ".mk_mappings." + rKeyInfo.substring(0, 6);
                String mappingValue = config.getString(keyInfoMap, null);
                if (mappingValue == null) {
                    selectedToken = config.getString("tks.defaultSlot", "internal");
                    keyNickName = rKeyInfo;
                } else {
                    StringTokenizer st = new StringTokenizer(mappingValue, ":");
                    if (st.hasMoreTokens()) {
                        selectedToken = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        keyNickName = st.nextToken();
                    }
                }
                logger.debug(method + " selectedToken: " + selectedToken + " keyNickName: " + keyNickName);
                SymmetricKey macSessionKey = null;
                SymmetricKey encSessionKey = null;
                SymmetricKey kekSessionKey = null;
                if (selectedToken != null && keyNickName != null && missingSetting_exception == null) {
                    try {
                        byte[] macKeyArray = Utils.SpecialDecode((String)config.getString("tks." + keySet + ".mac_key"));
                        logger.debug("TokenServlet about to try ComputeSessionKey selectedToken=" + selectedToken + " keyNickName=" + keyNickName);
                        SecureChannelProtocol protocol = new SecureChannelProtocol(3);
                        macSessionKey = protocol.computeSessionKey_SCP03(selectedToken, keyNickName, xkeyInfo, "mac", macKeyArray, keySet, xCUID, xKDD, xhost_challenge, xcard_challenge, transportKeyName, gp3Params);
                        mac_session_key = protocol.wrapSessionKey(selectedToken, macSessionKey, null);
                        if (mac_session_key == null) {
                            logger.error(method + " Can't get mac session key bytes");
                            throw new Exception(method + " Can't get mac session key bytes");
                        }
                        byte[] encKeyArray = Utils.SpecialDecode((String)config.getString("tks." + keySet + ".auth_key"));
                        encSessionKey = protocol.computeSessionKey_SCP03(selectedToken, keyNickName, xkeyInfo, "enc", encKeyArray, keySet, xCUID, xKDD, xhost_challenge, xcard_challenge, transportKeyName, gp3Params);
                        enc_session_key = protocol.wrapSessionKey(selectedToken, encSessionKey, null);
                        if (enc_session_key == null) {
                            logger.error("TokenServlet:Tried ComputeEncSessionKey, got NULL ");
                            throw new Exception("Can't compute enc session key!");
                        }
                        byte[] kekKeyArray = Utils.SpecialDecode((String)config.getString("tks." + keySet + ".kek_key"));
                        kekSessionKey = protocol.computeSessionKey_SCP03(selectedToken, keyNickName, xkeyInfo, "kek", kekKeyArray, keySet, xCUID, xKDD, xhost_challenge, xcard_challenge, transportKeyName, gp3Params);
                        kek_session_key = protocol.wrapSessionKey(selectedToken, kekSessionKey, null);
                        if (serversideKeygen) {
                            try {
                                serverSideValues = this.calculateServerSideKeygenValues(useSoftToken_s, selectedToken, kekSessionKey, protocol);
                            }
                            catch (EBaseException e) {
                                logger.warn(method + " Can't calcualte server side keygen required values: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        try {
                            isCryptoValidate = config.getBoolean("cardcryptogram.validate.enable", true);
                        }
                        catch (EBaseException e) {
                            // empty catch block
                        }
                        ByteArrayOutputStream contextStream = new ByteArrayOutputStream();
                        try {
                            contextStream.write(host_challenge);
                            contextStream.write(card_challenge);
                        }
                        catch (IOException e) {
                            throw new EBaseException(method + " Error calculating derivation data!");
                        }
                        host_cryptogram = protocol.computeCryptogram_SCP03(macSessionKey, selectedToken, contextStream.toByteArray(), (byte)1);
                        if (isCryptoValidate) {
                            if (rcard_cryptogram == null) {
                                logger.error(method + " missing card cryptogram");
                                throw new Exception(method + "Missing card cryptogram");
                            }
                            byte[] input_card_crypto = Utils.SpecialDecode((String)rcard_cryptogram);
                            if (!this.cryptoGramsAreEqual(input_card_crypto, card_crypto = protocol.computeCryptogram_SCP03(macSessionKey, selectedToken, contextStream.toByteArray(), (byte)0))) {
                                throw new Exception(method + "Card cryptogram mismatch!");
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.warn("TokenServlet Computing Session Key: " + e.getMessage(), (Throwable)e);
                        if (!isCryptoValidate) break block70;
                        sameCardCrypto = false;
                    }
                }
            }
        }
        Object value = "";
        resp.setContentType("text/html");
        String encSessionKeyString = "";
        String macSessionKeyString = "";
        String kekSessionKeyString = "";
        String drm_trans_wrapped_desKeyString = "";
        String cryptogram = "";
        String status = "0";
        if (enc_session_key != null && enc_session_key.length > 0) {
            encSessionKeyString = Utils.SpecialEncode(enc_session_key);
        } else {
            status = "1";
        }
        if (mac_session_key != null && mac_session_key.length > 0) {
            macSessionKeyString = Utils.SpecialEncode(mac_session_key);
        } else {
            status = "1";
        }
        if (kek_session_key != null && kek_session_key.length > 0) {
            kekSessionKeyString = Utils.SpecialEncode(kek_session_key);
        } else {
            status = "1";
        }
        if (serversideKeygen) {
            if (serverSideValues.size() == 3) {
                drm_trans_wrapped_desKeyString = (String)serverSideValues.get(2);
                kek_wrapped_desKeyString = (String)serverSideValues.get(0);
                keycheck_s = (String)serverSideValues.get(1);
            } else {
                status = "1";
            }
        }
        if (host_cryptogram != null && host_cryptogram.length > 0) {
            cryptogram = Utils.SpecialEncode(host_cryptogram);
        } else if (status.equals("0")) {
            status = "2";
        }
        if ((selectedToken == null || keyNickName == null) && status.equals("0")) {
            status = "4";
        }
        if (!sameCardCrypto && status.equals("0")) {
            status = "5";
        }
        if (missingSetting_exception != null) {
            status = "6";
        }
        if (missingParam) {
            status = "3";
        }
        if (!status.equals("0")) {
            if (status.equals("1")) {
                errorMsg = "Problem generating session key info.";
            }
            if (status.equals("2")) {
                errorMsg = "Problem creating host_cryptogram.";
            }
            if (status.equals("5")) {
                errorMsg = "Card cryptogram mismatch. Token likely has incorrect keys.";
            }
            if (status.equals("4")) {
                errorMsg = "Problem obtaining token information.";
            }
            if (status.equals("6")) {
                errorMsg = "Problem reading required configuration value.";
            }
            if (status.equals("3")) {
                if (((String)badParams).endsWith(",")) {
                    badParams = ((String)badParams).substring(0, ((String)badParams).length() - 1);
                }
                errorMsg = "Missing input parameters :" + (String)badParams;
            }
            value = "status=" + status;
        } else if (serversideKeygen) {
            sb = new StringBuffer();
            sb.append("status=0&");
            sb.append("macSessionKey=");
            sb.append(macSessionKeyString);
            sb.append("&hostCryptogram=");
            sb.append(cryptogram);
            sb.append("&encSessionKey=");
            sb.append(encSessionKeyString);
            sb.append("&kekSessionKey=");
            sb.append(kekSessionKeyString);
            sb.append("&kek_wrapped_desKey=");
            sb.append(kek_wrapped_desKeyString);
            sb.append("&keycheck=");
            sb.append(keycheck_s);
            sb.append("&drm_trans_desKey=");
            sb.append(drm_trans_wrapped_desKeyString);
            value = sb.toString();
        } else {
            sb = new StringBuffer();
            sb.append("status=0&");
            sb.append("macSessionKey=");
            sb.append(macSessionKeyString);
            sb.append("&hostCryptogram=");
            sb.append(cryptogram);
            sb.append("&encSessionKey=");
            sb.append(encSessionKeyString);
            sb.append("&kekSessionKey=");
            value = sb.toString();
        }
        try {
            resp.setContentLength(((String)value).length());
            logger.debug("TokenServlet:outputString.length " + ((String)value).length());
            ServletOutputStream ooss = resp.getOutputStream();
            ooss.write(((String)value).getBytes());
            ooss.flush();
            this.mRenderResult = false;
        }
        catch (IOException e) {
            logger.warn("TokenServlet: " + e.getMessage(), (Throwable)e);
        }
        if (status.equals("0")) {
            event = ComputeSessionKeyRequestProcessedEvent.success((String)this.log_string_from_specialDecoded_byte_array(xCUID), (String)this.log_string_from_specialDecoded_byte_array(xKDD), (String)status, (String)agentId, (String)(isCryptoValidate ? "true" : "false"), (String)(serversideKeygen ? "true" : "false"), (String)selectedToken, (String)keyNickName, (String)keySet, (String)this.log_string_from_keyInfo(xkeyInfo), null, null);
            auditor.log((LogEvent)event);
        } else {
            event = ComputeSessionKeyRequestProcessedEvent.failure((String)this.log_string_from_specialDecoded_byte_array(xCUID), (String)this.log_string_from_specialDecoded_byte_array(xKDD), (String)status, (String)agentId, (String)(isCryptoValidate ? "true" : "false"), (String)(serversideKeygen ? "true" : "false"), (String)selectedToken, (String)keyNickName, (String)keySet, (String)this.log_string_from_keyInfo(xkeyInfo), null, null, (String)errorMsg);
            auditor.log((LogEvent)event);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    private PK11SymKey getSharedSecretKey() throws EBaseException, NotInitializedException {
        TKSEngine engine = TKSEngine.getInstance();
        TKSEngineConfig config = engine.getConfig();
        String sharedSecretName = null;
        try {
            sharedSecretName = this.getSharedSecretName(config);
        }
        catch (EBaseException e) {
            throw new EBaseException("TokenServlet.getSharedSecetKey: Internal error finding config value: " + e);
        }
        logger.debug("TokenServlet.getSharedSecretTransportKey: calculated key name: " + sharedSecretName);
        String symmKeys = null;
        boolean keyPresent = false;
        try {
            symmKeys = SessionKey.ListSymmetricKeys((String)"internal");
            logger.debug("TokenServlet.getSharedSecretTransportKey: symmKeys List: " + symmKeys);
        }
        catch (Exception e) {
            logger.warn("TokenServlet: " + e.getMessage(), (Throwable)e);
        }
        for (String keyName : symmKeys.split(",")) {
            if (!sharedSecretName.equals(keyName)) continue;
            logger.debug("TokenServlet.getSharedSecret: shared secret key found!");
            keyPresent = true;
            break;
        }
        if (!keyPresent) {
            throw new EBaseException("TokenServlet.getSharedSecret: Can't find shared secret!");
        }
        String tokenName = "Internal Key Storage Token";
        PK11SymKey sharedSecret = SessionKey.GetSymKeyByName((String)tokenName, (String)sharedSecretName);
        logger.debug("TokenServlet.getSharedSecret: SymKey returns: " + sharedSecret);
        return sharedSecret;
    }

    private ArrayList<String> calculateServerSideKeygenValues(String useSoftToken, String selectedToken, SymmetricKey kekSessionKey, SecureChannelProtocol protocol) throws EBaseException {
        SymmetricKey desKey = null;
        String method = "TokenServlet.calculateSErverSideKeygenValues: ";
        ArrayList<String> values = new ArrayList<String>();
        logger.debug(method + " entering...");
        if (useSoftToken.equals("true")) {
            logger.debug(method + " key encryption key generated on internal");
            desKey = protocol.generateSymKey("internal");
        } else {
            logger.debug("TokenServlet: key encryption key generated on " + selectedToken);
            desKey = protocol.generateSymKey(selectedToken);
        }
        if (desKey == null) {
            throw new EBaseException(method + "can't generate key encryption key");
        }
        byte[] encDesKey = protocol.ecbEncrypt(kekSessionKey, desKey, selectedToken);
        String kek_wrapped_desKeyString = Utils.SpecialEncode((byte[])encDesKey);
        values.add(kek_wrapped_desKeyString);
        byte[] keycheck = null;
        keycheck = protocol.computeKeyCheck(desKey, selectedToken);
        String keycheck_s = Utils.SpecialEncode((byte[])keycheck);
        values.add(keycheck_s);
        TKSEngine engine = TKSEngine.getInstance();
        TKSEngineConfig config = engine.getConfig();
        String drmTransNickname = config.getString("tks.drm_transport_cert_nickname", "");
        if (drmTransNickname == null || drmTransNickname == "") {
            logger.error(method + " did not find DRM transport certificate nickname");
            throw new EBaseException(method + "can't find DRM transport certificate nickname");
        }
        logger.debug(method + " drmtransport_cert_nickname=" + drmTransNickname);
        X509Certificate drmTransCert = null;
        try {
            drmTransCert = CryptoManager.getInstance().findCertByNickname(drmTransNickname);
            CryptoToken token = null;
            token = useSoftToken.equals("true") ? CryptoManager.getInstance().getInternalCryptoToken() : CryptoManager.getInstance().getTokenByName(selectedToken);
            PublicKey pubKey = drmTransCert.getPublicKey();
            String pubKeyAlgo = pubKey.getAlgorithm();
            logger.debug("Transport Cert Key Algorithm: " + pubKeyAlgo);
            KeyWrapper keyWrapper = null;
            if (pubKeyAlgo.equals("EC")) {
                keyWrapper = token.getKeyWrapper(KeyWrapAlgorithm.AES_ECB);
                keyWrapper.initWrap(pubKey, null);
            } else {
                boolean useOAEP = config.getUseOAEPKeyWrap();
                KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.RSA;
                if (useOAEP) {
                    wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
                }
                keyWrapper = token.getKeyWrapper(wrapAlg);
                OAEPParameterSpec params = null;
                if (useOAEP) {
                    params = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
                }
                keyWrapper.initWrap(pubKey, params);
            }
            logger.debug("desKey token " + desKey.getOwningToken().getName() + " token: " + token.getName());
            byte[] drm_trans_wrapped_desKey = keyWrapper.wrap(desKey);
            String drmWrappedDesStr = Utils.SpecialEncode((byte[])drm_trans_wrapped_desKey);
            values.add(drmWrappedDesStr);
        }
        catch (Exception e) {
            throw new EBaseException(e);
        }
        return values;
    }

    private boolean cryptoGramsAreEqual(byte[] original_cryptogram, byte[] calculated_cryptogram) {
        boolean sameCardCrypto = true;
        if (original_cryptogram == null || calculated_cryptogram == null) {
            return false;
        }
        if (original_cryptogram.length == calculated_cryptogram.length) {
            for (int i = 0; i < original_cryptogram.length; ++i) {
                if (original_cryptogram[i] == calculated_cryptogram[i]) continue;
                sameCardCrypto = false;
                break;
            }
        } else {
            sameCardCrypto = false;
        }
        return sameCardCrypto;
    }

    static GPParams readGPSettings(String keySet) {
        GPParams params = new GPParams();
        String method = "TokenServlet.readGPSettings: ";
        String gp3Settings = "tks." + keySet + ".prot3";
        TKSEngine engine = TKSEngine.getInstance();
        TKSEngineConfig config = engine.getConfig();
        String divers = "emv";
        try {
            divers = config.getString(gp3Settings + ".divers", "emv");
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        params.setDiversificationScheme(divers);
        logger.debug(method + " Divers: " + divers);
        String diversVer1Keys = "emv";
        try {
            diversVer1Keys = config.getString(gp3Settings + ".diversVer1Keys", "emv");
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        params.setVersion1DiversificationScheme(diversVer1Keys);
        logger.debug(method + " Version 1 keys Divers: " + divers);
        String keyType = null;
        try {
            keyType = config.getString(gp3Settings + ".devKeyType", "DES3");
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        logger.debug(method + " devKeyType: " + keyType);
        params.setDevKeyType(keyType);
        try {
            keyType = config.getString(gp3Settings + ".masterKeyType", "DES3");
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        params.setMasterKeyType(keyType);
        logger.debug(method + " masterKeyType: " + keyType);
        return params;
    }

    private byte[] getDeveKeyArray(String keyType, ConfigStore sconfig, String keySet) throws EBaseException {
        byte[] devKeyArray = null;
        try {
            devKeyArray = Utils.SpecialDecode((String)sconfig.getString("tks." + keySet + "." + keyType));
        }
        catch (Exception e) {
            throw new EBaseException("Can't read static developer key array: " + keySet + ": " + keyType);
        }
        return devKeyArray;
    }
}

