/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.base;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.util.StatsEvent;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.util.StatsSubsystem;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;

public class GetStats
extends CMSServlet {
    private static final long serialVersionUID = -3336253558044271816L;
    private static final String TPL_FILE = "getStats.template";
    private String mFormPath = null;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/" + this.mAuthority.getId() + "/getStats.template";
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
        this.mTemplates.remove(CMSRequest.SUCCESS);
    }

    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        CMSEngine engine = this.getCMSEngine();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, httpReq, locale);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage("CMSGW_ERR_GET_TEMPLATE", this.mFormPath, e.toString()), (Throwable)e);
            cmsReq.setError(new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0])));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        StatsEvent st = statsSub.getMainStatsEvent();
        String op = httpReq.getParameter("op");
        if (op != null && op.equals("clear")) {
            statsSub.resetCounters();
        }
        header.addStringValue("startTime", statsSub.getStartTime().toString());
        header.addStringValue("curTime", new Date().toString());
        this.parse(argSet, st, 0);
        try {
            ServletOutputStream out = httpResp.getOutputStream();
            httpResp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
            cmsReq.setStatus(CMSRequest.SUCCESS);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage("CMSGW_ERR_STREAM_TEMPLATE", e.toString()), (Throwable)e);
            cmsReq.setError(new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0])));
            cmsReq.setStatus(CMSRequest.ERROR);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }

    public String getSep(int level) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            s.append("-");
        }
        return s.toString();
    }

    public void parse(CMSTemplateParams argSet, StatsEvent st, int level) {
        Enumeration names = st.getSubEventNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            StatsEvent subSt = st.getSubEvent(name);
            ArgBlock rarg = new ArgBlock();
            rarg.addStringValue("name", this.getSep(level) + " " + subSt.getName());
            rarg.addLongValue("noOfOp", subSt.getNoOfOperations());
            rarg.addLongValue("timeTaken", subSt.getTimeTaken());
            rarg.addLongValue("max", subSt.getMax());
            rarg.addLongValue("min", subSt.getMin());
            rarg.addLongValue("percentage", subSt.getPercentage());
            rarg.addLongValue("avg", subSt.getAvg());
            rarg.addLongValue("stddev", subSt.getStdDev());
            argSet.addRepeatRecord(rarg);
            this.parse(argSet, subSt, level + 1);
        }
    }
}

