/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.processors;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIProcessor {
    public static Logger logger = LoggerFactory.getLogger(PKIProcessor.class);
    public static final String ADMIN_ENROLL_SERVLET_ID = "caadminEnroll";
    public static final String SUBJECT_NAME = "subject";
    public static final String OLD_CERT_TYPE = "csrCertType";
    public static final String CERT_TYPE = "certType";
    public static final String PKCS10_REQUEST = "pkcs10Request";
    public static final String SUBJECT_KEYGEN_INFO = "subjectKeyGenInfo";
    protected CMSEngine engine;
    protected CMSRequest mRequest = null;
    protected HttpServletRequest httpReq = null;
    protected String mServletId = null;
    protected CMSServlet mServlet = null;

    public PKIProcessor() {
    }

    public PKIProcessor(CMSRequest cmsReq, CMSServlet servlet) {
        this.mRequest = cmsReq;
        this.mServlet = servlet;
        if (this.mServlet == null || this.mRequest == null) {
            return;
        }
        this.mServletId = servlet.getId();
    }

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
    }

    protected void fillCertInfo(String protocolString, X509CertInfo certInfo, AuthToken authToken, ArgBlock httpParams) throws EBaseException {
    }

    protected X509CertInfo[] fillCertInfoArray(byte[] bytes, AuthToken authToken, ArgBlock httpParams, Request req) throws EBaseException {
        return null;
    }

    public static void fillCertInfoFromAuthToken(X509CertInfo certInfo, AuthToken authToken) throws EBaseException {
        logger.debug("PKIProcessor: fillCertInfoFromAuthToken");
        try {
            String subjectname = authToken.getInString("tokenCertSubject");
            if (subjectname != null) {
                CertificateSubjectName certSubject = new CertificateSubjectName(new X500Name(subjectname));
                certInfo.set(SUBJECT_NAME, (Object)certSubject);
                logger.info("PKIProcessor: cert subject set to " + certSubject + " from authtoken");
            }
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_SET_SUBJECT_NAME_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_SUBJECT_NAME_ERROR", new String[0]), e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_SET_SUBJECT_NAME", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_SUBJECT_NAME_ERROR", new String[0]), e);
        }
        try {
            CertificateValidity validity = null;
            Date notBefore = authToken.getInDate("tokenCertNotBefore");
            Date notAfter = authToken.getInDate("tokenCertNotAfter");
            if (notBefore != null && notAfter != null) {
                validity = new CertificateValidity(notBefore, notAfter);
                certInfo.set("validity", (Object)validity);
                logger.info("PKIProcessor: cert validity set to " + validity + " from authtoken");
            }
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_SET_VALIDITY_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_VALIDITY_ERROR", new String[0]), e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_SET_VALIDITY_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_VALIDITY_ERROR", new String[0]), e);
        }
        try {
            CertificateExtensions extensions = authToken.getInCertExts("extensions");
            if (extensions != null) {
                certInfo.set("extensions", (Object)extensions);
                logger.info("PKIProcessor: cert extensions set from authtoken");
            }
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_SET_EXTENSIONS_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_EXTENSIONS_ERROR", new String[0]), e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_SET_EXTENSIONS_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_EXTENSIONS_ERROR", new String[0]), e);
        }
    }

    public static void fillCertInfoFromForm(X509CertInfo certInfo, ArgBlock httpParams) throws EBaseException {
        logger.debug("PKIProcessor: fillCertInfoFromForm");
        try {
            String subject = httpParams.getValueAsString(SUBJECT_NAME, null);
            if (subject == null) {
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_MISSING_SUBJECT_FROM_FORM", new String[0]));
            }
            X500Name x500name = new X500Name(subject);
            certInfo.set(SUBJECT_NAME, (Object)new CertificateSubjectName(x500name));
            PKIProcessor.fillValidityFromForm(certInfo, httpParams);
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_SET_SUBJECT_NAME_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_SUBJECT_NAME_ERROR", new String[0]), e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_SET_SUBJECT_NAME_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_SUBJECT_NAME_ERROR", new String[0]), e);
        }
        catch (IllegalArgumentException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_SET_SUBJECT_NAME_1", e.toString()), (Throwable)e);
            logger.error(CMS.getLogMessage("CMSGW_REQ_ILLEGAL_CHARACTERS", new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CONVERT_DN_TO_X500NAME_ERROR", new String[0]), e);
        }
    }

    public static void fillValidityFromForm(X509CertInfo certInfo, ArgBlock httpParams) throws EBaseException {
        block9: {
            logger.debug("PKIProcessor: fillValidityFromForm!");
            try {
                String notValidBeforeStr = httpParams.getValueAsString("notValidBefore", null);
                String notValidAfterStr = httpParams.getValueAsString("notValidAfter", null);
                if (notValidBeforeStr == null || notValidAfterStr == null) break block9;
                long notValidBefore = 0L;
                long notValidAfter = 0L;
                try {
                    notValidBefore = Long.parseLong(notValidBeforeStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    notValidAfter = Long.parseLong(notValidAfterStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (notValidBefore > 0L && notValidAfter > 0L) {
                    CertificateValidity validity = null;
                    Date notBefore = new Date(notValidBefore);
                    Date notAfter = new Date(notValidAfter);
                    if (notBefore != null && notAfter != null) {
                        validity = new CertificateValidity(notBefore, notAfter);
                        certInfo.set("validity", (Object)validity);
                        logger.info("PKIProcessor: cert validity set to " + validity + " from authtoken");
                    }
                }
            }
            catch (CertificateException e) {
                logger.error(CMS.getLogMessage("CMSGW_ERROR_SET_SUBJECT_NAME_1", e.toString()), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_SUBJECT_NAME_ERROR", new String[0]), e);
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage("CMSGW_ERROR_SET_SUBJECT_NAME_1", e.toString()), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_SUBJECT_NAME_ERROR", new String[0]), e);
            }
        }
    }

    protected String auditSubjectID() {
        String subjectID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        subjectID = auditContext != null ? ((subjectID = (String)auditContext.get((Object)"userid")) != null ? subjectID.trim() : "$NonRoleUser$") : "$Unidentified$";
        return subjectID;
    }
}

