/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.IDBObj;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(ByteArrayMapper.class);
    private String mLdapName = null;
    private Vector<String> v = new Vector();

    public ByteArrayMapper(String ldapName) {
        this.mLdapName = ldapName;
        this.v.addElement(this.mLdapName);
    }

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return this.v.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        byte[] data = (byte[])obj;
        logger.debug("ByteArrayMapper: Mapping " + name + " to " + this.mLdapName);
        attrs.add(new LDAPAttribute(this.mLdapName, data));
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        LDAPAttribute attr = attrs.getAttribute(this.mLdapName);
        if (attr == null) {
            return;
        }
        parent.set(name, attr.getByteValues().nextElement());
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        return this.mLdapName + op + value;
    }
}

