/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(DateMapper.class);
    private String mLdapName = null;
    private Vector<String> v = new Vector();
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss'Z'");

    public DateMapper(String ldapName) {
        this.mLdapName = ldapName;
        this.v.addElement(this.mLdapName);
    }

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return this.v.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
        logger.debug("DateMapper: Mapping " + name + " to " + this.mLdapName);
        Date value = (Date)obj;
        logger.debug("DateMapper: - value: " + value);
        String dbValue = DateMapper.dateToDB(value);
        logger.debug("DateMapper: - database value: " + dbValue);
        attrs.add(new LDAPAttribute(this.mLdapName, dbValue));
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        LDAPAttribute attr = attrs.getAttribute(this.mLdapName);
        if (attr == null) {
            return;
        }
        logger.debug("DateMapper: Mapping " + this.mLdapName + " to " + name);
        String dbValue = (String)attr.getStringValues().nextElement();
        logger.debug("DateMapper: - database value: " + dbValue);
        Date value = DateMapper.dateFromDB(dbValue);
        logger.debug("DateMapper: - value: " + value);
        parent.set(name, value);
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        String val = null;
        try {
            val = DateMapper.dateToDB(new Date(Long.parseLong(value)));
        }
        catch (NumberFormatException e) {
            val = value;
        }
        return this.mLdapName + op + val;
    }

    public static synchronized String dateToDB(Date date) {
        return formatter.format(date);
    }

    public static synchronized Date dateFromDB(String dbDate) {
        try {
            return formatter.parse(dbDate);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

